/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.diff.AbstractPropertyFilter;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.PropertyManager;

public class UnsupportedPropertyFilter
extends AbstractPropertyFilter {
    private final PropertyManager m_sourcePropertyManager;
    private final PropertyManager m_targetPropertyManager;

    public UnsupportedPropertyFilter(DBObjectProvider sourceProv, DBObjectProvider targetProv) {
        this.m_sourcePropertyManager = sourceProv.getPropertyManager();
        this.m_targetPropertyManager = targetProv.getPropertyManager();
    }

    public UnsupportedPropertyFilter(DBObjectProvider provider, DDLGenerator targetGenerator) {
        this.m_sourcePropertyManager = provider.getPropertyManager();
        this.m_targetPropertyManager = targetGenerator;
    }

    protected boolean isFilteredProperty(Difference diff, DBObject original, DBObject updated, String prop) {
        DBObject obj = this.getAnObject(original, updated);
        boolean sourceSupport = this.m_sourcePropertyManager.supportsProperty(obj.getClass(), prop);
        boolean targetSupport = this.m_targetPropertyManager.supportsProperty(obj.getClass(), prop);
        boolean filter = !sourceSupport || !targetSupport;
        return filter;
    }
}

