/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.informix.InformixDDLType;
import oracle.javatools.db.informix.InformixDatabase;
import oracle.javatools.db.informix.InformixDatabaseImpl;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InformixDDLGenerator
extends BundleDDLGenerator<InformixDDLType> {
    InformixDDLGenerator(Class<? extends InformixDatabase> dbClz, DBObjectProvider pro) {
        super(dbClz, pro, new String[]{"/oracle/javatools/db/informix/InformixDDL.properties"});
        this.registerTokens();
    }

    protected InformixDDLType getDDLType(String type) {
        return InformixDDLType.getDDLType(type);
    }

    protected void registerTokens() {
        this.registerTokenGenerator("quotedName", new QuotedNameGenerator());
    }

    public Collection getAllowedPropertyValues(DBObject originalObject, DBObject updatedObject, String property) {
        if (property.equals("onDeleteAction")) {
            return Collections.singleton(FKConstraint.ReferentialAction.CASCADE);
        }
        return super.getAllowedPropertyValues(originalObject, updatedObject, property);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QuotedNameGenerator
    extends TokenGenerator {
        private static final String TOKEN = "quotedName";

        private QuotedNameGenerator() {
        }

        public void generateToken(TokenContext context) {
            String nme = this.getName(context);
            boolean doQuotes = false;
            DBObjectProvider pro = context.getProvider();
            if (pro instanceof InformixDatabaseImpl) {
                Connection conn = ((InformixDatabaseImpl)pro).getConnection();
                try {
                    String s = conn.getMetaData().getIdentifierQuoteString();
                    if (s != " ") {
                        doQuotes = true;
                    }
                }
                catch (SQLException e) {
                    String msg = e.getLocalizedMessage();
                }
            }
            if (nme != null && doQuotes) {
                context.append((Object)Character.valueOf('\"'));
                context.append((Object)nme);
                context.append((Object)Character.valueOf('\"'));
            } else if (nme != null) {
                context.append((Object)nme);
            }
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("name".toString());
        }

        private String getName(TokenContext context) {
            String retval = null;
            Object c = context.getObject();
            if (c instanceof DBObject) {
                retval = (String)((DBObject)c).getProperty("name");
            }
            return retval;
        }

        public Object evaluateToken(TokenContext context) {
            return ModelUtil.hasLength((String)this.getName(context));
        }
    }
}

