/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DataTypeUsageValidator;
import oracle.javatools.db.validators.ValidationException;

public class InformixDataTypeUsageValidator
extends DataTypeUsageValidator {
    private static final String FRACTION = "FRACTION";
    private static final String YEAR = "YEAR";
    private static final String MONTH = "MONTH";
    static final String[] TIME_UNITS = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "FRACTION"};

    public InformixDataTypeUsageValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected void validateAttributes(DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        super.validateAttributes(dataTypeUsage, dataType);
        String dataTypeName = dataType.getName();
        if (this.isVarchar(dataTypeName)) {
            String reserveAttributeName = "reserve";
            Long reserve = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"reserve");
            Long size = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"size");
            if (size != null && reserve != null && reserve.compareTo(size) > 0) {
                this.throwAttributeValueInvalid(dataTypeUsage, "reserve", APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE2", (Object[])new Object[]{DataTypeHelper.getNameFromLabel((String)"DATATYPE_ATTRIBUTE_LABEL_RESERVE"), size}));
            }
        } else if (this.isTime(dataTypeName)) {
            String toAttributeName = "to";
            String fromAttributeName = "from";
            String to = DataTypeHelper.getStringAttributeValue((DataTypeUsage)dataTypeUsage, (String)"to");
            String from = DataTypeHelper.getStringAttributeValue((DataTypeUsage)dataTypeUsage, (String)"from");
            Long scale = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale");
            if (from != null && to == null || from == null && to != null) {
                this.throwAttributeValueInvalid(dataTypeUsage, from == null ? "to" : "from", APIBundle.get((String)"DATATYPE_ERROR_INVALID_INFORMIX_DATETIME_OR_INTERVAL"));
            }
            if (scale != null && to != null && !to.equalsIgnoreCase(FRACTION)) {
                this.throwAttributeValueInvalid(dataTypeUsage, "scale", APIBundle.get((String)"DATATYPE_ERROR_INVALID_INFORMIX_INVALID_FRACTION"));
            }
            if (from != null) {
                if (InformixDataTypeUsageValidator.getTimeSize(to) < InformixDataTypeUsageValidator.getTimeSize(from)) {
                    this.throwAttributeValueInvalid(dataTypeUsage, "to", APIBundle.get((String)"DATATYPE_ERROR_INVALID_INFORMIX_INVALID_QUALIFIERS"));
                }
                if ("INTERVAL".equals(dataTypeName)) {
                    Long precision;
                    if ((from.equals(YEAR) || from.equals(MONTH)) && !to.equals(YEAR) && !to.equals(MONTH)) {
                        this.throwAttributeValueInvalid(dataTypeUsage, "to", APIBundle.get((String)"DATATYPE_ERROR_INVALID_INFORMIX_INVALID_INTERVAL_QUALIFIERS"));
                    }
                    if (from.equals(FRACTION) && (precision = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"precision")) != null && precision.compareTo(5L) > 0) {
                        this.throwAttributeValueInvalid(dataTypeUsage, "precision", APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE2", (Object[])new Object[]{DataTypeHelper.getNameFromLabel((String)"DATATYPE_ATTRIBUTE_LABEL_PRECISION"), 5L}));
                    }
                }
            }
        }
    }

    private boolean isVarchar(String dataTypeName) {
        return "VARCHAR".equals(dataTypeName) || "NVARCHAR".equals(dataTypeName);
    }

    private boolean isTime(String dataTypeName) {
        return "DATETIME".equals(dataTypeName) || "INTERVAL".equals(dataTypeName);
    }

    private static int getTimeSize(String timeUnit) {
        int idx = 0;
        while (!TIME_UNITS[idx].equalsIgnoreCase(timeUnit)) {
            ++idx;
        }
        return idx;
    }
}

