/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.DMDBuilder;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcSynonymBuilder
extends DMDBuilder<Synonym> {
    private boolean m_synonymNotAlias;

    public JdbcSynonymBuilder(JdbcDatabase db, String catalog, boolean synonymNotAlias) {
        super(db, catalog, synonymNotAlias ? "SYNONYM" : "ALIAS");
        this.m_synonymNotAlias = synonymNotAlias;
    }

    protected final boolean isSynonymNotAlias() {
        return this.m_synonymNotAlias;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"reference"})
    public void buildReference(final Synonym syn) throws DBException {
        String query = this.getDictionaryQuery();
        if (query == null) {
            this.getLogger().warning(APIBundle.format((String)"SYNONYM_BUILD_REF_ERR", (Object[])new Object[]{syn.getName()}));
        } else {
            final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), query, this.getDictionaryQueryParams(syn));
            wrap.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            DBObjectID ref = JdbcSynonymBuilder.this.decodeReferenceID(rs, syn);
                            syn.setReference(ref);
                        }
                    }
                    catch (SQLException sqe) {
                        wrap.throwDBException(sqe);
                    }
                }
            });
        }
    }

    protected String getDictionaryQuery() {
        return null;
    }

    protected Object[] getDictionaryQueryParams(Synonym syn) {
        return new Object[]{syn.getSchema(), syn};
    }

    protected DBObjectID decodeReferenceID(ResultSet rs, Synonym syn) throws SQLException {
        String name = rs.getString(1);
        String schema = null;
        int count = rs.getMetaData().getColumnCount();
        if (count > 1) {
            schema = rs.getString(2).trim();
        } else if (name.contains(".")) {
            int i = name.lastIndexOf(".");
            schema = name.substring(0, i);
            name = name.substring(i + 1);
        }
        ReferenceID retval = null;
        if (ModelUtil.hasLength((String)name)) {
            if (this.needsNamesConverting()) {
                name = this.getProvider().getInternalName(name);
            }
            if (!ModelUtil.hasLength((String)schema)) {
                schema = syn.getSchema().getName();
            } else if (this.needsNamesConverting()) {
                schema = this.getProvider().getInternalName(schema);
            }
            retval = new ReferenceID("UNSPECIFIED_TYPE", schema, name);
            retval.setProvider((DBObjectProvider)this.getProvider());
        }
        return retval;
    }

    protected boolean needsNamesConverting() {
        return false;
    }

    public boolean canBuildEditableObject() {
        return this.getDictionaryQuery() != null;
    }

    protected boolean canBuildComponents() {
        return true;
    }
}

