/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.View;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.jdbc.JdbcRelationBuilder;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcViewBuilder
extends JdbcRelationBuilder<View> {
    protected static final String DEFAULT_SEARCH_STRING = "CREATE VIEW <name ?.> [(<cols {^)}...>)] AS <select {^{WITH CHECK OPTION|WITH READ ONLY}}...> <check [WITH CHECK OPTION]> <readOnly [WITH READ ONLY]>";
    private PlSqlSearch m_viewSearch;

    public JdbcViewBuilder(JdbcDatabase db, String catalog) {
        super(db, catalog, "VIEW");
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"SQLQuery", "restriction"})
    public void buildQuery(final View view) throws DBException {
        String query = this.getDictionaryQuery();
        if (query == null) {
            this.getLogger().warning(APIBundle.format((String)"VIEW_BUILD_SQL_ERR", (Object[])new Object[]{view.getName()}));
        } else {
            final QueryWrapper wrap = new QueryWrapper((Database)this.getDatabase(), query, this.getDictionaryQueryParams(view));
            wrap.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            String queryString = rs.getString(1);
                            JdbcViewBuilder.this.decodeQueryString(queryString, view);
                            if (rs.getMetaData().getColumnCount() > 1) {
                                String r = rs.getString(2);
                                View.Restriction vr = JdbcViewBuilder.this.decodeRestriction(r);
                                view.setRestriction(vr);
                            }
                        }
                    }
                    catch (SQLException sqe) {
                        wrap.throwDBException(sqe);
                    }
                }
            });
        }
    }

    public boolean canBuildEditableObject() {
        return this.getDictionaryQuery() != null;
    }

    protected String getDictionaryQuery() {
        return null;
    }

    protected Object[] getDictionaryQueryParams(View view) {
        return new Object[]{view.getSchema(), view};
    }

    @Deprecated
    protected SQLQuery decodeQueryString(String queryString) {
        return null;
    }

    protected void decodeQueryString(String queryString, View view) {
        String search = this.getQuerySearchString();
        if (search != null) {
            if (this.m_viewSearch == null) {
                this.m_viewSearch = new PlSqlSearch(search);
            }
            if (this.m_viewSearch.matches(queryString)) {
                PlSqlToken startOfReadOnly;
                PlSqlToken startOfSelect = this.m_viewSearch.getNamedMatchStartToken("select");
                PlSqlToken endOfSelect = this.m_viewSearch.getNamedMatchEndToken("select");
                queryString = startOfSelect.getSource(false, endOfSelect);
                PlSqlToken startOfCheck = this.m_viewSearch.getNamedMatchStartToken("check");
                if (startOfCheck != null) {
                    view.setRestriction(View.Restriction.CHECK_OPTION);
                }
                if ((startOfReadOnly = this.m_viewSearch.getNamedMatchStartToken("readOnly")) != null) {
                    view.setRestriction(View.Restriction.READ_ONLY);
                }
            }
        }
        SQLQuery query = (SQLQuery)this.newObject(SQLQuery.class, null);
        query.setQueryString(queryString);
        view.setSQLQuery(query);
    }

    protected String getQuerySearchString() {
        return null;
    }

    protected View.Restriction decodeRestriction(String result) {
        return null;
    }
}

