/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.marshal.BaseSAXHelper;
import oracle.javatools.db.marshal.DBObject2XML;
import oracle.javatools.db.marshal.DBObjectHandler;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.sql.SQLFragmentUtils;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBObjectRefsSAXHelper
extends BaseSAXHelper<BaseObjectID> {
    private final DBObjectHandler.UnmarshalledIDs m_ids;
    private final Collection<String> m_patterns;
    private final Collection<String> m_parseProps;
    private final List<String> m_xmlPath = new ArrayList<String>();
    private final Map<String, String> m_elemToTypeMap = new HashMap<String, String>();
    private String m_rootElem;
    private final MultiMap<String, String> m_nameMap = new MultiMap();
    private final MultiMap<String, DBObjectID> m_idMap = new MultiMap();
    private String m_openingName;
    private DBObjectID m_lastID;

    DBObjectRefsSAXHelper(String namespace, DBObjectHandler.UnmarshalledIDs ids, Collection<String> patterns, Collection<String> parseProps) {
        super(namespace);
        this.m_ids = ids;
        this.m_patterns = patterns;
        this.m_parseProps = parseProps;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.m_rootElem == null) {
            this.checkNamespace(uri);
            this.m_rootElem = localName;
        } else {
            this.m_xmlPath.add(localName);
        }
        this.clearChars();
        Class<? extends BaseObjectID> idClz = this.getIDClass(localName, attributes);
        if (idClz != null) {
            if (!"parent".equals(localName)) {
                if (this.getStackSize() > 0) {
                    throw new SAXException(new IllegalStateException("current but not parent"));
                }
                this.m_openingName = localName;
            }
            try {
                BaseObjectID id = idClz.newInstance();
                this.push(id, localName);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        } else if (!"name".equals(localName)) {
            this.m_lastID = null;
        }
    }

    private boolean isSupportedIDClass(String className) {
        for (String pattern : this.m_patterns) {
            if (!className.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    private Class<? extends BaseObjectID> getIDClass(String localName, Attributes attributes) {
        Class<?> retval = null;
        String classAttr = attributes.getValue("class");
        if (ModelUtil.hasLength((String)classAttr) && this.isSupportedIDClass(classAttr)) {
            try {
                Class<?> clz = this.findClassLoader().loadClass(classAttr);
                if (BaseObjectID.class.isAssignableFrom(clz)) {
                    retval = clz;
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Couldn't load id class " + classAttr);
            }
        }
        return retval;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        BaseObjectID id;
        int size;
        if (!this.m_xmlPath.isEmpty() || !ModelUtil.areEqual((Object)localName, (Object)this.m_rootElem)) {
            int lastInPath = this.m_xmlPath.size() - 1;
            if (lastInPath < 0 || ModelUtil.areDifferent((Object)localName, (Object)this.m_xmlPath.get(lastInPath))) {
                throw new SAXException(new IllegalStateException("path is broken: " + this.m_xmlPath));
            }
            this.m_xmlPath.remove(lastInPath);
        }
        if (this.hasChars() && this.m_parseProps.contains(localName)) {
            String sql = this.getChars();
            Collection refs = SQLFragmentUtils.getReferenceIDs((String)sql, (DBObjectProvider)this.getProvider());
            for (DBObjectID ref : refs) {
                this.m_ids.addReferenceID(ref);
            }
        }
        if ((size = this.getStackSize()) > 1 && "parent".equals(localName)) {
            id = (BaseObjectID)this.pop(localName);
            BaseObjectID kid = (BaseObjectID)this.getCurrentObject();
            kid.setParent((DBObjectID)id);
            this.m_ids.addReferenceID((DBObjectID)id);
        } else if (size > 0) {
            if (this.hasChars()) {
                String val = this.getChars();
                BaseObjectID id2 = (BaseObjectID)this.getCurrentObject();
                if ("name".equals(localName)) {
                    id2.setName(val);
                } else if ("identifier".equals(localName) && id2 instanceof IdentifierBasedID) {
                    ((IdentifierBasedID)id2).setIdentifier((Object)val);
                } else if ("type".equals(localName)) {
                    id2.setType(val);
                } else if ("schemaName".equals(localName)) {
                    id2.setSchemaName(val);
                } else if ("databaseName".equals(localName)) {
                    id2.setDatabaseName(val);
                }
            }
            if (size == 1 && ModelUtil.areEqual((Object)this.m_openingName, (Object)localName)) {
                id = (BaseObjectID)this.pop(localName);
                if ("ID".equals(localName)) {
                    this.m_idMap.add((Object)this.getCurrentXMLPath(), (Object)id);
                } else {
                    this.m_ids.addReferenceID((DBObjectID)id);
                }
                this.m_openingName = null;
                this.m_lastID = id;
            }
        } else if (size == 0 && "name".equals(localName) && this.hasChars()) {
            String xmlPath = this.getCurrentXMLPath();
            if (!this.m_idMap.containsKey((Object)xmlPath)) {
                this.m_nameMap.add((Object)xmlPath, (Object)this.getChars());
            } else if (this.m_lastID instanceof BaseObjectID && ((BaseObjectID)this.m_lastID).getName() == null) {
                ((BaseObjectID)this.m_lastID).setName(this.getChars());
            }
        }
        this.clearChars();
    }

    @Override
    public void endDocument() throws SAXException {
        String type;
        String xmlPath;
        NameBasedID topLevel = null;
        for (Map.Entry entry : this.m_nameMap.entrySet()) {
            xmlPath = (String)entry.getKey();
            type = this.getObjectType(xmlPath);
            if (type == null) continue;
            for (String name : (Collection)entry.getValue()) {
                NameBasedID id = new NameBasedID();
                id.setName(name);
                id.setType(type);
                if (!ModelUtil.hasLength((String)xmlPath)) {
                    topLevel = id;
                } else {
                    id.setParent((DBObjectID)topLevel);
                }
                this.m_ids.addObjectID((DBObjectID)id);
            }
        }
        for (Map.Entry entry : this.m_idMap.entrySet()) {
            xmlPath = (String)entry.getKey();
            type = this.getObjectType(xmlPath);
            for (DBObjectID id : (Collection)entry.getValue()) {
                if (id instanceof BaseObjectID && id.getType() == null) {
                    ((BaseObjectID)id).setType(type);
                }
                this.m_ids.addObjectID(id);
            }
        }
    }

    private String getCurrentXMLPath() {
        StringBuilder buff = new StringBuilder();
        for (String elem : this.m_xmlPath) {
            if (buff.length() > 0) {
                buff.append("/");
            }
            buff.append(elem);
        }
        return buff.toString();
    }

    private String getObjectType(String xmlPath) throws SAXException {
        String retval = this.m_elemToTypeMap.get(xmlPath);
        if (retval == null) {
            if (ModelUtil.hasLength((String)xmlPath)) {
                Class propClz;
                String rootType = this.getObjectType(null);
                PropertyInfo prop = null;
                String propPath = Property.stripProperties((String)xmlPath);
                String[] bits = Property.getProperties((String)propPath);
                if (bits.length > 1 && bits[bits.length - 2].startsWith(bits[bits.length - 1])) {
                    prop = PropertyHelper.findPropertyInfo((String)rootType, (String)Property.getParentProperty((String)propPath), null);
                }
                if (prop == null) {
                    prop = PropertyHelper.findPropertyInfo((String)rootType, (String)propPath, null);
                }
                if (prop != null && DBObject.class.isAssignableFrom(propClz = DBUtil.decodeArrayClass((Class)prop.getPropertyClass()))) {
                    retval = Metadata.getType((Class)propClz);
                }
            } else {
                for (String type : Metadata.getInstance().getDBObjectClasses().keySet()) {
                    if (!DBObject2XML.convertType(type).equals(this.m_rootElem)) continue;
                    retval = type;
                    break;
                }
                if (retval == null) {
                    throw new SAXException(new IllegalStateException("No object type found for root element " + xmlPath));
                }
            }
            this.m_elemToTypeMap.put(xmlPath, retval);
        }
        return retval;
    }
}

