/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.marshal.DBObjectHandler;
import oracle.javatools.db.marshal.DBObjectXMLHandler;
import oracle.javatools.db.marshal.DBObjectXMLSupport;
import oracle.javatools.db.marshal.PartialParseUnsupportedException;
import oracle.javatools.db.ora.Oracle11gR2;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlSqlObjectHandler
extends DBObjectHandler {
    private final DBObjectHandler m_delegateWriteHandler;
    private final List<DBObjectHandler> m_delegateReadHandlers;
    private final PlSqlSearch m_typeAndNameSearch;
    private final PlSqlSearch m_disabledTriggerSearch;
    private static final String NEWLINE = "\n";
    private static final String BLANKLINE = "\n\n";
    private static final String CR = "\r";
    private static final String CRNEWLINE = "\r\n";
    private static final String NEWLINESLASH = "\n/";
    private static final String NEWLINECOMMENT = "\n-- ";
    private static final String COMMENT = "-- ";
    private DatabaseDescriptor m_ora11gR2Descriptor;
    private Set<String> m_predfinedDataTypes;

    public PlSqlObjectHandler() {
        this(null);
    }

    public PlSqlObjectHandler(String namespace) {
        this.m_delegateWriteHandler = DBObjectXMLSupport.getInstance().getHandler(namespace);
        this.m_delegateReadHandlers = new ArrayList<DBObjectHandler>();
        this.m_delegateReadHandlers.add(this.m_delegateWriteHandler);
        this.m_typeAndNameSearch = new PlSqlSearch("[create [or replace] ] <type ? [body]> <name ?.>");
        this.m_disabledTriggerSearch = new PlSqlSearch("/ alter trigger ?. disable /");
    }

    public void addLegacyReadHandlers(String namespace) {
        DBObjectXMLHandler legacyReadHandler = DBObjectXMLSupport.getInstance().getHandler(namespace);
        this.m_delegateReadHandlers.add(legacyReadHandler);
    }

    public void write(List<? extends DBObject> objs, Writer writer) throws IOException {
        DBObject obj = objs.get(0);
        if (obj instanceof PlSqlSourceObject) {
            Trigger trig;
            PlSqlSourceObject so = (PlSqlSourceObject)obj;
            StringWriter headerWriter = new StringWriter();
            StringBuilder header = new StringBuilder();
            StringBuilder source = new StringBuilder();
            if (so.getSource() != null) {
                source.append(so.getSource().trim());
                if (!source.toString().endsWith(NEWLINESLASH)) {
                    source.append(NEWLINESLASH);
                }
                source.append(NEWLINE);
            }
            boolean headerRequired = false;
            PlSqlUtil.TypeAndNameInfo typeAndName = PlSqlUtil.getTypeAndNameFromSource(so, this.getDescriptor());
            if (!so.getType().equals(typeAndName.m_type) || !so.getName().equals(typeAndName.m_name)) {
                headerRequired = true;
            }
            if (!headerRequired && so.getProperties() != null) {
                for (Object o : so.getProperties().keySet()) {
                    if (!(o instanceof String)) continue;
                    String prop = (String)o;
                    if (so instanceof Trigger && "enabled".equals(prop) || Metadata.getInstance().isBeanProperty(so.getClass(), prop) || so.getProperty(prop) == null) continue;
                    headerRequired = true;
                    break;
                }
            }
            if (headerRequired && this.m_delegateWriteHandler != null) {
                so = (PlSqlSourceObject)DBUtil.makeClonedCopy((DBObject)so);
                so.setSource(null);
                so.setID(null);
                so.setSchema(null);
                if (so instanceof DBObjectPlSqlFragment) {
                    ((DBObjectPlSqlFragment)so).setStartOffset(null);
                    ((DBObjectPlSqlFragment)so).setEndOffset(null);
                }
                if (so instanceof Trigger) {
                    so.getProperties().remove("enabled");
                }
                this.m_delegateWriteHandler.write(Collections.singletonList(so), (Writer)headerWriter);
                String xml = headerWriter.toString().trim();
                if (xml.length() > 0) {
                    header.append(COMMENT);
                    header.append(xml.replaceAll(NEWLINE, NEWLINECOMMENT));
                    header.append(BLANKLINE);
                    writer.write(header.toString());
                }
            }
            writer.write(source.toString());
            if (obj instanceof Trigger && !(trig = (Trigger)obj).isEnabled()) {
                PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)trig);
                writer.write(NEWLINE);
                writer.write("ALTER TRIGGER " + pi.getName() + " DISABLE");
                writer.write(NEWLINESLASH);
                writer.write(NEWLINE);
            }
            writer.close();
        }
    }

    public boolean canRead(Reader reader, DBObjectProvider pro) throws IOException {
        PlSqlToken tk = PlSqlTokenizer.tokenize((Reader)reader, (Integer)10, (String[])new String[0]);
        if (this.m_typeAndNameSearch.matches(tk)) {
            return true;
        }
        if (tk != null) {
            return this.getXMLHeader(tk) != null;
        }
        return false;
    }

    protected List<DBObject> readImpl(Reader reader, DBObjectProvider pro, Schema schema) throws IOException {
        return this.readImpl(reader, pro, schema, true);
    }

    protected List<DBObject> readInfoImpl(Reader reader, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        return this.readImpl(reader, pro, schema, false);
    }

    private List<DBObject> readImpl(Reader reader, DBObjectProvider pro, Schema schema, boolean all) throws IOException {
        String nameInSource;
        String typeInSource;
        DBObject retval = null;
        PlSqlToken tk = PlSqlTokenizer.tokenize((Reader)new EOLFixingReader(reader), null, (String[])new String[0]);
        String xmlHeader = this.getXMLHeader(tk);
        if (this.m_typeAndNameSearch.matches(tk)) {
            typeInSource = this.m_typeAndNameSearch.getNamedMatch("type").toUpperCase();
            PlSqlToken nameTk = this.m_typeAndNameSearch.getNamedMatchEndToken("name");
            if (nameTk.getType() == PlSqlToken.Type.DOUBLE_QUOTED_STRING) {
                String n = nameTk.getSource();
                nameInSource = n.substring(1, n.length() - 1);
            } else {
                nameInSource = nameTk.getSource(true);
            }
        } else {
            typeInSource = null;
            nameInSource = null;
        }
        if (xmlHeader != null) {
            IOException firstIOE = null;
            for (DBObjectHandler readHandler : this.m_delegateReadHandlers) {
                try {
                    List delegateResult = readHandler.read((Reader)new StringReader(xmlHeader), pro, schema);
                    if (delegateResult == null || delegateResult.size() <= 0) continue;
                    retval = (DBObject)delegateResult.get(0);
                    firstIOE = null;
                    break;
                }
                catch (IOException ioe) {
                    if (firstIOE != null) continue;
                    firstIOE = ioe;
                }
            }
            if (firstIOE != null) {
                DBLog.getLogger(PlSqlObjectHandler.class).log(Level.WARNING, "Failed to parse XML Header {0} {1}", new Object[]{typeInSource, nameInSource});
            }
        }
        if (retval == null && typeInSource != null && nameInSource != null) {
            retval = Metadata.getInstance().newDBObject(typeInSource, nameInSource);
        }
        if (retval == null) {
            throw new IOException("Failed to create PL/SQL object");
        }
        if (retval.getName() == null) {
            retval.setName(nameInSource);
        }
        DBObjectID parent = null;
        NameBasedID id = new NameBasedID(retval, parent);
        id.setSchema(schema);
        id.setProvider(pro);
        retval.setID((DBObjectID)id);
        if (all) {
            PlSqlToken endTk = tk;
            while (endTk.getNextToken().getType() != PlSqlToken.Type.END_MARKER) {
                if (endTk.matches("/")) {
                    PlSqlToken prev = endTk.getPrevToken();
                    PlSqlToken next = endTk.getNextToken();
                    if (prev.getType() == PlSqlToken.Type.WHITESPACE && next.getType() == PlSqlToken.Type.WHITESPACE) {
                        String prevStr = prev.getSource(false);
                        String nextStr = next.getSource(false);
                        if (prevStr.endsWith(NEWLINE) && nextStr.contains(NEWLINE)) break;
                    }
                }
                endTk = endTk.getNextToken();
            }
            if (endTk.matches("/")) {
                for (endTk = endTk.getPrevToken(); endTk != null && !endTk.isCode(); endTk = endTk.getPrevToken()) {
                }
            }
            ((PlSqlSourceObject)retval).setSource(tk.getSource(false, endTk));
            if (retval instanceof Type) {
                PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)((PlSqlSourceObject)retval));
                ((Type)retval).setTypeCode(pi.getTypeCode());
                ((Type)retval).setCollectionType(pi.getCollectionType());
            } else if (retval instanceof Trigger && this.m_disabledTriggerSearch.matches(endTk = endTk.getNextCodeToken())) {
                ((Trigger)retval).setEnabled(false);
            }
            if (pro != null) {
                pro.getObjectFactory().ensureID(retval, true, true);
            }
        }
        return Collections.singletonList(retval);
    }

    private String getXMLHeader(PlSqlToken firstCodeToken) {
        String line;
        PlSqlToken tk = firstCodeToken;
        while (tk.getPrevToken().getType() != PlSqlToken.Type.END_MARKER) {
            tk = tk.getPrevToken();
        }
        StringBuilder xmlHeader = new StringBuilder();
        if (tk.getType() == PlSqlToken.Type.SINGLE_LINE_COMMENT && (line = tk.getSource().substring(2).trim()).startsWith("<?xml")) {
            while (!tk.isCode()) {
                String ws;
                if (tk.getType() == PlSqlToken.Type.SINGLE_LINE_COMMENT) {
                    line = tk.getSource().substring(2).trim();
                    xmlHeader.append(line);
                }
                if ((tk = tk.getNextToken()).getType() != PlSqlToken.Type.WHITESPACE || !(ws = tk.getSource(false)).contains(BLANKLINE)) continue;
                break;
            }
        }
        return xmlHeader.length() == 0 ? null : xmlHeader.toString();
    }

    protected void readIDsImpl(DBObjectHandler.UnmarshalledIDs retval, Reader reader, DBObjectProvider pro, Schema schema) throws IOException, PartialParseUnsupportedException {
        List<DBObject> objs = this.readImpl(reader, pro, schema);
        if (objs != null) {
            for (DBObject so : objs) {
                if (!(so instanceof PlSqlSourceObject)) continue;
                retval.addObjectID(so.getID());
                this.getPossiblePlSqlRefs((PlSqlSourceObject)so, retval);
            }
        }
    }

    private void getPossiblePlSqlRefs(PlSqlSourceObject so, DBObjectHandler.UnmarshalledIDs refs) {
        HashSet<String> names = new HashSet<String>();
        PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)so);
        this.addTokens(pi.getRoot(), names, this.getDescriptor().getInternalName(pi.getName(), null));
        if (so instanceof PlSqlSchemaObjectBody) {
            names.add(so.getName());
        }
        for (String name : names) {
            ReferenceID id = new ReferenceID("UNSPECIFIED_TYPE", (String)null, name);
            refs.addReferenceID((DBObjectID)id);
        }
    }

    private void addTokens(PlSqlFragment frag, Set<String> names, String startAfter) {
        PlSqlToken token = frag.getFirstToken();
        boolean ignorePredefinedDTs = false;
        PlSqlToken endToken = token.getPrevToken();
        if (frag.getChildren().length == 0) {
            endToken = frag.getLastToken();
        } else if (frag.getChildren()[0].getFirstToken().getStart() > token.getStart()) {
            endToken = frag.getChildren()[0].getFirstToken().getPrevToken();
        }
        if (frag.getFragmentType() == PlSqlFragment.Type.DECLARATION || frag.getFragmentType() == PlSqlFragment.Type.PARAMETER) {
            ignorePredefinedDTs = true;
        }
        boolean childObjct = false;
        while (token != null && token.getStart() <= endToken.getStart()) {
            String indexValue = this.getIndexValue(token, ignorePredefinedDTs);
            if (startAfter != null) {
                if (startAfter.equals(indexValue)) {
                    startAfter = null;
                }
                indexValue = null;
            }
            if (indexValue != null) {
                if (!childObjct) {
                    names.add(indexValue);
                    if (token.getNextCodeToken().matches(".") && token.getNextCodeToken(2).getType() != PlSqlToken.Type.END_MARKER) {
                        childObjct = true;
                        token = token.getNextCodeToken();
                    }
                } else {
                    names.add(indexValue);
                    while (token.getNextCodeToken().matches(".")) {
                        token = token.getNextCodeToken(2);
                    }
                    childObjct = false;
                }
            }
            token = token.getNextCodeToken();
        }
        for (PlSqlFragment childFrag : frag.getChildren()) {
            this.addTokens(childFrag, names, startAfter);
        }
    }

    private String getIndexValue(PlSqlToken token, boolean ignorePredefinedDTs) {
        if (this.m_predfinedDataTypes == null) {
            this.m_predfinedDataTypes = new HashSet<String>();
            ArrayList ds = new ArrayList();
            ds.addAll(this.getDescriptor().listSupportedDataTypes());
            for (DataType d : ds) {
                if (!(d instanceof PredefinedDataType)) continue;
                this.m_predfinedDataTypes.add(d.getName());
            }
        }
        String internalName = this.getDescriptor().getInternalName(token.getSource(), null);
        if (token.getType() == PlSqlToken.Type.ALPHANUMERIC && !PlSqlToken.isReservedWord((PlSqlToken)token) && !token.isNumber() ? !ignorePredefinedDTs || !this.m_predfinedDataTypes.contains(internalName) : token.getType() == PlSqlToken.Type.DOUBLE_QUOTED_STRING) {
            return internalName;
        }
        return null;
    }

    private DatabaseDescriptor getDescriptor() {
        if (this.m_ora11gR2Descriptor == null) {
            this.m_ora11gR2Descriptor = DatabaseFactory.getDatabaseDescriptor(Oracle11gR2.class);
        }
        return this.m_ora11gR2Descriptor;
    }

    private static class EOLFixingReader
    extends Reader {
        private final Reader m_delegate;

        public EOLFixingReader(Reader reader) {
            this.m_delegate = reader;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            char[] buffer = new char[cbuf.length];
            if ((len = this.m_delegate.read(buffer, off, len)) > -1) {
                String strBuff = new String(buffer, off, len);
                strBuff = strBuff.replaceAll(PlSqlObjectHandler.CRNEWLINE, PlSqlObjectHandler.NEWLINE);
                strBuff = strBuff.replaceAll(PlSqlObjectHandler.CR, PlSqlObjectHandler.NEWLINE);
                len = strBuff.length();
                StringReader sr = new StringReader(strBuff);
                sr.read(cbuf, off, len);
            }
            return len;
        }

        public void close() throws IOException {
            this.m_delegate.close();
        }
    }
}

