/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.mysql.MySQLColumnValidator;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DataTypeUsageValidator;
import oracle.javatools.db.validators.ValidationException;

public class MySQLDataTypeUsageValidator
extends DataTypeUsageValidator {
    public MySQLDataTypeUsageValidator(DBObjectProvider dbObjectProvider) {
        super(dbObjectProvider);
    }

    protected void validateAttributes(DataTypeUsage dataTypeUsage, DataType dataType) throws ValidationException {
        Long scaleVal;
        boolean skipSuper = false;
        if ("FLOAT".equals(dataType.getName()) && (scaleVal = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale")) == null) {
            skipSuper = true;
            Long size = (Long)dataTypeUsage.getAttributeValue("size");
            if (size != null) {
                long max;
                long min = MySQLColumnValidator.FLOAT_PRECISION.getMinValue();
                if (size.compareTo(min) < 0) {
                    this.throwAttributeValueInvalid(dataTypeUsage, "size", APIBundle.format((String)"DATATYPE_ERROR_INVALID_NUMERIC_VALUE1", (Object[])new Object[]{DataTypeHelper.getNameFromLabel((String)"DATATYPE_ATTRIBUTE_LABEL_SIZE"), min}));
                }
                if (size.compareTo(max = MySQLColumnValidator.FLOAT_PRECISION.getMaxValue().longValue()) > 0) {
                    this.throwAttributeValueInvalid(dataTypeUsage, "size", APIBundle.format((String)"DATATYPE_ERROR_INVALID_MYSQL_FLOAT", (Object[])new Object[]{DataTypeHelper.getNameFromLabel((String)"DATATYPE_ATTRIBUTE_LABEL_SIZE"), max}));
                }
            }
        }
        if (!skipSuper) {
            super.validateAttributes(dataTypeUsage, dataType);
        }
    }
}

