/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.db.mysql.MySQLDatabase;
import oracle.javatools.db.mysql.MySQLTableBuilder;
import oracle.javatools.db.mysql.MySQLViewBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDatabaseImpl
extends JdbcDDLDatabase
implements MySQLDatabase {
    protected MySQLDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    @Override
    protected void registerBuilders(Collection<String> types, String catalog) {
        super.registerBuilders(types, catalog);
        if (types.contains("TABLE")) {
            this.registerBuilder("TABLE", (DBObjectBuilder)new MySQLTableBuilder(this, catalog));
        }
        if (types.contains("VIEW")) {
            this.registerBuilder("VIEW", (DBObjectBuilder)new MySQLViewBuilder(this, catalog));
        }
    }

    @Override
    public Schema getSchema(String name) throws DBException {
        Schema schema = super.getSchema(name);
        if (schema == null) {
            schema = super.getSchema(this.getCatalog());
        }
        return schema;
    }

    @Override
    protected Schema findSchema(String name) throws DBException {
        Schema schema = super.findSchema(name);
        if (schema == null) {
            schema = super.getSchema(this.getCatalog());
        }
        return schema;
    }

    @Override
    public String normaliseDefaultValue(DataType dataType, String defaultValue) {
        if (!DataTypeHelper.isNumericType((DataType)dataType)) {
            defaultValue = defaultValue.replaceAll("'", "''");
            defaultValue = "'" + defaultValue + "'";
        }
        return defaultValue;
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    protected void processDeleteException(DBException dbe, SystemObject obj) throws DBException {
        int code;
        Throwable cause = dbe.getCause();
        if (cause instanceof SQLException && ((code = ((SQLException)cause).getErrorCode()) == 1217 || code == 1091)) {
            throw new CascadeRequiredException((DBObject)obj, ((SQLException)cause).getMessage());
        }
        throw dbe;
    }

    public Boolean isConnectionClosed(SQLException sqe) {
        return super.isConnectionClosed(sqe) != null;
    }
}

