/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.dictionary.DictionaryDatabase;
import oracle.javatools.db.dictionary.DictionaryQueries;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleQueryWrapper;
import oracle.javatools.db.ora.OracleSchemaBuilder;
import oracle.javatools.db.ora.OracleSchemaProperties;
import oracle.javatools.db.ora.OracleSequenceBuilder;
import oracle.javatools.db.ora.OracleSynonymBuilder;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleViewBuilder;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OracleConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseOracleDatabase
extends DictionaryDatabase
implements OracleDatabase,
DatabaseLink.DefaultSchemaFinder {
    static final String PUBLIC_NAME = "PUBLIC";
    private final OracleDictionaryQueries m_dictionary = new OracleDictionaryQueries(this);
    private SessionParameterQueryMap m_nlsParamQueries = null;
    private final Holder<String> m_databaseLinkNameSuffix = new Holder();

    BaseOracleDatabase(String storeName, String connName, Connection conn) {
        super(storeName, connName, conn);
    }

    public DictionaryQueries getDictionaryQueries() {
        return this.m_dictionary;
    }

    public void disableDBAViews() {
        this.m_dictionary.disableDBAViews();
    }

    @Deprecated
    public int getOracleDatabaseType() {
        return this.getDatabaseVersion();
    }

    protected QueryWrapper newQueryWrapper(SystemObject obj, String query, Object ... params) {
        return this.newQueryWrapper(obj, query, Arrays.asList(params));
    }

    protected QueryWrapper newQueryWrapper(SystemObject obj, String query, List params) {
        OracleQueryWrapper wrap = new OracleQueryWrapper(this, query, params);
        if (obj != null && obj.getID() instanceof BaseObjectID) {
            wrap.setDatabaseName(((BaseObjectID)obj.getID()).getDatabaseName());
        }
        return wrap;
    }

    protected final boolean isPublicSchema(Schema schema) {
        return schema != null && PUBLIC_NAME.equals(schema.getName());
    }

    protected final boolean isCurrentUser(Schema schema) {
        return schema != null && ModelUtil.areEqual((Object)this.getUserName(), (Object)schema.getName());
    }

    public void clearAllCaches() {
        super.clearAllCaches();
        this.m_databaseLinkNameSuffix.set(null);
        if (this.m_nlsParamQueries != null) {
            this.m_nlsParamQueries.markAsDirty();
        }
    }

    protected boolean isConnectionAlive(Connection conn) {
        boolean retval;
        if (conn instanceof OracleConnection) {
            try {
                int ping = ((OracleConnection)conn).pingDatabase();
                retval = ping == 0;
            }
            catch (SQLException sqe) {
                retval = false;
            }
        } else {
            retval = super.isConnectionAlive(conn);
        }
        return retval;
    }

    protected String getTransactionTestQuery() {
        return "SELECT /*OracleDictionaryQueries.LOCAL_TRANSACTION_QUERY*/ dbms_transaction.local_transaction_id FROM SYS.DUAL";
    }

    protected void registerBuilders() {
        this.registerBuilder("SCHEMA", (DBObjectBuilder)new OracleSchemaBuilder(this));
        this.registerBuilder("SYNONYM", (DBObjectBuilder)new OracleSynonymBuilder(this));
        this.registerBuilder("SEQUENCE", (DBObjectBuilder)new OracleSequenceBuilder(this));
        this.registerBuilder("TABLE", (DBObjectBuilder)new OracleTableBuilder(this));
        this.registerBuilder("INDEX", (DBObjectBuilder)new OracleIndexBuilder(this));
        this.registerBuilder("VIEW", (DBObjectBuilder)new OracleViewBuilder(this));
    }

    public boolean supportsDebugging() {
        return false;
    }

    protected DBObjectBuilder getBuilderForType(String type) {
        return super.getBuilderForType(type);
    }

    <T extends AbstractBuildableObject> void setOracleBuilder(T object, OracleDBObjectBuilder<? super T> builder) {
        this.markForLazyInit(object, (DBObjectBuilder)builder);
    }

    protected void cacheObject(SystemObject object, boolean loadOperation) {
        super.cacheObject(object, loadOperation);
    }

    public boolean hasSystemPrivilege(String type, Schema schema, String priv) {
        return !ModelUtil.areEqual((Object)"CREATE", (Object)priv) && super.hasSystemPrivilege(type, schema, priv);
    }

    public void validateUniqueName(DBObject object, final DBObject contextObject) throws NameInUseException {
        String name = object.getName();
        String type = object.getType();
        if (ModelUtil.hasLength((String)name)) {
            if (!(contextObject instanceof Schema)) {
                super.validateUniqueName(object, contextObject);
                return;
            }
            Schema schema = (Schema)contextObject;
            if ("DATABASE LINK".equals(type)) {
                NameInUseException nameInUseException = null;
                String suffix = this.getGlobalName();
                try {
                    for (String dbLinkName : this.listObjects("DATABASE LINK", schema, name)) {
                        if (!dbLinkName.equals(name) && !dbLinkName.equals(name + suffix)) continue;
                        nameInUseException = new NameInUseException(object, dbLinkName, "DATABASE LINK");
                    }
                }
                catch (DBException e) {
                    // empty catch block
                }
                if (nameInUseException != null) {
                    throw nameInUseException;
                }
            } else {
                final Holder found = new Holder();
                String query = this.m_dictionary.getValidateNamespaceQuery(type);
                List params = this.getParameters(this.m_dictionary.getValidateNamespaceQueryParams(type), BaseOracleDatabase.convertObject((DBObject)schema), name, null);
                final QueryWrapper wrap = this.newQueryWrapper((SystemObject)null, query, params);
                QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            if (rs.next()) {
                                found.set((Object)new String[]{rs.getString(1), rs.getString(2)});
                            }
                        }
                        catch (SQLException sqe) {
                            wrap.throwDBException(contextObject, sqe);
                        }
                    }
                };
                try {
                    wrap.executeQuery(r);
                }
                catch (DBException dbe) {
                    this.getLogger().log(Level.WARNING, APIBundle.format((String)"UNIQUE_NAME_CHECK_ERR", (Object[])new Object[]{dbe.getMessage()}));
                }
                String[] existing = (String[])found.get();
                if (existing != null) {
                    throw new NameInUseException(object, existing[0], existing[1]);
                }
            }
        }
    }

    public String getUniqueName(String type, DBObject contextObject, String baseName) {
        if (!(contextObject instanceof Schema)) {
            return super.getUniqueName(type, contextObject, baseName);
        }
        Schema schema = (Schema)contextObject;
        if ("DATABASE LINK".equals(type)) {
            if (!ModelUtil.hasLength((String)baseName)) {
                baseName = "DBLINK";
            }
            try {
                String suffix = this.getGlobalName();
                String namePart1 = baseName.split("\\.")[0];
                String namePart2 = baseName.replaceFirst(baseName, "");
                HashSet<String> names = new HashSet<String>();
                boolean nameSeen = false;
                for (String dbLinkName : this.listObjects("DATABASE LINK", schema)) {
                    if (dbLinkName.equals(baseName) || dbLinkName.equals(baseName + suffix)) {
                        nameSeen = true;
                    }
                    names.add(dbLinkName.split("\\.")[0]);
                }
                return nameSeen ? DBUtil.getUniqueName(names, (String)namePart1) + namePart2 : baseName;
            }
            catch (DBException e) {
                // empty catch block
            }
        }
        final HashSet names = new HashSet();
        type = this.normaliseType(type);
        if (!ModelUtil.hasLength((String)baseName)) {
            baseName = type + 1;
        }
        int maxLen = this.getDescriptor().getMaxNameLength(type);
        int maxChop = 3;
        String queryName = baseName;
        if (queryName.length() > maxLen - 3) {
            queryName = queryName.substring(0, maxLen - 3);
        }
        String objectNameLike = queryName.replaceAll("\\d*$", "") + '%';
        String query = this.m_dictionary.getNamespaceQuery(type);
        List params = this.getParameters(this.m_dictionary.getNamespaceQueryParams(type), BaseOracleDatabase.convertObject((DBObject)schema), objectNameLike, null);
        final QueryWrapper wrap = this.newQueryWrapper((SystemObject)null, query, params);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        names.add(rs.getString(1));
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException(sqe);
                }
            }
        };
        try {
            wrap.executeQuery(r);
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, APIBundle.format((String)"UNIQUE_NAME_CHECK_ERR", (Object[])new Object[]{dbe.getMessage()}));
        }
        return DBUtil.getUniqueName(names, (String)baseName, (boolean)true, (int)maxLen);
    }

    public boolean canRestrictSchemaList() {
        return true;
    }

    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> criteria) throws DBException {
        Collection retval = super.listObjectsImpl(criteria);
        if (criteria.isAllowedType("SCHEMA") && criteria.isAllowedName(PUBLIC_NAME)) {
            Schema pubSchema = null;
            if (criteria.getDatabaseName() == null) {
                pubSchema = (Schema)this.findObject("SCHEMA", null, PUBLIC_NAME);
            }
            if (pubSchema == null) {
                pubSchema = new Schema(PUBLIC_NAME);
                pubSchema.setID(this.createID(criteria.getDatabaseName(), null, PUBLIC_NAME, "SCHEMA", null));
            }
            retval.add(pubSchema);
        }
        return retval;
    }

    protected SystemObject loadObjectImpl(String type, Schema schema, String name) throws DBException {
        SystemObject retval;
        if ("SCHEMA".equals(type) && (PUBLIC_NAME.equals(name) || ModelUtil.areEqual((Object)this.getUserName(), (Object)name))) {
            retval = (Schema)this.findObject("SCHEMA", null, name);
            if (retval == null) {
                Schema s = new Schema(name);
                s.setID(this.createID(null, schema, name, type, null));
                this.markForLazyInit((AbstractBuildableObject)s);
                retval = s;
            }
        } else {
            retval = super.loadObjectImpl(type, schema, name);
        }
        return retval;
    }

    public boolean supportsTimestamps(String objectType) {
        boolean retval = "DATABASE LINK".equals(objectType) || "XML SCHEMA".equals(objectType) || !Metadata.getInstance().isTypeOf(SchemaObject.class, objectType) ? false : super.supportsTimestamps(objectType);
        return retval;
    }

    protected <T extends SystemObject> T checkCachedObject(T object) throws DBException {
        Object retval = object instanceof Schema && (this.isCurrentUser((Schema)object) || this.isPublicSchema((Schema)object)) ? object : super.checkCachedObject(object);
        return (T)retval;
    }

    @Deprecated
    public final String[] listTablespaces() {
        final ArrayList list = new ArrayList();
        final QueryWrapper wrap = this.newQueryWrapper(null, "SELECT /*OracleDictionaryQueries.QUERY_TABLESPACES*/ TABLESPACE_NAME FROM SYS.USER_TABLESPACES WHERE CONTENTS = 'PERMANENT'", new Object[0]);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        list.add(rs.getString(1));
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException(sqe);
                }
            }
        };
        try {
            wrap.executeQuery(r);
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "could not query tablespaces from " + this.getConnectionName(), dbe);
        }
        return list.toArray(new String[list.size()]);
    }

    protected boolean isCauseNameInUse(DBException dbe) {
        int errorCode;
        Throwable cause = dbe.getCause();
        return cause instanceof SQLException && ((errorCode = ((SQLException)cause).getErrorCode()) == 955 || errorCode == 12000 || errorCode == 12006 || errorCode == 2011);
    }

    protected void processDeleteException(DBException dbe, SystemObject obj) throws DBException {
        Throwable cause = dbe.getCause();
        if (cause instanceof SQLException) {
            int code = ((SQLException)cause).getErrorCode();
            if (code == 2441 || code == 2442 || code == 2443) {
                return;
            }
            if (code == 2449) {
                throw new CascadeRequiredException((DBObject)obj, cause.getMessage());
            }
        }
        throw dbe;
    }

    public String getDatabaseSource(String objectType, Schema schema, String objectName, String sourceType) throws DBException {
        SchemaObject object;
        String source = null;
        String type = objectType;
        if ("Body".equals(sourceType)) {
            if ("PACKAGE".equals(type)) {
                type = "PACKAGE BODY";
            } else if ("TYPE".equals(type)) {
                type = "TYPE BODY";
            }
        }
        if ((object = this.getObject(type, schema, objectName)) instanceof SourceObject) {
            source = ((SourceObject)object).getSource();
        }
        if (source == null) {
            return null;
        }
        if (!(object instanceof PlSqlSourceObject)) {
            return source;
        }
        if (source.indexOf("CREATE OR REPLACE") == 0) {
            return source;
        }
        return "CREATE OR REPLACE \n" + source;
    }

    public String getDatabaseSource(String objectType, Schema schema, String objectName) throws DBException {
        return this.getDatabaseSource(objectType, schema, objectName, null);
    }

    protected SystemObject getCreatedObject(String type, Schema schema, String name) throws DBException {
        SystemObject retval = super.getCreatedObject(type, schema, name);
        if (retval == null && type.equals("DATABASE LINK")) {
            DBObjectCriteria crit = new DBObjectCriteria(DatabaseLink.class, new String[0]);
            crit.setName(name + this.getGlobalName());
            crit.setSchema(schema);
            Collection possibles = this.listObjects(crit);
            if (possibles != null & possibles.size() == 1) {
                retval = (SystemObject)possibles.iterator().next();
            }
        }
        return retval;
    }

    protected Schema createSchema(Connection conn) {
        final Holder holder = new Holder();
        final QueryWrapper wrap = new QueryWrapper((Database)this, "SELECT /*OracleDictionaryQueries.CURR_USER_QUERY*/ \n       USERNAME\n,      DEFAULT_TABLESPACE\n,      TEMPORARY_TABLESPACE\nFROM   SYS.USER_USERS\nUNION ALL\nSELECT USER, NULL, NULL\nFROM   SYS.DUAL\nWHERE  NOT EXISTS (SELECT 1 FROM SYS.USER_USERS)");
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        Schema currSchema = BaseOracleDatabase.this.createSchema(rs.getString(1));
                        OracleSchemaProperties props = new OracleSchemaProperties();
                        props.setDefaultTablespace(rs.getString(2));
                        props.setTemporaryTablespace(rs.getString(3));
                        currSchema.setProperty("OracleSchemaProperties", (Object)props);
                        holder.set((Object)currSchema);
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException(ex);
                }
            }
        };
        Schema currSchema = null;
        try {
            wrap.executeQuery(r);
            currSchema = (Schema)holder.get();
        }
        catch (DBException dbe) {
            try {
                currSchema = this.createSchema(conn.getMetaData().getUserName());
            }
            catch (SQLException x) {
                // empty catch block
            }
        }
        return currSchema;
    }

    protected boolean isRequestedObject(SystemObject object, String type, Schema schema, String name) {
        Schema objSchema;
        boolean matches = super.isRequestedObject(object, type, schema, name);
        if (!matches && "DATABASE LINK".equals(type) && "DATABASE LINK".equals(object.getType()) && (objSchema = ((SchemaObject)object).getSchema()) != null && ModelUtil.areEqual((Object)objSchema.getName(), (Object)schema.getName())) {
            matches = object.getName().equals(name + this.getGlobalName());
        }
        return matches;
    }

    public String getGlobalName() {
        if (this.m_databaseLinkNameSuffix.get() == null) {
            final Holder holder = new Holder();
            final OracleQueryWrapper wrap = new OracleQueryWrapper(this, "SELECT /*OracleDictionaryQueries.QUERY_GLOBAL_NAME*/ GLOBAL_NAME FROM GLOBAL_NAME ", new Object[0]);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            holder.set((Object)rs.getString(1));
                        }
                    }
                    catch (SQLException ex) {
                        wrap.throwDBException(ex);
                    }
                }
            };
            String suffix = "";
            try {
                wrap.executeQuery(r);
                String globalName = (String)holder.get();
                if (globalName != null && globalName.indexOf(".") != -1) {
                    suffix = globalName.substring(globalName.indexOf("."), globalName.length());
                }
            }
            catch (DBException dbe) {
                this.getLogger().warning(APIBundle.format((String)"GLOBAL_NAME_CHECK_ERR", (Object[])new Object[]{dbe.getMessage()}));
            }
            this.m_databaseLinkNameSuffix.set((Object)suffix);
        }
        return (String)this.m_databaseLinkNameSuffix.get();
    }

    public final String getSessionParameterValue(String parameter) {
        return this.getSessionQueriesImpl().getValue(parameter);
    }

    public final void alterSessionParameterValue(String parameter, String value) throws DBException {
        this.getSessionQueriesImpl().setValue(parameter, value);
    }

    public final void markSessionParametersDirty() {
        this.getSessionQueriesImpl().markAsDirty();
    }

    public final Map<String, String> getSessionParameterQueries() {
        return this.getSessionQueriesImpl();
    }

    private SessionParameterQueryMap getSessionQueriesImpl() {
        if (this.m_nlsParamQueries == null) {
            this.m_nlsParamQueries = new SessionParameterQueryMap(this);
            this.initSessionParameterQueryMap(this.m_nlsParamQueries);
        }
        return this.m_nlsParamQueries;
    }

    protected void initSessionParameterQueryMap(Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null");
        }
        map.put("NLS_SESSION_PARAMS", "select /*OracleDictionaryQueries.NLS_SESSION_PARAMS_QUERY*/\n       s.parameter, s.value \nfrom  sys.nls_session_parameters s");
        map.put("NLS_CHARACTERSET", "select /*OracleDictionaryQueries.NLS_CHARACTERSET_QUERY*/\n       d.parameter, d.value \nfrom  sys.nls_database_parameters d \nwhere d.parameter = 'NLS_CHARACTERSET'");
        map.put("NLS_CHARSET_ID", "select /*OracleDictionaryQueries.NLS_CHARSET_ID_QUERY*/\n     'NLS_CHARSET_ID' parameter, to_char(/**/NLS_CHARSET_ID(charset.value)) value\nfrom (select value\n      from sys.nls_database_parameters\n      where parameter = 'NLS_CHARACTERSET') charset \n");
        map.put("NLS_OTHER_DATABASE_PARAMS", "select /*OracleDictionaryQueries.NLS_OTHER_DATABASE_PARAMS_QUERY*/\n       d.parameter, d.value \nfrom  sys.nls_database_parameters d \nwhere not exists (select 1 from sys.nls_session_parameters s2 \n                  where   s2.parameter = d.parameter) \nand   d.parameter != 'NLS_CHARACTERSET'");
        map.put("DB_TIMEZONE", "select /*OracleDictionaryQueries.DB_TIMEZONE_QUERY*/\n       'DB_TIMEZONE' parameter,  DBTIMEZONE value \nfrom  sys.dual");
        map.put("SESSION_TIMEZONE", "select /*OracleDictionaryQueries.SESSION_TIMEZONE_QUERY*/\n       'SESSION_TIMEZONE' parameter,  SESSIONTIMEZONE value \nfrom  sys.dual");
        map.put("SESSION_TIMEZONE_OFFSET", "select /*OracleDictionaryQueries.SESSION_TIMEZONE_OFFSET_QUERY*/\n       'SESSION_TIMEZONE_OFFSET' parameter,  TZ_OFFSET(SESSIONTIMEZONE) value \nfrom  sys.dual");
    }

    public Schema findDefaultSchema(DatabaseLink link) {
        if (link != null) {
            final Holder h = new Holder();
            String query = "select /*OracleDictionaryQueries.DEFAULT_DBLINK_SCHEMA_QUERY*/\n       sys.dbms_utility.old_current_schema@<LINK> \nfrom   sys.dual".replace("<LINK>", link.getName());
            QueryWrapper wrap = new QueryWrapper((Database)this, query);
            try {
                wrap.executeQuery(new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            if (rs.next()) {
                                h.set((Object)rs.getString(1));
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (DBException e) {
                // empty catch block
            }
            try {
                DBObjectCriteria crit = DBObjectCriteria.createCriteria((String)"SCHEMA", (String)link.getName(), (String)null, (String)((String)h.get()));
                Iterator i$ = this.listObjects(crit).iterator();
                if (i$.hasNext()) {
                    SystemObject so = (SystemObject)i$.next();
                    return (Schema)so;
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger((Object)((Object)this)).warning(dbe.getMessage());
            }
        }
        return null;
    }

    public boolean supportsDatabaseChangeNotification() {
        return false;
    }

    public boolean isDatabaseChangeNotificationCompatible(String sql, boolean qrcn, boolean bestEffort) throws DBException {
        throw new DBException((Throwable)new UnsupportedOperationException());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SessionParameterQueryMap
    extends HashMap<String, String> {
        private final Map<String, String> m_cache;
        private final BaseOracleDatabase m_db;
        private String m_query;

        SessionParameterQueryMap(BaseOracleDatabase db) {
            this.m_db = db;
            this.m_cache = new HashMap<String, String>();
            this.m_query = null;
        }

        String getValue(String parameter) {
            if (this.m_query == null && this.size() > 0) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                ArrayList keys = new ArrayList();
                keys.addAll(this.keySet());
                Collections.sort(keys);
                for (String key : keys) {
                    String val = (String)this.get(key);
                    if (val == null || val.length() <= 0) continue;
                    if (!first) {
                        sb.append("\nunion all\n");
                    }
                    sb.append(val);
                    first = false;
                }
                this.m_query = sb.toString();
                final QueryWrapper wrap = new QueryWrapper((Database)this.m_db, this.m_query);
                QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            while (rs.next()) {
                                SessionParameterQueryMap.this.m_cache.put(rs.getString(1), rs.getString(2));
                            }
                        }
                        catch (SQLException sqe) {
                            wrap.throwDBException(sqe);
                        }
                    }
                };
                try {
                    wrap.executeQuery(r);
                }
                catch (DBException dbe) {
                    DBLog.getLogger().log(Level.WARNING, APIBundle.format((String)"NLS_PARAM_LOAD_ERR", (Object[])new Object[]{this.m_db.getConnectionName(), dbe.getMessage()}));
                }
            }
            return this.m_cache.get(parameter);
        }

        void setValue(String parameter, String value) throws DBException {
            try {
                this.setValueImpl(parameter, value, false);
            }
            catch (DBException dbe) {
                if (value.startsWith("'")) {
                    throw dbe;
                }
                this.setValueImpl(parameter, value, true);
            }
            this.markAsDirty();
        }

        void setValueImpl(String parameter, String value, boolean quote) throws DBException {
            StringBuilder sb = new StringBuilder("ALTER SESSION SET ");
            sb.append(parameter);
            sb.append(" = ");
            if (quote) {
                sb.append("'");
            }
            sb.append(value);
            if (quote) {
                sb.append("'");
            }
            StatementWrapper wrap = new StatementWrapper((Database)this.m_db, new String[]{sb.toString()});
            wrap.execute();
        }

        void markAsDirty() {
            this.m_query = null;
            this.m_cache.clear();
        }

        @Override
        public void clear() {
            this.markAsDirty();
            super.clear();
        }

        @Override
        public String put(String key, String value) {
            this.markAsDirty();
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            this.markAsDirty();
            super.putAll(m);
        }

        @Override
        public String remove(Object key) {
            this.markAsDirty();
            return (String)super.remove(key);
        }
    }
}

