/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.ide.util.Assert;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializedViewLogBuilder
extends OracleDBObjectBuilder<MaterializedViewLog> {
    MaterializedViewLogBuilder(BaseOracleDatabase db) {
        super(db, "MATERIALIZED VIEW LOG");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"masterTableID", "logTable", "rowidLogged", "primaryKeyLogged", "objectIdLogged", "sequenceLogged", "newValues", "cache", "parallel", "OracleStorageProperties"})
    public void fillInBaseProperties(final MaterializedViewLog log) throws DBException {
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)log, "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_OBJECT_QUERY*/\n       L.MASTER, L.LOG_TABLE, L.ROWIDS, L.PRIMARY_KEY, \n       L.OBJECT_ID, L.SEQUENCE, L.INCLUDE_NEW_VALUES, \n       T.CACHE, T.DEGREE \nFROM SYS.ALL_SNAPSHOT_LOGS L, \n     SYS.ALL_TABLES T \nWHERE T.TABLE_NAME = L.LOG_TABLE \nAND   T.OWNER = L.LOG_OWNER \nAND   L.LOG_OWNER = ''{0}'' AND L.MASTER = ''{1}''", log.getSchema(), log);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                block10: {
                    try {
                        if (!rs.next()) break block10;
                        int index = 1;
                        SchemaObject obj = null;
                        String masterTableName = rs.getString(index++);
                        try {
                            obj = MaterializedViewLogBuilder.this.getDatabase().getObject("TABLE", log.getSchema(), masterTableName);
                        }
                        catch (DBException e) {
                            Assert.printStackTrace();
                            return;
                        }
                        if (obj == null) {
                            try {
                                obj = MaterializedViewLogBuilder.this.getDatabase().getObject("MATERIALIZED VIEW", log.getSchema(), masterTableName);
                            }
                            catch (DBException e) {
                                Assert.printStackTrace();
                                return;
                            }
                        }
                        if (obj != null) {
                            log.setMasterTableID(obj.getID());
                        }
                        log.setLogTable(rs.getString(index++));
                        log.setRowidLogged(MaterializedViewLogBuilder.parseBoolean(rs.getString(index++)));
                        log.setPrimaryKeyLogged(MaterializedViewLogBuilder.parseBoolean(rs.getString(index++)));
                        log.setObjectIdLogged(MaterializedViewLogBuilder.parseBoolean(rs.getString(index++)));
                        log.setSequenceLogged(MaterializedViewLogBuilder.parseBoolean(rs.getString(index++)));
                        log.setNewValues(MaterializedViewLogBuilder.parseBoolean(rs.getString(index++)));
                        log.setCache(MaterializedViewLogBuilder.parseBoolean(rs.getString(index++)));
                        String sParallel = rs.getString(index++).trim();
                        if ("DEFAULT".equals(sParallel)) {
                            log.setParallelDegree(Integer.valueOf(0));
                        } else {
                            log.setParallelDegree(Integer.valueOf(sParallel));
                        }
                    }
                    catch (SQLException ex) {
                        wrap.throwDBException(ex);
                    }
                }
            }
        };
        wrap.executeQuery(r);
        final QueryWrapper wrap2 = this.getDatabase().newQueryWrapper((SystemObject)log, this.getTableQuery(), log.getSchema(), log.getLogTable());
        QueryWrapper.QueryRunnable r2 = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        OracleStorageProperties osp = OracleTableBuilder.getSegmentAttributeProperties(rs, MaterializedViewLogBuilder.this.getDatabase());
                        log.setProperty("OracleStorageProperties", (Object)osp);
                    }
                }
                catch (SQLException ex) {
                    wrap2.throwDBException((DBObject)log, ex);
                }
            }
        };
        wrap2.executeQuery(r2);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"columnIDs"}, depends={"masterTableID"})
    public void fillInColumns(final MaterializedViewLog log) throws DBException {
        final QueryWrapper colsWrap = this.getDatabase().newQueryWrapper((SystemObject)log, "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_COLUMNS_QUERY*/\n     TC.COLUMN_NAME \nFROM SYS.ALL_SNAPSHOT_LOGS MVL\n,    SYS.ALL_TAB_COLS TC\nWHERE TC.OWNER = MVL.LOG_OWNER\n  AND TC.TABLE_NAME = MVL.LOG_TABLE\n  AND MVL.LOG_OWNER = ? \n  AND MVL.MASTER = ?\n  AND TC.COLUMN_NAME IN \n  ( SELECT TC2.COLUMN_NAME \n    FROM SYS.ALL_TAB_COLS TC2\n    WHERE TC2.OWNER = MVL.LOG_OWNER\n      AND TC2.TABLE_NAME = MVL.MASTER\n    MINUS \n    SELECT ACC.COLUMN_NAME \n    FROM SYS.ALL_CONS_COLUMNS ACC \n    WHERE ACC.OWNER = MVL.LOG_OWNER \n      AND ACC.TABLE_NAME = MVL.MASTER \n      AND ACC.CONSTRAINT_NAME = \n    ( SELECT C.CONSTRAINT_NAME FROM SYS.ALL_CONSTRAINTS C \n      WHERE C.CONSTRAINT_TYPE = 'P' AND C.TABLE_NAME = MVL.MASTER \n        AND C.OWNER = MVL.LOG_OWNER ) ) \nORDER BY TC.COLUMN_ID", log.getSchema(), log);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    DBObjectID masterTabID = log.getMasterTableID();
                    ArrayList<NameBasedID> columnIDs = new ArrayList<NameBasedID>();
                    while (rs.next()) {
                        NameBasedID refID = new NameBasedID("COLUMN", rs.getString(1), masterTabID);
                        columnIDs.add(refID);
                    }
                    log.setColumnIDs(columnIDs.toArray(new DBObjectID[columnIDs.size()]));
                }
                catch (SQLException sqe) {
                    colsWrap.throwDBException(sqe);
                }
            }
        };
        colsWrap.executeQuery(r);
    }

    private String getTableQuery() {
        return OracleTableBuilder.getTableQuery(this.getDatabase());
    }

    public static String getCandidateTablesQuery() {
        return "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_CANDIDATE_TABLES_QUERY*/\n       T.TABLE_NAME \n,      DECODE(MV.MVIEW_NAME,null,'TABLE','MATERIALIZED VIEW') OBJECT_TYPE\n,     (SELECT O.OBJECT_ID\n       FROM   SYS.ALL_OBJECTS O \n       WHERE  O.OWNER = T.OWNER \n       AND    O.OBJECT_TYPE = DECODE(MV.MVIEW_NAME,null,'TABLE','MATERIALIZED VIEW') \n       AND    O.OBJECT_NAME = T.TABLE_NAME) OBJECT_ID \nFROM   SYS.ALL_TABLES T \n,      SYS.ALL_MVIEWS MV\nWHERE  T.OWNER = ? \nAND    T.TEMPORARY = 'N' \nAND    T.NESTED = 'NO' \nAND    T.IOT_NAME IS NULL \nAND    T.SECONDARY = 'N'\nAND    MV.MVIEW_NAME (+) = T.TABLE_NAME\nAND    MV.OWNER (+) = T.OWNER\nAND    NOT EXISTS (SELECT 1 \n                   FROM   SYS.ALL_SNAPSHOT_LOGS L   \n                   WHERE  (L.MASTER = T.TABLE_NAME OR \n                           L.LOG_TABLE = T.TABLE_NAME) \n                   AND    L.LOG_OWNER = T.OWNER) \nAND    NOT EXISTS (SELECT 1 \n                   FROM   SYS.ALL_EXTERNAL_TABLES E \n                   WHERE  E.TABLE_NAME = T.TABLE_NAME \n                   AND    E.OWNER = T.OWNER)\nORDER BY 1";
    }

    private static Boolean parseBoolean(String s) {
        return "Y".equals(s.trim()) || "YES".equals(s.trim()) ? Boolean.TRUE : Boolean.FALSE;
    }
}

