/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.sql.SQLFragmentUtils;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.dcn.DatabaseChangeRegistration;

public class Oracle10gR2
extends Oracle10g {
    Oracle10gR2(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    public boolean supportsDatabaseChangeNotification() {
        boolean retval;
        try {
            retval = this.getConnection(false) instanceof OracleConnection;
        }
        catch (DBException dbe) {
            retval = false;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDatabaseChangeNotificationCompatible(String sql, boolean qrcn, boolean bestEffort) throws DBException {
        boolean retval = false;
        Connection conn = this.getConnection();
        if (conn instanceof OracleConnection) {
            OracleConnection oc = (OracleConnection)conn;
            Properties regProps = new Properties();
            if (qrcn) {
                regProps.setProperty("DCN_QUERY_CHANGE_NOTIFICATION", "true");
            }
            if (bestEffort) {
                regProps.setProperty("DCN_BEST_EFFORT", "true");
            }
            DatabaseChangeRegistration dcReg = null;
            try {
                dcReg = oc.registerDatabaseChangeNotification(regProps);
            }
            catch (SQLException sqe) {
                throw new DBException(null, sqe.getMessage(), (Throwable)sqe);
            }
            if (dcReg != null) {
                try {
                    OraclePreparedStatement stmt = (OraclePreparedStatement)oc.prepareStatement(sql);
                    stmt.setDatabaseChangeRegistration(dcReg);
                    for (String bind : SQLFragmentUtils.listBindVariables((String)sql)) {
                        stmt.setNullAtName(bind, 12);
                    }
                    try {
                        ResultSet rs = stmt.executeQuery();
                        rs.close();
                        retval = true;
                    }
                    catch (SQLException sqe) {
                        int err = sqe.getErrorCode();
                        if (err == 29983) {
                            retval = false;
                        }
                        throw new DBException(null, sqe.getMessage(), (Throwable)sqe);
                    }
                    finally {
                        try {
                            stmt.close();
                        }
                        catch (Exception e) {}
                    }
                }
                catch (SQLException sqe) {
                    throw new DBException(null, sqe.getMessage(), (Throwable)sqe);
                }
                finally {
                    try {
                        oc.unregisterDatabaseChangeNotification(dcReg);
                    }
                    catch (SQLException sqe) {
                        this.getLogger().warning("DCN deregistration failed: " + sqe.getMessage());
                    }
                }
            }
        } else {
            retval = super.isDatabaseChangeNotificationCompatible(sql, qrcn, bestEffort);
        }
        return retval;
    }
}

