/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleNestedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleTablespaceUtil;
import oracle.javatools.db.ora.XMLSchema;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlInterrogatorFactory;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleColumnPropertiesBuilder
extends OracleDBObjectBuilder<OracleColumnProperties> {
    public OracleColumnPropertiesBuilder(BaseOracleDatabase db) {
        super(db, "OracleColumnProperties");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    private OracleColumnProperties getOrCreateProperties(Column col) {
        OracleColumnProperties retval = (OracleColumnProperties)col.getProperty("OracleColumnProperties");
        if (retval == null) {
            retval = new OracleColumnProperties();
            col.setProperty("OracleColumnProperties", (Object)retval);
        }
        return retval;
    }

    private Column getColumn(OracleColumnProperties props) throws DBException {
        Column retval = (Column)props.getParent();
        if (retval == null) {
            throw new DBException((DBObject)props, "OracleColumnProperties must have a parent Column.");
        }
        return retval;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"XMLTypeColumnProperties"})
    public void buildXMLProperties(OracleColumnProperties props) throws DBException {
        Relation table;
        Column col = this.getColumn(props);
        DataType type = DataTypeHelper.getDataType((DataTypeUsage)col.getDataTypeUsage());
        if (type != null && XMLTypeColumnProperties.isXMLType((DataType)type) && (table = col.getRelation()) != null) {
            this.buildAllXMLColumns(table);
        }
    }

    private void buildAllXMLColumns(final Relation table) throws DBException {
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)table, "SELECT /*OracleDictionaryQueries.ALL_XMLTYPE_COLUMN_PROPERTIES_QUERY*/ \n       XTC.COLUMN_NAME, XTC.SCHEMA_OWNER, XTC.XMLSCHEMA, XTC.ELEMENT_NAME \n,      XTC.STORAGE_TYPE, XTC.ANYSCHEMA, XTC.NONSCHEMA \nFROM   SYS.ALL_XML_TAB_COLS XTC \nWHERE  XTC.OWNER = ? \nAND    XTC.TABLE_NAME = ?", table.getSchema(), table);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs2) throws DBException {
                try {
                    while (rs2.next()) {
                        XMLTypeColumnProperties props = (XMLTypeColumnProperties)OracleColumnPropertiesBuilder.this.newObject(XMLTypeColumnProperties.class, null);
                        XMLTypeColumnProperties.StoreAs storeAs = null;
                        String storeAsStr = rs2.getString("STORAGE_TYPE");
                        storeAs = "BINARY".equals(storeAsStr) ? XMLTypeColumnProperties.StoreAs.BINARY_XML : ("OBJECT-RELATIONAL".equals(storeAsStr) ? XMLTypeColumnProperties.StoreAs.OBJECT_RELATIONAL : XMLTypeColumnProperties.StoreAs.valueOf((String)storeAsStr));
                        props.setStoreAs(storeAs);
                        String element = rs2.getString("ELEMENT_NAME");
                        if (ModelUtil.hasLength((String)element)) {
                            String xmlschemaOwner = rs2.getString("SCHEMA_OWNER");
                            String xmlschemaName = rs2.getString("XMLSCHEMA");
                            XMLSchema xmlschema = (XMLSchema)OracleColumnPropertiesBuilder.this.getProvider().getObject("XML SCHEMA", OracleColumnPropertiesBuilder.this.getSchema(xmlschemaOwner), xmlschemaName);
                            NameBasedID elemntid = new NameBasedID("XMLSchemaElement", element, xmlschema.getID());
                            props.setElementID((DBObjectID)elemntid);
                        } else {
                            props.setElementID(null);
                        }
                        props.setAllowAnySchema("YES".equals(rs2.getString("ANYSCHEMA")));
                        props.setAllowNonSchema("YES".equals(rs2.getString("NONSCHEMA")));
                        Column col = table.getColumn(rs2.getString("COLUMN_NAME"));
                        if (col == null) continue;
                        OracleColumnProperties ocp = OracleColumnPropertiesBuilder.this.getOrCreateProperties(col);
                        ocp.setXMLTypeColumnProperties(props);
                        props.setID((DBObjectID)new NameBasedID((DBObject)props, ocp.getID()));
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)table, ex);
                }
            }
        };
        wrap.executeQuery(r);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"nestedTableProperties"})
    public void buildNestedTableProperties(final OracleColumnProperties props) throws DBException {
        Column col = this.getColumn(props);
        Relation relation = col.getRelation();
        DataType type = DataTypeHelper.getDataType((DataTypeUsage)col.getDataTypeUsage());
        if (relation != null && OracleColumnPropertiesBuilder.isTableCollectionType(type)) {
            final QueryWrapper cuWrap = this.getDatabase().newQueryWrapper((SystemObject)relation, "SELECT /*OracleDictionaryQueries.ALL_COLUMN_NESTED_TAB_QUERY*/\n       ANT.TABLE_NAME NESTED_TABLE \n,      TRIM(ANT.RETURN_TYPE) \nFROM   SYS.ALL_NESTED_TABLES ANT \nWHERE  ANT.OWNER = ? \nAND    ANT.PARENT_TABLE_NAME = ? \nAND    ANT.PARENT_TABLE_COLUMN = ? \n", relation.getSchema(), relation, col);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet curs) throws DBException {
                    try {
                        if (curs.next()) {
                            OracleNestedTableProperties ntp = (OracleNestedTableProperties)OracleColumnPropertiesBuilder.this.newObject(OracleNestedTableProperties.class, null);
                            ntp.setTableName(curs.getString(1));
                            String returnAs = curs.getString(2);
                            if (returnAs != null) {
                                if (returnAs.equals("LOCATOR")) {
                                    ntp.setReturnAs(OracleNestedTableProperties.ReturnAs.LOCATOR);
                                } else {
                                    ntp.setReturnAs(OracleNestedTableProperties.ReturnAs.VALUE);
                                }
                            }
                            props.setNestedTableProperties(ntp);
                            ntp.setID((DBObjectID)new NameBasedID((DBObject)ntp, props.getID()));
                        }
                    }
                    catch (SQLException e) {
                        cuWrap.throwDBException(e);
                    }
                }
            };
            cuWrap.executeQuery(r);
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"LOBProperties", "VAProperties"})
    public void buildLOBProperties(OracleColumnProperties props) throws DBException {
        Column col = this.getColumn(props);
        DataType type = DataTypeHelper.getDataType((DataTypeUsage)col.getDataTypeUsage());
        Relation rel = col.getRelation();
        if (rel != null && type != null && LOBDescriptor.isLOBType((DataType)type) || LOBDescriptor.isVARRAYType((DataType)type)) {
            this.buildAllLOBColumns(rel);
        }
    }

    private void buildAllLOBColumns(final Relation table) throws DBException {
        String query = this.getLOBParametersQuery();
        if (query != null) {
            Schema schema = table.getSchema();
            final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)table, query, this.getDatabase().getExternalName(schema.getName(), "SCHEMA"), table, schema, table);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs2) throws DBException {
                    try {
                        while (rs2.next()) {
                            LOBDescriptor lobDescriptor = (LOBDescriptor)OracleColumnPropertiesBuilder.this.newObject(LOBDescriptor.class, null);
                            int chunk = rs2.getInt("CHUNK");
                            lobDescriptor.setChunk(rs2.wasNull() ? null : Integer.valueOf(chunk));
                            lobDescriptor.setLOBSegName(rs2.getString("SEGMENT_NAME"));
                            int pctVersion = rs2.getInt("PCTVERSION");
                            lobDescriptor.setPctVersion(rs2.wasNull() ? null : Integer.valueOf(pctVersion));
                            lobDescriptor.setStorageEnabledInRow("YES".equalsIgnoreCase(rs2.getString("IN_ROW")));
                            int freepools = rs2.getInt("FREEPOOLS");
                            lobDescriptor.setFreepools(rs2.wasNull() ? null : Integer.valueOf(freepools));
                            if (lobDescriptor.getPctVersion() == null) {
                                rs2.getInt("RETENTION");
                                lobDescriptor.setRetention(!rs2.wasNull());
                            }
                            String cache = rs2.getString("CACHE");
                            if (!rs2.wasNull() && cache != null) {
                                OracleTableBuilder.setLOBCache(lobDescriptor, cache);
                            }
                            OracleStorageProperties storage = OracleTableBuilder.getStorageProperties(rs2);
                            lobDescriptor.setStorage(storage);
                            String tablespaceName = rs2.getString("TABLESPACE_NAME");
                            if (ModelUtil.hasLength((String)tablespaceName)) {
                                storage.setTablespaceID(OracleTablespaceUtil.getTablespaceID((DBObjectProvider)OracleColumnPropertiesBuilder.this.getDatabase(), tablespaceName));
                            }
                            OracleTableBuilder.setLogging(rs2, storage);
                            Column col = table.getColumn(rs2.getString("COLUMN_NAME"));
                            if (col == null) continue;
                            OracleColumnProperties ocp = OracleColumnPropertiesBuilder.this.getOrCreateProperties(col);
                            if (LOBDescriptor.isLOBColumn((Column)col)) {
                                ocp.setLOBProperties(lobDescriptor);
                            } else if (LOBDescriptor.isVARRAYColumn((Column)col)) {
                                ocp.setVAProperties(lobDescriptor);
                            }
                            lobDescriptor.setID((DBObjectID)new NameBasedID((DBObject)lobDescriptor, ocp.getID()));
                        }
                    }
                    catch (SQLException ex) {
                        wrap.throwDBException((DBObject)table, ex);
                    }
                }
            };
            wrap.executeQuery(r);
        }
    }

    private String getLOBParametersQuery() {
        String retval = null;
        BaseOracleDatabase db = this.getDatabase();
        if ("Oracle Database".equals(db.getDatabaseType())) {
            retval = "SELECT /*OracleDictionaryQueries.ALL_TABLE_LOB_PARMATERS_QUERY*/ \n       AL.COLUMN_NAME\n,      AL.SEGMENT_NAME\n,      AL.PCTVERSION\n,      AL.IN_ROW\n,      AL.CHUNK\n,      AL.FREEPOOLS\n,      AL.RETENTION\n,      PS.TABLESPACE_NAME\n,      AL.CACHE\n,      AL.LOGGING\n,      PS.INITIAL_EXTENT\n,      PS.NEXT_EXTENT\n,      PS.MIN_EXTENTS\n,      PS.MAX_EXTENTS\n,      PS.PCT_INCREASE\n,      PS.FREELISTS\n,      PS.FREELIST_GROUPS\n,      PS.BUFFER_POOL\nFROM   SYS.ALL_LOBS AL\n,      SYS.ALL_TABLES T\n,     (SELECT US.SEGMENT_NAME\n       ,      US.TABLESPACE_NAME\n       ,      US.INITIAL_EXTENT\n       ,      US.NEXT_EXTENT\n       ,      US.MIN_EXTENTS\n       ,      US.MAX_EXTENTS\n       ,      US.PCT_INCREASE\n       ,      US.FREELISTS\n       ,      US.FREELIST_GROUPS\n       ,      US.BUFFER_POOL\n       ,      US.PARTITION_NAME\n       FROM   SYS.USER_SEGMENTS US\n       ,      SYS.USER_LOBS UL\n       WHERE  US.SEGMENT_NAME = UL.SEGMENT_NAME\n       AND    US.PARTITION_NAME IS NULL\n       AND    US.SEGMENT_TYPE = 'LOBSEGMENT'\n       AND    USER = ?\n       AND    UL.TABLE_NAME = ?\n      ) PS\nWHERE AL.OWNER = ?\nAND   AL.TABLE_NAME = ?\nAND   AL.OWNER = T.OWNER\nAND   AL.TABLE_NAME = T.TABLE_NAME\nAND   T.PARTITIONED = 'NO'\nAND   AL.SEGMENT_NAME = PS.SEGMENT_NAME (+)";
            int databaseType = db.getDatabaseVersion();
            if (databaseType <= 82) {
                retval = retval.replaceFirst("AL.FREEPOOLS", "null FREEPOOLS").replaceFirst("AL.RETENTION", "null RETENTION");
            }
        }
        return retval;
    }

    private static boolean isTableCollectionType(DataType type) {
        boolean retval = false;
        if (type instanceof Type) {
            PlSqlInterrogator pi = PlSqlInterrogatorFactory.getInterrogator((SourceObject)((Type)type));
            retval = "TABLE".equals(pi.getCollectionType());
        }
        return retval;
    }

    static boolean needColumnProperties(BaseOracleDatabase db, Table table, Column col, DataType type) {
        boolean retval = false;
        if ("TABLE".equals(table.getType())) {
            if (OracleColumnPropertiesBuilder.isTableCollectionType(type)) {
                retval = true;
            }
            if ("Oracle Database".equals(db.getDatabaseType())) {
                if (LOBDescriptor.isLOBType((DataType)type) || LOBDescriptor.isVARRAYType((DataType)type)) {
                    retval = true;
                } else if (db.getDatabaseVersion() >= 110 && XMLTypeColumnProperties.isXMLType((DataType)type)) {
                    retval = true;
                }
            }
        }
        return retval;
    }
}

