/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.ColumnSequenceProcessor;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.db.ora.Oracle10gR2XE;
import oracle.javatools.db.ora.Oracle11g;
import oracle.javatools.db.ora.Oracle11gR2;
import oracle.javatools.db.ora.Oracle11gR2XE;
import oracle.javatools.db.ora.Oracle12c;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.Oracle8i;
import oracle.javatools.db.ora.Oracle9i;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseDescriptor;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleLite10gR3;
import oracle.javatools.db.ora.lite.OracleDatabaseLite;
import oracle.javatools.db.ora.lite.OracleDatabaseLiteDescriptor;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabaseFactory
extends BaseDatabaseCreator {
    private static boolean s_autocommit = true;
    private static final String VERSION_PATTERN = "[0-9]+\\.[0-9.]*";

    public DatabaseDescriptor getDatabaseDescriptorImpl(Database db) {
        if (db instanceof OracleDatabaseImpl) {
            return new OracleDatabaseDescriptor((OracleDatabaseImpl)db, null, null);
        }
        return super.getDatabaseDescriptorImpl(db);
    }

    public DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        OracleDatabaseDescriptor retval = null;
        if (OracleDatabaseLite.class.isAssignableFrom(providerClass)) {
            retval = new OracleDatabaseLiteDescriptor(providerClass);
        } else if (OracleDatabase.class.isAssignableFrom(providerClass)) {
            retval = new OracleDatabaseDescriptor(providerClass);
        }
        return retval;
    }

    public Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        BaseOracleDatabase db = null;
        Pair<String, Integer> type = OracleDatabaseFactory.getType(conn);
        if (type != null) {
            if ("Oracle Lite".equals(type.first)) {
                switch ((Integer)type.second) {
                    case 101: {
                        db = new OracleLite(connStore, connName, conn);
                        break;
                    }
                    case 103: {
                        db = new OracleLite10gR3(connStore, connName, conn);
                    }
                }
            } else {
                switch ((Integer)type.second) {
                    case 81: {
                        db = new Oracle8(connStore, connName, conn);
                        break;
                    }
                    case 82: {
                        db = new Oracle8i(connStore, connName, conn);
                        break;
                    }
                    case 91: {
                        db = new Oracle9i(connStore, connName, conn);
                        break;
                    }
                    case 92: {
                        db = new Oracle9iR2(connStore, connName, conn);
                        break;
                    }
                    case 100: {
                        db = new Oracle10g(connStore, connName, conn);
                        break;
                    }
                    case 102: {
                        db = new Oracle10gR2(connStore, connName, conn);
                        break;
                    }
                    case 101: {
                        db = new Oracle10gR2XE(connStore, connName, conn);
                        break;
                    }
                    case 110: {
                        db = new Oracle11g(connStore, connName, conn);
                        break;
                    }
                    case 112: {
                        db = new Oracle11gR2(connStore, connName, conn);
                        break;
                    }
                    case 111: {
                        db = new Oracle11gR2XE(connStore, connName, conn);
                        break;
                    }
                    case 120: {
                        db = new Oracle12c(connStore, connName, conn);
                    }
                }
            }
        }
        if (db != null) {
            this.initDB((Database)db);
        }
        return db;
    }

    private void initDB(Database db) {
        ConnectionWrapper wrap = new ConnectionWrapper(db, APIBundle.get((String)"SET_AUTOCOMMIT"));
        try {
            wrap.run(new ConnectionWrapper.SQLRunnable(wrap){

                public void run() throws SQLException {
                    this.getConnection().setAutoCommit(s_autocommit);
                }
            });
        }
        catch (DBException dbe) {
            DBLog.getLogger((Object)((Object)this)).warning(dbe.getMessage());
        }
    }

    public static void setDefaultAutocommit(boolean autocommit) {
        s_autocommit = autocommit;
    }

    public static boolean isDefaultAutocommit() {
        return s_autocommit;
    }

    public static boolean isOracleDatabase(Connection conn) {
        return OracleDatabaseFactory.getType(conn) != null;
    }

    private static boolean isExpressEdition(String ver) {
        return ver.indexOf("Express Edition") >= 0;
    }

    private static Pair<String, Integer> getType(Connection conn) {
        Pair retval = null;
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String dbName = dmd.getDatabaseProductName();
                if (ModelUtil.hasLength((String)dbName)) {
                    if (dbName.startsWith("Oracle Lite")) {
                        String ver = dmd.getDatabaseProductVersion();
                        int[] version = OracleDatabaseFactory.getOracleMajorMinorVersion(ver);
                        int finalVersion = -1;
                        if (version.length == 2 && version[0] == 10) {
                            if (version[1] == 1) {
                                finalVersion = 101;
                            } else if (version[1] == 3) {
                                finalVersion = 103;
                            }
                        }
                        if (finalVersion > 0) {
                            retval = new Pair((Object)"Oracle Lite", (Object)finalVersion);
                        }
                    } else if (dbName.startsWith("Personal Oracle") || dbName.startsWith("Oracle") && !dbName.startsWith("Oracle Rdb") && !dbName.startsWith("Oracle Business Intelligence")) {
                        int type = 0;
                        String ver = dmd.getDatabaseProductVersion();
                        int[] version = OracleDatabaseFactory.getOracleMajorMinorVersion(ver);
                        if (version != null && version.length == 2) {
                            int major = version[0];
                            int minor = version[1];
                            if (major < 8) {
                                type = 0;
                            } else if (major == 8) {
                                type = minor >= 1 ? 82 : 81;
                            } else if (major == 9) {
                                type = minor >= 2 ? 92 : 91;
                            } else if (major == 10) {
                                type = minor < 2 ? 100 : (OracleDatabaseFactory.isExpressEdition(ver) ? 101 : 102);
                            } else if (major == 11) {
                                type = minor < 2 ? 110 : (OracleDatabaseFactory.isExpressEdition(ver) ? 111 : 112);
                            } else if (major >= 12) {
                                type = 120;
                            }
                        }
                        retval = new Pair((Object)"Oracle Database", (Object)type);
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return retval;
    }

    public static int[] getOracleMajorMinorVersion(String dbVersion) {
        if (ModelUtil.hasLength((String)dbVersion)) {
            String num;
            Pattern pattern = Pattern.compile(VERSION_PATTERN);
            Matcher matcher = pattern.matcher(dbVersion);
            String string = num = matcher.find() ? matcher.group() : null;
            if (ModelUtil.hasLength((String)num)) {
                int major = 8;
                int minor = 0;
                int idx = num.indexOf(46);
                if (idx != -1) {
                    try {
                        major = Integer.parseInt(num.substring(0, idx));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    int start = idx + 1;
                    idx = num.indexOf(46, start);
                    if (idx != -1) {
                        try {
                            minor = Integer.parseInt(num.substring(start, idx));
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                }
                return new int[]{major, minor};
            }
        }
        return null;
    }

    public static void registerOracleDatabases() {
        DatabaseRegistry dbreg = DatabaseRegistry.getInstance();
        dbreg.registerDatabases("Oracle Lite", OracleDatabaseFactory.class.getName(), null, null, new DatabaseRegistry.DatabaseVersion[]{new DatabaseRegistry.DatabaseVersion(101, APIBundle.get((String)"DB_ORACLE_LITE_10gR1"), "oracle.javatools.db.ora.OracleLite"), new DatabaseRegistry.DatabaseVersion(103, APIBundle.get((String)"DB_ORACLE_LITE_10gR3"), "oracle.javatools.db.ora.OracleLite10gR3")});
        dbreg.registerDatabases("Oracle Database", OracleDatabaseFactory.class.getName(), null, null, new DatabaseRegistry.DatabaseVersion[]{new DatabaseRegistry.DatabaseVersion(0, null, "oracle.javatools.db.ora.OracleDatabaseImpl"), new DatabaseRegistry.DatabaseVersion(81, null, "oracle.javatools.db.ora.Oracle8"), new DatabaseRegistry.DatabaseVersion(82, APIBundle.get((String)"DB_ORACLE_8i"), "oracle.javatools.db.ora.Oracle8i"), new DatabaseRegistry.DatabaseVersion(91, null, "oracle.javatools.db.ora.Oracle9i"), new DatabaseRegistry.DatabaseVersion(92, APIBundle.get((String)"DB_ORACLE_9i2"), "oracle.javatools.db.ora.Oracle9iR2"), new DatabaseRegistry.DatabaseVersion(100, APIBundle.get((String)"DB_ORACLE_10g"), "oracle.javatools.db.ora.Oracle10g"), new DatabaseRegistry.DatabaseVersion(102, APIBundle.get((String)"DB_ORACLE_10gR2"), "oracle.javatools.db.ora.Oracle10gR2"), new DatabaseRegistry.DatabaseVersion(101, APIBundle.get((String)"DB_ORACLE_10gR2XE"), "oracle.javatools.db.ora.Oracle10gR2XE"), new DatabaseRegistry.DatabaseVersion(110, APIBundle.get((String)"DB_ORACLE_11g"), "oracle.javatools.db.ora.Oracle11g"), new DatabaseRegistry.DatabaseVersion(112, APIBundle.get((String)"DB_ORACLE_11gR2"), "oracle.javatools.db.ora.Oracle11gR2"), new DatabaseRegistry.DatabaseVersion(111, APIBundle.get((String)"DB_ORACLE_11gR2XE"), "oracle.javatools.db.ora.Oracle11gR2XE"), new DatabaseRegistry.DatabaseVersion(120, APIBundle.get((String)"DB_ORACLE_12c"), "oracle.javatools.db.ora.Oracle12c")});
        Metadata m = Metadata.getInstance();
        m.registerBooleanProperty("OBJECT TABLE", Nullable.NullBehaviour.NULL_MEANS_FALSE, OracleDatabase.class, new Class[]{Table.class});
        m.registerBooleanProperty("NESTED TABLE", Nullable.NullBehaviour.NULL_MEANS_FALSE, OracleDatabase.class, new Class[]{Table.class});
        m.registerBooleanProperty("PARTITIONED TABLE", Nullable.NullBehaviour.NULL_MEANS_FALSE, OracleDatabase.class, new Class[]{Table.class});
        m.registerProperty("USER_PRIVS", Set.class, OracleDatabase.class, new Class[]{Schema.class});
        m.registerProperty("USER_ROLES", Set.class, OracleDatabase.class, new Class[]{Schema.class});
        ColumnSequenceProcessor.registerProcessorProperties(OracleDatabaseImpl.class);
    }
}

