/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.dictionary.DictionaryQueries;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.lite.OracleDatabaseLite;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

class OracleDictionaryQueries
extends DictionaryQueries {
    static final String LOCAL_TRANSACTION_QUERY = "SELECT /*OracleDictionaryQueries.LOCAL_TRANSACTION_QUERY*/ dbms_transaction.local_transaction_id FROM SYS.DUAL";
    static final String QUERY_TABLESPACES = "SELECT /*OracleDictionaryQueries.QUERY_TABLESPACES*/ TABLESPACE_NAME FROM SYS.USER_TABLESPACES WHERE CONTENTS = 'PERMANENT'";
    static final String QUERY_GLOBAL_NAME = "SELECT /*OracleDictionaryQueries.QUERY_GLOBAL_NAME*/ GLOBAL_NAME FROM GLOBAL_NAME ";
    static final String CURR_USER_QUERY = "SELECT /*OracleDictionaryQueries.CURR_USER_QUERY*/ \n       USERNAME\n,      DEFAULT_TABLESPACE\n,      TEMPORARY_TABLESPACE\nFROM   SYS.USER_USERS\nUNION ALL\nSELECT USER, NULL, NULL\nFROM   SYS.DUAL\nWHERE  NOT EXISTS (SELECT 1 FROM SYS.USER_USERS)";
    static final String NLS_SESSION_PARAMS_QUERY = "select /*OracleDictionaryQueries.NLS_SESSION_PARAMS_QUERY*/\n       s.parameter, s.value \nfrom  sys.nls_session_parameters s";
    static final String NLS_CHARACTERSET_QUERY = "select /*OracleDictionaryQueries.NLS_CHARACTERSET_QUERY*/\n       d.parameter, d.value \nfrom  sys.nls_database_parameters d \nwhere d.parameter = 'NLS_CHARACTERSET'";
    static final String NLS_CHARSET_ID_QUERY = "select /*OracleDictionaryQueries.NLS_CHARSET_ID_QUERY*/\n     'NLS_CHARSET_ID' parameter, to_char(/**/NLS_CHARSET_ID(charset.value)) value\nfrom (select value\n      from sys.nls_database_parameters\n      where parameter = 'NLS_CHARACTERSET') charset \n";
    static final String NLS_OTHER_DATABASE_PARAMS_QUERY = "select /*OracleDictionaryQueries.NLS_OTHER_DATABASE_PARAMS_QUERY*/\n       d.parameter, d.value \nfrom  sys.nls_database_parameters d \nwhere not exists (select 1 from sys.nls_session_parameters s2 \n                  where   s2.parameter = d.parameter) \nand   d.parameter != 'NLS_CHARACTERSET'";
    static final String DB_TIMEZONE_QUERY = "select /*OracleDictionaryQueries.DB_TIMEZONE_QUERY*/\n       'DB_TIMEZONE' parameter,  DBTIMEZONE value \nfrom  sys.dual";
    static final String SESSION_TIMEZONE_QUERY = "select /*OracleDictionaryQueries.SESSION_TIMEZONE_QUERY*/\n       'SESSION_TIMEZONE' parameter,  SESSIONTIMEZONE value \nfrom  sys.dual";
    static final String SESSION_TIMEZONE_OFFSET_QUERY = "select /*OracleDictionaryQueries.SESSION_TIMEZONE_OFFSET_QUERY*/\n       'SESSION_TIMEZONE_OFFSET' parameter,  TZ_OFFSET(SESSIONTIMEZONE) value \nfrom  sys.dual";
    static final String DEFAULT_DBLINK_SCHEMA_QUERY = "select /*OracleDictionaryQueries.DEFAULT_DBLINK_SCHEMA_QUERY*/\n       sys.dbms_utility.old_current_schema@<LINK> \nfrom   sys.dual";
    private static String ORACLE_SINGLE_OBJECT_QUERY = "SELECT /*OracleDictionaryQueries.ALL_ORACLE_SINGLE_OBJECT_QUERY*/\n       O.OBJECT_NAME, O.OBJECT_TYPE, O.OBJECT_ID, O.LAST_DDL_TIME \nFROM   SYS.ALL_OBJECTS O\nWHERE  O.OWNER = ?\nAND    O.OBJECT_NAME = ?\nAND    O.OBJECT_TYPE = ?\n";
    static final String ORACLE_OBJECT_QUERY = "SELECT /*OracleDictionaryQueries.ALL_ORACLE_OBJECT_QUERY*/\n       O.OBJECT_NAME, O.OBJECT_TYPE, O.OBJECT_ID, O.LAST_DDL_TIME \nFROM   SYS.ALL_OBJECTS O\nWHERE  O.OWNER = ?\nAND    O.OBJECT_NAME LIKE ?\nAND    O.OBJECT_TYPE IN (<types>)\nAND    O.SUBOBJECT_NAME IS NULL\nAND    O.SECONDARY = 'N'\nAND    ( O.OBJECT_TYPE <> 'INDEX' OR\n         (\n          EXISTS (SELECT 1\n                  FROM   SYS.ALL_INDEXES I\n                  WHERE  I.OWNER = O.OWNER\n                  AND    I.INDEX_NAME = O.OBJECT_NAME\n--10g             AND    I.DROPPED = 'NO'\n                 )\n         )\n       )\nAND    ( O.OBJECT_TYPE <> 'TRIGGER' OR\n         (\n          EXISTS (SELECT 1\n                  FROM   SYS.ALL_TRIGGERS TR\n                  WHERE  TR.OWNER = O.OWNER\n                  AND    TR.TRIGGER_NAME = O.OBJECT_NAME\n                  AND   (   TR.BASE_OBJECT_TYPE <> 'TABLE'\n                         OR EXISTS ( SELECT 1 FROM SYS.ALL_TABLES T2\n                                     WHERE  T2.OWNER = TR.TABLE_OWNER\n                                     AND    T2.TABLE_NAME = TR.TABLE_NAME\n--10g                                AND    T2.DROPPED = 'NO'\n                                    )\n                        )\n                 )\n         )\n       )\nAND    ( O.OBJECT_TYPE <> 'TYPE' OR\n         EXISTS (SELECT 1\n                  FROM   SYS.ALL_TYPES T\n                  WHERE  T.OWNER = O.OWNER\n                  AND    T.TYPE_NAME = O.OBJECT_NAME)\n       )\nAND    ( O.OBJECT_NAME NOT LIKE 'AQ$%' OR \n         NOT EXISTS\n         ( SELECT 1\n           FROM   SYS.ALL_QUEUE_TABLES QT\n           WHERE  O.OWNER = QT.OWNER\n           AND    (   O.OBJECT_NAME = 'AQ$'||QT.queue_table \n                   OR O.OBJECT_NAME like 'AQ$'||QT.queue_table||'^_%' escape '^'\n                   OR O.OBJECT_NAME like 'AQ$^_'||QT.queue_table||'^_%' escape '^') \n          )\n       )\n";
    static final String ORACLE_NON_XE_PUBLIC_SYNONYM_QUERY = "SELECT /*OracleDictionaryQueries.ALL_ORACLE_NON_XE_PUBLIC_SYNONYM_QUERY*/\n       O.OBJECT_NAME, O.OBJECT_TYPE, O.OBJECT_ID, O.LAST_DDL_TIME \nFROM   SYS.ALL_OBJECTS O\n,      SYS.ALL_SYNONYMS S\nWHERE  O.OWNER = 'PUBLIC'\nAND    S.OWNER = O.OWNER\nAND    S.SYNONYM_NAME = O.OBJECT_NAME\nAND    O.OBJECT_TYPE = 'SYNONYM'\nAND NOT EXISTS (SELECT 1\n                FROM   SYS.ALL_OBJECTS O2\n                WHERE  O2.OWNER = S.TABLE_OWNER\n                AND    O2.OBJECT_NAME = S.TABLE_NAME\n                AND    O2.OBJECT_TYPE = 'JAVA CLASS')";
    static final String TABLESPACE_QUERY = "SELECT /*OracleDictionaryQueries.USER_TABLESPACE_QUERY*/\n       TABLESPACE_NAME \n,      'TABLESPACE' OBJECT_TYPE \n,      NULL OBJECT_ID \n,      NULL LAST_DDL_TIME \nFROM   SYS.USER_TABLESPACES\nWHERE  TABLESPACE_NAME LIKE ?";
    static final String TABLE_ORACLE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TABLE_ORACLE_QUERY*/\n       X.TABLE_NAME\n,     'TABLE' OBJECT_TYPE\n,     (SELECT O.OBJECT_ID\n       FROM   SYS.ALL_OBJECTS O\n       WHERE  O.OWNER = X.OWNER\n       AND O.OBJECT_TYPE = 'TABLE'\n       AND O.OBJECT_NAME = X.TABLE_NAME) OBJECT_ID\n,      NULL LAST_DDL_TIME\nFROM (\nSELECT T.TABLE_NAME, T.OWNER\nFROM   SYS.ALL_TABLES T\nWHERE  T.OWNER = ?\nAND    T.NESTED = 'NO'\nAND    T.TABLE_NAME LIKE ?\nAND    T.IOT_NAME IS NULL\nAND    T.SECONDARY = 'N'\n--10g AND    T.DROPPED = 'NO'\nMINUS\nSELECT QT.QUEUE_TABLE, QT.OWNER\nFROM   SYS.ALL_QUEUE_TABLES QT\nWHERE  QT.OWNER = ?\nAND    QT.QUEUE_TABLE LIKE ?\nMINUS\nSELECT MV.MVIEW_NAME, MV.OWNER\nFROM   SYS.ALL_MVIEWS MV\nWHERE  MV.OWNER = ?\nAND    MV.MVIEW_NAME LIKE ?\nMINUS\nSELECT MVL.LOG_TABLE, MVL.LOG_OWNER\nFROM   SYS.ALL_SNAPSHOT_LOGS MVL\nWHERE  MVL.LOG_OWNER = ?\nAND    MVL.LOG_TABLE LIKE ?\nMINUS\nSELECT RU.TABLE_NAME, RU.OWNER\nFROM   SYS.ALL_TABLES RU\nWHERE  RU.TABLE_NAME LIKE 'RUPD%'\nAND    RU.TEMPORARY = 'Y'\nAND    RU.OWNER = ?\nAND    EXISTS (SELECT 1\n               FROM   SYS.ALL_TAB_COLUMNS ATC\n               WHERE  ATC.OWNER = RU.OWNER\n               AND    ATC.TABLE_NAME = RU.TABLE_NAME\n               AND    ATC.COLUMN_NAME = 'CHANGE_VECTOR$$')\n) X\nUNION ALL\nSELECT T.TABLE_NAME\n,     'TABLE' OBJECT_TYPE\n,     (SELECT O.OBJECT_ID\n       FROM   SYS.ALL_OBJECTS O\n       WHERE  O.OWNER = T.OWNER\n       AND O.OBJECT_TYPE = 'TABLE'\n       AND O.OBJECT_NAME = T.TABLE_NAME) OBJECT_ID\n,      NULL LAST_DDL_TIME\nFROM   SYS.ALL_OBJECT_TABLES T\nWHERE  T.OWNER = ?\nAND    T.TABLE_NAME LIKE ?\nAND    T.IOT_NAME IS NULL\nAND    T.NESTED = 'NO'\nAND    T.SECONDARY = 'N'\n--10g AND    T.DROPPED = 'NO'\n";
    static final String TABLESPACE_PROPERTIES_QUERY = "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      UT.COMPRESS_FOR\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION\n,      DTG.GROUP_NAME\n/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  SYS.USER_TABLESPACES UT, SYS.DBA_TABLESPACE_GROUPS DTG\nWHERE DTG.TABLESPACE_NAME(+) = UT.TABLESPACE_NAME\nAND   UT.TABLESPACE_NAME = ?";
    static final String TABLESPACE_PROPERTIES_QUERY_NO_DBA = "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      UT.COMPRESS_FOR\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION\n,      NULL/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  SYS.USER_TABLESPACES UT \nWHERE   UT.TABLESPACE_NAME = ?";
    static final String TABLESPACE_PROPERTIES_ORACLE9_QUERY = "SELECT NULL\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      NULL\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      NULL\n,      NULL/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  SYS.USER_TABLESPACES UT \nWHERE   UT.TABLESPACE_NAME = ?";
    static final String TABLESPACE_DATA_FILES_QUERY = "SELECT \nFILE_NAME, BYTES\n,      MAXBYTES\n,      AUTOEXTENSIBLE\n,      INCREMENT_BY\n,      'DATA'\nFROM   SYS.DBA_DATA_FILES\nWHERE  TABLESPACE_NAME = ?\nUNION\nSELECT FILE_NAME, BYTES\n,      MAXBYTES\n,      AUTOEXTENSIBLE\n,      INCREMENT_BY\n,      'TEMP' FILE_TYPE\nFROM   SYS.DBA_TEMP_FILES\nWHERE  TABLESPACE_NAME = ?";
    static final String TABLESPACE_PROPERTIES_XE_QUERY = "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      NULL\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION\n,      DTG.GROUP_NAME\n/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  SYS.USER_TABLESPACES UT, SYS.DBA_TABLESPACE_GROUPS DTG\nWHERE DTG.TABLESPACE_NAME(+) = UT.TABLESPACE_NAME\nAND   UT.TABLESPACE_NAME = ?";
    static final String TABLESPACE_PROPERTIES_XE_QUERY_NO_DBA = "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      NULL\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION\n,      NULL\n/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  SYS.USER_TABLESPACES UT\nWHERE UT.TABLESPACE_NAME = ?";
    static final String TABLE_TYPE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TABLE_TYPE_QUERY*/\n A.TEMPORARY, A.DURATION, A.IOT_TYPE, A.PARTITIONED, A.NESTED,\n ( SELECT 1 FROM SYS.ALL_EXTERNAL_TABLES E    WHERE E.OWNER = A.OWNER AND E.TABLE_NAME = A.TABLE_NAME ) EXTERNAL_TAB\nFROM SYS.ALL_TABLES A \nWHERE A.OWNER = ? AND A.TABLE_NAME = ?";
    static final String TABLE_TYPE_ORACLE8_QUERY = "SELECT /*OracleDictionaryQueries.TABLE_TYPE_ORACLE8_QUERY(SYS.ALL_TABLES)*/\n 'N' TEMPORARY, null DURATION, IOT_TYPE, PARTITIONED, NESTED, null EXTERNAL_TAB\nFROM SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
    static final String TABLE_PROPERTIES_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_QUERY(SYS.ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, COMPRESSION,\n       COMPRESS_FOR, DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
    static final String TABLE_PROPERTIES_ORACLE10_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE10_QUERY(SYS.ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, COMPRESSION,\n       null COMPRESS_FOR, DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
    static final String TABLE_PROPERTIES_ORACLE9_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE9_QUERY(SYS.ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, null COMPRESSION,\n       null COMPRESS_FOR, DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
    static final String TABLE_PROPERTIES_ORACLE8_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE8_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, null COMPRESSION,\n       null COMPRESS_FOR, DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
    static final String TABLE_PROPERTIES_ORACLE7_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE7_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, null LOGGING, null BUFFER_POOL, null COMPRESSION,\n       null COMPRESSION_FOR, 1 DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
    static final String TABLE_PROPERTIES_OLITE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_OLITE_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       null FREELISTS, null FREELIST_GROUPS, null LOGGING,\n       null BUFFER_POOL, null COMPRESSION, null COMPRESS_FOR, null DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
    static final String TABLE_EXTERNAL_TAB_QUERY = "select /*OracleDictionaryQueries.ALL_TABLE_EXTERNAL_TAB_QUERY*/\n       TYPE_NAME, REJECT_LIMIT, ACCESS_TYPE, ACCESS_PARAMETERS, PROPERTY, \n       DEFAULT_DIRECTORY_OWNER, DEFAULT_DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_TABLES \nwhere  OWNER = ? \nand    TABLE_NAME = ? \n";
    static final String TABLE_EXTERNAL_TAB_ORACLE9i_QUERY = "select /*OracleDictionaryQueries.ALL_TABLE_EXTERNAL_TAB_ORACLE9i_QUERY*/\n       TYPE_NAME, REJECT_LIMIT, ACCESS_TYPE, ACCESS_PARAMETERS, null, \n       DEFAULT_DIRECTORY_OWNER, DEFAULT_DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_TABLES \nwhere  OWNER = ? \nand    TABLE_NAME = ? \n";
    static final String TABLE_EXT_LOCATIONS_QUERY = "select /*OracleDictionaryQueries.ALL_TABLE_EXT_LOCATIONS_QUERY*/\n       LOCATION, DIRECTORY_OWNER, DIRECTORY_NAME \nfrom   SYS.ALL_EXTERNAL_LOCATIONS \nwhere  OWNER = ?\nand    TABLE_NAME = ?\n";
    static String TABLE_IOT_STORAGE_PROPERTIES_QUERY = "select TABLESPACE_NAME, PCT_FREE, null PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, TEMPORARY, DURATION\nfrom  SYS.ALL_INDEXES \nwhere OWNER = ? AND TABLE_NAME = ? AND INDEX_TYPE = 'IOT - TOP'";
    static String TABLE_IOT_INDEX_QUERY = "select PCT_THRESHOLD, PREFIX_LENGTH, INCLUDE_COLUMN\nfrom   SYS.ALL_INDEXES\nwhere  OWNER = ?\nand    INDEX_NAME = ?";
    static String TABLE_IOT_MAPPING_AND_OVERFLOW_QUERY = "select TABLE_NAME, IOT_TYPE,\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL\nfrom   SYS.ALL_TABLES\nwhere  OWNER = ?\nand    IOT_NAME = ?\nand    IOT_TYPE like 'IOT_%'";
    static final String TABLE_REFS_COLLECTION = "select /*OracleDictionaryQueries.ALL_TABLE_REFS_COLLECTION*/\n       1\nfrom sys.all_tab_columns c\nwhere c.owner=?\nand   c.table_name=?\nand exists ( select 1 from sys.all_types t\n             where  t.owner = c.owner\n             and    t.type_name = c.data_type\n             and    t.typecode like '%COLLECTION' )";
    static final String TABLE_PARTITIONS_TYPE_QUERY = "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_TYPE_QUERY*/\n       apt.partitioning_type, apt.subpartitioning_type, apkc.column_name\nfrom   sys.all_part_tables apt, sys.all_part_key_columns apkc\nwhere  apt.owner = ?\nand    apt.table_name = ?\nand    apkc.owner = apt.owner\nand    apkc.name  = apt.table_name\nand    apkc.object_type = 'TABLE'\norder by apkc.column_position";
    static final String PARTITIONED_TABLE_DEFAULT_STORAGE_PROPERTIES_QUERY = "select /*OracleDictionaryQueries.ALL_PARTITIONED_TABLE_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, def_pct_used PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   sys.all_part_tables\nwhere  owner = ?\nand    table_name = ?\n";
    static final String PARTITIONED_IOT_DEFAULT_STORAGE_PROPERTIES_QUERY = "select /*OracleDictionaryQueries.ALL_PARTITIONED_IOT_DEFAULT_STORAGE_PROPERTIES_QUERY*/\n       def_tablespace_name TABLESPACE_NAME,\n       def_pct_free PCT_FREE, null PCT_USED,\n       def_ini_trans INI_TRANS, def_max_trans MAX_TRANS,\n       decode(def_initial_extent, 'DEFAULT', null, def_initial_extent) INITIAL_EXTENT,\n       decode(def_next_extent, 'DEFAULT', null, def_next_extent) NEXT_EXTENT,\n       decode(def_min_extents, 'DEFAULT', null, def_min_extents) MIN_EXTENTS,\n       decode(def_max_extents, 'DEFAULT', null, def_max_extents) MAX_EXTENTS,\n       decode(def_pct_increase, 'DEFAULT', null, def_pct_increase) PCT_INCREASE,\n       decode(def_freelists, 0, null, def_freelists) FREELISTS,\n       decode(def_freelist_groups, 0, null, def_freelist_groups) FREELIST_GROUPS,\n       decode(def_logging, 'NONE', null, def_logging) LOGGING,\n       def_buffer_pool BUFFER_POOL\nfrom   sys.all_part_indexes\nwhere  owner = ?\nand    index_name = ?\n";
    static final String TABLE_PARTITIONS_PRE_ORACLE11_QUERY = "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, min_extent MIN_EXTENTS, max_extent MAX_EXTENTS,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, null COMPRESS_FOR, PARTITION_NAME, HIGH_VALUE\nfrom   sys.all_tab_partitions atp\nwhere  atp.table_owner = ?\nand    atp.table_name  = ?\norder by atp.partition_position";
    static final String TABLE_PARTITIONS_QUERY = "select /*OracleDictionaryQueries.ALL_TABLE_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, min_extent MIN_EXTENTS, max_extent MAX_EXTENTS,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, COMPRESS_FOR, PARTITION_NAME, HIGH_VALUE\nfrom   sys.all_tab_partitions atp\nwhere  atp.table_owner = ?\nand    atp.table_name  = ?\norder by atp.partition_position";
    static final String TABLE_LOB_PARTITIONS_QUERY = "select /*OracleDictionaryQueries.ALL_TABLE_LOB_PARTITIONS_QUERY*/\n       COLUMN_NAME, PARTITION_NAME NAME, LOB_PARTITION_NAME LOB_SEGMENT_NAME, CHUNK,\n       PCTVERSION, CACHE, IN_ROW, TABLESPACE_NAME, LOGGING, BUFFER_POOL,\n       decode(INITIAL_EXTENT, 'DEFAULT', null, INITIAL_EXTENT) INITIAL_EXTENT,\n       decode(NEXT_EXTENT, 'DEFAULT', null, NEXT_EXTENT) NEXT_EXTENT,\n       decode(MIN_EXTENTS, 'DEFAULT', null, MIN_EXTENTS) MIN_EXTENTS,\n       decode(MAX_EXTENTS, 'DEFAULT', null, MAX_EXTENTS) MAX_EXTENTS,\n       decode(PCT_INCREASE, 'DEFAULT', null, PCT_INCREASE) PCT_INCREASE,\n       decode(FREELISTS, 'DEFAULT', null, FREELISTS) FREELISTS,\n       decode(FREELIST_GROUPS, 'DEFAULT', null, FREELIST_GROUPS) FREELIST_GROUPS\nfrom   SYS.ALL_LOB_PARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_POSITION, COLUMN_NAME";
    static final String TABLE_SUBPARTITION_COLUMNS_QUERY = "select /*OracleDictionaryQueries.ALL_TABLE_SUBPARTITION_COLUMNS_QUERY*/\n       COLUMN_NAME\nfrom   SYS.ALL_SUBPART_KEY_COLUMNS\nwhere  OWNER = ?\nand    NAME  = ?\norder by COLUMN_POSITION";
    static final String TABLE_SUBPARTITION_TEMPLATES_QUERY = "select /*OracleDictionaryQueries.ALL_TABLE_SUBPARTITION_TEMPLATES_QUERY*/\n       SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_BOUND\nfrom   SYS.ALL_SUBPARTITION_TEMPLATES\nwhere  /**/USER_NAME  = ?\nand    TABLE_NAME = ?\norder by SUBPARTITION_POSITION";
    static final String TABLE_LOB_TEMPLATES_QUERY = "select /*OracleDictionaryQueries.ALL_TABLE_LOB_TEMPLATES_QUERY*/\n       distinct SUBPARTITION_NAME, LOB_SEGMENT_NAME, TABLESPACE_NAME, LOB_COL_NAME\nfrom   SYS.ALL_LOB_TEMPLATES\nwhere  /**/USER_NAME  = ?\nand    TABLE_NAME = ?\norder by SUBPARTITION_NAME";
    static final String TABLE_PARTITION_LEVEL_SUBPARTITIONS_QUERY = "select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITIONS_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE\nfrom   SYS.ALL_TAB_SUBPARTITIONS\nwhere  TABLE_OWNER = ?\nand    TABLE_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION";
    static final String TABLE_PARTITION_LEVEL_SUBPARTITION_LOBS_QUERY = "select /*OracleDictionaryQueries.ALL_TABLE_PARTITION_LEVEL_SUBPARTITION_LOBS_QUERY*/\n       LS.COLUMN_NAME\n,      LS.SUBPARTITION_NAME NAME\n,      LS.LOB_SUBPARTITION_NAME LOB_SEGMENT_NAME\n,      LS.CHUNK\n,      LS.PCTVERSION\n,      LS.CACHE\n,      LS.IN_ROW\n,      LS.TABLESPACE_NAME\n,      LS.LOGGING\n,      LS.BUFFER_POOL\n,      LS.INITIAL_EXTENT\n,      LS.NEXT_EXTENT\n,      LS.MIN_EXTENTS\n,      LS.MAX_EXTENTS\n,      LS.PCT_INCREASE\n,      LS.FREELISTS\n,      LS.FREELIST_GROUPS\nfrom   SYS.ALL_LOB_SUBPARTITIONS LS\n,      SYS.ALL_LOBS L\nwhere  LS.TABLE_OWNER = ?\nand    LS.TABLE_NAME  = ?\nand    LS.TABLE_OWNER = L.OWNER\nand    LS.TABLE_NAME = L.TABLE_NAME\nand    LS.COLUMN_NAME = L.COLUMN_NAME\norder by LS.SUBPARTITION_NAME";
    static final String TABLE_LOB_PARMATERS_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TABLE_LOB_PARMATERS_QUERY*/ \n       AL.COLUMN_NAME\n,      AL.SEGMENT_NAME\n,      AL.PCTVERSION\n,      AL.IN_ROW\n,      AL.CHUNK\n,      AL.FREEPOOLS\n,      AL.RETENTION\n,      PS.TABLESPACE_NAME\n,      AL.CACHE\n,      AL.LOGGING\n,      PS.INITIAL_EXTENT\n,      PS.NEXT_EXTENT\n,      PS.MIN_EXTENTS\n,      PS.MAX_EXTENTS\n,      PS.PCT_INCREASE\n,      PS.FREELISTS\n,      PS.FREELIST_GROUPS\n,      PS.BUFFER_POOL\nFROM   SYS.ALL_LOBS AL\n,      SYS.ALL_TABLES T\n,     (SELECT US.SEGMENT_NAME\n       ,      US.TABLESPACE_NAME\n       ,      US.INITIAL_EXTENT\n       ,      US.NEXT_EXTENT\n       ,      US.MIN_EXTENTS\n       ,      US.MAX_EXTENTS\n       ,      US.PCT_INCREASE\n       ,      US.FREELISTS\n       ,      US.FREELIST_GROUPS\n       ,      US.BUFFER_POOL\n       ,      US.PARTITION_NAME\n       FROM   SYS.USER_SEGMENTS US\n       ,      SYS.USER_LOBS UL\n       WHERE  US.SEGMENT_NAME = UL.SEGMENT_NAME\n       AND    US.PARTITION_NAME IS NULL\n       AND    US.SEGMENT_TYPE = 'LOBSEGMENT'\n       AND    USER = ?\n       AND    UL.TABLE_NAME = ?\n      ) PS\nWHERE AL.OWNER = ?\nAND   AL.TABLE_NAME = ?\nAND   AL.OWNER = T.OWNER\nAND   AL.TABLE_NAME = T.TABLE_NAME\nAND   T.PARTITIONED = 'NO'\nAND   AL.SEGMENT_NAME = PS.SEGMENT_NAME (+)";
    static final String COLUMN_ORACLE12c_QUERY = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE12c_QUERY*/\n       C.COLUMN_NAME, C.DATA_TYPE, C.DATA_TYPE_OWNER, \n       C.DATA_LENGTH, C.DATA_PRECISION, C.DATA_SCALE, C.NULLABLE, \n       C.DEFAULT_LENGTH, C.CHAR_LENGTH, C.DATA_DEFAULT, \n    ( SELECT CMT.COMMENTS FROM SYS.ALL_COL_COMMENTS CMT \n      WHERE C.OWNER = CMT.OWNER \n        AND C.TABLE_NAME = CMT.TABLE_NAME \n        AND C.COLUMN_NAME = CMT.COLUMN_NAME) COMMENTS \n    , decode(C.CHAR_USED, 'B', 'BYTE', 'C', 'CHAR', null) \n    , C.DATA_TYPE_MOD, C.VIRTUAL_COLUMN, C.IDENTITY_COLUMN, C.DEFAULT_ON_NULL \nFROM SYS.ALL_TAB_COLS C \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.HIDDEN_COLUMN = 'NO' \nORDER BY C.COLUMN_ID\n";
    static final String COLUMN_ORACLE11g_QUERY = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE11g_QUERY*/\n       C.COLUMN_NAME, C.DATA_TYPE, C.DATA_TYPE_OWNER, \n       C.DATA_LENGTH, C.DATA_PRECISION, C.DATA_SCALE, C.NULLABLE, \n       C.DEFAULT_LENGTH, C.CHAR_LENGTH, C.DATA_DEFAULT, \n    ( SELECT CMT.COMMENTS FROM SYS.ALL_COL_COMMENTS CMT \n      WHERE C.OWNER = CMT.OWNER \n        AND C.TABLE_NAME = CMT.TABLE_NAME \n        AND C.COLUMN_NAME = CMT.COLUMN_NAME) COMMENTS \n    , decode(C.CHAR_USED, 'B', 'BYTE', 'C', 'CHAR', null) \n    , C.DATA_TYPE_MOD, C.VIRTUAL_COLUMN, null, null \nFROM SYS.ALL_TAB_COLS C \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.HIDDEN_COLUMN = 'NO' \nORDER BY C.COLUMN_ID\n";
    static final String COLUMN_ORACLE9i_QUERY = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE9i_QUERY*/\n       C.COLUMN_NAME, C.DATA_TYPE, C.DATA_TYPE_OWNER, \n       C.DATA_LENGTH, C.DATA_PRECISION, C.DATA_SCALE, C.NULLABLE, \n       C.DEFAULT_LENGTH, C.CHAR_LENGTH, C.DATA_DEFAULT, CMT.COMMENTS \n    , decode(C.CHAR_USED, 'B', 'BYTE', 'C', 'CHAR', null) \n    , C.DATA_TYPE_MOD, null, null, null \nFROM SYS.ALL_TAB_COLS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nAND   C.HIDDEN_COLUMN = 'NO' \nORDER BY C.COLUMN_ID\n";
    static final String COLUMN_ORACLE8i_QUERY = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE8i_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, CHAR_COL_DECL_LENGTH, DATA_DEFAULT, COMMENTS, null \n       , null, null, null, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
    static final String COLUMN_ORACLE8_QUERY = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE8_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null \n       , null, null, null, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
    static final String COLUMN_ORACLE7_QUERY = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE7_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, null,        DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE,        DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null        , null, null, null, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
    static final String COLUMN_OLITE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_OLITE_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, null, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null \n       , null, null, null, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER(+) \nAND   C.TABLE_NAME = CMT.TABLE_NAME(+) \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME(+) \nORDER BY COLUMN_ID \n";
    static final String CONSTRAINT_ENTERPRISE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_ENTERPRISE_QUERY*/\n  A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER,  \n  A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, A.GENERATED, \n  NVL( A.INDEX_OWNER, A.OWNER ) INDEX_OWNER, A.INDEX_NAME, \n  DECODE( A.INDEX_NAME, NULL, NULL, \n    ( SELECT OBJECT_ID FROM SYS.ALL_OBJECTS AO \n      WHERE AO.OBJECT_TYPE = 'INDEX' \n        AND AO.OBJECT_NAME = A.INDEX_NAME \n        AND AO.OWNER = NVL( A.INDEX_OWNER, A.OWNER ) ) ) INDEX_OBJECT_ID, \n  DECODE( A.R_CONSTRAINT_NAME, NULL, NULL, \n    ( SELECT ( SELECT BB.OBJECT_TYPE || BB.OBJECT_ID \n               FROM SYS.ALL_OBJECTS BB \n               WHERE AA.OWNER = BB.OWNER \n               AND   AA.TABLE_NAME = BB.OBJECT_NAME \n               AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW') ) \n        || '#' || AA.TABLE_NAME \n      FROM SYS.ALL_CONSTRAINTS AA \n      WHERE AA.OWNER = A.R_OWNER \n        AND AA.CONSTRAINT_TYPE IN ( 'P', 'U' ) \n        AND AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME ) ) ref_relation_info, \n  B.COLUMN_NAME, A.DEFERRABLE, A.DEFERRED \nFROM SYS.USER_CONSTRAINTS A, SYS.USER_CONS_COLUMNS B \nWHERE A.OWNER = ? \nAND A.TABLE_NAME = ? \nAND A.CONSTRAINT_TYPE IN ( 'P', 'U', 'R', 'C' ) \nAND A.CONSTRAINT_NAME = B.CONSTRAINT_NAME(+) \nAND A.OWNER = B.OWNER(+) \nORDER BY B.POSITION";
    static final String CONSTRAINT_ENTERPRISE_QUERY_11g2 = "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_ENTERPRISE_QUERY*/\n  A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER,  \n  A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, A.GENERATED, \n  NVL( A.INDEX_OWNER, A.OWNER ) INDEX_OWNER, A.INDEX_NAME, \n  DECODE( A.INDEX_NAME, NULL, NULL, \n    ( SELECT OBJECT_ID FROM SYS.ALL_OBJECTS AO \n      WHERE AO.OBJECT_TYPE = 'INDEX' \n        AND AO.OBJECT_NAME = A.INDEX_NAME \n        AND AO.OWNER = NVL( A.INDEX_OWNER, A.OWNER ) ) ) INDEX_OBJECT_ID, \n  DECODE( A.R_CONSTRAINT_NAME, NULL, NULL, \n    ( SELECT ( SELECT BB.OBJECT_TYPE || BB.OBJECT_ID \n               FROM SYS.ALL_OBJECTS BB \n               WHERE AA.OWNER = BB.OWNER \n               AND   AA.TABLE_NAME = BB.OBJECT_NAME \n               AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW') ) \n        || '#' || AA.TABLE_NAME \n      FROM SYS.ALL_CONSTRAINTS AA \n      WHERE AA.OWNER = A.R_OWNER \n        AND AA.CONSTRAINT_TYPE IN ( 'P', 'U' ) \n        AND AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME ) ) ref_relation_info, \n  ( SELECT LISTAGG( REPLACE( B.COLUMN_NAME, ';', ';;' ), ';' ) \n               WITHIN GROUP (ORDER BY B.POSITION) \n      FROM SYS.USER_CONS_COLUMNS B \n      WHERE A.CONSTRAINT_NAME = B.CONSTRAINT_NAME \n        AND A.OWNER = B.OWNER ) concatcols, \n  A.DEFERRABLE, A.DEFERRED \nFROM SYS.USER_CONSTRAINTS A \nWHERE A.OWNER = ? \nAND A.TABLE_NAME = ? \nAND A.CONSTRAINT_TYPE IN ( 'P', 'U', 'R', 'C' ) \n";
    static final String CONSTRAINT_OLITE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_OLITE_QUERY*/\n        A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER, \n        A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, 'GENERATED NAME' GENERATED, \n        NULL INDEX_OWNER, NULL INDEX_NAME, NULL INDEX_OBJECT_ID, \n        ( SELECT 'TABLE#' || AA.TABLE_NAME \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_TABLES      BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.TABLE_NAME \n         UNION\n          SELECT 'VIEW#' || AA.TABLE_NAME \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_VIEWS       BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.VIEW_NAME           ) ref_relation_info,\n        B.COLUMN_NAME, null DEFERRABLE, null DEFERRED \nFROM SYS.ALL_CONSTRAINTS  A,  \n     SYS.ALL_CONS_COLUMNS B  \nWHERE A.OWNER           = ?  \nAND   A.TABLE_NAME      = ?  \nAND   A.OWNER           = B.OWNER  \nAND   A.CONSTRAINT_NAME = B.CONSTRAINT_NAME  \nORDER BY B.POSITION \n";
    static final String TABLE_COMMENT_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TABLE_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_TAB_COMMENTS WHERE OWNER = ? AND TABLE_NAME = ? AND TABLE_TYPE = ?";
    static final String MVIEW_COMMENT_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_MVIEW_COMMENTS WHERE OWNER = ? AND MVIEW_NAME = ?";
    static final String COLUMN_NESTED_TAB_QUERY = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_NESTED_TAB_QUERY*/\n       ANT.TABLE_NAME NESTED_TABLE \n,      TRIM(ANT.RETURN_TYPE) \nFROM   SYS.ALL_NESTED_TABLES ANT \nWHERE  ANT.OWNER = ? \nAND    ANT.PARENT_TABLE_NAME = ? \nAND    ANT.PARENT_TABLE_COLUMN = ? \n";
    static final String COLUMN_VARRAY_QUERY = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_VARRAY_QUERY*/\n       AL.SEGMENT_NAME \nFROM   SYS.ALL_TAB_COLUMNS ATC \n,      SYS.ALL_LOBS AL \nWHERE  ATC.OWNER = ? \nAND    ATC.TABLE_NAME = ? \nAND    ATC.COLUMN_NAME = ? \nAND    AL.OWNER(+) = ATC.OWNER \nAND    AL.TABLE_NAME(+) = ATC.TABLE_NAME \nAND    AL.COLUMN_NAME(+) = ATC.COLUMN_NAME \n";
    static final String REF_COLUMN_SCOPE = "SELECT /*OracleDictionaryQueries.ALL_REF_COLUMN_SCOPE*/\n       SCOPE_TABLE_OWNER\n,      SCOPE_TABLE_NAME\nFROM   SYS.ALL_REFS\nWHERE  OWNER = ?\nAND    TABLE_NAME = ?\nAND    COLUMN_NAME = ?\nAND    SCOPE_TABLE_NAME IS NOT NULL\n";
    static final String MVIEW_PROPERTIES_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_PROPERTIES_QUERY*/\n  A.UPDATABLE, A.REWRITE_ENABLED, A.REWRITE_CAPABILITY, \n  A.REFRESH_MODE, A.REFRESH_METHOD, A.FAST_REFRESHABLE, \n  A.LAST_REFRESH_TYPE, A.LAST_REFRESH_DATE, A.STALENESS, A.BUILD_MODE, \n  A.UNKNOWN_PREBUILT, A.USE_NO_INDEX, A.MASTER_ROLLBACK_SEG, %1$S, \n  ( SELECT E.REFRESH_METHOD FROM SYS.ALL_SNAPSHOTS E \n    WHERE A.OWNER = E.OWNER AND A.MVIEW_NAME = E.NAME ) KEY_TYPE, \n  C.DEGREE, C.CACHE, C.PARTITIONED, \n  ( SELECT D.NEXT_DATE FROM SYS.ALL_REFRESH D \n    WHERE A.OWNER = D.ROWNER AND A.MVIEW_NAME = D.RNAME ) NEXT_DATE, \n  ( SELECT D.INTERVAL FROM SYS.ALL_REFRESH D \n    WHERE A.OWNER = D.ROWNER AND A.MVIEW_NAME = D.RNAME ) INTERVAL, \n  ( SELECT B.DETAILOBJ_OWNER FROM SYS.ALL_MVIEW_DETAIL_RELATIONS B \n    WHERE A.OWNER = B.OWNER AND A.MVIEW_NAME = B.MVIEW_NAME ) DETAILOBJ_OWNER, \n  ( SELECT B.DETAILOBJ_NAME FROM SYS.ALL_MVIEW_DETAIL_RELATIONS B \n    WHERE A.OWNER = B.OWNER AND A.MVIEW_NAME = B.MVIEW_NAME ) DETAILOBJ_NAME \nFROM SYS.ALL_MVIEWS A, SYS.ALL_TABLES C \nWHERE A.MVIEW_NAME = C.TABLE_NAME AND A.OWNER = C.OWNER \n  AND A.OWNER = ? AND A.MVIEW_NAME = ? \n";
    static final String MVIEW_QUERY_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_QUERY_QUERY*/\n       A.QUERY\nFROM SYS.ALL_MVIEWS A\nWHERE A.OWNER = ? AND A.MVIEW_NAME = ? \n";
    static final String MVIEW_INDEX_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_INDEX_QUERY*/\n       I.INDEX_NAME \n,      I.TABLESPACE_NAME \n,      I.PCT_FREE \n,      NULL PCT_USED \n,      I.INI_TRANS \n,      I.MAX_TRANS \n,      I.INITIAL_EXTENT \n,      I.NEXT_EXTENT \n,      I.MIN_EXTENTS \n,      I.MAX_EXTENTS \n,      I.PCT_INCREASE \n,      I.FREELISTS \n,      I.FREELIST_GROUPS \n,      I.LOGGING \n,      I.BUFFER_POOL \nFROM  SYS.ALL_INDEXES I \nWHERE I.TABLE_NAME = ? \n AND I.OWNER = ? \n AND I.INDEX_NAME = \n ( SELECT C.INDEX_NAME FROM SYS.ALL_CONSTRAINTS C \n   WHERE C.TABLE_NAME = I.TABLE_NAME \n     AND C.CONSTRAINT_TYPE = 'P' \n     AND I.OWNER = NVL( C.INDEX_OWNER, C.OWNER ) ) ";
    static final String MVIEW_ORACLE8i_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_ORACLE8i_QUERY*/\n       MV.MVIEW_NAME, 'MATERIALIZED VIEW', O.OBJECT_ID, O.LAST_DDL_TIME  FROM  SYS.ALL_MVIEWS MV, SYS.ALL_OBJECTS O WHERE MV.OWNER = ? AND   MV.MVIEW_NAME LIKE ? AND   MV.OWNER = O.OWNER AND   MV.MVIEW_NAME = O.OBJECT_NAME AND   O.OBJECT_TYPE = 'UNDEFINED'";
    private static final String MVIEW_OTHER_USER_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_OTHER_USER_QUERY*/   MVIEW_NAME OBJECT_NAME, 'MATERIALIZED VIEW' OBJECT_TYPE,    NULL OBJECT_ID, NULL LAST_DDL_TIME FROM SYS.ALL_MVIEWS WHERE OWNER = ? AND MVIEW_NAME LIKE ?";
    static final String MVIEW_LOG_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_QUERY*/\n       L.MASTER, 'MATERIALIZED VIEW LOG',        NULL OBJECT_ID, NULL LAST_DDL_TIME \nFROM SYS.ALL_MVIEW_LOGS L\nWHERE L.LOG_OWNER = ? AND L.MASTER LIKE ?\n";
    static final String MVIEW_LOG_817_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_817_QUERY*/\n       L.MASTER, 'MATERIALIZED VIEW LOG',        NULL OBJECT_ID, NULL LAST_DDL_TIME \nFROM SYS.ALL_SNAPSHOT_LOGS L\nWHERE L.LOG_OWNER = ? AND L.MASTER LIKE ?\n";
    static final String TYPE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TYPE_QUERY*/\nT.TYPE_NAME, 'TYPE' OBJECT_TYPE,\n( SELECT O.OBJECT_ID FROM SYS.ALL_OBJECTS O \n  WHERE O.OBJECT_TYPE = 'TYPE' AND O.OBJECT_NAME =  T.TYPE_NAME AND O.OWNER = T.OWNER AND   O.SUBOBJECT_NAME IS NULL ) OBJECT_ID, NULL LAST_DDL_TIME \n                  FROM   SYS.ALL_TYPES T\n                  WHERE  T.OWNER = ?                  AND T.TYPE_NAME LIKE ?";
    static final String MVIEW_LOG_OBJECT_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_OBJECT_QUERY*/\n       L.MASTER, L.LOG_TABLE, L.ROWIDS, L.PRIMARY_KEY, \n       L.OBJECT_ID, L.SEQUENCE, L.INCLUDE_NEW_VALUES, \n       T.CACHE, T.DEGREE \nFROM SYS.ALL_SNAPSHOT_LOGS L, \n     SYS.ALL_TABLES T \nWHERE T.TABLE_NAME = L.LOG_TABLE \nAND   T.OWNER = L.LOG_OWNER \nAND   L.LOG_OWNER = ''{0}'' AND L.MASTER = ''{1}''";
    static final String MVIEW_LOG_COLUMNS_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_COLUMNS_QUERY*/\n     TC.COLUMN_NAME \nFROM SYS.ALL_SNAPSHOT_LOGS MVL\n,    SYS.ALL_TAB_COLS TC\nWHERE TC.OWNER = MVL.LOG_OWNER\n  AND TC.TABLE_NAME = MVL.LOG_TABLE\n  AND MVL.LOG_OWNER = ? \n  AND MVL.MASTER = ?\n  AND TC.COLUMN_NAME IN \n  ( SELECT TC2.COLUMN_NAME \n    FROM SYS.ALL_TAB_COLS TC2\n    WHERE TC2.OWNER = MVL.LOG_OWNER\n      AND TC2.TABLE_NAME = MVL.MASTER\n    MINUS \n    SELECT ACC.COLUMN_NAME \n    FROM SYS.ALL_CONS_COLUMNS ACC \n    WHERE ACC.OWNER = MVL.LOG_OWNER \n      AND ACC.TABLE_NAME = MVL.MASTER \n      AND ACC.CONSTRAINT_NAME = \n    ( SELECT C.CONSTRAINT_NAME FROM SYS.ALL_CONSTRAINTS C \n      WHERE C.CONSTRAINT_TYPE = 'P' AND C.TABLE_NAME = MVL.MASTER \n        AND C.OWNER = MVL.LOG_OWNER ) ) \nORDER BY TC.COLUMN_ID";
    static final String MVIEW_LOG_CANDIDATE_TABLES_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_CANDIDATE_TABLES_QUERY*/\n       T.TABLE_NAME \n,      DECODE(MV.MVIEW_NAME,null,'TABLE','MATERIALIZED VIEW') OBJECT_TYPE\n,     (SELECT O.OBJECT_ID\n       FROM   SYS.ALL_OBJECTS O \n       WHERE  O.OWNER = T.OWNER \n       AND    O.OBJECT_TYPE = DECODE(MV.MVIEW_NAME,null,'TABLE','MATERIALIZED VIEW') \n       AND    O.OBJECT_NAME = T.TABLE_NAME) OBJECT_ID \nFROM   SYS.ALL_TABLES T \n,      SYS.ALL_MVIEWS MV\nWHERE  T.OWNER = ? \nAND    T.TEMPORARY = 'N' \nAND    T.NESTED = 'NO' \nAND    T.IOT_NAME IS NULL \nAND    T.SECONDARY = 'N'\nAND    MV.MVIEW_NAME (+) = T.TABLE_NAME\nAND    MV.OWNER (+) = T.OWNER\nAND    NOT EXISTS (SELECT 1 \n                   FROM   SYS.ALL_SNAPSHOT_LOGS L   \n                   WHERE  (L.MASTER = T.TABLE_NAME OR \n                           L.LOG_TABLE = T.TABLE_NAME) \n                   AND    L.LOG_OWNER = T.OWNER) \nAND    NOT EXISTS (SELECT 1 \n                   FROM   SYS.ALL_EXTERNAL_TABLES E \n                   WHERE  E.TABLE_NAME = T.TABLE_NAME \n                   AND    E.OWNER = T.OWNER)\nORDER BY 1";
    static final String JAVA_QUERY = "SELECT /*OracleDictionaryQueries.ALL_JAVA_QUERY*/\n   NVL(LONGNAME,OBJECT_NAME), OBJECT_TYPE, OBJECT_ID, LAST_DDL_TIME FROM SYS.ALL_OBJECTS, JAVASNM WHERE OWNER = ? AND NVL(LONGNAME,OBJECT_NAME) LIKE ? AND OBJECT_TYPE = ? AND OBJECT_NAME = SHORT(+)";
    static final String JAVA_SOURCE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_JAVA_SOURCE_QUERY*/\n       TEXT FROM SYS.ALL_SOURCE, JAVASNM WHERE TYPE = ? AND OWNER = ? AND NAME = SHORT(+) AND NVL(LONGNAME,NAME) = ? ORDER BY LINE";
    static final String PL_SQL_SOURCE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_PL_SQL_SOURCE_QUERY*/\n       TEXT FROM SYS.ALL_SOURCE WHERE TYPE = ? AND OWNER = ? AND NAME = ? ORDER BY LINE";
    static final String OBJECT_TYPE_ORACLE8_QUERY = "SELECT /*OracleDictionaryQueries.ALL_OBJECT_TYPE_ORACLE8_QUERY*/\n       T.TYPECODE ,      (SELECT CT.COLL_TYPE         FROM SYS.ALL_COLL_TYPES CT         WHERE CT.OWNER = T.OWNER         AND CT.TYPE_NAME = T.TYPE_NAME) COLLTYPE FROM   SYS.ALL_TYPES T WHERE  T.OWNER = ? AND T.TYPE_NAME = ? ";
    static final String TRIGGER_PROPS_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TRIGGER_PROPS_QUERY*/\n       A.BASE_OBJECT_TYPE, A.TRIGGER_TYPE, A.TRIGGERING_EVENT, A.TABLE_OWNER, A.TABLE_NAME, A.REFERENCING_NAMES, A.WHEN_CLAUSE, A.TRIGGER_BODY, A.STATUS, B.COLUMN_NAME, B.COLUMN_LIST FROM SYS.ALL_TRIGGERS A, SYS.ALL_TRIGGER_COLS B WHERE A.OWNER = B.TRIGGER_OWNER(+) AND A.TRIGGER_NAME = B.TRIGGER_NAME(+) AND A.OWNER = ? AND A.TRIGGER_NAME = ?";
    static final String TRIGGER_SOURCE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TRIGGER_SOURCE_QUERY*/\n       TEXT FROM SYS.ALL_SOURCE WHERE TYPE = 'TRIGGER' AND OWNER = ? AND NAME = ? ORDER BY LINE";
    static final String TRIGGER_PROPS_ORACLE8_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TRIGGER_SOURCE_QUERY*/\n       TEXT FROM SYS.ALL_SOURCE WHERE TYPE = 'TRIGGER' AND OWNER = ? AND NAME = ? ORDER BY LINE".replaceFirst("A /*OracleDictionaryQueries.ALL_TRIGGER_PROPS_ORACLE8_QUERY*/\n      .BASE_OBJECT_TYPE", "'TABLE'");
    static final String VIEW_TEXT_QUERY = "SELECT /*OracleDictionaryQueries.ALL_VIEW_TEXT_QUERY*/\n       TEXT_LENGTH, TEXT FROM SYS.ALL_VIEWS WHERE OWNER = ? AND VIEW_NAME = ?";
    static final String ORACLE_ID_QUERY = "SELECT /*OracleDictionaryQueries.ALL_ORACLE_ID_QUERY*/\n       OWNER, OBJECT_NAME, LAST_DDL_TIME FROM SYS.ALL_OBJECTS WHERE OBJECT_ID = ? AND OBJECT_TYPE = ?";
    static final String ORACLE_ID_10g_QUERY = "SELECT /*OracleDictionaryQueries.ALL_ORACLE_ID_10G_QUERY*/\n       AO.OWNER, AO.OBJECT_NAME, AO.LAST_DDL_TIME FROM   SYS.ALL_OBJECTS AO WHERE  AO.OBJECT_ID = ? AND OBJECT_TYPE = ? AND NOT EXISTS \n   ( SELECT 1 FROM RECYCLEBIN RB \n     WHERE RB.PURGE_OBJECT = AO.OBJECT_ID)";
    static final String JAVA_BY_ID_QUERY = "SELECT /*OracleDictionaryQueries.ALL_JAVA_BY_ID_QUERY*/\n       O.OWNER, NVL(J.LONGNAME,O.OBJECT_NAME), O.LAST_DDL_TIME  FROM SYS.ALL_OBJECTS O, SYS.JAVASNM J  WHERE O.OBJECT_ID = ? AND O.OBJECT_NAME = J.SHORT(+)";
    static final String SYNONYM_REF_OBJECT_QUERY = "SELECT /*OracleDictionaryQueries.ALL_SYNONYM_REF_OBJECT_QUERY*/\n       S.TABLE_OWNER, S.TABLE_NAME, REF.OBJECT_TYPE, REF.OBJECT_ID,        S.DB_LINK  FROM  SYS.ALL_OBJECTS REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.DB_LINK IS NULL AND   S.TABLE_NAME   = REF.OBJECT_NAME AND   REF.OBJECT_TYPE NOT LIKE '% BODY'";
    static final String SYNONYM_REF_OBJECT_OLITE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_SYNONYM_REF_OBJECT_OLITE_QUERY*/\n       S.TABLE_OWNER, S.TABLE_NAME, 'TABLE', NULL, S.DB_LINK  FROM  SYS.ALL_TABLES REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.TABLE_NAME UNION ALL\n SELECT S.TABLE_OWNER, S.TABLE_NAME, 'VIEW', NULL, S.DB_LINK  FROM  SYS.ALL_VIEWS REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.VIEW_NAME";
    static final String SYNONYM_REF_OBJECT_NAME_AND_TYPE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_SYNONYM_REF_OBJECT_NAME_AND_TYPE_QUERY*/\n       S.TABLE_OWNER, S.TABLE_NAME, S.DB_LINK  FROM  SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ? ";
    static final String ORACLE_SEQUENCE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_ORACLE_SEQUENCE_QUERY*/\n       MIN_VALUE, MAX_VALUE, INCREMENT_BY, CYCLE_FLAG, ORDER_FLAG, CACHE_SIZE, LAST_NUMBER FROM SYS.ALL_SEQUENCES S WHERE SEQUENCE_OWNER = ? AND SEQUENCE_NAME = ? ";
    static final String OLITE_SEQUENCE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_OLITE_SEQUENCE_QUERY*/\n       MIN_VALUE, MAX_VALUE, INCREMENT_BY, NULL, NULL, NULL, NULL FROM SYS.ALL_SEQUENCES S WHERE SEQUENCE_OWNER = ? AND SEQUENCE_NAME = ?";
    static final String MVIEW_LOG_DEF_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_DEF_QUERY*/\n       UNIQUE MASTER, ROWIDS, PRIMARY_KEY, FILTER_COLUMNS FROM SYS.ALL_SNAPSHOT_LOGS WHERE LOG_OWNER = ? AND LOG_TABLE = ?";
    static final String RECYCLED_OBJECT_QUERY = "SELECT /*OracleDictionaryQueries.RECYCLED_OBJECT_QUERY*/\n       ORIGINAL_NAME, OPERATION, TYPE, TS_NAME, CREATETIME, DROPTIME,  DROPSCN, PARTITION_NAME, CAN_UNDROP, CAN_PURGE, SPACE, RELATED, BASE_OBJECT, PURGE_OBJECT FROM RECYCLEBIN WHERE OBJECT_NAME = ? AND NOT(CAN_PURGE = 'NO' AND CAN_UNDROP = 'NO')";
    static final String DBA_RECYCLED_OBJECT_QUERY = "SELECT /*OracleDictionaryQueries.DBA_RECYCLED_OBJECT_QUERY*/\n       ORIGINAL_NAME, OPERATION, TYPE, TS_NAME, CREATETIME, DROPTIME,  DROPSCN, PARTITION_NAME, CAN_UNDROP, CAN_PURGE, SPACE, RELATED, BASE_OBJECT, PURGE_OBJECT FROM DBA_RECYCLEBIN WHERE OBJECT_NAME = ? AND OWNER = ? AND NOT(CAN_PURGE = 'NO' AND CAN_UNDROP = 'NO')";
    static final String RECYCLEBIN_QUERY = "SELECT /*OracleDictionaryQueries.ALL_RECYCLEBIN_QUERY*/\n       OBJECT_NAME, 'RECYCLEBIN',        NULL OBJECT_ID, NULL LAST_DDL_TIME FROM RECYCLEBIN WHERE '<SCHEMA>' = ? AND OBJECT_NAME LIKE ? AND NOT(CAN_PURGE = 'NO' AND CAN_UNDROP = 'NO')";
    static final String DBA_RECYCLEBIN_QUERY = "SELECT /*OracleDictionaryQueries.DBA_RECYCLEBIN_QUERY*/\n       OBJECT_NAME, 'RECYCLEBIN',        NULL OBJECT_ID, NULL LAST_DDL_TIME FROM DBA_RECYCLEBIN WHERE OWNER = ? AND OBJECT_NAME LIKE ? AND NOT(CAN_PURGE = 'NO' AND CAN_UNDROP = 'NO')";
    static final String DATABASE_LINK_QUERY = "SELECT /*OracleDictionaryQueries.ALL_DATABASE_LINK_QUERY*/ DB_LINK\n,      ' DATABASE LINK '\n,      NULL OBJECT_ID \n,      NULL LAST_DDL_TIME \nFROM   SYS.ALL_DB_LINKS \n,      (SELECT SUBSTR(GLOBAL_NAME,INSTR(GLOBAL_NAME,'.')) GNAME_SUFFIX\n       ,       ? NAME \n       FROM    GLOBAL_NAME) GNAME\nWHERE  OWNER = ? \nAND   ( DB_LINK LIKE GNAME.NAME OR DB_LINK LIKE GNAME.NAME||GNAME.GNAME_SUFFIX )";
    static final String DATABASE_LINK_OBJECT_QUERY = "WITH API AS (SELECT ? NAME \n             ,      (SELECT SUBSTR(GLOBAL_NAME,INSTR(GLOBAL_NAME,'.')) FROM GLOBAL_NAME) GNAME\n             ,      DBL2.DB_LINK\n             ,      DBL2.OWNER\n             ,      TO_CHAR(DBMS_METADATA.GET_XML('DB_LINK',DBL2.DB_LINK,DBL2.OWNER)) XML\n             FROM   SYS.ALL_DB_LINKS DBL2)\nSELECT /*OracleDictionaryQueries.ALL_DATABASE_LINK_OBJECT_QUERY*/\n       DBL.USERNAME, DBL.HOST, DBL.CREATED,\n       REGEXP_REPLACE(REGEXP_SUBSTR(A.XML, '<AUTHUSR>.*AUTHUSR>',1,1,'n'),'<\\/*AUTHUSR>',null) AUTHUSR,\n       REGEXP_REPLACE(REGEXP_SUBSTR(A.XML, '<PASSWORDX>.*PASSWORDX>',1,1,'n'),'<\\/*PASSWORDX>',null) PASSWORDX,\n       REGEXP_REPLACE(REGEXP_SUBSTR(A.XML, '<AUTHPWDX>.*AUTHPWDX>',1,1,'n'),'<\\/*AUTHPWDX>',null) AUTHPWDX\nFROM  API A\n,     SYS.ALL_DB_LINKS DBL\nWHERE DBL.OWNER = A.OWNER\nAND   DBL.DB_LINK = A.DB_LINK\nAND   DBL.OWNER = ?\nAND   ( DBL.DB_LINK = A.NAME OR DBL.DB_LINK = A.NAME||A.GNAME )";
    static final String DATABASE_LINK_OBJECT_9i_QUERY = "WITH API AS (SELECT ? NAME \n             ,      (SELECT SUBSTR(GLOBAL_NAME,INSTR(GLOBAL_NAME,'.')) FROM GLOBAL_NAME) GNAME\n             ,      DBL2.DB_LINK\n             ,      DBL2.OWNER\n             ,      TO_CHAR(DBMS_METADATA.GET_XML('DB_LINK',DBL2.DB_LINK,DBL2.OWNER)) XML\n             FROM   SYS.ALL_DB_LINKS DBL2)\nSELECT /*OracleDictionaryQueries.ALL_DATABASE_LINK_OBJECT_QUERY*/\n       DBL.USERNAME, DBL.HOST, DBL.CREATED,\n       NULL AUTHUSR,\n       NULL PASSWORDX,\n       NULL AUTHPWDX\nFROM  API A\n,     SYS.ALL_DB_LINKS DBL\nWHERE DBL.OWNER = A.OWNER\nAND   DBL.DB_LINK = A.DB_LINK\nAND   DBL.OWNER = ?\nAND   ( DBL.DB_LINK = A.NAME OR DBL.DB_LINK = A.NAME||A.GNAME )";
    static final String DATABASE_LINK_OBJECT_BACKUP_QUERY = "WITH API AS (SELECT ? NAME \n             ,      (SELECT SUBSTR(GLOBAL_NAME,INSTR(GLOBAL_NAME,'.')) FROM GLOBAL_NAME) GNAME\n             ,      DBL2.DB_LINK\n             ,      DBL2.OWNER\n             FROM   SYS.ALL_DB_LINKS DBL2)\nSELECT /*OracleDictionaryQueries.ALL_DATABASE_LINK_OBJECT_BACKUP_QUERY*/\n       DBL.USERNAME, DBL.HOST, DBL.CREATED,\n       null AUTHUSR,\n       null PASSWORDX,\n       null AUTHPWDX\nFROM  API A\n,     SYS.ALL_DB_LINKS DBL\nWHERE DBL.OWNER = A.OWNER\nAND   DBL.DB_LINK = A.DB_LINK\nAND   DBL.OWNER = ?\nAND   ( DBL.DB_LINK = A.NAME OR DBL.DB_LINK = A.NAME||A.GNAME )";
    static final String INDEX_TAB_QUERY = "SELECT /*OracleDictionaryQueries.ALL_INDEX_TAB_QUERY*/\n       TABLE_NAME, TABLE_OWNER, TABLE_TYPE FROM SYS.ALL_INDEXES WHERE OWNER = ? AND INDEX_NAME = ?";
    static final String INDEX_OLITE_TAB_QUERY = "SELECT /*OracleDictionaryQueries.ALL_INDEX_TAB_QUERY*/\n       TABLE_NAME, TABLE_OWNER, TABLE_TYPE FROM SYS.ALL_INDEXES WHERE OWNER = ? AND INDEX_NAME = ?";
    static final String INDEX_PER_TAB_QUERY = "SELECT /*OracleDictionaryQueries.ALL_INDEX_PER_TAB_QUERY*/\n       i.INDEX_NAME, i.OWNER,       (select object_id from sys.all_objects where object_name = i.index_name and owner = i.owner and object_type = 'INDEX') OBJECT_ID,       i.UNIQUENESS, i.INDEX_TYPE, i.ITYP_OWNER, i.ITYP_NAME, i.PARAMETERS, i.DOMIDX_OPSTATUS, i.DEGREE, i.PREFIX_LENGTH,        i.TABLESPACE_NAME, i.PCT_FREE, null PCT_USED, i.INI_TRANS, i.MAX_TRANS,\n       i.INITIAL_EXTENT, i.NEXT_EXTENT, i.MIN_EXTENTS, i.MAX_EXTENTS, i.PCT_INCREASE,\n       i.FREELISTS, i.FREELIST_GROUPS, i.LOGGING, i.BUFFER_POOL\nFROM SYS.ALL_INDEXES i WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ? AND INDEX_TYPE != 'LOB'";
    static final String INDEX_OLITE_PER_TAB_QUERY = " SELECT /*OracleDictionaryQueries.ALL_INDEX_OLITE_PER_TAB_QUERY*/\n       i.INDEX_NAME, i.OWNER, null OBJECT_ID,       i.UNIQUENESS, 'NORMAL', null, null, null, null, null, null,        null TABLESPACE_NAME, null PCT_FREE, null PCT_USED, null INI_TRANS, null MAX_TRANS,\n       null INITIAL_EXTENT, null NEXT_EXTENT, null MIN_EXTENTS, null MAX_EXTENTS, null PCT_INCREASE,\n       null FREELISTS, null FREELIST_GROUPS, null LOGGING, null BUFFER_POOL\n FROM SYS.ALL_INDEXES i  WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ?";
    static final String INDEX_COLUMN_PER_TAB_QUERY = "SELECT /*OracleDictionaryQueries.ALL_INDEX_COLUMN_PER_TAB_QUERY*/\n       c.index_name, c.column_name, c.column_position, c.descend,   ( SELECT 1     FROM   sys.all_ind_expressions e     WHERE  e.index_name  = c.index_name     AND    e.index_owner = c.index_owner     AND    e.column_position = c.column_position ) col_expr_exists FROM sys.all_ind_columns c  WHERE c.table_owner = ? AND c.table_name  = ? ORDER BY c.index_name, c.column_position ";
    static final String INDEX_EXPRESSION_PER_TAB_QUERY = "SELECT /*OracleDictionaryQueries.ALL_INDEX_EXPRESSION_PER_TAB_QUERY*/\n       index_name, column_position, column_expression  FROM sys.all_ind_expressions WHERE table_owner = ? AND table_name = ? ";
    static final String INDEX_OLITE_COLUMN_PER_TAB_QUERY = "SELECT /*OracleDictionaryQueries.ALL_INDEX_OLITE_COLUMN_PER_TAB_QUERY*/\n       INDEX_NAME, COLUMN_NAME, COLUMN_POSITION, NULL, 0 FROM SYS.ALL_IND_COLUMNS WHERE TABLE_OWNER = ? AND TABLE_NAME = ? ORDER BY INDEX_NAME, COLUMN_POSITION";
    static final String INDEX_PARTITION_TYPE_QUERY = "select /*OracleDictionaryQueries.ALL_INDEX_PARTITION_TYPE_QUERY*/\n       partitioning_type, subpartitioning_type, locality, partition_count\nfrom   sys.all_part_indexes api\nwhere  api.owner = ?\nand    api.index_name = ?\n";
    static final String INDEX_PARTITION_COLUMNS_QUERY = "select /*OracleDictionaryQueries.ALL_INDEX_PARTITION_COLUMNS_QUERY*/\n       column_name\nfrom   sys.all_part_key_columns apk1\nwhere  apk1.owner = ?\nand    apk1.name = ?\nand    apk1.object_type = 'INDEX'\norder by apk1.column_position";
    static final String INDEX_PARTITIONS_QUERY = "select /*OracleDictionaryQueries.ALL_INDEX_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, null PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENT min_extents, MAX_EXTENT max_extents,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, PARTITION_NAME, HIGH_VALUE, PARAMETERS\nfrom   sys.all_ind_partitions aip\nwhere  aip.index_owner = ?\nand    aip.index_name  = ?\norder by aip.partition_position";
    static final String INDEX_SUBPARTITIONS_QUERY = "select /*OracleDictionaryQueries.ALL_INDEX_SUBPARTITIONS_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE\nfrom   SYS.ALL_IND_SUBPARTITIONS\nwhere  INDEX_OWNER = ?\nand    INDEX_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION";
    static final String DIRECTORY_QUERY = "SELECT /*OracleDictionaryQueries.ALL_DIRECTORY_QUERY*/\n       DIRECTORY_PATH FROM SYS.ALL_DIRECTORIES WHERE OWNER = ? AND DIRECTORY_NAME = ? ";
    static final String XML_SCHEMA_QUERY = "SELECT /*OracleDictionaryQueries.ALL_XML_SCHEMA_QUERY*/\n   a.SCHEMA_URL OBJECT_NAME\n,  'XML SCHEMA' OBJECT_TYPE\n,  to_number(SUBSTR(a.ID_TIME, 1, INSTR(a.ID_TIME,'_')-1)) OBJECT_ID\n,  to_date(SUBSTR(a.ID_TIME, INSTR(a.ID_TIME,'_')+1), 'JSSSSS') LAST_DDL_TIME\nFROM ( SELECT X.SCHEMA_URL\n       ,   ( SELECT O.OBJECT_ID||'_'||to_char(O.LAST_DDL_TIME,'JSSSSS')\n             FROM SYS.ALL_OBJECTS O \n             WHERE O.OWNER = 'XDB' \n             AND   O.OBJECT_NAME = X.INT_OBJNAME ) ID_TIME\n       FROM SYS.ALL_XML_SCHEMAS X \n       WHERE X.OWNER = ? AND X.SCHEMA_URL LIKE ? ) a ";
    static final String XML_SCHEMA_BY_ID_QUERY = "SELECT /*OracleDictionaryQueries.ALL_XML_SCHEMA_BY_ID_QUERY*/\n       X.OWNER, X.SCHEMA_URL, O.LAST_DDL_TIME FROM SYS.ALL_XML_SCHEMAS X, SYS.ALL_OBJECTS O WHERE O.OBJECT_ID = ? AND O.OWNER='XDB' AND O.OBJECT_NAME = X.INT_OBJNAME ";
    static final String XMLTYPE_COLUMN_PROPERTIES_QUERY = "SELECT /*OracleDictionaryQueries.ALL_XMLTYPE_COLUMN_PROPERTIES_QUERY*/ \n       XTC.COLUMN_NAME, XTC.SCHEMA_OWNER, XTC.XMLSCHEMA, XTC.ELEMENT_NAME \n,      XTC.STORAGE_TYPE, XTC.ANYSCHEMA, XTC.NONSCHEMA \nFROM   SYS.ALL_XML_TAB_COLS XTC \nWHERE  XTC.OWNER = ? \nAND    XTC.TABLE_NAME = ?";
    static final String IDENTITY_COLUMN_PROPERTIES_QUERY = "SELECT /*OracleDictionaryQueries.ALL_IDENTITY_COLUMN_PROPERTIES_QUERY*/ \n       GENERATION_TYPE FROM SYS.ALL_TAB_IDENTITY_COLS \nWHERE  OWNER = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?";
    static final String TABLE_COLSEQ_TRIGGERS_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TABLE_COLSEQ_TRIGGERS_QUERY*/\n       S.NAME, S.TEXT\nFROM   SYS.ALL_SOURCE S\nWHERE  S.OWNER = ? \nAND    S.TYPE = 'TRIGGER'\nAND EXISTS (SELECT 1\n            FROM   SYS.ALL_TRIGGERS T\n            WHERE  T.OWNER = S.OWNER\n            AND    T.TABLE_NAME = ? \n            AND    T.TRIGGER_NAME = S.NAME\n            AND    T.TABLE_OWNER = S.OWNER\n            AND    T.BASE_OBJECT_TYPE = 'TABLE'\n            AND    T.TRIGGER_TYPE LIKE '%EACH ROW'\n            AND    T.TRIGGERING_EVENT LIKE '%INSERT%'\n            AND EXISTS (SELECT 1\n                        FROM   SYS.ALL_SOURCE S2\n                        WHERE  S2.OWNER = S.OWNER\n                        AND    S2.NAME = S.NAME\n                        AND    S2.TYPE = S2.TYPE\n                        AND    S2.TEXT LIKE '%<<COLUMN_SEQUENCES>>%'\n                        )\n             )\nORDER BY S.NAME, S.LINE";
    static final String TRIGGERS_FOR_BASE_OBJECT_QUERY = "SELECT  /*OracleDictionaryQueries.ALL_TRIGGERS_FOR_BASE_OBJECT_QUERY*/\n       O.OBJECT_TYPE, T.OWNER, T.TRIGGER_NAME, O.OBJECT_ID\nFROM   SYS.ALL_TRIGGERS T\n,      SYS.ALL_OBJECTS O\nWHERE  T.BASE_OBJECT_TYPE = ?\nAND    ( T.TABLE_OWNER = ? OR T.BASE_OBJECT_TYPE = 'DATABASE' )\nAND    ( ( T.BASE_OBJECT_TYPE IN ( 'TABLE','VIEW') AND T.TABLE_NAME LIKE ? ) OR\n         ( T.BASE_OBJECT_TYPE IN ( 'SCHEMA','DATABASE') AND T.TABLE_NAME IS NULL ) \n       )\nAND    O.OBJECT_TYPE = 'TRIGGER'\nAND    O.OWNER = T.OWNER\nAND    O.OBJECT_NAME = T.TRIGGER_NAME";
    static final String XML_SCHEMA_OBJECT_QUERY = "SELECT /*OracleDictionaryQueries.ALL_XML_SCHEMA_OBJECT_QUERY*/\n       sys.xmltype.getClobVal(SCHEMA), INT_OBJNAME, LOCAL, QUAL_SCHEMA_URL FROM SYS.ALL_XML_SCHEMAS WHERE OWNER = ? AND SCHEMA_URL = ? ";
    static final String OLITE_OBJECT_QUERY = "SELECT /*OracleDictionaryQueries.ALL_OLITE_OBJECT_QUERY*/\n       <type>_NAME, '<type>', NULL OBJECT_ID, NULL LAST_DDL_TIME \nFROM SYS.<table> \nWHERE <owner> = ? AND <type>_NAME LIKE ?";
    static final String TIMESTAMP_BY_NAME_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TIMESTAMP_BY_NAME_QUERY*/\n       LAST_DDL_TIME FROM SYS.ALL_OBJECTS WHERE OWNER = ? AND OBJECT_NAME = ? AND OBJECT_TYPE = ? ";
    static final String TIMESTAMP_BY_ID_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TIMESTAMP_BY_ID_QUERY*/\n       LAST_DDL_TIME FROM SYS.ALL_OBJECTS WHERE OBJECT_ID = ? ";
    static final String TIMESTAMP_BY_ID_MVIEW_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TIMESTAMP_BY_ID_MVIEW_QUERY*/\n       GREATEST(T.LAST_DDL_TIME,MV.LAST_DDL_TIME) LAST_DDL_TIME FROM SYS.ALL_OBJECTS T ,    SYS.ALL_OBJECTS MV WHERE MV.OBJECT_ID = ? AND   T.OWNER = MV.OWNER AND   T.OBJECT_TYPE = 'TABLE' AND   T.OBJECT_NAME = MV.OBJECT_NAME";
    static final String TIMESTAMP_BY_ID_10g_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TIMESTAMP_BY_ID_10g_QUERY*/\n       AO.LAST_DDL_TIME FROM SYS.ALL_OBJECTS AO WHERE AO.OBJECT_ID = ? AND NOT EXISTS ( SELECT 1 FROM RECYCLEBIN RB WHERE RB.PURGE_OBJECT = AO.OBJECT_ID)";
    static final String TIMESTAMP_BY_NAME_QUERY_MATERIALIZED_VIEW_LOG = "SELECT /*OracleDictionaryQueries.ALL_TIMESTAMP_BY_NAME_QUERY_MATERIALIZED_VIEW_LOG*/\n       SAO.LAST_DDL_TIME FROM SYS.ALL_OBJECTS SAO     ,SYS.ALL_SNAPSHOT_LOGS MVL\nWHERE SAO.OWNER = MVL.LOG_OWNER AND SAO.OBJECT_NAME = MVL.LOG_TABLE AND SAO.OBJECT_TYPE = 'TABLE' AND MVL.LOG_OWNER = ? AND MVL.MASTER = ? AND 'MATERIALIZED VIEW LOG' = ? ";
    static final String TIMESTAMP_BY_NAME_MVIEW_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TIMESTAMP_BY_ID_MVIEW_QUERY*/\n       GREATEST(T.LAST_DDL_TIME,MV.LAST_DDL_TIME) LAST_DDL_TIME FROM SYS.ALL_OBJECTS T ,    SYS.ALL_OBJECTS MV WHERE MV.OWNER = ? AND   MV.OBJECT_NAME = ? AND   MV.OBJECT_TYPE = ? AND   T.OWNER = MV.OWNER AND   T.OBJECT_TYPE = 'TABLE' AND   T.OBJECT_NAME = MV.OBJECT_NAME";
    static final String INDEX_METADATA_QUERY = "SELECT /*OracleDictionaryQueries.ALL_INDEX_METADATA_QUERY*/\n       SYS.DBMS_METADATA.GET_XML('INDEX', ?, ?) XML\nFROM   SYS.DUAL";
    private static final String USERS_QUERY = "SELECT /*OracleDictionaryQueries.ALL_USERS_QUERY*/ USERNAME, 'SCHEMA', NULL OBJECT_ID, NULL LAST_DDL_TIME FROM SYS.ALL_USERS WHERE USERNAME LIKE ? ";
    private static final String VISIBLE_USERS_QUERY = "SELECT /*OracleDictionaryQueries.ALL_VISIBLE_USERS_QUERY*/ \nU.USERNAME, 'SCHEMA', NULL OBJECT_ID, NULL LAST_DDL_TIME \nFROM SYS.ALL_USERS U \nWHERE EXISTS ( SELECT 1 \n               FROM   SYS.ALL_TAB_PRIVS_RECD TPR \n               WHERE  TPR.OWNER = U.USERNAME ) \nAND U.USERNAME LIKE ? \nUNION \nSELECT USER, 'SCHEMA', NULL OBJECT_ID, NULL LAST_DDL_TIME FROM SYS.DUAL ";
    private static final String VISIBLE_DBLINK_USERS_QUERY = "SELECT /*OracleDictionaryQueries.ALL_VISIBLE_DBLINK_USERS_QUERY*/ \nU.USERNAME, 'SCHEMA', NULL OBJECT_ID, NULL LAST_DDL_TIME \nFROM SYS.ALL_USERS U \nWHERE EXISTS ( SELECT 1 \n               FROM   SYS.ALL_TAB_PRIVS_RECD TPR \n               WHERE  TPR.OWNER = U.USERNAME ) \nAND U.USERNAME LIKE ? \nUNION \nSELECT SYS.DBMS_UTILITY.OLD_CURRENT_USER, 'SCHEMA', NULL FROM SYS.DUAL ";
    private static final String VISIBLE_DIRECTORIES_QUERY = "SELECT /*OracleDictionaryQueries.ALL_VISIBLE_DIRECTORIES_QUERY*/        O.OBJECT_NAME, O.OBJECT_TYPE, O.OBJECT_ID, O.LAST_DDL_TIME FROM  SYS.ALL_OBJECTS O WHERE O.OWNER = ? AND O.OBJECT_TYPE = 'DIRECTORY' AND O.OBJECT_NAME LIKE ? AND EXISTS (SELECT 1             FROM   SYS.ALL_TAB_PRIVS TP             WHERE  TP.TABLE_NAME = O.OBJECT_NAME             AND    TP.TABLE_SCHEMA = O.OWNER             AND    TP.GRANTEE = USER) ";
    private static final String SEQUENCE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_SEQUENCES_QUERY*/        OBJECT_NAME, OBJECT_TYPE, OBJECT_ID, LAST_DDL_TIME FROM  SYS.ALL_OBJECTS WHERE OWNER = ? AND OBJECT_TYPE = 'SEQUENCE' AND OBJECT_NAME LIKE ? AND OBJECT_NAME NOT LIKE 'ISEQ$$_%' ";
    static final String PRIVS_QUERY = "SELECT /*OracleDictionaryQueries.ALL_PRIVS_QUERY*/\n       PRIVILEGE FROM SYS.SESSION_PRIVS";
    static final String ROLES_QUERY = "SELECT /*OracleDictionaryQueries.ALL_ROLES_QUERY*/\n       GRANTED_ROLE FROM SYS.USER_ROLE_PRIVS";
    static final String PARTITIONING_QUERY = "SELECT /*OracleDictionaryQueries.ALL_PARTITIONING_QUERY*/\n       VALUE FROM V$OPTION WHERE PARAMETER='Partitioning'";
    static final String OBJECT_PRIV_CHECK = "SELECT /*OracleDictionaryQueries.OBJECT_ALTER_CHECK*/ \n       PRIVILEGE \nFROM SYS.ALL_TAB_PRIVS\nWHERE TABLE_SCHEMA = ?\nAND TABLE_NAME = ?\nAND GRANTEE IN (SELECT USER FROM SYS.DUAL\n                UNION ALL\n                SELECT 'PUBLIC' FROM SYS.DUAL\n                UNION ALL\n                SELECT ROLE FROM SYS.SESSION_ROLES)";
    private static final String EXISTS_QUERY = "SELECT /*OracleDictionaryQueries.ALL_EXISTS_QUERY*/\n       OBJECT_NAME FROM SYS.ALL_OBJECTS WHERE OWNER = ? AND OBJECT_NAME = ? AND OBJECT_TYPE = ?";
    private static final String EXISTS_JAVA_QUERY = "SELECT /*OracleDictionaryQueries.ALL_EXISTS_JAVA_QUERY*/\n       OBJECT_NAME FROM JAVASNM, SYS.ALL_OBJECTS WHERE OWNER = ? AND OBJECT_NAME = SHORT(+) AND NVL(LONGNAME,OBJECT_NAME) = ? AND OBJECT_TYPE = ?";
    private static final String EXISTS_XML_SCHEMA_QUERY = "SELECT /*OracleDictionaryQueries.ALL_EXISTS_XML_SCHEMA_QUERY*/\n       1 FROM SYS.ALL_XML_SCHEMAS WHERE OWNER = ? AND SCHEMA_URL = ? ";
    private static final String EXISTS_DBLINK_QUERY = "SELECT /*OracleDictionaryQueries.ALL_EXISTS_DBLINK_QUERY*/\n       1 \nFROM   SYS.ALL_DB_LINKS \n,      (SELECT SUBSTR(GLOBAL_NAME,INSTR(GLOBAL_NAME,'.')) GNAME_SUFFIX\n       ,       ? NAME \n       FROM    GLOBAL_NAME) GNAME\nWHERE OWNER = ? \nAND   ( DB_LINK = GNAME.NAME OR DB_LINK = GNAME.NAME||GNAME.GNAME_SUFFIX )";
    private static final String EXISTS_TABLESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_EXISTS_TABLESPACE_QUERY*/\n       1 FROM SYS.USER_TABLESPACES\nWHERE TABLESPACE_NAME = ? ";
    private static final String MAIN_OBJECT_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MAIN_OBJECT_NAMESPACE_QUERY*/\n       OBJECT_NAME FROM SYS.ALL_OBJECTS WHERE OWNER = ? AND   OBJECT_NAME LIKE ? AND   OBJECT_TYPE IN ( <types> )";
    private static final String INDIVIDUAL_OBJECT_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_INDIVIDUAL_OBJECT_NAMESPACE_QUERY*/\n       OBJECT_NAME FROM SYS.ALL_OBJECTS WHERE  OWNER = ? AND OBJECT_NAME LIKE ? AND OBJECT_TYPE = '<type>'";
    private static final String CONSTRAINT_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_NAMESPACE_QUERY*/\n       CONSTRAINT_NAME FROM   SYS.ALL_CONSTRAINTS WHERE  OWNER = ? AND    CONSTRAINT_NAME LIKE ?";
    private static final String DATABASE_LINK_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_DATABASE_LINK_NAMESPACE_QUERY*/\n       DB_LINK\nFROM   SYS.ALL_DB_LINKS\n,      (SELECT SUBSTR(GLOBAL_NAME,INSTR(GLOBAL_NAME,'.')) GNAME_SUFFIX\n       ,       ? NAME \n       FROM    GLOBAL_NAME) GNAME\nWHERE OWNER = ? \nAND   ( DB_LINK = GNAME.NAME OR DB_LINK = GNAME.NAME||GNAME.GNAME_SUFFIX )";
    private static final String XML_SCHEMA_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_XML_SCHEMA_NAMESPACE_QUERY*/\n       SCHEMA_URL FROM   SYS.ALL_XML_SCHEMAS WHERE  OWNER = ? AND    SCHEMA_URL LIKE ?";
    private static final String TABLESPACE_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_TABLESPACE_NAMESPACE_QUERY*/\n       TABLESPACE_NAME FROM SYS.USER_TABLESPACES\nWHERE TABLESPACE_NAME LIKE ? ";
    private static final String MVIEW_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_NAMESPACE_QUERY*/\n       OBJECT_NAME, OBJECT_TYPE FROM   SYS.ALL_OBJECTS WHERE  OWNER = ? AND    OBJECT_NAME LIKE ? AND    OBJECT_TYPE NOT IN ( 'TRIGGER', 'INDEX', 'TABLE' )";
    private static final String VALIDATE_MAIN_OBJECT_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_VALIDATE_MAIN_OBJECT_NAMESPACE_QUERY*/\n       OBJECT_NAME, OBJECT_TYPE FROM   SYS.ALL_OBJECTS WHERE  OWNER = ? AND    OBJECT_NAME = ? AND    OBJECT_TYPE IN ( <types> )";
    private static final String VALIDATE_CONSTRAINT_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_VALIDATE_CONSTRAINT_NAMESPACE_QUERY*/\n       T.TABLE_NAME, 'TABLE' FROM   SYS.ALL_CONSTRAINTS C, SYS.ALL_TABLES T WHERE  C.OWNER = T.OWNER AND    C.TABLE_NAME = T.TABLE_NAME AND    C.OWNER = ? AND    C.CONSTRAINT_NAME = ? UNION ALL SELECT V.VIEW_NAME, 'VIEW' FROM   SYS.ALL_CONSTRAINTS C, SYS.ALL_VIEWS V WHERE  C.OWNER = V.OWNER AND    C.TABLE_NAME = V.VIEW_NAME AND    C.OWNER = ? AND    C.CONSTRAINT_NAME = ?";
    private static final String VALIDATE_INDEX_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_VALIDATE_INDEX_NAMESPACE_QUERY*/\n       TABLE_NAME, 'TABLE' FROM SYS.ALL_INDEXES WHERE  OWNER = ? AND INDEX_NAME = ? ";
    private static final String VALIDATE_TABLESPACE_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_VALIDATE_TABLESPACE_NAMESPACE_QUERY*/\n       TABLESPACE_NAME, 'TABLESPACE' FROM SYS.USER_TABLESPACES WHERE TABLESPACE_NAME LIKE ? ";
    private static final String VALIDATE_TRIGGER_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_VALIDATE_TRIGGER_NAMESPACE_QUERY*/\n       TABLE_NAME, 'TABLE' FROM SYS.ALL_TRIGGERS WHERE  OWNER = ? AND TRIGGER_NAME = ? ";
    private static final String VALIDATE_DATABASE_LINK_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_VALIDATE_DATABASE_LINK_NAMESPACE_QUERY*/\n       DB_LINK, 'DATABASE LINK' FROM   SYS.ALL_DB_LINKS WHERE  OWNER = ? AND    DB_LINK = ?";
    private static final String VALIDATE_XML_SCHEMA_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_VALIDATE_XML_SCHEMA_NAMESPACE_QUERY*/\n       SCHEMA_URL, 'XML SCHEMA' FROM   SYS.ALL_XML_SCHEMAS WHERE  OWNER = ? AND    SCHEMA_URL = ?";
    private static final String OBJECT_STATUS_QUERY = "SELECT /*OracleDictionaryQueries.ALL_OBJECT_STATUS_QUERY*/\n       STATUS FROM SYS.ALL_OBJECTS WHERE  OWNER = ? AND OBJECT_NAME = ? AND OBJECT_TYPE = ?";
    private static final String EXISTS_OLITE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_EXISTS_OLITE_QUERY*/\n       <type>_NAME FROM SYS.<table> WHERE  <owner> = ? AND <type>_NAME = ?";
    private static final String OLITE_MAIN_OBJECT_NAMESPACE_QUERY_TEMPLATE = "SELECT /*OracleDictionaryQueries.ALL_OLITE_MAIN_OBJECT_NAMESPACE_QUERY_TEMPLATE*/\n       <type>_NAME FROM SYS.<table> WHERE  <owner> = ? AND <type>_NAME LIKE ? ";
    private static final String OLITE_INDIVIDUAL_OBJECT_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_OLITE_INDIVIDUAL_OBJECT_NAMESPACE_QUERY*/\n       <type>_NAME FROM SYS.<table> WHERE  <owner> = ? AND <type>_NAME LIKE ?";
    private static final String OLITE_VALIDATE_MAIN_OBJECT_NAMESPACE_QUERY_TEMPLATE = "SELECT /*OracleDictionaryQueries.ALL_OLITE_VALIDATE_MAIN_OBJECT_NAMESPACE_QUERY_TEMPLATE*/\n       <type>_NAME, '<type>' FROM SYS.<table> WHERE  <owner> = ? AND <type>_NAME = ? ";
    private static final String OLITE_VALIDATE_INDEX_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_OLITE_VALIDATE_INDEX_NAMESPACE_QUERY*/\n       TABLE_NAME, 'TABLE' FROM SYS.ALL_INDEXES WHERE  OWNER = ? AND INDEX_NAME = ?";
    private static final String OLITE_VALIDATE_TRIGGER_NAMESPACE_QUERY = "SELECT /*OracleDictionaryQueries.ALL_OLITE_VALIDATE_TRIGGER_NAMESPACE_QUERY*/\n       TABLE_NAME, 'TABLE' FROM SYS.ALL_TRIGGERS WHERE  OWNER = ? AND TRIGGER_NAME = ? ";
    private static final String OLITE_OBJECT_STATUS_QUERY = "SELECT /*OracleDictionaryQueries.ALL_OLITE_OBJECT_STATUS_QUERY*/\n       STATUS FROM SYS.<table> WHERE <owner> = ? AND <type>_NAME = ?";
    private static final String IS_ALIVE_STATEMENT = "/** TESTING CONNECTION IS ALIVE */ SELECT 1 FROM SYS.DUAL";
    private final int m_version;
    private final BaseOracleDatabase m_db;
    private final boolean m_isOlite;
    private boolean m_disableDBAViews = false;

    protected OracleDictionaryQueries(BaseOracleDatabase db) {
        this.m_db = db;
        this.m_version = db.getDatabaseVersion();
        this.m_isOlite = db instanceof OracleDatabaseLite;
    }

    protected void disableDBAViews() {
        this.m_disableDBAViews = true;
    }

    protected boolean isXE() {
        return this.m_version == 101 || this.m_version == 111;
    }

    private void checkOLiteType(String type) {
        if (this.m_isOlite && !OracleLite.isOLiteType(type)) {
            throw new IllegalArgumentException("Invalid OLITE type " + type);
        }
    }

    public String getQuery(String query) {
        Pattern p;
        Matcher matcher;
        if (!this.m_disableDBAViews && this.m_db instanceof OracleDatabaseImpl && (matcher = (p = Pattern.compile("SYS\\.ALL_", 2)).matcher(query)).find()) {
            boolean canSeeDBA;
            boolean bl = canSeeDBA = ((OracleDatabaseImpl)this.m_db).hasRole("SELECT_CATALOG_ROLE") || ((OracleDatabaseImpl)this.m_db).hasRole("DBA");
            if (canSeeDBA) {
                return matcher.replaceAll("SYS.DBA_");
            }
        }
        return query;
    }

    public String getAliveTestStatement() {
        return IS_ALIVE_STATEMENT;
    }

    public String getStandardListQuery(String[] types) {
        String query = this.m_version >= 100 ? ORACLE_OBJECT_QUERY.replaceAll("--10g", "") : ORACLE_OBJECT_QUERY;
        return this.addTypeBinds(query, types.length);
    }

    private String addTypeBinds(String query, int numbinds) {
        StringBuffer binds = new StringBuffer();
        for (int i = 0; i < numbinds; ++i) {
            binds.append("?");
            if (i + 1 >= numbinds) continue;
            binds.append(", ");
        }
        return query.replace("<types>", binds.toString()).replace("/*OracleDictionaryQueries.ALL_ORACLE_OBJECT_QUERY*/", "/*OracleDictionaryQueries.ALL_ORACLE_OBJECT_QUERY(" + Integer.toString(numbinds) + ")*/");
    }

    public DictionaryQueries.Params[] getStandardListQueryParams() {
        return new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF, DictionaryQueries.Params.ALL_TYPES};
    }

    public String getSingleObjectQuery(String type, boolean defaultSchema, DBObjectCriteria criteria) {
        Object retval = this.m_isOlite || "TABLESPACE".equals(type) || "SCHEMA".equals(type) || "RECYCLEBIN".equals(type) || "DATABASE LINK".equals(type) || "XML SCHEMA".equals(type) || "MATERIALIZED VIEW LOG".equals(type) || "JAVA RESOURCE".equals(type) || "JAVA CLASS".equals(type) || "JAVA SOURCE".equals(type) ? null : ("MATERIALIZED VIEW".equals(type) && (!defaultSchema || this.m_version < 91) ? null : ORACLE_SINGLE_OBJECT_QUERY);
        return retval;
    }

    public DictionaryQueries.Params[] getSingleObjectQueryParams(String type, boolean defaultSchema, DBObjectCriteria criteria) {
        return new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF, DictionaryQueries.Params.ALL_TYPES};
    }

    public boolean isCustomListQuery(String type, boolean defaultSchema, DBObjectCriteria criteria) {
        boolean retval;
        boolean bl = retval = this.getSingleObjectQuery(type, defaultSchema, criteria) == null;
        if (!retval) {
            if ("SYNONYM".equals(type)) {
                retval = "PUBLIC".equals(criteria.getSchemaName()) && !ModelUtil.hasLength((String)criteria.getNameLike()) && !defaultSchema && !this.isXE();
            } else if ("SEQUENCE".equals(type)) {
                retval = this.m_version >= 120;
            } else if ("DIRECTORY".equals(type)) {
                retval = criteria.isUserOnly();
            } else if ("TABLE".equals(type) || "TYPE".equals(type)) {
                retval = true;
            }
        }
        return retval;
    }

    public String getCustomListQuery(String type, boolean defaultSchema, DBObjectCriteria criteria) throws IllegalStateException {
        String query;
        if (this.m_isOlite) {
            if (type.equals("SCHEMA")) {
                if (criteria.isUserOnly()) {
                    return this.convertQuery(VISIBLE_USERS_QUERY, type);
                }
                return this.convertQuery(USERS_QUERY, type);
            }
            if (OracleLite.isOLiteType(type)) {
                return this.convertQuery(OLITE_OBJECT_QUERY, type);
            }
            throw new IllegalStateException("OLite custom query requested for unsupported type : " + type);
        }
        if (type.equals("TABLE")) {
            query = TABLE_ORACLE_QUERY;
            if (this.m_version >= 100) {
                query = query.replaceAll("--10g ", "");
            }
        } else if ("PUBLIC".equals(criteria.getSchemaName()) && "SYNONYM".equals(type) && !defaultSchema && !this.isXE()) {
            query = ORACLE_NON_XE_PUBLIC_SYNONYM_QUERY;
        } else if ("MATERIALIZED VIEW LOG".equals(type)) {
            query = this.m_version <= 82 ? MVIEW_LOG_817_QUERY : MVIEW_LOG_QUERY;
        } else if ("MATERIALIZED VIEW".equals(type)) {
            query = !defaultSchema ? MVIEW_OTHER_USER_QUERY : MVIEW_ORACLE8i_QUERY;
        } else if ("JAVA SOURCE".equals(type) || "JAVA CLASS".equals(type) || "JAVA RESOURCE".equals(type)) {
            query = JAVA_QUERY;
        } else if ("DATABASE LINK".equals(type)) {
            query = DATABASE_LINK_QUERY;
        } else if ("RECYCLEBIN".equals(type)) {
            if (((OracleDatabaseImpl)this.m_db).hasPrivilege("SYSDBA")) {
                query = DBA_RECYCLEBIN_QUERY;
            } else {
                query = RECYCLEBIN_QUERY;
                query = query.replace("<SCHEMA>", this.m_db.getUserName());
            }
        } else if ("XML SCHEMA".equals(type)) {
            query = XML_SCHEMA_QUERY;
        } else if ("SCHEMA".equals(type)) {
            query = criteria.isUserOnly() && criteria.getDatabaseName() != null ? VISIBLE_DBLINK_USERS_QUERY : (criteria.isUserOnly() && !((OracleDatabaseImpl)this.m_db).hasRole("DBA") && !((OracleDatabaseImpl)this.m_db).hasPrivilege("SELECT ANY TABLE") ? VISIBLE_USERS_QUERY : USERS_QUERY);
        } else if ("DIRECTORY".equals(type)) {
            query = VISIBLE_DIRECTORIES_QUERY;
        } else if ("TABLESPACE".equals(type)) {
            query = TABLESPACE_QUERY;
        } else if ("TYPE".equals(type)) {
            query = TYPE_QUERY;
        } else if ("SEQUENCE".equals(type)) {
            query = SEQUENCE_QUERY;
        } else {
            throw new IllegalStateException("Custom query requested for unsupported type : " + type);
        }
        return query;
    }

    public DictionaryQueries.Params[] getCustomListQueryParams(String type, boolean defaultSchema, DBObjectCriteria criteria) {
        if ("JAVA SOURCE".equals(type) || "JAVA CLASS".equals(type) || "JAVA RESOURCE".equals(type)) {
            return new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF, DictionaryQueries.Params.ALL_TYPES};
        }
        if ("PUBLIC".equals(criteria.getSchemaName()) && "SYNONYM".equals(type) && !defaultSchema && !this.isXE() && !this.m_isOlite) {
            return EMPTY_PARAMS;
        }
        if ("DATABASE LINK".equals(type)) {
            return new DictionaryQueries.Params[]{DictionaryQueries.Params.NAMEREF, DictionaryQueries.Params.SCHEMA};
        }
        if ("TABLE".equals(type) && !this.m_isOlite) {
            return new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF, DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF, DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF, DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF, DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF};
        }
        if ("SCHEMA".equals(type) || "TABLESPACE".equals(type)) {
            return new DictionaryQueries.Params[]{DictionaryQueries.Params.NAMEREF};
        }
        return new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF};
    }

    public boolean canUnionListQueries() {
        return true;
    }

    public boolean useMessageFormat() {
        return false;
    }

    public String getTimestampQueryByName(String type) {
        String retval = "TABLE".equals(type) || "VIEW".equals(type) || "PACKAGE".equals(type) || "FUNCTION".equals(type) || "PROCEDURE".equals(type) || "TYPE".equals(type) || "TRIGGER".equals(type) || "JAVA SOURCE".equals(type) || "PACKAGE BODY".equals(type) || "TYPE BODY".equals(type) || "INDEX".equals(type) ? TIMESTAMP_BY_NAME_QUERY : ("MATERIALIZED VIEW".equals(type) ? TIMESTAMP_BY_NAME_MVIEW_QUERY : ("MATERIALIZED VIEW LOG".equals(type) ? TIMESTAMP_BY_NAME_QUERY_MATERIALIZED_VIEW_LOG : null));
        return retval;
    }

    public String getTimestampQueryByID(String type) {
        String retval = this.m_isOlite || this.isExtensionType(type) ? null : ("MATERIALIZED VIEW".equals(type) ? TIMESTAMP_BY_ID_MVIEW_QUERY : (this.m_version < 100 ? TIMESTAMP_BY_ID_QUERY : TIMESTAMP_BY_ID_10g_QUERY));
        return retval;
    }

    public String getUserNameQuery() {
        return null;
    }

    @Deprecated
    public String getSchemasQuery() {
        return USERS_QUERY;
    }

    public String getExistsQuery(String type) {
        Object retval;
        if (this.m_isOlite) {
            this.checkOLiteType(type);
            retval = this.convertQuery(EXISTS_OLITE_QUERY, type);
        } else {
            retval = type.equals("JAVA SOURCE") || type.equals("JAVA CLASS") || type.equals("JAVA RESOURCE") ? EXISTS_JAVA_QUERY : (type.equals("XML SCHEMA") ? EXISTS_XML_SCHEMA_QUERY : (type.equals("DATABASE LINK") ? EXISTS_DBLINK_QUERY : (type.equals("SCHEMA") || this.isExtensionType(type) ? null : (type.equals("TABLESPACE") ? EXISTS_TABLESPACE_QUERY : EXISTS_QUERY))));
        }
        return retval;
    }

    public DictionaryQueries.Params[] getExistsQueryParams(String type) {
        DictionaryQueries.Params[] retval = this.m_isOlite || type.equals("XML SCHEMA") ? new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF} : (type.equals("DATABASE LINK") ? new DictionaryQueries.Params[]{DictionaryQueries.Params.NAMEREF, DictionaryQueries.Params.SCHEMA} : (type.equals("TABLESPACE") ? new DictionaryQueries.Params[]{DictionaryQueries.Params.NAMEREF} : new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF, DictionaryQueries.Params.ALL_TYPES}));
        return retval;
    }

    public String getNamespaceQuery(String type) {
        String retval;
        if ("INDEX".equals(type) || "TRIGGER".equals(type)) {
            String query = this.m_isOlite ? OLITE_INDIVIDUAL_OBJECT_NAMESPACE_QUERY : INDIVIDUAL_OBJECT_NAMESPACE_QUERY;
            retval = this.convertQuery(query, type);
        } else if ("CONSTRAINT".equals(type)) {
            retval = CONSTRAINT_NAMESPACE_QUERY;
        } else if ("XML SCHEMA".equals(type)) {
            retval = XML_SCHEMA_NAMESPACE_QUERY;
        } else if ("DATABASE LINK".equals(type)) {
            retval = DATABASE_LINK_NAMESPACE_QUERY;
        } else if ("TABLESPACE".equals(type)) {
            retval = TABLESPACE_NAMESPACE_QUERY;
        } else if ("MATERIALIZED VIEW".equals(type)) {
            retval = MVIEW_NAMESPACE_QUERY;
        } else if (this.m_isOlite) {
            this.checkOLiteType(type);
            retval = this.buildOLiteQuery(OLITE_MAIN_OBJECT_NAMESPACE_QUERY_TEMPLATE, OracleLite.OLITE_SCHEMA_OBJECT_TYPES);
        } else {
            retval = this.replaceSchemaNamespaceTypes(MAIN_OBJECT_NAMESPACE_QUERY);
        }
        return retval;
    }

    public DictionaryQueries.Params[] getNamespaceQueryParams(String type) {
        DictionaryQueries.Params[] retval;
        if ("INDEX".equals(type) || "TRIGGER".equals(type) || "MATERIALIZED VIEW".equals(type) || "CONSTRAINT".equals(type) || "XML SCHEMA".equals(type)) {
            retval = new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF};
        } else if ("DATABASE LINK".equals(type)) {
            retval = new DictionaryQueries.Params[]{DictionaryQueries.Params.NAMEREF, DictionaryQueries.Params.SCHEMA};
        } else if ("TABLESPACE".equals(type)) {
            retval = new DictionaryQueries.Params[]{DictionaryQueries.Params.NAMEREF};
        } else if (this.m_isOlite) {
            this.checkOLiteType(type);
            retval = this.getOLiteMainNamespaceParams();
        } else {
            retval = new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF};
        }
        return retval;
    }

    public String getValidateNamespaceQuery(String type) {
        String retval;
        if ("INDEX".equals(type)) {
            retval = this.m_isOlite ? this.convertQuery(OLITE_VALIDATE_INDEX_NAMESPACE_QUERY, type) : VALIDATE_INDEX_NAMESPACE_QUERY;
        } else if ("TRIGGER".equals(type)) {
            retval = this.m_isOlite ? this.convertQuery(OLITE_VALIDATE_TRIGGER_NAMESPACE_QUERY, type) : VALIDATE_TRIGGER_NAMESPACE_QUERY;
        } else if ("CONSTRAINT".equals(type)) {
            retval = VALIDATE_CONSTRAINT_NAMESPACE_QUERY;
        } else if ("DATABASE LINK".equals(type)) {
            retval = VALIDATE_DATABASE_LINK_NAMESPACE_QUERY;
        } else if ("XML SCHEMA".equals(type)) {
            retval = VALIDATE_XML_SCHEMA_NAMESPACE_QUERY;
        } else if ("TABLESPACE".equals(type)) {
            retval = VALIDATE_TABLESPACE_NAMESPACE_QUERY;
        } else if ("MATERIALIZED VIEW".equals(type)) {
            retval = MVIEW_NAMESPACE_QUERY;
        } else if (this.m_isOlite) {
            this.checkOLiteType(type);
            retval = this.buildOLiteQuery(OLITE_VALIDATE_MAIN_OBJECT_NAMESPACE_QUERY_TEMPLATE, OracleLite.OLITE_SCHEMA_OBJECT_TYPES);
        } else {
            retval = this.replaceSchemaNamespaceTypes(VALIDATE_MAIN_OBJECT_NAMESPACE_QUERY);
        }
        return retval;
    }

    public DictionaryQueries.Params[] getValidateNamespaceQueryParams(String type) {
        DictionaryQueries.Params[] retval;
        if ("CONSTRAINT".equals(type)) {
            retval = new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF, DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF};
        } else if ("INDEX".equals(type) || "TRIGGER".equals(type) || "MATERIALIZED VIEW".equals(type) || "XML SCHEMA".equals(type) || "DATABASE LINK".equals(type)) {
            retval = new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF};
        } else if ("TABLESPACE".equals(type)) {
            retval = new DictionaryQueries.Params[]{DictionaryQueries.Params.NAMEREF};
        } else if (this.m_isOlite) {
            this.checkOLiteType(type);
            retval = this.getOLiteMainNamespaceParams();
        } else {
            retval = new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF};
        }
        return retval;
    }

    public String getObjectStatusQuery(String objectType) {
        if ("DATABASE LINK".equals(objectType) || "XML SCHEMA".equals(objectType) || "TABLESPACE".equals(objectType) || !Metadata.getInstance().isSchemaObject(objectType) || this.isExtensionType(objectType)) {
            return null;
        }
        return this.m_isOlite ? OLITE_OBJECT_STATUS_QUERY : OBJECT_STATUS_QUERY;
    }

    public DictionaryQueries.Params[] getObjectStatusQueryParams(String type) {
        DictionaryQueries.Params[] paramsArray;
        if (this.m_isOlite) {
            DictionaryQueries.Params[] paramsArray2 = new DictionaryQueries.Params[2];
            paramsArray2[0] = DictionaryQueries.Params.SCHEMA;
            paramsArray = paramsArray2;
            paramsArray2[1] = DictionaryQueries.Params.NAMEREF;
        } else {
            DictionaryQueries.Params[] paramsArray3 = new DictionaryQueries.Params[3];
            paramsArray3[0] = DictionaryQueries.Params.SCHEMA;
            paramsArray3[1] = DictionaryQueries.Params.NAMEREF;
            paramsArray = paramsArray3;
            paramsArray3[2] = DictionaryQueries.Params.ALL_TYPES;
        }
        return paramsArray;
    }

    public String getObjectQueryByID(String type) {
        if ("JAVA SOURCE".equals(type) || "JAVA CLASS".equals(type) || "JAVA RESOURCE".equals(type)) {
            return JAVA_BY_ID_QUERY;
        }
        if ("XML SCHEMA".equals(type)) {
            return XML_SCHEMA_BY_ID_QUERY;
        }
        if (this.isExtensionType(type)) {
            return null;
        }
        if (this.m_version < 100) {
            return ORACLE_ID_QUERY;
        }
        return ORACLE_ID_10g_QUERY;
    }

    public DictionaryQueries.Params[] getObjectQueryByIDParams(String type) {
        DictionaryQueries.Params[] retval = "JAVA SOURCE".equals(type) || "JAVA CLASS".equals(type) || "JAVA RESOURCE".equals(type) || "XML SCHEMA".equals(type) ? super.getObjectQueryByIDParams(type) : new DictionaryQueries.Params[]{DictionaryQueries.Params.IDENTIFIER, DictionaryQueries.Params.ALL_TYPES};
        return retval;
    }

    private DictionaryQueries.Params[] getOLiteMainNamespaceParams() {
        DictionaryQueries.Params[] params = new DictionaryQueries.Params[OracleLite.OLITE_SCHEMA_OBJECT_TYPES.length * 2];
        int i = 0;
        while (i < OracleLite.OLITE_SCHEMA_OBJECT_TYPES.length * 2) {
            params[i++] = DictionaryQueries.Params.SCHEMA;
            params[i++] = DictionaryQueries.Params.NAMEREF;
        }
        return params;
    }

    private String buildOLiteQuery(String queryTemplate, String[] types) {
        String query = "";
        for (int i = 0; i < types.length; ++i) {
            if (!OracleLite.isOLiteType(types[i])) continue;
            query = query + (query.length() > 0 ? " UNION ALL " : "") + this.convertQuery(queryTemplate, types[i]);
        }
        return query;
    }

    private String convertQuery(String query, String type) {
        return query.replaceAll("<type>", type).replaceAll("<table>", "ALL_" + type + (type.equals("INDEX") ? "ES" : "S")).replaceAll("<owner>", type.equals("SEQUENCE") ? "SEQUENCE_OWNER" : "OWNER");
    }

    private boolean isExtensionType(String objectType) {
        return DBObjectRegistry.isExtensionType((String)objectType, (String)"Oracle Database", (int)this.m_version);
    }

    private String replaceSchemaNamespaceTypes(String query) {
        Collection types = this.m_db.getDescriptor().listSchemaNamespaceTypes((DBObjectProvider)this.m_db);
        String typesString = OracleDictionaryQueries.convertArrayToQuotedList((String[])types.toArray(new String[types.size()]));
        return query.replace("<types>", typesString);
    }
}

