/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractIncrementer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OracleIncrementerBuilder<T extends AbstractIncrementer>
extends OracleDBObjectBuilder<T> {
    OracleIncrementerBuilder(BaseOracleDatabase db, String type) {
        super(db, type);
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"minValue", "maxValue", "incrementBy", "cacheFlag", "cacheSize", "cycleFlag", "orderFlag", "lastNumber"})
    public void fillInIncrementProperties(final AbstractIncrementer incrementer) throws DBException {
        DBObject parent = DBUtil.getUppermostParent((DBObject)incrementer);
        if (parent instanceof SchemaObject) {
            final SchemaObject so = (SchemaObject)parent;
            final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)so, this.getSequenceQuery(), so.getSchema(), incrementer.getName());
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            BigDecimal min = rs.getBigDecimal(1);
                            BigDecimal max = rs.getBigDecimal(2);
                            BigDecimal inc = rs.getBigDecimal(3);
                            String cycle = rs.getString(4);
                            String order = rs.getString(5);
                            BigDecimal cache = rs.getBigDecimal(6);
                            BigDecimal last = rs.getBigDecimal(7);
                            BigInteger biMin = min == null ? null : min.toBigInteger();
                            BigInteger biMax = max == null ? null : max.toBigInteger();
                            BigInteger biInc = inc == null ? null : inc.toBigInteger();
                            BigInteger biLast = last == null ? null : last.toBigInteger();
                            BigInteger biCache = null;
                            if (cache == null || cache.intValue() == 0) {
                                incrementer.setCacheFlag(Boolean.valueOf(false));
                            } else {
                                incrementer.setCacheFlag(Boolean.valueOf(true));
                                biCache = cache.toBigInteger();
                            }
                            incrementer.setMinValue(biMin);
                            incrementer.setMaxValue(biMax);
                            incrementer.setIncrementBy(biInc);
                            incrementer.setCycleFlag(Boolean.valueOf("Y".equalsIgnoreCase(cycle)));
                            incrementer.setOrderFlag(Boolean.valueOf("Y".equalsIgnoreCase(order)));
                            incrementer.setCacheSize(biCache);
                            incrementer.setLastNumber(biLast);
                        }
                    }
                    catch (SQLException ex) {
                        wrap.throwDBException((DBObject)so, ex);
                    }
                }
            };
            wrap.executeQuery(r);
        }
    }

    private String getSequenceQuery() {
        return "Oracle Lite".equals(this.getDatabase().getDatabaseType()) ? "SELECT /*OracleDictionaryQueries.ALL_OLITE_SEQUENCE_QUERY*/\n       MIN_VALUE, MAX_VALUE, INCREMENT_BY, NULL, NULL, NULL, NULL FROM SYS.ALL_SEQUENCES S WHERE SEQUENCE_OWNER = ? AND SEQUENCE_NAME = ?" : "SELECT /*OracleDictionaryQueries.ALL_ORACLE_SEQUENCE_QUERY*/\n       MIN_VALUE, MAX_VALUE, INCREMENT_BY, CYCLE_FLAG, ORDER_FLAG, CACHE_SIZE, LAST_NUMBER FROM SYS.ALL_SEQUENCES S WHERE SEQUENCE_OWNER = ? AND SEQUENCE_NAME = ? ";
    }
}

