/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.Schema;
import oracle.javatools.db.compilation.CompilationResults;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.lite.OracleDatabaseLite;
import oracle.javatools.db.plsql.PlSqlIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleLite
extends BaseOracleDatabase
implements OracleDatabaseLite {
    public static final String[] OLITE_SCHEMA_OBJECT_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "SYNONYM"};
    public static final String[] OLITE_OBJECT_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "SYNONYM", "INDEX", "CONSTRAINT", "SCHEMA"};

    OracleLite(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    public boolean supportsJava() {
        return false;
    }

    public boolean supportsPartitioning() {
        return false;
    }

    @Override
    protected Schema createSchema(Connection conn) {
        try {
            return this.createSchema(conn.getMetaData().getUserName());
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    protected boolean isSupportedType(String type) {
        return OracleLite.isOLiteType(type);
    }

    static boolean isOLiteType(String type) {
        for (int i = 0; i < OLITE_OBJECT_TYPES.length; ++i) {
            if (!OLITE_OBJECT_TYPES[i].equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSystemPrivilege(String type, Schema schema, String priv) {
        return schema.getName().equalsIgnoreCase("SYSTEM") || schema.getName().equals(this.getUserName());
    }

    public List<CompilationResults> submitDatabaseSources(String schemaName, List<String> sources) {
        throw new UnsupportedOperationException();
    }

    public CompilationResults submitDatabaseSource(String schemaName, String source) {
        throw new UnsupportedOperationException();
    }

    public List<CompilationResults> getCompilationResults(List<PlSqlIdentifier> plsqlIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void initSessionParameterQueryMap(Map<String, String> map) {
    }
}

