/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.IdentityColumnProperties;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleIncrementerBuilder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OracleRelationBuilder<T extends Relation>
extends OracleDBObjectBuilder<T> {
    private static final String ORACLE8i_NOT_NULL_COND = "\"{0}\" IS NOT NULL";
    private static final String ORACLE7_NOT_NULL_COND = "{0} IS NOT NULL";
    private static final char PK_TYPE = 'P';
    private static final char FK_TYPE = 'R';
    private static final char UNIQUE_TYPE = 'U';
    private static final char CHECK_TYPE = 'C';

    protected OracleRelationBuilder(BaseOracleDatabase db, String type) {
        super(db, type);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"Comment"})
    public void fillInComment(T rel) throws DBException {
        QueryWrapper wrap = rel instanceof MaterializedView && this.getProvider() instanceof Oracle10g ? this.getDatabase().newQueryWrapper((SystemObject)rel, "SELECT /*OracleDictionaryQueries.ALL_MVIEW_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_MVIEW_COMMENTS WHERE OWNER = ? AND MVIEW_NAME = ?", rel.getSchema(), rel) : (rel instanceof MaterializedView ? this.getDatabase().newQueryWrapper((SystemObject)rel, "SELECT /*OracleDictionaryQueries.ALL_TABLE_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_TAB_COMMENTS WHERE OWNER = ? AND TABLE_NAME = ? AND TABLE_TYPE = ?", rel.getSchema(), rel, "TABLE") : this.getDatabase().newQueryWrapper((SystemObject)rel, "SELECT /*OracleDictionaryQueries.ALL_TABLE_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_TAB_COMMENTS WHERE OWNER = ? AND TABLE_NAME = ? AND TABLE_TYPE = ?", rel.getSchema(), rel, this.getObjectType()));
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Relation)rel, wrap){
            final /* synthetic */ Relation val$rel;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$rel = relation;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        String com = rs.getString(1);
                        com = ModelUtil.hasLength((String)com) ? com : null;
                        this.val$rel.setProperty("Comment", (Object)com);
                    }
                }
                catch (SQLException ex) {
                    this.val$wrap.throwDBException((DBObject)this.val$rel, ex);
                }
            }
        };
        wrap.executeQuery(r);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"columns"})
    public void fillInColumns(T relation) throws DBException {
        BaseOracleDatabase db = this.getDatabase();
        String query = OracleRelationBuilder.getColumnQuery(db);
        relation.setColumns(new Column[0]);
        HashMap<Column, String> complexCols = new HashMap<Column, String>();
        QueryWrapper wrap = db.newQueryWrapper((SystemObject)relation, query, relation.getSchema(), relation);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Relation)relation, db, complexCols, wrap){
            final /* synthetic */ Relation val$relation;
            final /* synthetic */ BaseOracleDatabase val$db;
            final /* synthetic */ Map val$complexCols;
            final /* synthetic */ QueryWrapper val$wrap;
            {
                this.val$relation = relation;
                this.val$db = baseOracleDatabase;
                this.val$complexCols = map;
                this.val$wrap = queryWrapper;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String colName = rs.getString(1);
                        Column col = (Column)OracleRelationBuilder.this.newObject(Column.class, colName);
                        this.val$relation.addColumn(col);
                        String typeName = rs.getString(2);
                        String typeOwner = rs.getString(3);
                        if (!rs.wasNull()) {
                            typeName = typeOwner + "." + typeName;
                        }
                        col.setNotNull(rs.getString(7).equals("N"));
                        String defValue = rs.getString(10);
                        if (null != defValue) {
                            defValue = defValue.trim();
                            String virtual = rs.getString(14);
                            String identity = rs.getString(15);
                            String defaultOnNull = rs.getString(16);
                            if ("YES".equals(identity)) {
                                String[] bits = defValue.split("\\.");
                                if (bits.length == 3) {
                                    String seqName = this.val$db.getInternalName(bits[1]);
                                    IdentityColumnProperties props = new IdentityColumnProperties();
                                    props.setName(seqName);
                                    this.val$db.setOracleBuilder(props, new IdentityColumnPropertiesBuilder(this.val$db));
                                    if ("YES".equals(defaultOnNull)) {
                                        props.setGenerated(IdentityColumnProperties.GeneratedType.BY_DEFAULT_ON_NULL);
                                    }
                                    col.setIdentityProperties(props);
                                }
                            } else if ("YES".equals(virtual)) {
                                col.setVirtualExpressionSource(defValue);
                            } else {
                                col.setDefault((Object)defValue);
                            }
                        }
                        String cmt = rs.getString(11);
                        col.setProperty("Comment", (Object)cmt);
                        col.setID((DBObjectID)new NameBasedID((DBObject)col, this.val$relation.getID()));
                        String ref = rs.getString(13);
                        if (!rs.wasNull()) {
                            typeName = ref + " " + typeName;
                        }
                        if (typeName != null && typeName.indexOf(46) >= 0) {
                            this.val$complexCols.put(col, typeName);
                            continue;
                        }
                        DataType dataType = this.val$db.getDataType(typeName);
                        if (dataType == null) {
                            col.setDataTypeUsage(DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)this.val$db, (Schema)this.val$relation.getSchema(), (String)typeName));
                            continue;
                        }
                        long length = rs.getLong(5);
                        Long precision = rs.wasNull() ? null : new Long(length);
                        length = OracleRelationBuilder.this.isCharType(typeName) ? rs.getLong(9) : rs.getLong(4);
                        Long size = rs.wasNull() ? null : new Long(length);
                        Long scale = new Long(rs.getLong(6));
                        scale = rs.wasNull() ? null : scale;
                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                        attributes.put("name", typeName);
                        attributes.put("size", DataTypeHelper.getAttributeValue((Object)size, (DataType)dataType, (String)"size"));
                        attributes.put("precision", DataTypeHelper.getAttributeValue((Object)precision, (DataType)dataType, (String)"precision"));
                        attributes.put("scale", DataTypeHelper.getAttributeValue((Object)scale, (DataType)dataType, (String)"scale"));
                        attributes.put("unit", rs.getString(12));
                        col.setDataTypeUsage(dataType.createUsage(attributes));
                        OracleRelationBuilder.this.setupOracleColumnProperties(this.val$relation, col, dataType);
                    }
                }
                catch (SQLException ex) {
                    this.val$wrap.throwDBException((DBObject)this.val$relation, ex);
                }
            }
        };
        wrap.executeQuery(100, r);
        if (complexCols.size() > 0) {
            this.populateComplexColumnTypes(relation, complexCols);
        }
    }

    private void populateComplexColumnTypes(T relation, Map<Column, String> complexCols) throws DBException {
        BaseOracleDatabase db = this.getDatabase();
        for (Map.Entry<Column, String> entry : complexCols.entrySet()) {
            Column col = entry.getKey();
            String typeString = entry.getValue();
            boolean ref = false;
            if (typeString.startsWith("REF ")) {
                ref = true;
                typeString = typeString.substring("REF ".length());
            }
            StringBuilder buff = new StringBuilder();
            for (String bit : typeString.split("\\.")) {
                if (buff.length() > 0) {
                    buff.append(".");
                }
                buff.append(db.getExternalName(bit));
            }
            DBObjectID dataTypeID = DataTypeHelper.createReferenceIDForTypeString((DBObjectProvider)db, (Schema)relation.getSchema(), (String)buff.toString());
            DataTypeUsage dtu = new DataTypeUsage();
            dtu.setDataTypeID(dataTypeID);
            if (ref) {
                final HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
                attributes.put("ref", Boolean.TRUE);
                final QueryWrapper scopeWrap = this.getDatabase().newQueryWrapper((SystemObject)relation, "SELECT /*OracleDictionaryQueries.ALL_REF_COLUMN_SCOPE*/\n       SCOPE_TABLE_OWNER\n,      SCOPE_TABLE_NAME\nFROM   SYS.ALL_REFS\nWHERE  OWNER = ?\nAND    TABLE_NAME = ?\nAND    COLUMN_NAME = ?\nAND    SCOPE_TABLE_NAME IS NOT NULL\n", relation.getSchema(), relation, col);
                QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet scopeRS) throws DBException {
                        try {
                            if (scopeRS.next()) {
                                NameBasedID id = new NameBasedID("TABLE", scopeRS.getString(1), scopeRS.getString(2));
                                attributes.put("ref_scope", id);
                            }
                        }
                        catch (SQLException e) {
                            scopeWrap.throwDBException(e);
                        }
                    }
                };
                scopeWrap.executeQuery(r);
                dtu.setAttributeValues(attributes);
            }
            col.setDataTypeUsage(dtu);
            this.setupOracleColumnProperties(relation, col, null);
        }
    }

    protected void setupOracleColumnProperties(T relation, Column col, DataType type) {
    }

    private boolean isCharType(String typeName) {
        return typeName.equals("CHAR") || typeName.equals("NCHAR") || typeName.equals("VARCHAR2") || typeName.equals("NVARCHAR2");
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"constraints"}, depends={"columns"})
    public void fillInConstraints(T relation) throws DBException {
        boolean listagg;
        String query;
        BaseOracleDatabase db = this.getDatabase();
        Schema relationSchema = relation.getSchema();
        if ("Oracle Lite".equals(db.getDatabaseType())) {
            query = "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_OLITE_QUERY*/\n        A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER, \n        A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, 'GENERATED NAME' GENERATED, \n        NULL INDEX_OWNER, NULL INDEX_NAME, NULL INDEX_OBJECT_ID, \n        ( SELECT 'TABLE#' || AA.TABLE_NAME \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_TABLES      BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.TABLE_NAME \n         UNION\n          SELECT 'VIEW#' || AA.TABLE_NAME \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_VIEWS       BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.VIEW_NAME           ) ref_relation_info,\n        B.COLUMN_NAME, null DEFERRABLE, null DEFERRED \nFROM SYS.ALL_CONSTRAINTS  A,  \n     SYS.ALL_CONS_COLUMNS B  \nWHERE A.OWNER           = ?  \nAND   A.TABLE_NAME      = ?  \nAND   A.OWNER           = B.OWNER  \nAND   A.CONSTRAINT_NAME = B.CONSTRAINT_NAME  \nORDER BY B.POSITION \n";
            listagg = false;
        } else {
            String userQuery;
            if (112 > db.getDatabaseVersion()) {
                userQuery = "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_ENTERPRISE_QUERY*/\n  A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER,  \n  A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, A.GENERATED, \n  NVL( A.INDEX_OWNER, A.OWNER ) INDEX_OWNER, A.INDEX_NAME, \n  DECODE( A.INDEX_NAME, NULL, NULL, \n    ( SELECT OBJECT_ID FROM SYS.ALL_OBJECTS AO \n      WHERE AO.OBJECT_TYPE = 'INDEX' \n        AND AO.OBJECT_NAME = A.INDEX_NAME \n        AND AO.OWNER = NVL( A.INDEX_OWNER, A.OWNER ) ) ) INDEX_OBJECT_ID, \n  DECODE( A.R_CONSTRAINT_NAME, NULL, NULL, \n    ( SELECT ( SELECT BB.OBJECT_TYPE || BB.OBJECT_ID \n               FROM SYS.ALL_OBJECTS BB \n               WHERE AA.OWNER = BB.OWNER \n               AND   AA.TABLE_NAME = BB.OBJECT_NAME \n               AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW') ) \n        || '#' || AA.TABLE_NAME \n      FROM SYS.ALL_CONSTRAINTS AA \n      WHERE AA.OWNER = A.R_OWNER \n        AND AA.CONSTRAINT_TYPE IN ( 'P', 'U' ) \n        AND AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME ) ) ref_relation_info, \n  B.COLUMN_NAME, A.DEFERRABLE, A.DEFERRED \nFROM SYS.USER_CONSTRAINTS A, SYS.USER_CONS_COLUMNS B \nWHERE A.OWNER = ? \nAND A.TABLE_NAME = ? \nAND A.CONSTRAINT_TYPE IN ( 'P', 'U', 'R', 'C' ) \nAND A.CONSTRAINT_NAME = B.CONSTRAINT_NAME(+) \nAND A.OWNER = B.OWNER(+) \nORDER BY B.POSITION";
                listagg = false;
            } else {
                userQuery = "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_ENTERPRISE_QUERY*/\n  A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER,  \n  A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, A.GENERATED, \n  NVL( A.INDEX_OWNER, A.OWNER ) INDEX_OWNER, A.INDEX_NAME, \n  DECODE( A.INDEX_NAME, NULL, NULL, \n    ( SELECT OBJECT_ID FROM SYS.ALL_OBJECTS AO \n      WHERE AO.OBJECT_TYPE = 'INDEX' \n        AND AO.OBJECT_NAME = A.INDEX_NAME \n        AND AO.OWNER = NVL( A.INDEX_OWNER, A.OWNER ) ) ) INDEX_OBJECT_ID, \n  DECODE( A.R_CONSTRAINT_NAME, NULL, NULL, \n    ( SELECT ( SELECT BB.OBJECT_TYPE || BB.OBJECT_ID \n               FROM SYS.ALL_OBJECTS BB \n               WHERE AA.OWNER = BB.OWNER \n               AND   AA.TABLE_NAME = BB.OBJECT_NAME \n               AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW') ) \n        || '#' || AA.TABLE_NAME \n      FROM SYS.ALL_CONSTRAINTS AA \n      WHERE AA.OWNER = A.R_OWNER \n        AND AA.CONSTRAINT_TYPE IN ( 'P', 'U' ) \n        AND AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME ) ) ref_relation_info, \n  ( SELECT LISTAGG( REPLACE( B.COLUMN_NAME, ';', ';;' ), ';' ) \n               WITHIN GROUP (ORDER BY B.POSITION) \n      FROM SYS.USER_CONS_COLUMNS B \n      WHERE A.CONSTRAINT_NAME = B.CONSTRAINT_NAME \n        AND A.OWNER = B.OWNER ) concatcols, \n  A.DEFERRABLE, A.DEFERRED \nFROM SYS.USER_CONSTRAINTS A \nWHERE A.OWNER = ? \nAND A.TABLE_NAME = ? \nAND A.CONSTRAINT_TYPE IN ( 'P', 'U', 'R', 'C' ) \n";
                listagg = true;
            }
            if (!DBUtil.areNamesAndTypesEqual((DBObject)db.getDefaultSchema(), (DBObject)relationSchema)) {
                Pattern p1 = Pattern.compile("USER_CONSTRAINTS", 2);
                String working = p1.matcher(userQuery).replaceAll("ALL_CONSTRAINTS");
                Pattern p2 = Pattern.compile("USER_CONS_COLUMNS", 2);
                query = p2.matcher(working).replaceAll("ALL_CONS_COLUMNS");
            } else {
                query = userQuery;
            }
        }
        final HashMap data = new HashMap();
        final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)relation, query, relationSchema, relation);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable((Relation)relation){
            final /* synthetic */ Relation val$relation;
            {
                this.val$relation = relation;
            }

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String conName = rs.getString("CONSTRAINT_NAME");
                        ConstraintData con = (ConstraintData)data.get(conName);
                        if (con == null) {
                            con = new ConstraintData(conName, rs);
                            data.put(conName, con);
                        }
                        if (con.isInvisibleFK()) {
                            con.m_ignore = true;
                        }
                        if (listagg) {
                            String concatcols = rs.getString("concatcols");
                            if (rs.wasNull() || !ModelUtil.hasLength((String)concatcols)) continue;
                            int SEP = 59;
                            boolean lastCharWasSep = false;
                            StringBuilder buff = new StringBuilder();
                            for (int i = 0; i < concatcols.length(); ++i) {
                                boolean isSep;
                                boolean append;
                                char c = concatcols.charAt(i);
                                if (c == ';') {
                                    if (lastCharWasSep) {
                                        append = true;
                                        isSep = false;
                                    } else {
                                        append = false;
                                        isSep = true;
                                    }
                                } else if (lastCharWasSep) {
                                    append = true;
                                    isSep = false;
                                    con.addColumn(buff.toString());
                                    buff = new StringBuilder();
                                } else {
                                    append = true;
                                    isSep = false;
                                }
                                if (append) {
                                    buff.append(c);
                                }
                                lastCharWasSep = isSep;
                            }
                            con.addColumn(buff.toString());
                            continue;
                        }
                        String colName = rs.getString("COLUMN_NAME");
                        if (rs.wasNull()) continue;
                        con.addColumn(colName);
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)this.val$relation, ex);
                }
            }
        };
        wrap.executeQuery(r);
        ArrayList<Constraint> cons = new ArrayList<Constraint>(data.size());
        for (ConstraintData cd : data.values()) {
            Constraint con;
            if (cd.m_ignore || (con = cd.createConstraint(relation)) == null) continue;
            cons.add(con);
        }
        relation.setConstraints(cons.toArray(new Constraint[cons.size()]));
    }

    private static FKConstraint.ReferentialAction translateDeleteAction(String action) {
        FKConstraint.ReferentialAction result = FKConstraint.ReferentialAction.NO_ACTION;
        if ("CASCADE".equals(action)) {
            result = FKConstraint.ReferentialAction.CASCADE;
        } else if ("SET NULL".equals(action)) {
            result = FKConstraint.ReferentialAction.SET_NULL;
        }
        return result;
    }

    private static String getColumnQuery(BaseOracleDatabase db) {
        String query = null;
        String dbType = db.getDatabaseType();
        if ("Oracle Lite".equals(dbType)) {
            query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_OLITE_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, null, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null \n       , null, null, null, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER(+) \nAND   C.TABLE_NAME = CMT.TABLE_NAME(+) \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME(+) \nORDER BY COLUMN_ID \n";
        } else {
            int dbVersion = db.getDatabaseVersion();
            if (dbVersion == 0) {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE7_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, null,        DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE,        DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null        , null, null, null, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
            } else if (dbVersion == 81) {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE8_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null \n       , null, null, null, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
            } else if (dbVersion == 82) {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE8i_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, CHAR_COL_DECL_LENGTH, DATA_DEFAULT, COMMENTS, null \n       , null, null, null, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
            } else if (dbVersion > 82 && dbVersion < 110) {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE9i_QUERY*/\n       C.COLUMN_NAME, C.DATA_TYPE, C.DATA_TYPE_OWNER, \n       C.DATA_LENGTH, C.DATA_PRECISION, C.DATA_SCALE, C.NULLABLE, \n       C.DEFAULT_LENGTH, C.CHAR_LENGTH, C.DATA_DEFAULT, CMT.COMMENTS \n    , decode(C.CHAR_USED, 'B', 'BYTE', 'C', 'CHAR', null) \n    , C.DATA_TYPE_MOD, null, null, null \nFROM SYS.ALL_TAB_COLS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nAND   C.HIDDEN_COLUMN = 'NO' \nORDER BY C.COLUMN_ID\n";
            } else if (dbVersion >= 110 && dbVersion < 120) {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE11g_QUERY*/\n       C.COLUMN_NAME, C.DATA_TYPE, C.DATA_TYPE_OWNER, \n       C.DATA_LENGTH, C.DATA_PRECISION, C.DATA_SCALE, C.NULLABLE, \n       C.DEFAULT_LENGTH, C.CHAR_LENGTH, C.DATA_DEFAULT, \n    ( SELECT CMT.COMMENTS FROM SYS.ALL_COL_COMMENTS CMT \n      WHERE C.OWNER = CMT.OWNER \n        AND C.TABLE_NAME = CMT.TABLE_NAME \n        AND C.COLUMN_NAME = CMT.COLUMN_NAME) COMMENTS \n    , decode(C.CHAR_USED, 'B', 'BYTE', 'C', 'CHAR', null) \n    , C.DATA_TYPE_MOD, C.VIRTUAL_COLUMN, null, null \nFROM SYS.ALL_TAB_COLS C \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.HIDDEN_COLUMN = 'NO' \nORDER BY C.COLUMN_ID\n";
            } else if (dbVersion >= 120) {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE12c_QUERY*/\n       C.COLUMN_NAME, C.DATA_TYPE, C.DATA_TYPE_OWNER, \n       C.DATA_LENGTH, C.DATA_PRECISION, C.DATA_SCALE, C.NULLABLE, \n       C.DEFAULT_LENGTH, C.CHAR_LENGTH, C.DATA_DEFAULT, \n    ( SELECT CMT.COMMENTS FROM SYS.ALL_COL_COMMENTS CMT \n      WHERE C.OWNER = CMT.OWNER \n        AND C.TABLE_NAME = CMT.TABLE_NAME \n        AND C.COLUMN_NAME = CMT.COLUMN_NAME) COMMENTS \n    , decode(C.CHAR_USED, 'B', 'BYTE', 'C', 'CHAR', null) \n    , C.DATA_TYPE_MOD, C.VIRTUAL_COLUMN, C.IDENTITY_COLUMN, C.DEFAULT_ON_NULL \nFROM SYS.ALL_TAB_COLS C \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.HIDDEN_COLUMN = 'NO' \nORDER BY C.COLUMN_ID\n";
            }
        }
        return query;
    }

    private static String getNotNullText(BaseOracleDatabase db) {
        String query = null;
        String type = db.getDatabaseType();
        query = "Oracle Lite".equals(type) || db.getDatabaseVersion() <= 81 ? ORACLE7_NOT_NULL_COND : ORACLE8i_NOT_NULL_COND;
        return query;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IdentityColumnPropertiesBuilder
    extends OracleIncrementerBuilder<IdentityColumnProperties> {
        IdentityColumnPropertiesBuilder(BaseOracleDatabase db) {
            super(db, "IdentityColumnProperties");
        }

        public IdentityColumnProperties createObject(String name, Schema schema, DBObjectID id) {
            return null;
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"generated"})
        public void fillInGenerated(final IdentityColumnProperties props) throws DBException {
            Relation relation;
            Column col = (Column)props.getParent();
            Relation relation2 = relation = col == null ? null : col.getRelation();
            if (relation == null) {
                throw new DBException((DBObject)props, "IdentityColumnProperties instance has no parent Relation");
            }
            final QueryWrapper wrap = this.getDatabase().newQueryWrapper((SystemObject)relation, "SELECT /*OracleDictionaryQueries.ALL_IDENTITY_COLUMN_PROPERTIES_QUERY*/ \n       GENERATION_TYPE FROM SYS.ALL_TAB_IDENTITY_COLS \nWHERE  OWNER = ? AND TABLE_NAME = ? AND COLUMN_NAME = ?", relation.getSchema(), relation, col);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet curs) throws DBException {
                    block4: {
                        try {
                            if (!curs.next()) break block4;
                            String generated = curs.getString(1);
                            IdentityColumnProperties.GeneratedType generatedType = null;
                            try {
                                generatedType = IdentityColumnProperties.GeneratedType.valueOf((String)generated.replaceAll(" ", "_"));
                            }
                            catch (Exception e) {
                                DBLog.getLogger((Object)this).warning(e.getMessage());
                            }
                            props.setGenerated(generatedType);
                        }
                        catch (SQLException e) {
                            wrap.throwDBException(e);
                        }
                    }
                }
            };
            wrap.executeQuery(r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstraintData {
        private String m_cName;
        private char m_cType;
        private String m_cond;
        private String m_rSchemaName;
        private String m_rConstraintName;
        private String m_rRelationType;
        private String m_rRelationName;
        private Object m_rRelationObjectID;
        private FKConstraint.ReferentialAction m_dRule;
        private boolean m_status;
        private boolean m_generated;
        private Constraint.DeferrableState m_deferredState;
        private List<String> m_cols = new ArrayList<String>();
        private boolean m_ignore = false;
        private String m_indexOwner;
        private String m_indexName;
        private BigDecimal m_indexObjectID;

        ConstraintData(String name, ResultSet rs) throws SQLException {
            this.m_cName = name;
            String cType = rs.getString("CONSTRAINT_TYPE");
            this.m_cType = ModelUtil.hasLength((String)cType) ? cType.charAt(0) : (char)'\u0000';
            switch (this.m_cType) {
                case 'C': {
                    this.m_cond = rs.getString("SEARCH_CONDITION");
                    break;
                }
                case 'P': 
                case 'U': {
                    this.m_indexOwner = rs.getString("INDEX_OWNER");
                    this.m_indexName = rs.getString("INDEX_NAME");
                    BigDecimal id = rs.getBigDecimal("INDEX_OBJECT_ID");
                    this.m_indexObjectID = rs.wasNull() ? null : id;
                    break;
                }
                case 'R': {
                    this.m_rSchemaName = rs.getString("R_OWNER");
                    this.m_rConstraintName = rs.getString("R_CONSTRAINT_NAME");
                    String typeIDString = rs.getString("ref_relation_info");
                    if (typeIDString != null) {
                        String idNameString;
                        if (typeIDString.startsWith("TABLE")) {
                            this.m_rRelationType = "TABLE";
                            idNameString = typeIDString.substring(5);
                        } else if (typeIDString.startsWith("VIEW")) {
                            this.m_rRelationType = "VIEW";
                            idNameString = typeIDString.substring(4);
                        } else {
                            idNameString = "";
                        }
                        int split = idNameString.indexOf(35);
                        if (split < 0) {
                            OracleRelationBuilder.this.getLogger().severe("Invalid ref details: " + typeIDString);
                        } else {
                            String idString = idNameString.substring(0, split);
                            if (idString.length() > 0) {
                                try {
                                    this.m_rRelationObjectID = BigDecimal.valueOf(Long.parseLong(idString));
                                }
                                catch (NumberFormatException nfe) {
                                    OracleRelationBuilder.this.getLogger().severe(nfe.getMessage());
                                }
                            }
                            this.m_rRelationName = idNameString.substring(split + 1);
                        }
                    }
                    this.m_dRule = OracleRelationBuilder.translateDeleteAction(rs.getString("DELETE_RULE"));
                    break;
                }
                default: {
                    this.m_cType = '\u0000';
                }
            }
            String enabled = rs.getString("STATUS");
            this.m_status = "ENABLED".equals(enabled);
            String generated = rs.getString("GENERATED");
            this.m_generated = "GENERATED NAME".equals(generated);
            String deferrable = rs.getString("DEFERRABLE");
            String deferred = rs.getString("DEFERRED");
            this.m_deferredState = deferrable == null || deferrable.equals("NOT DEFERRABLE") ? null : (deferred.equals("DEFERRED") ? Constraint.DeferrableState.DEFER_INIT_DEFERRED : Constraint.DeferrableState.DEFER_INIT_IMMEDIATE);
        }

        private boolean isInvisibleFK() {
            return this.m_cType == 'R' && !this.isVisibleFK();
        }

        private boolean isVisibleFK() {
            return this.m_rSchemaName != null && this.m_rRelationName != null && this.m_rRelationType != null;
        }

        private void addColumn(String colName) {
            if (ModelUtil.hasLength((String)colName)) {
                if (colName.startsWith("SYS_NC")) {
                    this.m_ignore = true;
                } else if (DBUtil.isCompoundName((String)colName, (String)OracleRelationBuilder.this.getDatabase().getIdentifierQuoteString())) {
                    DBLog.getLogger().warning("Constraint " + this.m_cName + " ignored;" + " compound column name " + colName + " not supported.");
                    this.m_ignore = true;
                } else {
                    this.m_cols.add(colName);
                }
            }
        }

        private Constraint createConstraint(T relation) throws DBException {
            CheckConstraint con = null;
            switch (this.m_cType) {
                case 'C': {
                    con = this.createCheckConstraint(relation);
                    break;
                }
                case 'P': 
                case 'U': {
                    con = this.createUniqueConstraint(relation);
                    break;
                }
                case 'R': {
                    con = this.createFK(relation);
                    break;
                }
                default: {
                    con = null;
                }
            }
            if (con != null) {
                con.setID((DBObjectID)new NameBasedID((DBObject)con, relation.getID()));
                con.setEnabled(this.m_status);
                con.setDeferrableState(this.m_deferredState);
            }
            return con;
        }

        private CheckConstraint createCheckConstraint(T relation) {
            String colName;
            Column col;
            if (this.m_cond == null) {
                return null;
            }
            this.m_cond = this.m_cond.trim();
            if (this.m_generated && this.m_cols.size() == 1 && (col = relation.getColumn(colName = this.m_cols.get(0))) != null && col.isNotNull() && MessageFormat.format(OracleRelationBuilder.getNotNullText(OracleRelationBuilder.this.getDatabase()), colName).equals(this.m_cond)) {
                return null;
            }
            CheckConstraint con = (CheckConstraint)OracleRelationBuilder.this.newObject(CheckConstraint.class, this.m_cName);
            con.setRelation(relation);
            con.setCheckCondition(this.m_cond);
            return con;
        }

        private void setConstraintColumns(ColumnConstraint con, T relation) {
            DBObjectID relID = relation.getID();
            if (relID == null) {
                String[] colNames = this.m_cols.toArray(new String[this.m_cols.size()]);
                int count = 0;
                Column[] cols = new Column[colNames.length];
                for (int i = 0; i < colNames.length; ++i) {
                    Column col = relation.getColumn(colNames[i]);
                    if (col == null) continue;
                    cols[count++] = col;
                }
                if (count < cols.length) {
                    Column[] tmp = cols;
                    cols = new Column[count];
                    System.arraycopy(tmp, 0, cols, 0, count);
                }
                con.setColumns(cols);
            } else {
                DBObjectID[] ids = new DBObjectID[this.m_cols.size()];
                for (int i = 0; i < ids.length; ++i) {
                    ids[i] = new NameBasedID("COLUMN", this.m_cols.get(i), relID);
                }
                con.setColumnIDs(ids);
            }
        }

        private UniqueConstraint createUniqueConstraint(T relation) throws DBException {
            Class clz = this.m_cType == 'P' ? PKConstraint.class : UniqueConstraint.class;
            UniqueConstraint con = (UniqueConstraint)OracleRelationBuilder.this.newObject(clz, this.m_cName);
            con.setRelation(relation);
            this.setConstraintColumns((ColumnConstraint)con, relation);
            if (this.m_indexName != null) {
                BaseOracleDatabase db = OracleRelationBuilder.this.getDatabase();
                Schema schema = null;
                if (ModelUtil.hasLength((String)this.m_indexOwner)) {
                    schema = db.getSchema(this.m_indexOwner);
                }
                if (schema == null) {
                    schema = relation.getSchema();
                }
                DBObjectID id = db.createID(null, schema, this.m_indexName, "INDEX", this.m_indexObjectID);
                con.setIndexID(id);
            }
            return con;
        }

        private FKConstraint createFK(T relation) throws DBException {
            FKConstraint fk = (FKConstraint)OracleRelationBuilder.this.newObject(FKConstraint.class, this.m_cName);
            fk.setRelation(relation);
            this.setConstraintColumns((ColumnConstraint)fk, relation);
            fk.setOnDeleteAction(this.m_dRule);
            if (this.isVisibleFK()) {
                Schema refSchema = OracleRelationBuilder.this.getSchema(this.m_rSchemaName);
                DBObjectID refRelationID = OracleRelationBuilder.this.getDatabase().createID(null, refSchema, this.m_rRelationName, this.m_rRelationType, this.m_rRelationObjectID);
                NameBasedID refConstraintID = new NameBasedID("CONSTRAINT", this.m_rConstraintName, refRelationID);
                fk.setReferenceID((DBObjectID)refConstraintID);
            }
            return fk;
        }
    }
}

