/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleSchemaBuilder
extends OracleDBObjectBuilder<Schema> {
    public OracleSchemaBuilder(BaseOracleDatabase db) {
        super(db, "SCHEMA");
    }

    private boolean shouldBuild(Schema schema) {
        return this.getDatabase() instanceof OracleDatabaseImpl && ModelUtil.areEqual((Object)schema.getName(), (Object)this.getDatabase().getUserName());
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"OracleSchemaProperties"})
    public void fillInSchemaProperties(Schema schema) throws DBException {
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"USER_PRIVS"})
    public void fillInPrivs(Schema schema) throws DBException {
        if (this.shouldBuild(schema)) {
            final HashSet privs = new HashSet();
            schema.setProperty("USER_PRIVS", privs);
            final QueryWrapper privsWrap = this.getDatabase().newQueryWrapper((SystemObject)null, "SELECT /*OracleDictionaryQueries.ALL_PRIVS_QUERY*/\n       PRIVILEGE FROM SYS.SESSION_PRIVS", new Object[0]);
            QueryWrapper.QueryRunnable privsRun = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        while (rs.next()) {
                            privs.add(rs.getString(1));
                        }
                    }
                    catch (SQLException ex) {
                        privsWrap.throwDBException(ex);
                    }
                }
            };
            try {
                privsWrap.executeQuery(privsRun);
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, APIBundle.format((String)"PRIVS_LOAD_ERR", (Object[])new Object[]{this.getDatabase().getConnectionName(), dbe.getMessage()}));
            }
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"USER_ROLES"})
    public void fillInRoles(Schema schema) throws DBException {
        if (this.shouldBuild(schema)) {
            final HashSet roles = new HashSet();
            schema.setProperty("USER_ROLES", roles);
            final QueryWrapper rolesWrap = new QueryWrapper((Database)this.getDatabase(), "SELECT /*OracleDictionaryQueries.ALL_ROLES_QUERY*/\n       GRANTED_ROLE FROM SYS.USER_ROLE_PRIVS");
            QueryWrapper.QueryRunnable rolesRun = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        while (rs.next()) {
                            roles.add(rs.getString(1));
                        }
                    }
                    catch (SQLException ex) {
                        rolesWrap.throwDBException(ex);
                    }
                }
            };
            try {
                rolesWrap.executeQuery(rolesRun);
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "Could not load roles for database " + this.getDatabase().getConnectionName(), dbe.getCause() == null ? dbe : dbe.getCause());
            }
        }
    }

    protected boolean canBuildComponents() {
        return true;
    }
}

