/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.util.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OracleSynonymBuilder
extends OracleDBObjectBuilder<Synonym> {
    OracleSynonymBuilder(BaseOracleDatabase db) {
        super(db, "SYNONYM");
    }

    public Synonym createObject(String name, Schema schema, DBObjectID id) {
        Synonym syn = (Synonym)super.createObject(name, schema, id);
        syn.setPublic(this.getDatabase().isPublicSchema(schema));
        return syn;
    }

    protected void fillInObject(final Synonym synonym) throws DBException {
        final Holder firstQueryWorked = new Holder((Object)false);
        if (synonym.getSchema() != null) {
            synonym.setPublic(this.getDatabase().isPublicSchema(synonym.getSchema()));
        }
        final QueryWrapper wrap = this.getQueryWrapper(synonym);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        firstQueryWorked.set((Object)true);
                        String refSchemaName = rs.getString(1);
                        String refObjectName = rs.getString(2);
                        String refObjectType = rs.getString(3);
                        Object refobjectID = rs.getObject(4);
                        String refDatabaseLink = rs.getString(5);
                        OracleSynonymBuilder.this.populateSynonym(synonym, refSchemaName, refObjectName, refDatabaseLink, refObjectType, refobjectID);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)synonym, sqe);
                }
            }
        };
        wrap.executeQuery(r);
        if (!((Boolean)firstQueryWorked.get()).booleanValue()) {
            final QueryWrapper wrap2 = this.getDatabase().newQueryWrapper((SystemObject)synonym, "SELECT /*OracleDictionaryQueries.ALL_SYNONYM_REF_OBJECT_NAME_AND_TYPE_QUERY*/\n       S.TABLE_OWNER, S.TABLE_NAME, S.DB_LINK  FROM  SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ? ", synonym.getSchema(), synonym);
            QueryWrapper.QueryRunnable r2 = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            String refSchemaName = rs.getString(1);
                            String refObjectName = rs.getString(2);
                            String refDatabaseLink = rs.getString(3);
                            OracleSynonymBuilder.this.populateSynonym(synonym, refSchemaName, refObjectName, refDatabaseLink, null, null);
                        }
                    }
                    catch (SQLException ex) {
                        wrap2.throwDBException((DBObject)synonym, ex);
                    }
                }
            };
            wrap2.executeQuery(r2);
        }
    }

    private void populateSynonym(Synonym synonym, String refSchemaName, String refObjectName, String refDatabaseLink, String refObjectType, Object refobjectID) throws DBException {
        BaseOracleDatabase db = this.getDatabase();
        Schema refSchema = refSchemaName == null ? null : (refDatabaseLink == null ? this.getSchema(refSchemaName) : new Schema(refSchemaName));
        ReferenceID refID = refobjectID == null ? new ReferenceID("UNSPECIFIED_TYPE", refSchema, refObjectName, refDatabaseLink) : db.createID(null, refSchema, refObjectName, refObjectType, refobjectID);
        synonym.setReference((DBObjectID)refID);
    }

    private QueryWrapper getQueryWrapper(Synonym synonym) {
        if (this.getDatabase() instanceof OracleLite) {
            return this.getDatabase().newQueryWrapper((SystemObject)synonym, "SELECT /*OracleDictionaryQueries.ALL_SYNONYM_REF_OBJECT_OLITE_QUERY*/\n       S.TABLE_OWNER, S.TABLE_NAME, 'TABLE', NULL, S.DB_LINK  FROM  SYS.ALL_TABLES REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.TABLE_NAME UNION ALL\n SELECT S.TABLE_OWNER, S.TABLE_NAME, 'VIEW', NULL, S.DB_LINK  FROM  SYS.ALL_VIEWS REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.VIEW_NAME", synonym.getSchema(), synonym, synonym.getSchema(), synonym);
        }
        return this.getDatabase().newQueryWrapper((SystemObject)synonym, "SELECT /*OracleDictionaryQueries.ALL_SYNONYM_REF_OBJECT_QUERY*/\n       S.TABLE_OWNER, S.TABLE_NAME, REF.OBJECT_TYPE, REF.OBJECT_ID,        S.DB_LINK  FROM  SYS.ALL_OBJECTS REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.DB_LINK IS NULL AND   S.TABLE_NAME   = REF.OBJECT_NAME AND   REF.OBJECT_TYPE NOT LIKE '% BODY'", synonym.getSchema(), synonym);
    }
}

