/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.RecycledObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RecycledObjectBuilder
extends OracleDBObjectBuilder<RecycledObject> {
    public static final String YES = "YES";
    private Boolean m_sysDBA;

    public RecycledObjectBuilder(BaseOracleDatabase db) {
        super(db, "RECYCLEBIN");
    }

    protected void fillInObject(final RecycledObject recycled) throws DBException {
        final QueryWrapper wrap = this.getQueryWrapper(recycled);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        String origName = rs.getString(1);
                        recycled.setOriginalName(origName);
                        String operation = rs.getString(2);
                        recycled.setOperation(RecycledObject.Operation.valueOf((String)operation));
                        String type = rs.getString(3);
                        recycled.setOriginalType(type);
                        String tsName = rs.getString(4);
                        recycled.setTablespaceName(tsName);
                        String createTime = rs.getString(5);
                        recycled.setCreateTime(createTime);
                        String dropTime = rs.getString(6);
                        recycled.setDropTime(dropTime);
                        Long dropSCN = rs.getLong(7);
                        recycled.setDropSCN(dropSCN);
                        String partName = rs.getString(8);
                        recycled.setPartitionName(partName);
                        String canUndrop = rs.getString(9);
                        recycled.setCanUndrop(RecycledObjectBuilder.YES.equals(canUndrop));
                        String canPurge = rs.getString(10);
                        recycled.setCanPurge(RecycledObjectBuilder.YES.equals(canPurge));
                        int space = rs.getInt(11);
                        recycled.setSpace(space);
                        int related = rs.getInt(12);
                        recycled.setRelatedObjectID((DBObjectID)new IdentifierBasedID(type, (Object)related, (AbstractDBObjectProvider)RecycledObjectBuilder.this.getDatabase()));
                        int base = rs.getInt(13);
                        recycled.setBaseObjectID((DBObjectID)new IdentifierBasedID(type, (Object)base, (AbstractDBObjectProvider)RecycledObjectBuilder.this.getDatabase()));
                        int purge = rs.getInt(14);
                        recycled.setPurgeObjectID((DBObjectID)new IdentifierBasedID(type, (Object)purge, (AbstractDBObjectProvider)RecycledObjectBuilder.this.getDatabase()));
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)recycled, ex);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private QueryWrapper getQueryWrapper(RecycledObject recycled) {
        if (this.isSysdba()) {
            return this.getDatabase().newQueryWrapper((SystemObject)recycled, "SELECT /*OracleDictionaryQueries.DBA_RECYCLED_OBJECT_QUERY*/\n       ORIGINAL_NAME, OPERATION, TYPE, TS_NAME, CREATETIME, DROPTIME,  DROPSCN, PARTITION_NAME, CAN_UNDROP, CAN_PURGE, SPACE, RELATED, BASE_OBJECT, PURGE_OBJECT FROM DBA_RECYCLEBIN WHERE OBJECT_NAME = ? AND OWNER = ? AND NOT(CAN_PURGE = 'NO' AND CAN_UNDROP = 'NO')", recycled, recycled.getSchema());
        }
        return this.getDatabase().newQueryWrapper((SystemObject)recycled, "SELECT /*OracleDictionaryQueries.RECYCLED_OBJECT_QUERY*/\n       ORIGINAL_NAME, OPERATION, TYPE, TS_NAME, CREATETIME, DROPTIME,  DROPSCN, PARTITION_NAME, CAN_UNDROP, CAN_PURGE, SPACE, RELATED, BASE_OBJECT, PURGE_OBJECT FROM RECYCLEBIN WHERE OBJECT_NAME = ? AND NOT(CAN_PURGE = 'NO' AND CAN_UNDROP = 'NO')", recycled);
    }

    private boolean isSysdba() {
        if (this.m_sysDBA == null) {
            this.m_sysDBA = ((OracleDatabaseImpl)this.getDatabase()).hasPrivilege("SYSDBA");
        }
        return this.m_sysDBA;
    }
}

