/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddl;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractIncrementer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseDescriptor;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.ddl.OracleDDLSupport;
import oracle.javatools.db.ora.ddl.OracleDDLType;
import oracle.javatools.db.ora.ddl.OracleStatementType;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDDLGenerator
extends BundleDDLGenerator<OracleDDLType> {
    public OracleDDLGenerator(Class<? extends OracleDatabase> oraClz, DBObjectProvider pro) {
        super(oraClz, pro, OracleDDLSupport.getInstance().getBundles(oraClz));
        this.registerTokens();
    }

    protected OracleDDLType getDDLType(String key) {
        return OracleDDLType.getDDLType((String)key);
    }

    private int getDatabaseVersion() {
        return OracleDatabaseDescriptor.getDatabaseVersion(this.getProviderClass());
    }

    protected void registerTokens() {
        this.registerSimpleDropDDL("FUNCTION");
        this.registerSimpleDropDDL("SEQUENCE");
        this.registerSimpleDropDDL("MATERIALIZED VIEW");
        this.registerSimpleDropDDL("PROCEDURE");
        this.registerSimpleDropDDL("TRIGGER");
        this.registerSimpleDropDDL("PACKAGE");
        this.registerSimpleDropDDL("PACKAGE BODY");
        this.registerSimpleDropDDL("TYPE BODY");
        for (Map.Entry<String, TokenGenerator> entry : OracleDDLSupport.getInstance().getGlobalTokenGenerators().entrySet()) {
            this.registerTokenGenerator(entry.getKey(), entry.getValue());
        }
        this.registerTopLevelChild("TABLE", "indexes", "INDEX");
        this.registerTopLevelChild("MATERIALIZED VIEW", "indexes", "INDEX");
    }

    protected final void registerSimpleDropDDL(String type) {
        this.registerDropDDL(type, OracleDDLSupport.getInstance().getSimpleDropDDL(), (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.DROP));
    }

    protected DDL<OracleDDLType> finish(DDLOptions options, DDL<OracleDDLType> ddl) {
        String spoolFile;
        if (ddl != null) {
            ddl.remove((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.NOOP));
        }
        if (ModelUtil.hasLength((String)(spoolFile = options.getSpoolFile())) && ddl != null && ddl.get((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLON)).isEmpty()) {
            ddl.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLON), MessageFormat.format("SPOOL {0}\n", spoolFile));
            ddl.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLOFF), "SPOOL OFF");
        }
        if (!(!options.isSqlBlankLines() || ddl == null || ddl.get((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.CMT)).isEmpty() && ddl.get((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.CMC)).isEmpty())) {
            ddl.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SET_SQLBLANKLINES_ON), "SET SQLBLANKLINES ON");
        }
        return super.finish(options, ddl);
    }

    public boolean canCreateProperty(SystemObject obj, String prop) {
        boolean supportsProperty = super.canCreateProperty(obj, prop);
        if (supportsProperty) {
            prop = Property.stripProperties((String)prop);
            if (obj instanceof Tablespace) {
                Tablespace tbsp = (Tablespace)obj;
                Tablespace.TablespaceType tbspType = (Tablespace.TablespaceType)tbsp.getProperty("TablespaceType");
                String propsPath = "OracleTablespaceProperties";
                if (prop.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "tablespaceGroup"}))) {
                    if (!tbspType.equals((Object)Tablespace.TablespaceType.TEMPORARY)) {
                        supportsProperty = false;
                    }
                } else if (prop.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "retention"}))) {
                    if (!tbspType.equals((Object)Tablespace.TablespaceType.UNDO)) {
                        supportsProperty = false;
                    }
                } else if ((prop.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "blockSize"})) || prop.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "logging"})) || prop.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "forceLogging"})) || prop.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "defaultTableCompression"})) || prop.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "onlineStatus"})) || prop.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "segmentManagement"}))) && !tbspType.equals((Object)Tablespace.TablespaceType.PERMANENT)) {
                    supportsProperty = false;
                }
            } else if (obj instanceof Table) {
                Table table = (Table)obj;
                Table.TableType tableType = (Table.TableType)table.getProperty("TableType");
                if (prop.endsWith("virtualExpressionSource")) {
                    supportsProperty = tableType.equals((Object)Table.TableType.NORMAL);
                } else if (prop.equals(Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}))) {
                    supportsProperty = tableType == Table.TableType.NORMAL;
                } else if (prop.startsWith("OracleExternalTableProperties")) {
                    supportsProperty = tableType == Table.TableType.EXTERNAL;
                } else if (prop.startsWith("OracleIndexOrganizedTableProperties")) {
                    supportsProperty = tableType == Table.TableType.INDEX_ORGANIZED;
                } else if (prop.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitions", "segmentAttributes"}))) {
                    OracleTablePartitions otp = (OracleTablePartitions)obj.getProperty("OracleTablePartitions");
                    supportsProperty = otp == null || otp.getPartitionType() != OracleTablePartitions.PartitionType.HASH || prop.endsWith("tablespaceID") || prop.endsWith("segmentAttributes");
                } else if (prop.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitions", "segmentAttributes"}))) {
                    OracleTablePartitions mainPartitioning = (OracleTablePartitions)obj.getProperty("OracleTablePartitions");
                    OracleTablePartitions otp = mainPartitioning.getSubpartitionModel();
                    supportsProperty = otp == null || prop.endsWith("tablespaceID") || prop.endsWith("segmentAttributes");
                } else if (tableType == Table.TableType.EXTERNAL) {
                    if (prop.startsWith("constraints") || prop.startsWith("indexes") || prop.startsWith("OracleTablePartitions") || prop.startsWith("OracleStorageProperties") || prop.equals("Comment")) {
                        supportsProperty = false;
                    }
                } else if (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
                    if (prop.startsWith("OracleTablePartitions")) {
                        supportsProperty = false;
                    } else if (prop.startsWith("OracleStorageProperties")) {
                        supportsProperty = this.getDatabaseVersion() >= 110 ? prop.equals("OracleStorageProperties") || prop.equals(Property.createPath((String[])new String[]{"OracleStorageProperties", "tablespaceID"})) : false;
                    }
                }
            }
        } else if (obj instanceof Table && "PARTITIONED TABLE".equals(prop)) {
            supportsProperty = this.canCreateProperty(obj, "OracleTablePartitions");
        }
        return supportsProperty;
    }

    public Collection getAllowedPropertyValues(DBObject originalObject, DBObject updatedObject, String property) {
        List<Object> retval = null;
        int dbVersion = this.getDatabaseVersion();
        String subPartitionType = Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitionType"});
        if (updatedObject instanceof Relation && property.equals(subPartitionType)) {
            OracleTablePartitions otp = (OracleTablePartitions)updatedObject.getProperty("OracleTablePartitions");
            if (otp != null) {
                retval = this.getSubPartitionTypes(otp);
            }
        } else if (updatedObject instanceof OracleTablePartitions && property.equals("partitionType")) {
            DBObject parent = updatedObject.getParent();
            if (parent instanceof OracleTablePartitions) {
                retval = this.getSubPartitionTypes((OracleTablePartitions)parent);
            }
        } else if (property.equals("LOBCache")) {
            Table parent = (Table)DBUtil.findParentOfType((DBObject)updatedObject, Table.class);
            if (parent != null && parent.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED) {
                retval = Arrays.asList(LOBDescriptor.LOBCache.NOCACHE, LOBDescriptor.LOBCache.CACHE_READS);
            }
        } else if (property.equals("onDeleteAction")) {
            retval = Arrays.asList(FKConstraint.ReferentialAction.NO_ACTION, FKConstraint.ReferentialAction.CASCADE, FKConstraint.ReferentialAction.SET_NULL);
        } else if (Property.getLastProperty((String)property).equals("tableCompression") || Property.getLastProperty((String)property).equals("defaultTableCompression")) {
            retval = dbVersion >= 112 ? Arrays.asList(OracleTableProperties.OracleTableCompression.NOCOMPRESS, OracleTableProperties.OracleTableCompression.COMPRESS, OracleTableProperties.OracleTableCompression.COMPRESS_FOR_OLTP, OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW, OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH, OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW, OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH) : (dbVersion == 110 ? Arrays.asList(OracleTableProperties.OracleTableCompression.NOCOMPRESS, OracleTableProperties.OracleTableCompression.COMPRESS, OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ALL_OPERATIONS, OracleTableProperties.OracleTableCompression.COMPRESS_FOR_DIRECT_LOAD_OPERATIONS) : Arrays.asList(OracleTableProperties.OracleTableCompression.NOCOMPRESS, OracleTableProperties.OracleTableCompression.COMPRESS));
        } else if (Property.getLastProperty((String)property).equals("constraintType")) {
            Relation rel = (Relation)DBUtil.findParentOfType((DBObject)updatedObject, Relation.class);
            Object ttype = rel == null ? null : rel.getProperty("TableType");
            boolean temp = ttype == Table.TableType.TRANSACTION_TEMP || ttype == Table.TableType.SESSION_TEMP;
            retval = new ArrayList<Object>();
            retval.add("PKConstraint");
            retval.add("UniqueConstraint");
            retval.add("CheckConstraint");
            if (!temp) {
                retval.add("FKConstraint");
            }
        }
        if (retval == null) {
            retval = super.getAllowedPropertyValues(originalObject, updatedObject, property);
        }
        return retval;
    }

    public Collection<String> getRestrictingProperties(Class<? extends SystemObject> objClz, String property) {
        ArrayList<String> retval = new ArrayList<String>();
        if (objClz.equals(Table.class) && (property.equals("Comment") || property.startsWith("OracleStorageProperties") || property.startsWith("OracleTableProperties"))) {
            retval.add("TableType");
        }
        return retval;
    }

    private Collection getSubPartitionTypes(OracleTablePartitions otp) {
        List<Object> retval = null;
        boolean is11g = this.getDatabaseVersion() >= 110;
        OracleTablePartitions.PartitionType parttype = otp.getPartitionType();
        if (!(parttype == OracleTablePartitions.PartitionType.RANGE || is11g && parttype == OracleTablePartitions.PartitionType.LIST)) {
            retval = Collections.emptyList();
        } else if (!is11g) {
            retval = Arrays.asList(OracleTablePartitions.PartitionType.HASH, OracleTablePartitions.PartitionType.LIST);
        }
        return retval;
    }

    protected boolean canCreate(Class<? extends SystemObject> objClass, String prop) {
        boolean canCreate = super.canCreate(objClass, prop);
        if (!canCreate && Table.class.equals(objClass)) {
            canCreate = this.isSupportedColumnSequenceProperty(prop, "columns");
        }
        return canCreate;
    }

    protected boolean canChangeWithAlter(SystemObject orig, SystemObject update, String prop) {
        boolean canChange = super.canChangeWithAlter(orig, update, prop);
        if (canChange && update instanceof MaterializedViewLog) {
            MaterializedViewLog mvl = (MaterializedViewLog)update;
            if ("objectIdLogged".equals(prop) && Boolean.FALSE.equals(mvl.getObjectIdLogged()) || "primaryKeyLogged".equals(prop) && Boolean.FALSE.equals(mvl.getPrimaryKeyLogged()) || "rowidLogged".equals(prop) && Boolean.FALSE.equals(mvl.getRowidLogged()) || "sequenceLogged".equals(prop) && Boolean.FALSE.equals(mvl.getSequenceLogged())) {
                canChange = false;
            }
        }
        return canChange;
    }

    private boolean isSupportedColumnSequenceProperty(String prop, String base) {
        String[] path;
        String toTest = null;
        if (base == null) {
            toTest = prop;
        } else if (base != null && (path = Property.getProperties((String)prop)).length == 2 && base.equals(path[0])) {
            toTest = path[1];
        }
        return toTest != null && "AUTO_GENERATED_SEQUENCE".equals(toTest) || "AUTO_GENERATED_SEQUENCE_TRIGGER".equals(toTest) || "ColumnSequenceExpander.TriggerNullCheck".equals(toTest);
    }

    public Object getImplicitDefaultValue(DBObject obj, String property) {
        Object retval = null;
        if (obj instanceof MaterializedView && "Comment".equals(Property.stripProperties((String)property))) {
            retval = "snapshot table for snapshot " + DBUtil.getFullyQualifiedName((DBObject)obj, (boolean)true);
        } else if (obj instanceof AbstractIncrementer) {
            if ("maxValue".equals(property)) {
                int ver = this.getDatabaseVersion();
                retval = ver >= 111 ? new BigInteger("9999999999999999999999999999") : new BigInteger("999999999999999999999999999");
            } else if ("minValue".equals(property)) {
                retval = BigInteger.ONE;
            }
        }
        return retval;
    }

    protected Nullable.NullBehaviour getNullBehaviour(PropertyInfo info, boolean edit) {
        String propName = info.getPropertyName();
        Nullable.NullBehaviour retval = "startWith".equals(propName) ? Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED_AND_IGNORE : (this.isSupportedColumnSequenceProperty(propName, null) ? Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED_AND_IGNORE : super.getNullBehaviour(info, edit));
        return retval;
    }
}

