/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddl;

import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ora.ddl.OracleDDLGenerator;
import oracle.javatools.db.ora.ddl.OracleDDLType;
import oracle.javatools.db.ora.ddl.OracleStatementType;
import oracle.javatools.db.ora.lite.OracleDatabaseLite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleLiteDDLGenerator
extends OracleDDLGenerator {
    public OracleLiteDDLGenerator(Class<? extends OracleDatabaseLite> clazz, DBObjectProvider prov) {
        super(clazz, prov);
    }

    @Override
    public Collection getAllowedPropertyValues(DBObject originalObject, DBObject updatedObject, String property) {
        Collection<Table.TableType> retval = null;
        if (updatedObject instanceof Table && property.equals("TableType")) {
            retval = new ArrayList<Table.TableType>();
            retval.add(Table.TableType.NORMAL);
            retval.add(Table.TableType.SESSION_TEMP);
            retval.add(Table.TableType.TRANSACTION_TEMP);
        } else if (updatedObject instanceof Index && "indexType".equals(property)) {
            retval = new ArrayList();
            retval.add((Table.TableType)Index.IndexType.NORMAL);
            retval.add((Table.TableType)Index.IndexType.UNIQUE);
            retval.add((Table.TableType)Index.IndexType.BITMAP);
        } else {
            retval = super.getAllowedPropertyValues(originalObject, updatedObject, property);
        }
        return retval;
    }

    @Override
    protected DDL<OracleDDLType> finish(DDLOptions options, DDL<OracleDDLType> ddl) {
        DDL<OracleDDLType> retval = super.finish(options, ddl);
        if (retval != null && retval.size() > 0) {
            DDL commit = new DDL();
            commit.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.COMMIT), "COMMIT");
            retval.append(commit);
        }
        return retval;
    }
}

