/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.owb.OMBPropertyResolver;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;
import oracle.javatools.db.ora.owb.OMBStoragePropsBuilder;

class OMBMatViewPropsBuilder
extends OMBStoragePropsBuilder {
    MaterializedView m_mv = null;

    public OMBMatViewPropsBuilder(Object forMV) {
        this.m_mv = (MaterializedView)forMV;
        this.setContextObject(forMV);
        this.setMapPath("properties/OracleStorageProperties/");
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    public void registerPropertyMappings() {
        super.registerPropertyMappings();
        this.registerPropertyMapping("buildType", "BUILD");
        if (this.m_mv.getRefreshMode().equals((Object)MaterializedView.RefreshMode.SPECIFY)) {
            this.registerPropertyMapping("firstRefresh", new OMBStartsWithPropResolver(this.m_mv));
            this.registerPropertyMapping("interval", "NEXTDATE");
        }
        this.registerPropertyMapping("properties/OracleTableProperties/parallelDegree", new String[]{"PARALLEL_ACCESS_MODE", "PARALLEL_DEGREE"});
        HashMap<String, String> parallelMap = new HashMap<String, String>();
        parallelMap.put("$DEFAULT$", "PARALLEL");
        this.registerSubstitutionValues("PARALLEL_ACCESS_MODE", (HashMap)parallelMap);
        this.registerPropertyMapping("isRewrite", "QUERY_REWRITE");
        HashMap<String, String> rewriteMap = new HashMap<String, String>();
        rewriteMap.put("true", "ENABLE");
        rewriteMap.put("false", "DISABLE");
        this.registerSubstitutionValues("QUERY_REWRITE", (HashMap)rewriteMap);
        this.registerPropertyMapping("refreshMethod", "REFRESH");
        this.registerPropertyMapping("refreshMode", "REFRESH_ON");
        HashMap<String, String> refreshOnMap = new HashMap<String, String>();
        refreshOnMap.put("NEVER", "$IGNORE$");
        refreshOnMap.put("SPECIFY", "$IGNORE$");
        this.registerSubstitutionValues("REFRESH_ON", (HashMap)refreshOnMap);
        this.registerPropertyMapping("useNoIndex", "USING_INDEX_MODE");
        HashMap<String, String> usingIndexMap = new HashMap<String, String>();
        usingIndexMap.put("true", "USING_NO_INDEX");
        usingIndexMap.put("false", "USING_INDEX");
        this.registerSubstitutionValues("USING_INDEX_MODE", (HashMap)usingIndexMap);
        this.registerPropertyMapping("rollbackSegmentType", "ROLLBACK");
        HashMap<String, String> rollbackTypeMap = new HashMap<String, String>();
        rollbackTypeMap.put("MASTER", "DEFAULT MASTER");
        rollbackTypeMap.put("LOCAL", "DEFAULT LOCAL");
        rollbackTypeMap.put("NONE", "NONE");
        this.registerSubstitutionValues("ROLLBACK", (HashMap)rollbackTypeMap);
        this.registerPropertyMapping("rollbackSegmentName", new OMBRollbackSegPropResolver((MaterializedView)this.getContextObject()));
        this.registerPropertyMapping("viewText", new OMBPropsStatementBuilder.OMBViewQueryPropResolver(this, (Relation)((MaterializedView)this.getContextObject())));
        this.registerPropertyMapping("properties/MatViewIndexStorageProperties/bufferMode", "DEFAULTINDEXBUFFERPOOL");
        this.registerPropertyMapping("properties/MatViewIndexStorageProperties/freelistGroups", "DEFAULTINDEXFREELISTGROUPS");
        this.registerPropertyMapping("properties/MatViewIndexStorageProperties/freelists", "DEFAULTINDEXFREELISTS");
        this.registerPropertyMapping("properties/MatViewIndexStorageProperties/initialExtent", "DEFAULTINDEXINITIAL");
        this.registerPropertyMapping("properties/MatViewIndexStorageProperties/initrans", "DEFAULTINDEXINITRANS");
        this.registerPropertyMapping("properties/MatViewIndexStorageProperties/maxtrans", "DEFAULTINDEXMAXTRANS");
        this.registerPropertyMapping("properties/MatViewIndexStorageProperties/maxExtent", "DEFAULTINDEXMAXEXTENTS");
        this.registerPropertyMapping("properties/MatViewIndexStorageProperties/minExtent", "DEFAULTINDEXMINEXTENTS");
        this.registerPropertyMapping("properties/MatViewIndexStorageProperties/nextExtent", "DEFAULTINDEXNEXT");
        this.registerPropertyMapping("properties/MatViewIndexStorageProperties/percentIncrease", "DEFAULTINDEXPCTINCREASE");
        this.registerPropertyMapping("properties/MatViewIndexStorageProperties/tablespaceID/name", "DEFAULT_INDEX_TABLESPACE");
    }

    public final class OMBStartsWithPropResolver
    extends OMBPropertyResolver {
        MaterializedView m_matView = null;

        public OMBStartsWithPropResolver(MaterializedView matView) {
            this.m_matView = matView;
        }

        public String resolvePropertyValue() {
            StringBuffer buffer = new StringBuffer();
            if (this.m_matView.getFirstRefresh() != null) {
                buffer.append(this.m_matView.getFirstRefresh());
            }
            return buffer.toString();
        }

        public String resolvePropertyName() {
            return "STARTWITH";
        }
    }

    public final class OMBRollbackSegPropResolver
    extends OMBPropertyResolver {
        MaterializedView m_matView = null;

        public OMBRollbackSegPropResolver(MaterializedView matView) {
            this.m_matView = matView;
        }

        public String resolvePropertyValue() {
            return this.m_matView.getRollbackSegmentName();
        }

        public String resolvePropertyName() {
            if (this.m_matView.getRollbackSegmentType().equals((Object)MaterializedView.RollbackSegmentType.LOCAL)) {
                return "ROLLBACKSEGMENTLOCAL";
            }
            return "ROLLBACKSEGMENTMASTER";
        }
    }
}

