/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.Keywords;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilder;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.ora.sql.ParserRules;
import oracle.javatools.db.ora.sxml.SQLFragmentSXMLGenerator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.GroupByExpression;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpressionBuilder
implements ExpressionFactory,
Keywords,
ParserRules {
    protected ExpressionContext m_expressionContext;
    protected DBObjectProvider m_provider;
    protected OracleSQLQueryBuilder m_queryBuilder;
    protected Object m_queryContext;
    protected SQLQuery m_query;
    protected OracleSQLQueryBuilderHelper m_helper;
    protected SQLFragment m_creating;
    protected Schema m_defaultSchema;

    protected void init(ExpressionContext context) {
        this.m_expressionContext = context;
        this.m_provider = context.getProvider();
        this.m_queryBuilder = context.getQueryBuilder();
        this.m_queryContext = context.getQueryContext();
        this.m_query = context.getQuery();
        this.m_helper = context.getHelper();
        this.m_creating = context.getCreating();
        this.m_defaultSchema = context.getDefaultSchema();
    }

    protected FromObject findFromObject(String alias, FromObject creating) {
        FromObject from = this.m_queryBuilder.getFromObject(alias, creating);
        if (from == null) {
            for (OracleSQLQueryBuilder parent = (OracleSQLQueryBuilder)this.m_queryBuilder.getParentBuilder(); parent != null && from == null; parent = (OracleSQLQueryBuilder)parent.getParentBuilder()) {
                from = parent.getFromObject(alias);
            }
        }
        return from;
    }

    protected SQLFragment[] getArgList(SQLFragment creating, Object func, ParseNode node) throws SQLQueryException {
        List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
        int openParenIndex = this.m_helper.getKeywordIndex(kids, "(");
        int closeParenIndex = this.m_helper.getKeywordIndex(kids, ")");
        if (closeParenIndex == -1) {
            closeParenIndex = kids.size();
        }
        int start = openParenIndex + 1;
        return this.getArgList(creating, func, kids, start, closeParenIndex);
    }

    protected SQLFragment[] getArgList(SQLFragment creating, Object func, List<ParseNode> os, int start, int finish) throws SQLQueryException {
        boolean hasTrimFrom;
        SQLFragment trimChar = null;
        int fromIdx = this.m_helper.getKeywordIndex(os, "FROM");
        boolean bl = hasTrimFrom = fromIdx != -1 && fromIdx < finish;
        if (this.m_helper.isKeyword(os.get(start), "DISTINCT", "ALL")) {
            ++start;
        } else if (this.m_helper.isKeyword(os.get(start), "LEADING", "TRAILING", "BOTH")) {
            if (!this.m_helper.isKeyword(os.get(++start), "FROM")) {
                trimChar = this.m_queryBuilder.createFragment(os.get(start), this.m_creating, func);
                ++start;
            }
            ++start;
        } else if (hasTrimFrom) {
            trimChar = this.m_queryBuilder.createFragment(os.get(start), this.m_creating, func);
            ++start;
            ++start;
        }
        List<List<ParseNode>> pargs = this.m_helper.getCommaSeparatedList(os.subList(start, finish));
        if (finish == start + 1 && func instanceof GroupByExpression && GroupByExpression.GroupingType.GROUPING_SETS.equals((Object)((GroupByExpression)func).getGroupByType())) {
            pargs = this.m_helper.getCommaSeparatedList(os.get(start));
        }
        ArrayList<SQLFragment> args = new ArrayList<SQLFragment>();
        for (List<ParseNode> parg : pargs) {
            if (parg == null || parg.size() != 1) continue;
            SQLFragment arg = this.m_queryBuilder.createFragment(parg.get(0), creating, func);
            args.add(arg);
        }
        if (trimChar != null) {
            args.add(trimChar);
        }
        SQLFragment[] argsL = args.toArray(new SQLFragment[args.size()]);
        return argsL;
    }

    private DBObjectID findObjectID(DBObject parent, PlSqlToken tk) {
        String[] types = new String[]{"FUNCTION", "PACKAGE", "TYPE"};
        String tokVal = this.m_provider.getInternalName(tk.getSource(true));
        if (parent instanceof Schema) {
            for (String objType : types) {
                SchemaObject so = null;
                try {
                    so = this.m_provider.getObject(objType, (Schema)parent, tokVal);
                }
                catch (DBException e) {
                    so = null;
                }
                if (so == null) continue;
                if (tk.getNextCodeToken().getType() == PlSqlToken.Type.END_MARKER) {
                    return so.getID();
                }
                if (tk.getNextCodeToken().matches(".")) {
                    return this.findObjectID((DBObject)so, tk.getNextCodeToken(2));
                }
                return null;
            }
        } else {
            for (DBObject kid : parent.getOwnedObjects()) {
                if (kid.getName() == null || !kid.getName().equals(tokVal)) continue;
                if (tk.getNextCodeToken().getType() == PlSqlToken.Type.END_MARKER) {
                    return kid.getID();
                }
                if (tk.getNextCodeToken().matches(".")) {
                    return this.findObjectID(kid, tk.getNextCodeToken(2));
                }
                return null;
            }
        }
        return null;
    }

    protected DBObjectID findIdForFunctionString(String str) {
        PlSqlToken startTk;
        DBObjectID retval = null;
        PlSqlToken tk = startTk = PlSqlTokenizer.tokenize((String)str, (String[])new String[0]);
        PlSqlToken endTk = null;
        while (tk.getType() != PlSqlToken.Type.END_MARKER) {
            tk = tk.getNextToken();
        }
        endTk = tk.getPrevCodeToken();
        retval = this.findObjectID((DBObject)this.m_defaultSchema, startTk);
        if (retval == null) {
            try {
                Schema schema = this.m_provider.getSchema(this.m_provider.getInternalName(startTk.getSource(true)));
                if (schema != null && startTk.getNextCodeToken().matches(".")) {
                    retval = this.findObjectID((DBObject)schema, startTk.getNextCodeToken(2));
                }
            }
            catch (DBException e) {
                // empty catch block
            }
        }
        if (retval == null) {
            String[] bits = str.split("\\.");
            if (bits.length == 1) {
                retval = new ReferenceID("FUNCTION", this.m_defaultSchema, str);
            } else if (bits.length == 2) {
                Schema s = null;
                try {
                    s = this.m_provider.getSchema(bits[0]);
                }
                catch (DBException e) {
                    // empty catch block
                }
                if (s != null) {
                    retval = new ReferenceID("FUNCTION", s, bits[1]);
                } else {
                    retval = new ReferenceID("FUNCTION", (String)null, bits[1]);
                    ((ReferenceID)retval).setParent((DBObjectID)new ReferenceID("PACKAGE", this.m_defaultSchema, bits[0]));
                }
            }
        }
        return retval;
    }

    protected SQLFragment createFunction(String source, BuiltInFunction func, String distinctQualifierSource, boolean isDistinct, SQLFragment[] argsL) throws SQLQueryException {
        FunctionUsage retval = null;
        if (SQLFragmentSXMLGenerator.isInCompoundExpressionGroup(func.getName())) {
            retval = this.m_queryBuilder.createFunction(func.getName(), argsL, source);
            if (retval == null) {
                this.m_queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_UNKNOWN_FUNC", (Object[])new Object[]{func})));
            }
            ((Function)retval).setDistinct(isDistinct);
            ((Function)retval).setDistinctSource(distinctQualifierSource);
        } else {
            retval = new FunctionUsage();
            retval.setObjectID(this.findIdForFunctionString(func.getName()));
            retval.setArguments(argsL);
        }
        return retval;
    }

    protected List<List<ParseNode>> getCompoundExpression(List<ParseNode> kids, int start) {
        List<List<ParseNode>> pes = null;
        kids = this.m_helper.getOrderedChildren(kids.get(start));
        pes = this.m_helper.getCommaSeparatedList(kids.subList(this.m_helper.getKeywordIndex(kids, "(") + 1, this.m_helper.getKeywordIndex(kids, ")")));
        return pes;
    }

    protected ExpressionList createExpressionList(List<List<ParseNode>> pes, SQLFragment creating) throws SQLQueryException {
        SelectObject[] arguments = new SelectObject[pes.size()];
        int i = 0;
        for (List<ParseNode> n : pes) {
            ParseNode node = n.get(0);
            SQLFragment expr = this.m_queryBuilder.createFragment(node, creating, null);
            String alias = null;
            if (n.size() > 1 && this.m_helper.isLeaf(n.get(1))) {
                alias = this.m_helper.getContent(n.get(1));
            }
            arguments[i] = new SelectObject(expr, alias);
            ++i;
        }
        ExpressionList retval = new ExpressionList((SQLFragment[])arguments);
        return retval;
    }
}

