/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.ArithmeticOperation;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class ArithmeticOperationBuilder
extends AbstractExpressionBuilder {
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext context, ParseNode node) throws SQLQueryException {
        SQLFragment retval = null;
        List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
        if (this.m_helper.isRule(node, "expr") || this.m_helper.isRule(node, "compound_expression") || kids.size() == 2 && this.m_helper.isOperation(kids.get(0))) {
            if (kids.size() == 4 && this.m_helper.isKeyword(kids.get(1), "|") && this.m_helper.isKeyword(kids.get(2), "|")) {
                SQLFragment left = this.m_queryBuilder.createFragment(kids.get(0), this.m_creating, this.m_queryContext);
                SQLFragment right = this.m_queryBuilder.createFragment(kids.get(3), this.m_creating, this.m_queryContext);
                SQLFragment[] argsL = new SQLFragment[]{left, right};
                String source = "||";
                BuiltInFunction func = null;
                Iterator i$ = context.getProvider().getDescriptor().listBuiltInFunctions("CONCAT").iterator();
                if (i$.hasNext()) {
                    BuiltInFunction bif;
                    func = bif = (BuiltInFunction)i$.next();
                }
                retval = this.createFunction(source, func, null, false, argsL);
            } else if (kids.size() == 3) {
                if (this.m_helper.isKeyword(kids.get(0), "(")) {
                    retval = this.m_queryBuilder.createFragment(kids.get(1), this.m_creating, this.m_queryContext);
                } else if (this.m_helper.isLeaf(kids.get(1))) {
                    ParseNode operatorNode = kids.get(1);
                    if (!this.m_helper.isLeaf(operatorNode)) {
                        throw new SQLQueryException(this.m_queryBuilder.buildErrorMessage(operatorNode, APIBundle.get((String)"SQL_RQB_OPERATOR_EXPECTED")));
                    }
                    SQLFragment left = this.m_queryBuilder.createFragment(kids.get(0), this.m_creating, this.m_queryContext);
                    SQLFragment right = this.m_queryBuilder.createFragment(kids.get(2), this.m_creating, this.m_queryContext);
                    String operator = this.m_helper.getContent(operatorNode).toUpperCase();
                    ArithmeticOperation.ArithmeticOperator type = ArithmeticOperation.getArithmeticOperator((String)operator, (int)2);
                    if (type != null) {
                        retval = new ArithmeticOperation(type, new SQLFragment[]{left, right});
                    }
                }
            } else if (kids.size() == 2 && this.m_helper.isLeaf(kids.get(0))) {
                ParseNode operatorNode = kids.get(0);
                if (!this.m_helper.isLeaf(operatorNode)) {
                    throw new SQLQueryException("Operator expected");
                }
                SQLFragment operand = this.m_queryBuilder.createFragment(kids.get(1), this.m_creating, this.m_queryContext);
                String operator = this.m_helper.getContent(operatorNode);
                Comparison.Comparator comp = Comparison.getComparator((String)operator);
                if (comp != null) {
                    retval = new Comparison(operand, comp, null);
                } else {
                    ArithmeticOperation.ArithmeticOperator op = ArithmeticOperation.getArithmeticOperator((String)operator, (int)1);
                    if (op != null) {
                        retval = new ArithmeticOperation(op, new SQLFragment[]{operand});
                    } else {
                        throw new SQLQueryException(APIBundle.format((String)"SQL_UNRECOGNISED_OPERATOR", (Object[])new Object[]{operator}));
                    }
                }
            }
        }
        return retval;
    }
}

