/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryCancelledException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.XMLFunctionUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltInFunctionBuilder
extends AbstractExpressionBuilder {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext context, ParseNode node) throws SQLQueryException {
        SQLFragment retval = null;
        List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
        String source = context.getProvider().getInternalName(this.m_helper.getContent(kids.get(0)));
        BuiltInFunction func = null;
        Iterator i$ = context.getProvider().getDescriptor().listBuiltInFunctions(source).iterator();
        if (i$.hasNext()) {
            BuiltInFunction bif;
            func = bif = (BuiltInFunction)i$.next();
        }
        if (func != null) {
            if ((this.m_helper.isRule(node, "XML_function") || this.m_helper.isRule(node, "xmlexists") || this.m_helper.isRule(node, "xmltable") || this.m_helper.isRule(node, "xmlagg")) && this.m_helper.isKeyword(kids.get(1), "(") && this.m_helper.isKeyword(kids.get(kids.size() - 1), ")")) {
                retval = this.createXMLFunction(context, kids, source, func);
            } else if (this.m_helper.isRule(node, "function_expression") && this.m_helper.isLeaf(kids.get(0))) {
                if (func == null) {
                    if (this.m_helper.isKeyword(kids.get(0), "MULTISET")) {
                        retval = this.createMultiset(kids.get(2));
                    }
                } else {
                    String distinctQualifierSource = null;
                    boolean isDistinct = false;
                    if (this.m_helper.isRule(node, "cast")) {
                        SQLFragment arg0 = null;
                        if (this.m_helper.isKeyword(kids.get(2), "MULTISET")) {
                            List<ParseNode> kidskids = this.m_helper.getOrderedChildren(kids.get(3));
                            arg0 = this.createMultiset(kidskids.get(1));
                        } else {
                            arg0 = this.m_queryBuilder.createFragment(kids.get(2), this.m_creating, context);
                        }
                        ParseNode datatypeNode = this.m_helper.getRuleNode(kids, "datatype");
                        String datatype = this.m_helper.getContent(datatypeNode);
                        SimpleSQLFragment arg1 = new SimpleSQLFragment(datatype);
                        SQLFragment[] argsL = new SQLFragment[]{arg0, arg1};
                        retval = this.createFunction(source, func, null, false, argsL);
                    } else {
                        int distinctAllIndex;
                        if (this.m_helper.isRule(node, "trim")) {
                            BuiltInFunction bif;
                            Iterator i$2;
                            if (this.m_helper.getKeywordIndex(kids, "LEADING") != -1) {
                                source = "LEADING";
                                i$2 = context.getProvider().getDescriptor().listBuiltInFunctions("LTRIM").iterator();
                                if (i$2.hasNext()) {
                                    func = bif = (BuiltInFunction)i$2.next();
                                }
                            } else if (this.m_helper.getKeywordIndex(kids, "TRAILING") != -1) {
                                source = "TRAILING";
                                i$2 = context.getProvider().getDescriptor().listBuiltInFunctions("RTRIM").iterator();
                                if (i$2.hasNext()) {
                                    func = bif = (BuiltInFunction)i$2.next();
                                }
                            } else if (this.m_helper.getKeywordIndex(kids, "BOTH") != -1) {
                                source = "BOTH";
                            }
                        }
                        if ((distinctAllIndex = this.m_helper.getKeywordIndex(kids, "DISTINCT", "ALL")) != -1) {
                            distinctQualifierSource = this.m_helper.getContent(kids.get(distinctAllIndex));
                            isDistinct = this.m_helper.getKeywordIndex(kids, "DISTINCT") != -1;
                        }
                        SQLFragment[] argsL = null;
                        if (this.m_helper.isRule(node, "translate_using")) {
                            SQLFragment arg0 = this.m_queryBuilder.createFragment(kids.get(2), this.m_creating, retval);
                            SimpleSQLFragment arg1 = new SimpleSQLFragment(this.m_helper.getContent(kids.get(4)));
                            argsL = new SQLFragment[]{arg0, arg1};
                        } else {
                            argsL = this.getArgList(this.m_creating, func.getName(), node);
                        }
                        retval = this.createFunction(source, func, distinctQualifierSource, isDistinct, argsL);
                    }
                }
            }
        }
        return retval;
    }

    private SQLFragment createMultiset(ParseNode node) throws SQLQueryException {
        Function retval = null;
        SQLFragment multisetQuery = this.m_queryBuilder.createFragment(node, this.m_creating, this.m_queryContext);
        retval = new Function("MULTISET", new SQLFragment[]{multisetQuery});
        this.m_queryBuilder.setFunctionReturnTypeID(retval);
        return retval;
    }

    private SQLFragment createXMLFunction(ExpressionContext context, List<ParseNode> xmlNodes, String source, BuiltInFunction func) throws SQLQueryException {
        XMLFunctionUsage retval = null;
        List<SQLFragment> frags = this.createXMLargs(context, xmlNodes.subList(2, xmlNodes.size() - 1));
        SQLFragment[] argsL = frags.toArray(new SQLFragment[frags.size()]);
        retval = new XMLFunctionUsage();
        ((FunctionUsage)retval).setObjectID(this.findIdForFunctionString(func.getName()));
        ((FunctionUsage)retval).setArguments(argsL);
        return retval;
    }

    private List<SQLFragment> createXMLargs(ExpressionContext context, List<ParseNode> nodes) throws SQLQueryException {
        ArrayList<SQLFragment> retval = new ArrayList<SQLFragment>();
        ArrayList<Object> nodesToProcess = new ArrayList<ParseNode>();
        for (ParseNode n : nodes) {
            String debugContent = this.m_helper.getContent(n);
            if (this.hasExpr(n)) {
                if (nodesToProcess.size() > 0) {
                    retval.add(this.createStringFragment(nodesToProcess));
                    nodesToProcess = new ArrayList();
                }
                if (this.m_helper.isRule(n, "expr")) {
                    try {
                        retval.add(this.m_queryBuilder.createFragment(n, this.m_creating, context));
                        continue;
                    }
                    catch (SQLQueryCancelledException sqce) {
                        throw sqce;
                    }
                    catch (SQLQueryException e) {
                        retval.add((SQLFragment)new SimpleSQLFragment(this.m_helper.getContent(n)));
                        continue;
                    }
                }
                List<ParseNode> kids = this.m_helper.getOrderedChildren(n);
                retval.addAll(this.createXMLargs(context, kids));
                continue;
            }
            nodesToProcess.add(n);
        }
        if (nodesToProcess.size() > 0) {
            retval.add(this.createStringFragment(nodesToProcess));
        }
        return retval;
    }

    private SQLFragment createStringFragment(List<ParseNode> nodes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < nodes.size(); ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this.m_helper.getContent(nodes.get(i)));
        }
        SimpleSQLFragment retval = new SimpleSQLFragment(buf.toString());
        return retval;
    }

    private boolean hasExpr(ParseNode n) {
        boolean retval = false;
        if (this.m_helper.isRule(n, "expr")) {
            retval = true;
        } else if (!this.m_helper.isLeaf(n)) {
            List<ParseNode> kids = this.m_helper.getOrderedChildren(n);
            for (ParseNode kid : kids) {
                if (!this.hasExpr(kid)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }
}

