/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.CaseStatement;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class CaseBuilder
extends AbstractExpressionBuilder {
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext context, ParseNode node) throws SQLQueryException {
        CaseStatement retval = null;
        if (this.m_helper.isRule(node, "case_expression")) {
            List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
            SQLFragment exp = null;
            List<ParseNode> caseNodes = this.m_helper.getOrderedChildren(kids.get(1));
            int nodeIndex = 0;
            if (this.m_helper.isRule(kids.get(1), "simple_case_expression")) {
                exp = this.m_queryBuilder.createFragment(caseNodes.get(nodeIndex), this.m_creating, this.m_queryContext);
                ++nodeIndex;
            }
            ArrayList<CaseStatement.WhenThen> whenThens = new ArrayList<CaseStatement.WhenThen>();
            while (nodeIndex < caseNodes.size() && this.m_helper.isKeyword(caseNodes.get(nodeIndex), "WHEN")) {
                SQLFragment whenCond = this.m_queryBuilder.createFragment(caseNodes.get(++nodeIndex), this.m_creating, this.m_queryContext);
                if (!this.m_helper.isKeyword(caseNodes.get(++nodeIndex), "THEN")) {
                    throw new SQLQueryException(this.m_queryBuilder.buildErrorMessage(caseNodes.get(nodeIndex), APIBundle.get((String)"SQL_RQB_THEN_EXPECTED")));
                }
                SQLFragment thenExpr = this.m_queryBuilder.createFragment(caseNodes.get(++nodeIndex), this.m_creating, this.m_queryContext);
                ++nodeIndex;
                CaseStatement.WhenThen whenThen = new CaseStatement.WhenThen(whenCond, thenExpr);
                whenThens.add(whenThen);
            }
            SQLFragment elseExpr = null;
            if (kids.size() > 3 && this.m_helper.isRule(kids.get(2), "else_clause")) {
                List<ParseNode> elseNodes = this.m_helper.getOrderedChildren(kids.get(2));
                elseExpr = this.m_queryBuilder.createFragment(elseNodes.get(1), this.m_creating, this.m_queryContext);
                ++nodeIndex;
            }
            retval = new CaseStatement(exp, whenThens.toArray(new CaseStatement.WhenThen[whenThens.size()]), elseExpr);
        }
        return retval;
    }
}

