/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.UnrecognizedFragmentException;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLCallable;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryCancelledException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SequenceUsage;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnBuilder
extends AbstractExpressionBuilder {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext expContext, ParseNode node) throws SQLQueryException {
        SQLFragment retval;
        SQLQueryException saveException;
        block9: {
            saveException = null;
            retval = null;
            if (this.m_helper.isLeaf(node) || this.m_helper.isDotSeperatedList(node) || this.m_helper.isRule(node, "column") || this.m_helper.isRule(node, "col_oj")) {
                if (expContext.getQueryContext() != null && expContext.getQueryContext() instanceof String && "MAKE_REF".equalsIgnoreCase((String)expContext.getQueryContext())) {
                    retval = this.createColumnUsage(node, expContext.getCreating());
                } else {
                    try {
                        retval = this.createColumnUsage(node, expContext.getCreating());
                    }
                    catch (SQLQueryCancelledException sqce) {
                        throw sqce;
                    }
                    catch (SQLQueryException e) {
                        saveException = e;
                        retval = this.createFunctionUsageFromSqlColdef(node);
                        if (retval != null) break block9;
                        List<ParseNode> l = this.m_helper.getDotSeparatedList(node);
                        StringBuilder sb = new StringBuilder();
                        for (ParseNode n : l) {
                            if (sb.length() != 0) {
                                sb.append(".");
                            }
                            sb.append(this.m_helper.getContent(n));
                        }
                        retval = this.m_queryBuilder.createFromFactory(this.m_creating, sb.toString(), this.m_helper.getNodeStartOffset(node));
                    }
                }
            }
        }
        if (saveException != null && retval == null) {
            throw saveException;
        }
        return retval;
    }

    private FunctionUsage createFunctionUsageFromSqlColdef(ParseNode node) {
        FunctionUsage retval = null;
        List<ParseNode> l = this.m_helper.getDotSeparatedList(node);
        String userName = null;
        String tableName = null;
        String colName = null;
        boolean allLeaves = true;
        for (ParseNode n : l) {
            if (this.m_helper.isLeaf(n)) continue;
            allLeaves = false;
            break;
        }
        if (allLeaves) {
            DBObjectID id;
            if (l.size() >= 3) {
                userName = this.m_helper.getContent(l.get(0));
                l.remove(0);
            }
            if (l.size() >= 2) {
                tableName = this.m_helper.getContent(l.get(0));
                l.remove(0);
            }
            if (l.size() >= 1) {
                colName = this.m_helper.getContent(l.get(0));
                l.remove(0);
            }
            ArrayList<String> attributes = new ArrayList<String>();
            for (ParseNode n : l) {
                attributes.add(this.m_helper.getContent(n));
            }
            StringBuffer sb = new StringBuffer();
            if (ModelUtil.hasLength((String)userName)) {
                sb.append(".").append(userName);
            }
            if (ModelUtil.hasLength((String)tableName)) {
                sb.append(".").append(tableName);
            }
            if (ModelUtil.hasLength((String)colName)) {
                sb.append(".").append(colName);
                for (String s : attributes) {
                    sb.append(".").append(s);
                }
            }
            if ((id = this.findIdForFunctionString(sb.substring(1))) != null && !(id instanceof ReferenceID)) {
                retval = new FunctionUsage();
                retval.setObjectID(id);
            }
        }
        return retval;
    }

    private SQLFragment createColumnUsage(ParseNode columnDef, SQLFragment creating) throws SQLQueryException {
        ColumnKeywordUsage retval = null;
        boolean isOuterJoin = false;
        if (this.m_helper.isRule(columnDef, "col_oj")) {
            isOuterJoin = true;
            columnDef = this.m_helper.getOrderedChildren(columnDef).get(0);
        }
        List<String> bits = this.getBits(columnDef);
        ArrayList<String> bitsCopy = new ArrayList<String>(bits);
        int colindex = 0;
        FromObject extraFrom = creating instanceof FromObject ? (FromObject)creating : null;
        FromObject from = null;
        String parentName = null;
        if (bits.size() > 1) {
            ++colindex;
            parentName = bits.remove(0);
            from = this.findFromObject(parentName, extraFrom);
            if (from == null && bits.size() > 0 && (from = this.findFromObject(parentName = parentName + "." + bits.get(0), extraFrom)) != null) {
                ++colindex;
                bits.remove(0);
            }
            if (from == null) {
                String schemaName = this.m_defaultSchema == null ? null : this.m_defaultSchema.getName();
                ReferenceID par = null;
                ReferenceID id = null;
                for (String bit : bitsCopy) {
                    id = new ReferenceID("UNSPECIFIED_TYPE", schemaName, this.m_provider.getInternalName(bit));
                    id.setParent(par);
                    id.setProvider(this.m_provider);
                    schemaName = null;
                    par = id;
                }
                if (id != null) {
                    DBObject ref = null;
                    try {
                        ref = id.resolveID();
                    }
                    catch (DBException e) {
                        ref = null;
                    }
                    if (ref instanceof SQLCallable) {
                        FunctionUsage fu = new FunctionUsage();
                        fu.setObjectID(ref.getID());
                        retval = fu;
                    } else if (ref == null && bitsCopy.size() == 2 && ("NEXTVAL".equalsIgnoreCase((String)bitsCopy.get(1)) || "CURRVAL".equalsIgnoreCase((String)bitsCopy.get(1)))) {
                        try {
                            ref = id.getParent().resolveID();
                            if (ref instanceof Sequence) {
                                SequenceUsage su = new SequenceUsage();
                                su.setObjectID(ref.getID());
                                if ("NEXTVAL".equalsIgnoreCase((String)bitsCopy.get(1))) {
                                    su.setMode(SequenceUsage.Mode.NEXTVAL);
                                } else {
                                    su.setMode(SequenceUsage.Mode.CURRVAL);
                                }
                                retval = su;
                            }
                        }
                        catch (DBException e) {
                            ref = null;
                        }
                    }
                }
            }
            if (from == null) {
                this.m_queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_CANT_FIND_FROM", (Object[])new Object[]{parentName})));
            }
        }
        if (retval == null) {
            String externalColName = bits.remove(0);
            ColumnKeywordUsage fromObjUsage = null;
            if ("*".equals(externalColName)) {
                fromObjUsage = new ColumnKeywordUsage(externalColName, from);
            } else if (from == null) {
                fromObjUsage = this.m_queryBuilder.findColumnInFromObjects(externalColName, true, creating, extraFrom);
                if (fromObjUsage == null) {
                    if (creating instanceof OrderByObject) {
                        for (SelectObject select : this.m_query.getSelectObjects()) {
                            String selectName = select.getUsableAlias();
                            if (selectName == null || !this.m_provider.getDescriptor().areNamesEqual(externalColName, selectName, "COLUMN", true)) continue;
                            this.m_queryBuilder.ensureID((DBObject)select);
                            fromObjUsage = new SelectObjectUsage(select, null);
                            break;
                        }
                    }
                    if (fromObjUsage == null) {
                        this.m_queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_CANT_RESOLVE_COL", (Object[])new Object[]{externalColName})));
                    }
                }
            } else {
                this.m_queryBuilder.ensureID((DBObject)from);
                SQLFragment exp = from.getExpression();
                if (exp instanceof RelationUsage) {
                    fromObjUsage = this.m_queryBuilder.findColumnInRelation(externalColName, true, (RelationUsage)exp);
                    if (fromObjUsage == null) {
                        this.m_queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_NO_COL_ON_REL", (Object[])new Object[]{externalColName, parentName})));
                    }
                } else if (exp instanceof SQLQuery) {
                    SQLQuery sqlQuery = (SQLQuery)exp;
                    fromObjUsage = this.m_queryBuilder.findColumnInSubQuery(externalColName, true, sqlQuery);
                    if (fromObjUsage == null) {
                        fromObjUsage = this.m_queryBuilder.findColumnInStarSubQuery(externalColName, true, from);
                    }
                    if (fromObjUsage == null) {
                        this.m_queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_NO_COL_IN_QUERY", (Object[])new Object[]{externalColName})));
                    }
                } else if (exp instanceof SynonymUsage) {
                    SchemaObject obj = ((SynonymUsage)exp).getReferencedObject();
                    if (obj instanceof Relation) {
                        fromObjUsage = this.m_queryBuilder.findColumnInRelation(externalColName, true, (Relation)obj);
                    }
                    if (fromObjUsage == null) {
                        this.m_queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_NO_COL_ON_SYN", (Object[])new Object[]{externalColName, parentName})));
                    } else {
                        fromObjUsage.setFromObjectID(from.getID());
                    }
                } else {
                    fromObjUsage = this.m_queryBuilder.findColumnInFromExpression(externalColName, true, exp, false, from, creating);
                    if (fromObjUsage == null) {
                        this.m_queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_MISSING_COL", (Object[])new Object[]{externalColName, parentName})));
                    }
                }
            }
            fromObjUsage.setQualified(colindex > 0);
            if (fromObjUsage instanceof ColumnUsage) {
                if (bits.size() > 0) {
                    ((ColumnUsage)fromObjUsage).setAttributes(bits.toArray(new String[bits.size()]));
                }
                if (isOuterJoin) {
                    ((ColumnUsage)fromObjUsage).setOuterJoin(true);
                }
            }
            retval = fromObjUsage;
        }
        return retval;
    }

    private List<String> getBits(ParseNode dotSeparatedListNode) throws SQLQueryException {
        ArrayList<String> bits = new ArrayList<String>();
        if (this.m_helper.isLeaf(dotSeparatedListNode)) {
            bits.add(this.m_helper.getContent(dotSeparatedListNode));
        } else if (this.m_helper.isDotSeperatedList(dotSeparatedListNode)) {
            List<ParseNode> l = this.m_helper.getDotSeparatedList(dotSeparatedListNode);
            for (ParseNode n : l) {
                if (this.m_helper.isLeaf(n)) {
                    bits.add(this.m_helper.getContent(n));
                    continue;
                }
                bits.addAll(this.getBits(n));
            }
        } else {
            String rules = dotSeparatedListNode.toString();
            String sourceFragment = this.m_helper.getSourceFragment(dotSeparatedListNode);
            DBLog.getLogger().log(Level.FINEST, "OracleSQLQueryBuilder: Node cannot be built - Unrecognized SQL fragment\n Rules: " + rules + "\n" + " Source fragment: " + sourceFragment);
            throw new UnrecognizedFragmentException(this.m_helper.getSourceFragment(dotSeparatedListNode));
        }
        return bits;
    }
}

