/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SetOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionBuilder
extends AbstractExpressionBuilder {
    private static Map<String, Comparison.Comparator> s_op_map = new HashMap<String, Comparison.Comparator>();

    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext context, ParseNode node) throws SQLQueryException {
        if (!this.m_helper.isRule(node, "condition")) {
            return null;
        }
        Comparison retval = null;
        List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
        if (this.m_helper.isRule(node, "null_condition")) {
            int notIndex = this.m_helper.getKeywordIndex(kids, "not");
            Comparison.Comparator type = notIndex == -1 ? Comparison.Comparator.NULL : Comparison.Comparator.NOT_NULL;
            SQLFragment operand = this.m_queryBuilder.createFragment(kids.get(0), this.m_creating, this.m_queryContext);
            retval = new Comparison(operand, type, null);
        } else if (this.m_helper.isRule(node, "regexp_like_condition")) {
            SQLFragment[] argsL = this.getArgList(this.m_creating, retval, node);
            retval = new Comparison(Comparison.Comparator.REGEXP_LIKE, argsL);
        } else if (this.m_helper.isRule(node, "like_condition")) {
            SQLFragment lhs = this.m_queryBuilder.createFragment(kids.get(0), this.m_creating, this.m_queryContext);
            SQLFragment rhs = this.m_queryBuilder.createFragment(kids.get(kids.size() - 1), this.m_creating, this.m_queryContext);
            int notIndex = this.m_helper.getKeywordIndex(kids, "not");
            Comparison.Comparator type = notIndex == -1 ? Comparison.Comparator.LIKE : Comparison.Comparator.NOT_LIKE;
            retval = new Comparison(lhs, type, rhs);
        } else if (this.m_helper.isRule(node, "comparison_condition") || this.m_helper.isRule(node, "simple_comparison_condition")) {
            if (this.m_helper.isRule(node, "group_comparison_condition") && (kids.size() == 6 || kids.size() == 7)) {
                Comparison.Comparator operation;
                String op = this.m_helper.getContent(kids.get(1)) + this.m_helper.getContent(kids.get(2));
                int rhs_index = 4;
                if (kids.size() == 7) {
                    op = op + this.m_helper.getContent(kids.get(3));
                    rhs_index = 5;
                }
                if ((operation = this.getOperation(op)) != null) {
                    SQLFragment lhs = this.m_queryBuilder.createFragment(kids.get(0), this.m_creating, null);
                    List<SQLFragment> exprlist = this.getExpressionList(kids.get(rhs_index));
                    ExpressionList rhs = new ExpressionList(exprlist.toArray(new SQLFragment[exprlist.size()]));
                    retval = new Comparison(lhs, operation, (SQLFragment)rhs);
                }
            } else if ((this.m_helper.isRule(node, "comparison_condition") || this.m_helper.isRule(node, "simple_comparison_condition")) && (kids.size() == 4 || kids.size() == 3)) {
                SQLFragment lhs = this.m_queryBuilder.createFragment(kids.get(0), this.m_creating, null);
                boolean priorOnLeft = this.hasPrior(kids.get(0));
                int rhs_index = 2;
                String op = this.m_helper.getContent(kids.get(1));
                if (kids.size() == 4) {
                    op = op + this.m_helper.getContent(kids.get(2));
                    rhs_index = 3;
                }
                SQLFragment rhs = this.m_queryBuilder.createFragment(kids.get(rhs_index), this.m_creating, null);
                boolean priorOnRight = this.hasPrior(kids.get(rhs_index));
                Comparison.Comparator type = this.getOperation(op);
                if (type != null) {
                    retval = new Comparison(lhs, type, rhs);
                    retval.setPriorOnLeft(priorOnLeft);
                    retval.setPriorOnRight(priorOnRight);
                }
            }
        } else if (this.m_helper.isRule(node, "condition")) {
            if (this.m_helper.isRule(node, "in_condition")) {
                SQLFragment[] args = null;
                SQLFragment lhs = null;
                if (this.m_helper.isKeyword(kids.get(0), "(")) {
                    SQLFragment[] lhsSet = this.getExpressionList(kids, 0, this.m_helper.getKeywordIndex(kids, ")"));
                    lhs = new ExpressionList(lhsSet);
                } else {
                    lhs = this.m_queryBuilder.createFragment(kids.get(0), this.m_creating, null);
                }
                boolean isNot = this.m_helper.getKeywordIndex(kids, "not") != -1;
                int inIndex = this.m_helper.getKeywordIndex(kids, "IN");
                int lparenIndex = inIndex + 1;
                int rparenIndex = kids.size() - 1;
                SQLFragment[] rhsSet = this.getExpressionList(kids, lparenIndex, rparenIndex);
                if (rhsSet.length == 1 && rhsSet[0] instanceof ExpressionList) {
                    rhsSet = ((ExpressionList)rhsSet[0]).getArguments();
                }
                args = new SQLFragment[1 + rhsSet.length];
                args[0] = lhs;
                for (int i = 0; i < rhsSet.length; ++i) {
                    args[i + 1] = rhsSet[i];
                }
                SetOperation.Operator in = isNot ? SetOperation.Operator.NOT_IN : SetOperation.Operator.IN;
                retval = new SetOperation(in, args);
            } else if (this.m_helper.isRule(node, "exists_condition")) {
                boolean isNot = "not".equals(this.m_queryContext);
                int existsIndex = this.m_helper.getKeywordIndex(kids, "EXISTS");
                SQLFragment arg = this.m_queryBuilder.createFragment(kids.get(existsIndex + 2), this.m_creating, null);
                Comparison.Comparator exists = isNot ? Comparison.Comparator.NOT_EXISTS : Comparison.Comparator.EXISTS;
                retval = new Comparison(arg, exists);
            } else if (kids.size() == 2 && this.m_helper.isKeyword(kids.get(0), "not")) {
                retval = this.m_queryBuilder.createFragment(kids.get(1), this.m_creating, "not");
            }
        }
        return retval;
    }

    private boolean hasPrior(ParseNode n) {
        boolean retval = false;
        List<ParseNode> kids = this.m_helper.getOrderedChildren(n);
        if (this.m_helper.isRule(n, "compound_expression") && kids.size() == 2 && this.m_helper.isKeyword(kids.get(0), "PRIOR")) {
            retval = true;
        }
        return retval;
    }

    private Comparison.Comparator getOperation(String op) {
        Comparison.Comparator retval = Comparison.getComparator((String)(op = op.toUpperCase()));
        if (retval == null) {
            retval = s_op_map.get(op);
        }
        return retval;
    }

    private SQLFragment[] getExpressionList(List<ParseNode> parenlist, int lparenIndex, int rparenIndex) throws SQLQueryException {
        List<Object> exprlist = new ArrayList();
        SQLFragment[] retval = null;
        if (rparenIndex == lparenIndex + 2 && this.m_helper.isRule(parenlist.get(lparenIndex + 1), "\"expr_list\"")) {
            exprlist = this.getExpressionList(parenlist.get(lparenIndex + 1));
        } else {
            for (int i = lparenIndex + 1; i < rparenIndex; ++i) {
                if (this.m_helper.isKeyword(parenlist.get(i), ",")) continue;
                List<SQLFragment> subexprlist = this.getExpressionList(parenlist.get(i));
                ExpressionList expr = new ExpressionList(subexprlist.toArray(new SQLFragment[subexprlist.size()]));
                exprlist.add(expr);
            }
        }
        retval = exprlist.toArray(new SQLFragment[exprlist.size()]);
        return retval;
    }

    private List<SQLFragment> getExpressionList(ParseNode p) throws SQLQueryException {
        String debug_p_content = this.m_helper.getContent(p);
        ArrayList<SQLFragment> retval = new ArrayList<SQLFragment>();
        if (this.m_helper.isRule(p, "expr") || this.m_helper.isRule(p, "query_block")) {
            SQLFragment expr = this.m_queryBuilder.createFragment(p, this.m_creating, null);
            retval.add(expr);
        } else if (this.m_helper.isRule(p, "expression_list") || this.m_helper.isRule(p, "\"expr_list\"")) {
            List<ParseNode> kids = this.m_helper.getOrderedChildren(p);
            for (ParseNode kid : kids) {
                retval.addAll(this.getExpressionList(kid));
            }
        }
        return retval;
    }

    static {
        s_op_map.put("!=", Comparison.Comparator.NOT_EQUAL);
        s_op_map.put("^=", Comparison.Comparator.NOT_EQUAL);
        s_op_map.put("<>", Comparison.Comparator.NOT_EQUAL);
        s_op_map.put("!=ANY", Comparison.Comparator.NOT_EQUAL_ANY);
        s_op_map.put("^=ANY", Comparison.Comparator.NOT_EQUAL_ANY);
        s_op_map.put("<>ANY", Comparison.Comparator.NOT_EQUAL_ANY);
        s_op_map.put("!=ALL", Comparison.Comparator.NOT_EQUAL_ALL);
        s_op_map.put("^=ALL", Comparison.Comparator.NOT_EQUAL_ALL);
        s_op_map.put("<>ALL", Comparison.Comparator.NOT_EQUAL_ALL);
        s_op_map.put("!=SOME", Comparison.Comparator.NOT_EQUAL_SOME);
        s_op_map.put("^=SOME", Comparison.Comparator.NOT_EQUAL_SOME);
        s_op_map.put("<>SOME", Comparison.Comparator.NOT_EQUAL_SOME);
    }
}

