/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.DataMiningFunction;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SimpleSQLFragment;

public class DataMiningFunctionBuilder
extends AbstractExpressionBuilder {
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext context, ParseNode node) throws SQLQueryException {
        SQLFragment retval = null;
        if (this.m_helper.isRule(node, "data_mining_function")) {
            retval = this.createDataMiningFunction(node);
        }
        return retval;
    }

    private SQLFragment createDataMiningFunction(ParseNode odm) throws SQLQueryException {
        DataMiningFunction retval = null;
        List<ParseNode> kids = this.m_helper.getOrderedChildren(odm);
        String fname = null;
        if (this.m_helper.isLeaf(kids.get(0))) {
            fname = this.m_helper.getContent(kids.get(0));
        }
        if (fname == null) {
            this.m_queryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_UNKNOWN_FUNC", (Object[])new Object[]{fname})));
        }
        fname = fname.toUpperCase();
        int start = 2;
        String modelName = null;
        if (this.m_helper.isLeaf(kids.get(start))) {
            modelName = this.m_helper.getContent(kids.get(start));
            if (this.m_helper.isKeyword(kids.get(++start), ".") && this.m_helper.isLeaf(kids.get(++start))) {
                modelName = modelName + "." + this.m_helper.getContent(kids.get(start));
                ++start;
            }
        }
        ArrayList<SQLFragment> dmSpecificArgs = new ArrayList<SQLFragment>();
        while (!this.m_helper.isRule(kids.get(start), "cost_matrix_clause") && !this.m_helper.isRule(kids.get(start), "mining_attribute_clause")) {
            if (this.m_helper.isKeyword(kids.get(start), ",")) {
                ++start;
                continue;
            }
            SQLFragment arg = null;
            if (this.m_helper.isLeaf(kids.get(start))) {
                String argValue = this.m_helper.getContent(kids.get(start));
                arg = new SimpleSQLFragment(argValue);
            } else {
                arg = this.m_queryBuilder.createFragment(kids.get(start), this.m_creating, null);
            }
            dmSpecificArgs.add(arg);
            ++start;
        }
        SQLFragment[] dmCostArgs = null;
        boolean cost = false;
        if (this.m_helper.isRule(kids.get(start), "cost_matrix_clause")) {
            cost = true;
            dmCostArgs = this.getCost(kids.get(start));
            ++start;
        }
        SQLFragment[] usingArgs = null;
        if (this.m_helper.isRule(kids.get(start), "mining_attribute_clause")) {
            usingArgs = this.getMiningAttributes(fname, kids.get(start));
            ++start;
        }
        retval = new DataMiningFunction(fname, (SQLFragment)new SimpleSQLFragment(modelName), dmCostArgs, dmSpecificArgs.toArray(new SQLFragment[dmSpecificArgs.size()]), usingArgs);
        return retval;
    }

    private SQLFragment[] getCost(ParseNode node) throws SQLQueryException {
        SQLFragment[] retval = null;
        List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
        boolean start = true;
        if (kids.size() == 2 && this.m_helper.isKeyword(kids.get(1), "MODEL")) {
            retval = new SQLFragment[]{new SimpleSQLFragment("MODEL")};
        } else if (kids.size() == 3 && this.m_helper.isKeyword(kids.get(1), "MODEL") && this.m_helper.isKeyword(kids.get(2), "AUTO")) {
            retval = new SQLFragment[]{new SimpleSQLFragment("AUTO")};
        } else {
            int rparenx = this.m_helper.getKeywordIndex(kids, ")");
            SQLFragment[] costClassValues = this.getArgList(this.m_creating, null, kids, 2, rparenx);
            DataMiningFunction.DataMiningCostValues values = new DataMiningFunction.DataMiningCostValues(costClassValues);
            ArrayList<DataMiningFunction.DataMiningCostValues> cvMatrix = new ArrayList<DataMiningFunction.DataMiningCostValues>();
            cvMatrix.add(values);
            int lparenx = this.m_helper.getKeywordIndex(kids, "VALUES") + 2;
            while (lparenx != -1) {
                rparenx = this.m_helper.getKeywordIndex(kids, lparenx, ")");
                SQLFragment[] costValues = this.getArgList(this.m_creating, null, kids, lparenx + 1, rparenx);
                values = new DataMiningFunction.DataMiningCostValues(costValues);
                cvMatrix.add(values);
                lparenx = this.m_helper.getKeywordIndex(kids, rparenx, "(");
            }
            retval = cvMatrix.toArray(new DataMiningFunction.DataMiningCostValues[cvMatrix.size()]);
        }
        return retval;
    }

    private SQLFragment[] getMiningAttributes(Object func, ParseNode mac) throws SQLQueryException {
        SQLFragment[] retval = null;
        List<ParseNode> kids = this.m_helper.getOrderedChildren(mac);
        int start = 1;
        retval = this.getArgList(this.m_creating, func, kids, start, kids.size());
        return retval;
    }
}

