/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SimpleSQLFragment;

public class LiteralBuilder
extends AbstractExpressionBuilder {
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext context, ParseNode node) throws SQLQueryException {
        List<ParseNode> kids;
        SimpleSQLFragment retval = null;
        if (this.m_helper.isRule(node, "literal")) {
            String number = this.m_helper.getContent(node);
            retval = new SimpleSQLFragment(number);
        } else if (this.m_helper.isLeaf(node)) {
            if (this.m_helper.isKeyword(node, "ROWNUM", "ROWID", "USER", "LEVEL", "SYSDATE", "CURRENT_DATE", "CURRENT_TIMESTAMP", "LOCALTIMESTAMP", "SYSTIMESTAMP", "BINARY_FLOAT_NAN", "BINARY_FLOAT_INFINITY", "BINARY_DOUBLE_NAN", "BINARY_DOUBLE_INFINITY", "null")) {
                retval = new SimpleSQLFragment(this.m_helper.getContent(node).toUpperCase());
            } else if (this.m_helper.isRule(node, "identifier") && !this.m_helper.isRule(node, "column") || this.m_helper.isRule(node, "identifier") && this.m_helper.isRule(node, "column") && context.getQueryContext() instanceof String && "MAKE_REF".equalsIgnoreCase((String)context.getQueryContext())) {
                String text = this.m_helper.getContent(node);
                retval = new SimpleSQLFragment(text);
            } else {
                String text = this.m_helper.getContent(node);
                if (text != null && (text.startsWith("'") || Character.isDigit(text.charAt(0)))) {
                    retval = new SimpleSQLFragment(text);
                }
            }
        } else if (this.m_helper.isRule(node, "bind_var") && (kids = this.m_helper.getOrderedChildren(node)).size() == 2 && this.m_helper.isKeyword(kids.get(0), ":") && this.m_helper.isRule(kids.get(1), "identifier")) {
            String text = this.m_helper.getContent(node);
            retval = new SimpleSQLFragment(text);
            if (context.getQuery().getParent() instanceof Relation && text.startsWith(":")) {
                context.getQueryBuilder().addClauseException(new SQLQueryClauseException((SQLFragment)retval, APIBundle.format((String)"SQL_BIND_VAR", (Object[])new Object[]{text})));
            }
        }
        return retval;
    }
}

