/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.ModelObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBuilder
extends AbstractExpressionBuilder {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext context, ParseNode node) throws SQLQueryException {
        ModelObject retval = null;
        if (this.m_helper.isRule(node, "model_clause")) {
            ModelObject model = new ModelObject();
            List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
            for (int i = 1; i < kids.size(); ++i) {
                ParseNode child = kids.get(i);
                if (this.m_helper.isRule(child, "cell_reference_options")) {
                    ModelObject.CellReferenceOptions cellReferenceOptions = this.buildCellReferenceOptions(child);
                    model.setCellReferenceOptions(cellReferenceOptions);
                    continue;
                }
                if (this.m_helper.isRule(child, "return_rows_clause")) {
                    this.addReturnRowsClause(model, child);
                    continue;
                }
                if (this.m_helper.isRule(child, "reference_model")) {
                    this.addReferenceModel(model, child);
                    continue;
                }
                if (!this.m_helper.isRule(child, "main_model")) continue;
                this.addMainModel(model, child);
                break;
            }
            retval = model;
        }
        return retval;
    }

    private ModelObject.CellReferenceOptions buildCellReferenceOptions(ParseNode node) {
        ModelObject.CellReferenceOptions cellReferenceOptions = new ModelObject.CellReferenceOptions();
        for (ParseNode child : this.m_helper.getOrderedChildren(node)) {
            if (this.m_helper.isKeyword(child, "IGNORE")) {
                cellReferenceOptions.setIgnoreNav(true);
                continue;
            }
            if (this.m_helper.isKeyword(child, "KEEP")) {
                cellReferenceOptions.setKeepNav(true);
                continue;
            }
            if (this.m_helper.isKeyword(child, "DIMENSION")) {
                cellReferenceOptions.setUniqueDimension(true);
                continue;
            }
            if (!this.m_helper.isKeyword(child, "SINGLE")) continue;
            cellReferenceOptions.setUniqueSingleReference(true);
        }
        return cellReferenceOptions;
    }

    private void addReturnRowsClause(ModelObject model, ParseNode node) {
        List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
        if (this.m_helper.isKeyword(kids.get(1), "UPDATED")) {
            model.setReturnUpdatedRows(true);
        } else if (this.m_helper.isKeyword(kids.get(1), "ALL")) {
            model.setReturnAllRows(true);
        }
    }

    private void addReferenceModel(ModelObject model, ParseNode node) throws SQLQueryException {
        throw new SQLQueryException("Cant handle reference_model clause");
    }

    private void addMainModel(ModelObject model, ParseNode node) throws SQLQueryException {
        List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
        int i = 0;
        if (this.m_helper.isKeyword(kids.get(i), "MAIN")) {
            String mainModelName = this.m_helper.getContent(kids.get(i + 1));
            model.setMainModelName(mainModelName);
            i += 2;
        }
        this.addModelColumnClauses(model, kids.get(i));
        if (this.m_helper.isRule(kids.get(++i), "cell_reference_options")) {
            ModelObject.CellReferenceOptions cellReferenceOptions = this.buildCellReferenceOptions(kids.get(i));
            ++i;
            model.setMainModelCellReferenceOptions((SQLFragment)cellReferenceOptions);
        }
        this.addModelRulesClause(model, kids.get(i));
    }

    private void addModelColumnClauses(ModelObject model, ParseNode node) throws SQLQueryException {
        ModelObject.ModelColumnClauses modelColumnClauses = new ModelObject.ModelColumnClauses();
        List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
        Object pes = null;
        if (this.m_helper.isKeyword(kids.get(0), "PARTITION")) {
            SQLFragment partitionBy = this.m_queryBuilder.createFragment(kids.get(2), null, null);
            modelColumnClauses.setPartitionByExpressionList(partitionBy);
        }
        int i = this.m_helper.getKeywordIndex(kids, "DIMENSION");
        SQLFragment dimensionBy = this.buildExpressionList(kids, i + 2);
        modelColumnClauses.setDimensionByExpressionList(dimensionBy);
        i = this.m_helper.getKeywordIndex(kids, "MEASURES");
        SQLFragment measures = this.buildExpressionList(kids, i + 1);
        modelColumnClauses.setMeasuresExpressionList(measures);
        model.setModelColumnClauses((SQLFragment)modelColumnClauses);
    }

    private SQLFragment buildExpressionList(List<ParseNode> kids, int start) throws SQLQueryException {
        int rparenIndex = this.m_helper.getKeywordIndex(kids, start, ")");
        List<List<ParseNode>> pes = this.m_helper.getCommaSeparatedList(kids.subList(start + 1, rparenIndex));
        ExpressionList retval = this.createExpressionList(pes, null);
        return retval;
    }

    private void addModelRulesClause(ModelObject model, ParseNode node) throws SQLQueryException {
        List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
        ModelObject.ModelRulesClause rulesClause = new ModelObject.ModelRulesClause();
        int i = 0;
        if (this.m_helper.isKeyword(kids.get(i), "RULES")) {
            rulesClause.setRulesPresent(true);
            if (this.m_helper.isKeyword(kids.get(++i), "UPDATE")) {
                ++i;
                rulesClause.setRulesUpdate(true);
            } else if (this.m_helper.isKeyword(kids.get(i), "UPSERT")) {
                rulesClause.setRulesUpsert(true);
                if (this.m_helper.isKeyword(kids.get(++i), "ALL")) {
                    ++i;
                    rulesClause.setRulesAll(true);
                }
            }
            if (this.m_helper.isKeyword(kids.get(i), "AUTOMATIC")) {
                i += 2;
                rulesClause.setAutomatic(true);
                rulesClause.setOrder(true);
            } else if (this.m_helper.isKeyword(kids.get(i), "SEQUENTIAL")) {
                i += 2;
                rulesClause.setSequential(true);
                rulesClause.setOrder(true);
            }
            if (this.m_helper.isRule(kids.get(i), "model_iterate_clause")) {
                List<ParseNode> iterKids = this.m_helper.getOrderedChildren(kids.get(i));
                ++i;
                String iterNumber = this.m_helper.getContent(iterKids.get(2));
                rulesClause.setIterateNumber(iterNumber);
                if (iterKids.size() > 5 && this.m_helper.isKeyword(iterKids.get(4), "UNTIL")) {
                    SQLFragment untilCond = this.m_queryBuilder.createFragment(iterKids.get(6), (SQLFragment)model, null);
                    rulesClause.setUntilCondition(untilCond);
                }
            }
        }
        ArrayList<ModelObject.ModelRulesCellAssignmentExpr> elist = new ArrayList<ModelObject.ModelRulesCellAssignmentExpr>();
        while (!this.m_helper.isKeyword(kids.get(i), ")")) {
            if (!this.m_helper.isKeyword(kids.get(i), "(", ",")) {
                throw new SQLQueryException("Failed to find expected '(' or ',' in model_rules_clause");
            }
            ModelObject.ModelRulesCellAssignmentExpr mrcaExpr = new ModelObject.ModelRulesCellAssignmentExpr();
            if (this.m_helper.isKeyword(kids.get(++i), "UPDATE")) {
                ++i;
                mrcaExpr.setUpdate(true);
            } else if (this.m_helper.isKeyword(kids.get(i), "UPSERT")) {
                mrcaExpr.setUpsert(true);
                if (this.m_helper.isKeyword(kids.get(++i), "ALL")) {
                    ++i;
                    mrcaExpr.setAll(true);
                }
            }
            SQLFragment cellAssignment = this.m_queryBuilder.createFragment(kids.get(i), this.m_creating, null);
            mrcaExpr.setModelRulesCellAssignment(cellAssignment);
            if (this.m_helper.isKeyword(kids.get(++i), "=")) {
                ++i;
            } else {
                SQLFragment orderBy = this.m_queryBuilder.createFragment(kids.get(i), this.m_creating, null);
                if (orderBy == null) {
                    throw new SQLQueryException("Failed to find expected order_by_clause in model_rules_clause");
                }
                mrcaExpr.setOrderBy(orderBy);
                i += 2;
            }
            SQLFragment expr = this.m_queryBuilder.createFragment(kids.get(i), this.m_creating, null);
            if (expr == null) {
                throw new SQLQueryException("Failed to find expected expr in model_rules_clause");
            }
            ++i;
            mrcaExpr.setExpr(expr);
            elist.add(mrcaExpr);
        }
        ExpressionList cellAssignmentExprs = new ExpressionList(elist.toArray(new SQLFragment[elist.size()]));
        rulesClause.setCellAssignmentExprs(cellAssignmentExprs);
        model.setModelRulesClause((SQLFragment)rulesClause);
    }
}

