/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.ora.sql.Keywords;
import oracle.javatools.db.ora.sql.ParserRules;
import oracle.javatools.db.ora.sql.SqlUsageUtil;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleSQLQueryBuilderHelper
implements Keywords,
ParserRules {
    private static final String KW_DOT = ".";
    private String m_source;
    private List<LexerToken> m_lexerTokens;
    private Earley m_grammar;
    private SqlEarley m_earleyInstance;
    private ParseNode m_parseRoot;
    private Matrix m_matrix;

    private OracleSQLQueryBuilderHelper(Earley grammar, Matrix matrix, List<LexerToken> lexerTokens, String source) {
        this.m_source = source;
        this.m_lexerTokens = lexerTokens;
        this.m_grammar = grammar;
        this.m_matrix = matrix;
    }

    public int getTokenStartOffset(int token) {
        return this.m_lexerTokens.get((int)token).begin;
    }

    public int getTokenEndOffset(int token) {
        return this.m_lexerTokens.get((int)token).end;
    }

    public int getNodeStartOffset(ParseNode node) {
        return this.m_lexerTokens.get((int)node.from).begin;
    }

    public int getNodeEndOffset(ParseNode node) {
        int to = node.to;
        return this.m_lexerTokens.get((int)(to - 1)).end - 1;
    }

    public String getSourceFragment(int start, int end) {
        String retval = "";
        if (ModelUtil.hasLength((String)this.m_source)) {
            if (start < 0) {
                start = 0;
            }
            if (end > this.m_source.length()) {
                end = this.m_source.length() - 1;
            }
            if (end >= start) {
                retval = this.m_source.substring(start, end + 1);
            }
        }
        return retval;
    }

    public String getSourceFragment(ParseNode node) {
        int startOffset = this.getNodeStartOffset(node);
        int endOffset = this.getNodeEndOffset(node);
        return this.getSourceFragment(startOffset, endOffset);
    }

    public String getContent(ParseNode node) {
        String retval = null;
        if (node != null) {
            retval = this.isLeaf(node) ? this.m_lexerTokens.get((int)node.from).content : this.getSourceFragment(node);
        }
        return retval;
    }

    public String getContentType(ParseNode node) {
        String retval = null;
        if (this.isLeaf(node)) {
            retval = this.m_lexerTokens.get((int)node.from).type.toString();
        }
        return retval;
    }

    public List<ParseNode> getLeftAndRight(ParseNode node) {
        ArrayList<ParseNode> result = new ArrayList<ParseNode>();
        Set kids = node.children();
        int low = Integer.MAX_VALUE;
        ParseNode first = null;
        ParseNode second = null;
        for (ParseNode kid : kids) {
            if (kid.from < low) {
                if (first != null) {
                    second = first;
                }
                first = kid;
                low = kid.from;
                continue;
            }
            second = kid;
        }
        result.add(0, first);
        result.add(1, second);
        return result;
    }

    public List<ParseNode> getKeywordExpr(ParseNode node, String keywords) {
        ArrayList<ParseNode> result = null;
        ParseNode otherNode = null;
        ParseNode kwNode = null;
        Set kids = node.children();
        for (ParseNode kid : kids) {
            if (this.isKeyword(kid, keywords)) {
                kwNode = kid;
                continue;
            }
            otherNode = kid;
        }
        if (kwNode != null) {
            result = new ArrayList<ParseNode>();
            result.add(0, kwNode);
            result.add(1, otherNode);
        }
        return result;
    }

    public List<ParseNode> getOrderedChildren(ParseNode node) {
        ArrayList<ParseNode> result = new ArrayList<ParseNode>();
        if (node != null) {
            Set kids = node.children();
            if (kids.size() == 0) {
                result.add(node);
            } else {
                for (ParseNode kid : kids) {
                    if (this.isRule(kid)) {
                        result.add(kid);
                        continue;
                    }
                    result.addAll(this.getOrderedChildren(kid));
                }
            }
        }
        return result;
    }

    public int getRuleIndex(List<ParseNode> nodes, String rule) {
        int result = -1;
        for (int i = 0; i < nodes.size(); ++i) {
            if (!this.isRule(nodes.get(i), rule)) continue;
            result = i;
            break;
        }
        return result;
    }

    public List<ParseNode> findRuleNodes(ParseNode start, String ... rule) {
        List<ParseNode> result = Collections.emptyList();
        List kids = start.descendants();
        if (kids != null) {
            for (ParseNode kid : kids) {
                if (!this.isRule(kid, rule)) continue;
                if (result.size() == 0) {
                    result = new ArrayList<ParseNode>();
                }
                result.add(kid);
            }
        }
        return result;
    }

    public ParseNode getRuleNode(List<ParseNode> nodes, String rule) {
        ParseNode result = null;
        int index = this.getRuleIndex(nodes, rule);
        if (index >= 0) {
            result = nodes.get(index);
        }
        return result;
    }

    public boolean isRule(ParseNode node) {
        boolean result = false;
        for (int i : node.content()) {
            String rule = this.m_grammar.allSymbols[i];
            if (rule.indexOf("[") > 0) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isRule(ParseNode node, String ... rules) {
        boolean result = false;
        if (node != null) {
            block0: for (String rule : rules) {
                for (int i : node.content()) {
                    if (i < 0 || !rule.equals(this.m_grammar.allSymbols[i])) continue;
                    result = true;
                    continue block0;
                }
            }
        }
        return result;
    }

    public boolean isRule(ParseNode node, List<String> rules) {
        boolean result = false;
        for (String rule : rules) {
            if (!this.isRule(node, rule)) continue;
            result = true;
            break;
        }
        return result;
    }

    public int getKeywordIndex(List<ParseNode> nodes, String ... keywords) {
        return this.getKeywordIndex(nodes, 0, keywords);
    }

    public int getKeywordIndex(List<ParseNode> nodes, int start, String ... keywords) {
        int result = -1;
        for (int i = start; i < nodes.size(); ++i) {
            if (!this.isKeyword(nodes.get(i), keywords)) continue;
            result = i;
            break;
        }
        return result;
    }

    public boolean isKeyword(ParseNode node, String ... keywords) {
        boolean result = false;
        Set kids = node.children();
        if (kids.size() == 0) {
            String keyword;
            String token = this.m_lexerTokens.get((int)node.from).content;
            String[] arr$ = keywords;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(result = (keyword = arr$[i$]).equalsIgnoreCase(token)); ++i$) {
            }
        }
        return result;
    }

    public boolean isOperation(ParseNode node) {
        boolean result = this.isKeyword(node, "+", "-");
        return result;
    }

    public boolean isLeaf(ParseNode node) {
        boolean result = node.children().isEmpty();
        return result;
    }

    public List<List<ParseNode>> getCommaSeparatedList(ParseNode node) {
        List<List<ParseNode>> result = new ArrayList<List<ParseNode>>();
        if (this.isDotSeperatedList(node) || this.isRule(node, "expr")) {
            ArrayList<ParseNode> kid = new ArrayList<ParseNode>();
            kid.add(node);
            result.add(kid);
        } else {
            int lpx;
            List<ParseNode> kids = this.getOrderedChildren(node);
            if (kids.size() > 0 && (lpx = this.getKeywordIndex(kids, "(")) > 0 && this.isKeyword(kids.get(kids.size() - 1), ")")) {
                kids = kids.subList(lpx + 1, kids.size() - 1);
            }
            result = this.getCommaSeparatedList(kids);
        }
        return result;
    }

    public List<ParseNode> flattenListTree(String listRule, ParseNode tree) {
        ArrayList<ParseNode> retval = new ArrayList<ParseNode>();
        List<ParseNode> kids = this.getOrderedChildren(tree);
        if (this.isRule(tree, listRule) && kids.size() == 3 && this.isKeyword(kids.get(1), ",")) {
            retval.addAll(this.flattenListTree(listRule, kids.get(0)));
            retval.add(kids.get(1));
            retval.addAll(this.flattenListTree(listRule, kids.get(2)));
        } else {
            retval.add(tree);
        }
        return retval;
    }

    public List<List<ParseNode>> getCommaSeparatedList(List<ParseNode> nodes) {
        if (nodes.size() == 1 && this.isRule(nodes.get(0), "\"expr_list\"")) {
            nodes = this.flattenListTree("\"expr_list\"", nodes.get(0));
        }
        ArrayList<List<ParseNode>> result = new ArrayList<List<ParseNode>>();
        int commaIndex = this.getKeywordIndex(nodes, ",");
        if (commaIndex == -1) {
            result.add(nodes);
        } else {
            ArrayList<ParseNode> element = new ArrayList<ParseNode>();
            for (int i = 0; i < nodes.size(); ++i) {
                if (this.isKeyword(nodes.get(i), ",")) {
                    result.add(element);
                    element = new ArrayList();
                    continue;
                }
                element.add(nodes.get(i));
            }
            result.add(element);
        }
        return result;
    }

    public boolean isDotSeperatedList(List<ParseNode> l) {
        int dotIndex = this.getKeywordIndex(l, KW_DOT);
        int lparenIndex = this.getKeywordIndex(l, "(");
        return dotIndex > 0 && lparenIndex == -1;
    }

    public boolean isDotSeperatedList(ParseNode node) {
        List<ParseNode> kids = this.getOrderedChildren(node);
        return this.isDotSeperatedList(kids);
    }

    public List<ParseNode> getDotSeparatedList(ParseNode node) {
        List<ParseNode> kids = this.getOrderedChildren(node);
        ArrayList<ParseNode> result = new ArrayList<ParseNode>();
        int dotIndex = this.getKeywordIndex(kids, KW_DOT);
        if (dotIndex == -1) {
            result.add(node);
        } else {
            result = this.getDotSeparatedList(kids);
        }
        return result;
    }

    public List<ParseNode> getDotSeparatedList(List<ParseNode> nodes) {
        ArrayList<ParseNode> result = new ArrayList();
        int dotIndex = this.getKeywordIndex(nodes, KW_DOT);
        if (dotIndex == -1) {
            result = nodes;
        } else {
            for (int i = 0; i < nodes.size(); ++i) {
                if (this.isKeyword(nodes.get(i), KW_DOT)) continue;
                result.add(nodes.get(i));
            }
        }
        return result;
    }

    public String getRule(int i) {
        return this.m_earleyInstance.allSymbols[i];
    }

    private void setEarleyInstance(SqlEarley earleyInstance) {
        this.m_earleyInstance = earleyInstance;
    }

    public List<LexerToken> getLexerTokens() {
        return this.m_lexerTokens;
    }

    public ParseNode getRaptorRoot() {
        return this.m_parseRoot;
    }

    public SyntaxError getSyntaxError() {
        String[] grammarSymbols = new String[]{"sql_statements", "subprg_body"};
        SyntaxError retval = SyntaxError.checkSyntax((String)this.m_source, (String[])grammarSymbols, this.m_lexerTokens, (Earley)this.m_earleyInstance, (Matrix)this.m_matrix);
        return retval;
    }

    @Deprecated
    public ParseNode getRaptorRoot(String sql) {
        return this.m_parseRoot;
    }

    private void setRaptorRoot(ParseNode parseRoot) {
        this.m_parseRoot = parseRoot;
    }

    public ParseNode getNodeAtOffset(int offset) {
        return this.getNodeAtOffset(this.m_parseRoot, offset);
    }

    private ParseNode getNodeAtOffset(ParseNode node, int offset) {
        if (node == null || this.getNodeStartOffset(node) == offset) {
            return node;
        }
        for (ParseNode child : node.children()) {
            if (this.getNodeStartOffset(child) > offset || this.getNodeEndOffset(child) < offset) continue;
            return this.getNodeAtOffset(child, offset);
        }
        return null;
    }

    void checkErrors(ParseNode root, String sql) throws SQLParseException {
        Set tls = root.topLevel;
        if (tls != null) {
            OracleSQLQueryBuilderHelper.checkErrors(this.getSyntaxError(), sql);
        }
    }

    private static void checkErrors(SyntaxError syntaxError, String sql) throws SQLParseException {
        if (syntaxError != null) {
            String errmess = syntaxError.getMessage();
            int solOffset = syntaxError.offset;
            int line = 0;
            for (int i = 0; i < sql.lastIndexOf(10) && line != syntaxError.line; ++i) {
                if (sql.charAt(i) == '\n') {
                    ++line;
                }
                ++solOffset;
            }
            StringBuilder sugbuf = null;
            String[] suggestions = syntaxError.getSuggestions();
            for (int i = 0; i < 3 && i < suggestions.length; ++i) {
                String suggestion = suggestions[i];
                if (i == 0) {
                    sugbuf = new StringBuilder(suggestion);
                    continue;
                }
                sugbuf.append(',').append(suggestion);
            }
            String sugg = sugbuf == null ? "" : sugbuf.toString();
            SQLParseException.ParseError err = new SQLParseException.ParseError(solOffset, errmess, sugg);
            throw new SQLParseException(new SQLParseException.ParseError[]{err}, sql);
        }
    }

    public static void checkSyntax(String sql) throws SQLParseException {
        SyntaxError err = SyntaxError.checkSQLQuerySyntax((String)sql);
        if (err != null) {
            OracleSQLQueryBuilderHelper.checkErrors(err, sql);
        }
    }

    public static OracleSQLQueryBuilderHelper getFullHelper(String sql) {
        SqlEarley earley = SqlEarley.fullRecognizer();
        Matrix matrix = new Matrix((Parser)earley);
        List lexerTokens = LexerToken.parse((String)sql);
        earley.parse(lexerTokens, matrix);
        ParseNode parseRoot = earley.forest(lexerTokens, matrix);
        OracleSQLQueryBuilderHelper helper = new OracleSQLQueryBuilderHelper((Earley)earley, matrix, lexerTokens, sql);
        helper.setRaptorRoot(parseRoot);
        helper.setEarleyInstance(earley);
        return helper;
    }

    public static OracleSQLQueryBuilderHelper getHelper(String sql) {
        SqlEarley earleyInstance = OracleSQLQueryBuilderHelper.getEarleyInstance();
        Matrix matrix = new Matrix((Parser)earleyInstance);
        List lexerTokens = LexerToken.parse((String)sql);
        earleyInstance.parse(lexerTokens, matrix);
        ParseNode parseRoot = earleyInstance.forest(lexerTokens, matrix);
        OracleSQLQueryBuilderHelper helper = new OracleSQLQueryBuilderHelper((Earley)earleyInstance, matrix, lexerTokens, sql);
        helper.setRaptorRoot(parseRoot);
        helper.setEarleyInstance(earleyInstance);
        Logger logger = DBLog.getLogger(OracleSQLQueryBuilderHelper.class);
        if (logger.isLoggable(Level.FINEST)) {
            StringWriter writer = new StringWriter();
            helper.print(parseRoot, 0, "0", new PrintWriter((Writer)writer, true));
            logger.finest(writer.toString());
        }
        return helper;
    }

    private static SqlEarley getEarleyInstance() {
        SqlEarley retval = null;
        try {
            Class<?> EarleyClass = Class.forName("oracle.dbtools.parser.plsql.SqlEarley");
            try {
                Method getInstanceMethod = EarleyClass.getMethod("getInstance", new Class[0]);
                retval = (SqlEarley)getInstanceMethod.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (retval == null) {
                retval = SqlEarley.getInstance();
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return retval;
    }

    void print(ParseNode node, int depth, String para, PrintWriter out) {
        List<ParseNode> kids = this.getOrderedChildren(node);
        int kidCount = kids.size();
        boolean isLeaf = node.children().size() == 0;
        String topCount = node.topLevel == null ? "<null>" : String.valueOf(node.topLevel.size());
        int[] content = node.content();
        String childCount = content == null ? "<null>" : "" + String.valueOf(content.length);
        StringBuilder pb = new StringBuilder();
        pb.append(para).append(" ").append(isLeaf ? "Leaf" : kidCount + " children. ").append(" topCount=").append(topCount).append(" childCount=").append(childCount).append(" ::");
        if (isLeaf) {
            boolean isReservedWord = this.isKeyword(node, SqlUsageUtil.RESERVED_WORDS);
            LexerToken lexerTok = this.m_lexerTokens.get(node.from);
            pb.append("  ").append((Object)(isReservedWord ? "RESERVED_WORD" : lexerTok.type)).append(" ").append(lexerTok.content);
        }
        out.println(pb.toString());
        StringBuilder indentB = new StringBuilder();
        for (int i = 0; i <= para.length(); ++i) {
            indentB.append(" ");
        }
        String indent = indentB.toString();
        StringBuilder rules = new StringBuilder("rules...");
        boolean hasRules = false;
        for (int i : content) {
            String rule;
            if (i < 0 || (rule = this.getRule(i)).indexOf("[") > 0) continue;
            hasRules = true;
            rules.append("  " + rule);
        }
        if (node.isAuxiliary()) {
            rules.append("  - Auxillary");
        }
        if (hasRules) {
            out.println(indent + rules.toString());
        }
        out.println(indent + this.getContent(node));
        if (!isLeaf) {
            int subpara = 0;
            for (ParseNode kid : kids) {
                this.print(kid, depth + 1, para + KW_DOT + subpara++, out);
            }
        }
    }
}

