/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

public class OrderByBuilder
extends AbstractExpressionBuilder {
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext context, ParseNode node) throws SQLQueryException {
        ExpressionList retval = null;
        if (this.m_helper.isRule(node, "order_by_clause")) {
            ExpressionList orderBy = new ExpressionList();
            boolean siblings = false;
            String siblingsText = null;
            List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
            String orderText = this.m_helper.getContent(kids.get(0));
            int i = 1;
            if (this.m_helper.isKeyword(kids.get(1), "SIBLINGS")) {
                siblings = true;
                siblingsText = this.m_helper.getContent(kids.get(1));
                ++i;
            }
            String by = this.m_helper.getContent(kids.get(i));
            List<List<ParseNode>> components = this.m_helper.getCommaSeparatedList(kids.subList(++i, kids.size()));
            for (List<ParseNode> component : components) {
                OrderByObject orderByObject = new OrderByObject();
                SQLFragment exp = this.m_queryBuilder.createFragment(component.get(0), (SQLFragment)orderByObject, this.m_queryContext);
                orderByObject.setExpression(exp);
                String ascDescText = null;
                String nullsText = null;
                String firstLastText = null;
                for (int ic = 1; ic < component.size(); ++ic) {
                    if (this.m_helper.isKeyword(component.get(ic), "ASC")) {
                        ascDescText = this.m_helper.getContent(component.get(ic));
                        continue;
                    }
                    if (this.m_helper.isKeyword(component.get(ic), "DESC")) {
                        ascDescText = this.m_helper.getContent(component.get(ic));
                        continue;
                    }
                    if (this.m_helper.isKeyword(component.get(ic), "NULLS")) {
                        nullsText = this.m_helper.getContent(component.get(ic));
                        continue;
                    }
                    if (this.m_helper.isKeyword(component.get(ic), "FIRST")) {
                        firstLastText = this.m_helper.getContent(component.get(ic));
                        continue;
                    }
                    if (!this.m_helper.isKeyword(component.get(ic), "LAST")) continue;
                    firstLastText = this.m_helper.getContent(component.get(ic));
                }
                if (ModelUtil.hasLength(ascDescText)) {
                    orderByObject.setOrder(ascDescText);
                }
                if (ModelUtil.hasLength(firstLastText)) {
                    orderByObject.setNullOrdering(nullsText + " " + firstLastText);
                }
                orderBy.addArgument((SQLFragment)orderByObject);
            }
            retval = orderBy;
        }
        return retval;
    }
}

