/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class PartitionByBuilder
extends AbstractExpressionBuilder {
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext context, ParseNode node) throws SQLQueryException {
        String debug_node_content = this.m_helper.getContent(node);
        ExpressionList retval = null;
        if (this.m_helper.isRule(node, "query_partition_clause") || this.m_helper.isRule(node, "model_column_clauses")) {
            retval = this.processQueryPartitionClause(node, this.m_queryContext instanceof FromObject ? (FromObject)this.m_queryContext : null);
        }
        return retval;
    }

    private ExpressionList processQueryPartitionClause(ParseNode queryPartitionNode, FromObject from) throws SQLQueryException {
        ExpressionList retval = null;
        List<ParseNode> kids = this.m_helper.getOrderedChildren(queryPartitionNode);
        List<List<ParseNode>> pes = null;
        if (kids.size() == 3 && this.m_helper.isRule(kids.get(2), "compound_expression")) {
            pes = this.getCompoundExpression(kids, 2);
        } else {
            int first = 2;
            int last = kids.size();
            if (this.m_helper.isKeyword(kids.get(2), "(") && this.m_helper.isKeyword(kids.get(last - 1), ")")) {
                first = 3;
                --last;
            }
            pes = this.m_helper.getCommaSeparatedList(kids.subList(first, last));
        }
        retval = this.createExpressionList(pes, (SQLFragment)from);
        return retval;
    }
}

