/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class RelationalPropertiesBuilder
extends AbstractExpressionBuilder {
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext context, ParseNode node) throws SQLQueryException {
        Comparison retval = null;
        if (this.m_helper.isRule(node, "relational_properties")) {
            Comparison.Comparator type = null;
            List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
            if (kids.size() == 3) {
                if (this.m_helper.isKeyword(kids.get(1), "is")) {
                    if (this.m_helper.isLeaf(kids.get(2))) {
                        if (this.m_helper.isKeyword(kids.get(2), "null")) {
                            type = Comparison.Comparator.NULL;
                        }
                    } else {
                        List<ParseNode> kidskids = this.m_helper.getOrderedChildren(kids.get(2));
                        if (kidskids.size() == 2 && this.m_helper.isLeaf(kidskids.get(0)) && this.m_helper.isLeaf(kidskids.get(1)) && this.m_helper.isKeyword(kidskids.get(0), "not") && this.m_helper.isKeyword(kidskids.get(1), "null")) {
                            type = Comparison.Comparator.NOT_NULL;
                        }
                    }
                }
                if (type != null) {
                    SQLFragment operand = this.m_queryBuilder.createFragment(kids.get(0), this.m_creating, this.m_queryContext);
                    retval = new Comparison(operand, type, null);
                }
            }
        }
        return retval;
    }
}

