/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.ModelObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class SingleColumnForLoopBuilder
extends AbstractExpressionBuilder {
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext context, ParseNode node) throws SQLQueryException {
        ModelObject.SingleColumnForLoop retval = null;
        if (this.m_helper.isRule(node, "single_column_for_loop")) {
            ModelObject.SingleColumnForLoop singleColumnForLoop = new ModelObject.SingleColumnForLoop();
            List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
            String measureColumn = this.m_helper.getContent(kids.get(0));
            String dimensionColumn = this.m_helper.getContent(kids.get(1));
            singleColumnForLoop.setDimensionColumn(dimensionColumn);
            if (this.m_helper.isKeyword(kids.get(2), "IN")) {
                SQLFragment[] inArgs = this.getArgList(this.m_creating, null, node);
                ExpressionList inExpressionList = new ExpressionList(inArgs);
                singleColumnForLoop.setInExpressionList(inExpressionList);
            } else {
                int i = 2;
                if (this.m_helper.isKeyword(kids.get(i), "LIKE")) {
                    String pattern = this.m_helper.getContent(kids.get(i + 1));
                    i += 2;
                    singleColumnForLoop.setLikePattern(pattern);
                }
                String fromLiteral = this.m_helper.getContent(kids.get(i + 1));
                singleColumnForLoop.setFromLiteral(fromLiteral);
                String toLiteral = this.m_helper.getContent(kids.get(i + 3));
                singleColumnForLoop.setToLiteral(toLiteral);
                String literal = this.m_helper.getContent(kids.get(i + 5));
                if (this.m_helper.isKeyword(kids.get(i + 4), "INCREMENT")) {
                    singleColumnForLoop.setIncrementLiteral(literal);
                } else {
                    singleColumnForLoop.setDecrementLiteral(literal);
                }
            }
            retval = singleColumnForLoop;
        }
        return retval;
    }
}

