/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.sql.SqlAliasExpander;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlUsageUtil
implements SqlAliasExpander {
    private static final String RULE_TABLE_REFERENCE = "table_reference";
    private static final String RULE_INSERT_INTO_CLAUSE = "insert_into_clause";
    private static final String RULE_UPDATE = "update";
    private static final String RULE_UPDATE_SET_CLAUSE = "update_set_clause";
    private static final String ONLY = "only";
    private static final String LEFT_PAREN = "(";
    private static final String RIGHT_PAREN = ")";
    static final String[] RESERVED_WORDS = new String[]{"ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MLSLABEL", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"};
    private OracleSQLQueryBuilderHelper m_helper;
    private String m_schema;

    public SQLUsage[] getUsages(String sql, String schema) {
        return this.getUsagesImpl(sql, schema, 0);
    }

    public SQLUsage[] getUsagesImpl(String sql, String schema, int startOffset) {
        this.m_schema = schema;
        ArrayList<SQLUsage> usages = new ArrayList<SQLUsage>();
        HashMap<String, BaseObjectID> tableAliases = new HashMap<String, BaseObjectID>();
        this.m_helper = OracleSQLQueryBuilderHelper.getHelper(sql);
        ParseNode queryRoot = this.m_helper.getRaptorRoot();
        this.getKidsUsages(queryRoot, usages, tableAliases);
        this.replaceTableAliases(usages, tableAliases);
        SQLUsage[] retval = usages.toArray(new SQLUsage[usages.size()]);
        if (startOffset != 0) {
            for (SQLUsage su : retval) {
                su.m_startOffset = su.m_startOffset + startOffset;
                su.m_endOffset = su.m_endOffset + startOffset;
            }
        }
        return retval;
    }

    private void getKidsUsages(ParseNode n, List<SQLUsage> usages, HashMap<String, BaseObjectID> tableAliases) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (!this.m_helper.isRule(n, RULE_INSERT_INTO_CLAUSE)) break block6;
                        this.processInsertIntoClause(n, usages, tableAliases);
                        break block7;
                    }
                    if (!this.m_helper.isRule(n, RULE_UPDATE)) break block8;
                    this.processUpdate(n, usages, tableAliases);
                    break block7;
                }
                if (!this.m_helper.isLeaf(n)) break block9;
                String name = this.m_helper.getContent(n);
                Character firstChar = Character.valueOf(name.charAt(0));
                if ((!Character.isLetter(firstChar.charValue()) || this.m_helper.isKeyword(n, RESERVED_WORDS)) && '\"' != firstChar.charValue()) break block7;
                DBObjectID dboid = this.addUsage(usages, n, null);
                break block7;
            }
            if (this.m_helper.isRule(n, RULE_TABLE_REFERENCE)) {
                this.processTableReference(n, usages, tableAliases);
            } else {
                List<ParseNode> kids = this.m_helper.getOrderedChildren(n);
                if (this.m_helper.isDotSeperatedList(kids)) {
                    List<ParseNode> nodes = this.m_helper.getDotSeparatedList(kids);
                    DBObjectID parent = null;
                    for (ParseNode dn : nodes) {
                        parent = this.addUsage(usages, dn, parent);
                    }
                } else {
                    for (ParseNode child : kids) {
                        this.getKidsUsages(child, usages, tableAliases);
                    }
                }
            }
        }
    }

    private void processTableReference(ParseNode n, List<SQLUsage> usages, HashMap<String, BaseObjectID> tableAliases) {
        ParseNode aliasNode = null;
        List<ParseNode> kids = this.m_helper.getOrderedChildren(n);
        if (kids.size() == 2 && this.m_helper.isLeaf(kids.get(1))) {
            aliasNode = kids.get(1);
        }
        ParseNode tableNode = kids.get(0);
        this.processTableAndAlias(tableNode, aliasNode, usages, tableAliases);
    }

    private DBObjectID processTableAndAlias(ParseNode tableNode, ParseNode aliasNode, List<SQLUsage> usages, HashMap<String, BaseObjectID> tableAliases) {
        String alias = null;
        BaseObjectID tableid = null;
        if (aliasNode != null && this.m_helper.isLeaf(aliasNode)) {
            alias = this.m_helper.getContent(aliasNode);
        }
        if (this.m_helper.isLeaf(tableNode)) {
            tableid = (BaseObjectID)this.addUsage(usages, tableNode, null);
            if (alias != null) {
                tableAliases.put(alias, tableid);
            }
        } else {
            ArrayList<SQLUsage> myUsages = new ArrayList<SQLUsage>();
            HashMap<String, BaseObjectID> myAliases = new HashMap<String, BaseObjectID>();
            this.getKidsUsages(tableNode, myUsages, myAliases);
            this.replaceTableAliases(myUsages, myAliases);
            for (SQLUsage sqlu : myUsages) {
                usages.add(sqlu);
            }
        }
        return tableid;
    }

    private void replaceTableAliases(List<SQLUsage> usages, HashMap<String, BaseObjectID> tableAliases) {
        for (SQLUsage usage : usages) {
            if (usage.isAliasDone()) continue;
            BaseObjectID myUsage = (BaseObjectID)usage.getDbObjectID();
            BaseObjectID ancestor = this.getSecondParent(usage);
            String top = ancestor == null ? null : this.getOldestParentName((DBObjectID)ancestor);
            if (top == null || !tableAliases.containsKey(top)) continue;
            BaseObjectID table = tableAliases.get(top);
            if (top.equalsIgnoreCase(myUsage.getName())) {
                usage.setDbObjectID((DBObjectID)table);
            } else {
                ancestor.setParent((DBObjectID)table);
            }
            usage.setAliasDone(true);
        }
    }

    private BaseObjectID getSecondParent(SQLUsage usage) {
        DBObjectID retval;
        for (DBObjectID parent = retval = usage.getDbObjectID(); parent != null && parent.getParent() != null; parent = parent.getParent()) {
            retval = parent;
        }
        return (BaseObjectID)retval;
    }

    private String getOldestParentName(DBObjectID dboid) {
        DBObjectID parent = dboid;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return ((BaseObjectID)parent).getName();
    }

    private DBObjectID addUsage(List<SQLUsage> usages, ParseNode n, DBObjectID parent) {
        String name = this.m_helper.getContent(n);
        int startOffset = this.m_helper.getNodeStartOffset(n);
        int endOffset = this.m_helper.getNodeEndOffset(n);
        ReferenceID dboid = null;
        dboid = parent == null ? new ReferenceID("UNSPECIFIED_TYPE", this.m_schema, name) : new ReferenceID("UNSPECIFIED_TYPE", parent, name, null, null);
        SQLUsage usage = new SQLUsage(startOffset, endOffset, (DBObjectID)dboid);
        usages.add(usage);
        return dboid;
    }

    private void processInsertIntoClause(ParseNode n, List<SQLUsage> usages, HashMap<String, BaseObjectID> tableAliases) {
        List<ParseNode> kids = this.m_helper.getOrderedChildren(n);
        ParseNode tableNode = kids.get(1);
        ParseNode aliasNode = null;
        int lparenIndex = 2;
        if (kids.size() > 2 && this.m_helper.isLeaf(kids.get(2)) && !this.m_helper.isKeyword(kids.get(2), LEFT_PAREN)) {
            aliasNode = kids.get(2);
            lparenIndex = 3;
        }
        DBObjectID tableId = this.processTableAndAlias(tableNode, aliasNode, usages, tableAliases);
        if (kids.size() > lparenIndex && this.m_helper.isKeyword(kids.get(lparenIndex), LEFT_PAREN) && this.m_helper.isKeyword(kids.get(kids.size() - 1), RIGHT_PAREN)) {
            int lparen = this.m_helper.getKeywordIndex(kids, LEFT_PAREN);
            List<ParseNode> colNodes = kids.subList(lparenIndex + 1, kids.size() - 1);
            List<List<ParseNode>> cols = this.m_helper.getCommaSeparatedList(colNodes);
            for (List<ParseNode> col : cols) {
                this.addUsage(usages, col.get(0), tableId);
            }
        }
    }

    private void processUpdate(ParseNode n, List<SQLUsage> usages, HashMap<String, BaseObjectID> tableAliases) {
        List<ParseNode> kids = this.m_helper.getOrderedChildren(n);
        ParseNode tableNode = null;
        int i = 1;
        if (this.m_helper.isKeyword(kids.get(i), ONLY)) {
            tableNode = kids.get(i + 2);
            i += 4;
        } else {
            tableNode = kids.get(i);
            ++i;
        }
        if (this.m_helper.isLeaf(kids.get(i))) {
            ParseNode aliasNode = kids.get(i);
            this.processTableAndAlias(tableNode, aliasNode, usages, tableAliases);
            ++i;
        }
        while (i < kids.size()) {
            this.getKidsUsages(kids.get(i), usages, tableAliases);
            ++i;
        }
    }

    public Collection<SqlAliasExpander.Usage> getUsages(String sql) {
        SQLUsage[] res;
        ArrayList<SqlAliasExpander.Usage> ret = new ArrayList<SqlAliasExpander.Usage>();
        for (SQLUsage u : res = this.getUsagesImpl(sql, null, 0)) {
            ret.add(u);
        }
        return ret;
    }

    public Collection<SqlAliasExpander.Usage> getUsages(PlSqlToken startToken, PlSqlToken endToken) {
        SQLUsage[] res;
        String sql = startToken.getSource(false, endToken);
        ArrayList<SqlAliasExpander.Usage> ret = new ArrayList<SqlAliasExpander.Usage>();
        for (SQLUsage u : res = this.getUsagesImpl(sql, null, startToken.getStart())) {
            ret.add(u);
        }
        return ret;
    }

    public void print(ParseNode node, String para) {
        if (this.m_helper == null) {
            System.out.println("No usage statement to print");
            return;
        }
        if (node == null) {
            node = this.m_helper.getRaptorRoot();
            if (node.topLevel != null) {
                System.out.println("\nThere were parse errors!\ntopLevel set size = " + node.topLevel.size());
            }
            System.out.println("\n");
        }
        this.m_helper.print(node, 0, "0", new PrintWriter(System.out, true));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SQLUsage
    implements SqlAliasExpander.Usage {
        private boolean m_aliasDone;
        private int m_startOffset;
        private int m_endOffset;
        private DBObjectID m_dbObjectID;

        public SQLUsage() {
        }

        private SQLUsage(int startOffset, int endOffset, DBObjectID dboid) {
            this.m_startOffset = startOffset;
            this.m_endOffset = endOffset;
            this.m_dbObjectID = dboid;
        }

        public void setStartOffset(int offset) {
            this.m_startOffset = offset;
        }

        public int getStartOffset() {
            return this.m_startOffset;
        }

        public void setDbObjectID(DBObjectID dbObjectID) {
            this.m_dbObjectID = dbObjectID;
        }

        public DBObjectID getDbObjectID() {
            return this.m_dbObjectID;
        }

        public void setEndOffset(int endOffset) {
            this.m_endOffset = endOffset;
        }

        public int getEndOffset() {
            return this.m_endOffset;
        }

        private void setAliasDone(boolean aliasDone) {
            this.m_aliasDone = aliasDone;
        }

        private boolean isAliasDone() {
            return this.m_aliasDone;
        }

        public List<String> getTokens() {
            ArrayList<String> retval = new ArrayList<String>();
            for (BaseObjectID id = (BaseObjectID)this.m_dbObjectID; id != null; id = (BaseObjectID)id.getParent()) {
                retval.add(0, id.getName());
            }
            return retval;
        }
    }
}

