/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.WhereObject;

public class WhereObjectBuilder
extends AbstractExpressionBuilder {
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext context, ParseNode node) throws SQLQueryException {
        WhereObject retval = null;
        WhereObject.WhereOperator type = null;
        List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
        if (kids.size() == 3) {
            if (this.m_helper.isLeaf(kids.get(1))) {
                if (this.m_helper.isKeyword(kids.get(1), "and")) {
                    type = WhereObject.WhereOperator.AND;
                } else if (this.m_helper.isKeyword(kids.get(1), "or")) {
                    type = WhereObject.WhereOperator.OR;
                }
            }
            if (type != null) {
                SQLFragment left = this.m_queryBuilder.createFragment(kids.get(0), this.m_creating, this.m_queryContext);
                SQLFragment right = this.m_queryBuilder.createFragment(kids.get(2), this.m_creating, this.m_queryContext);
                SQLFragment[] operands = null;
                if (left instanceof WhereObject && type == ((WhereObject)left).getOperator()) {
                    SQLFragment[] lhsOperands = ((WhereObject)left).getArguments();
                    operands = new SQLFragment[lhsOperands.length + 1];
                    for (int i = 0; i < lhsOperands.length; ++i) {
                        operands[i] = lhsOperands[i];
                    }
                    operands[lhsOperands.length] = right;
                } else {
                    operands = new SQLFragment[]{left, right};
                }
                retval = new WhereObject(operands, type);
            }
        }
        return retval;
    }
}

