/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.AbstractExpressionBuilder;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.WindowFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowFunctionBuilder
extends AbstractExpressionBuilder {
    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        this.init(context);
        return this.createFragmentImpl(context, node);
    }

    private SQLFragment createFragmentImpl(ExpressionContext context, ParseNode node) throws SQLQueryException {
        WindowFunction retval = null;
        List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
        if (this.m_helper.isRule(node, "analytic_function")) {
            String functionName = this.m_helper.getContent(kids.get(0));
            functionName = functionName.toUpperCase();
            BuiltInFunction func = null;
            boolean grouping = false;
            for (BuiltInFunction bif : context.getProvider().getDescriptor().listBuiltInFunctions(functionName)) {
                if (func == null) {
                    func = bif;
                }
                if (!bif.isAggregate()) continue;
                grouping = true;
            }
            if (func != null) {
                WindowFunction windowFunction = new WindowFunction();
                windowFunction.setFunction(func.getName());
                windowFunction.setGrouping(grouping);
                if (this.m_helper.isKeyword(kids.get(2), "DISTINCT")) {
                    windowFunction.setGrouping(true);
                    windowFunction.setDistinct(true);
                    windowFunction.setDistinctSource(this.m_helper.getContent(kids.get(2)));
                } else if (this.m_helper.isKeyword(kids.get(2), "ALL")) {
                    windowFunction.setGrouping(true);
                    windowFunction.setDistinct(false);
                    windowFunction.setDistinctSource(this.m_helper.getContent(kids.get(2)));
                }
                SQLFragment[] args = this.getArgList(this.m_creating, windowFunction, node);
                windowFunction.setArguments(args);
                int i = this.m_helper.getKeywordIndex(kids, "WITHIN");
                if (i >= 0) {
                    this.processWithinGroup(kids, i, windowFunction);
                }
                if ((i = this.m_helper.getKeywordIndex(kids, "FROM")) >= 0) {
                    this.processFrom(kids, i, windowFunction);
                }
                if ((i = this.m_helper.getKeywordIndex(kids, "NULLS")) >= 0) {
                    this.processNulls(kids, i - 1, windowFunction);
                }
                if ((i = this.m_helper.getKeywordIndex(kids, "OVER")) >= 0) {
                    this.processOver(kids, i + 2, windowFunction);
                }
                if ((i = this.m_helper.getRuleIndex(kids, "over_clause")) >= 0) {
                    this.processOver(kids.get(i), windowFunction);
                }
                retval = windowFunction;
            }
        }
        return retval;
    }

    private void processOver(ParseNode overClause, WindowFunction windowFunction) throws SQLQueryException {
        List<ParseNode> kids = this.m_helper.getOrderedChildren(overClause);
        this.processOver(kids, 2, windowFunction);
    }

    private void processOver(List<ParseNode> kids, int i, WindowFunction windowFunction) throws SQLQueryException {
        ParseNode windowingClauseNode = null;
        if (this.m_helper.isRule(kids.get(i), "analytic_clause") || this.m_helper.isRule(kids.get(i), "query_partition_clause")) {
            ParseNode queryPartitionClauseNode = null;
            ParseNode orderByClauseNode = null;
            if (this.m_helper.isRule(kids.get(i), "query_partition_clause")) {
                queryPartitionClauseNode = kids.get(i);
            } else if (this.m_helper.isRule(kids.get(i), "order_by_clause")) {
                orderByClauseNode = kids.get(i);
            } else if (this.m_helper.isRule(kids.get(i), "windowing_clause")) {
                windowingClauseNode = kids.get(i);
            } else {
                List<ParseNode> kidskids = this.m_helper.getOrderedChildren(kids.get(i));
                for (ParseNode n : kidskids) {
                    if (this.m_helper.isRule(n, "query_partition_clause")) {
                        queryPartitionClauseNode = n;
                        continue;
                    }
                    if (this.m_helper.isRule(n, "order_by_clause")) {
                        orderByClauseNode = n;
                        continue;
                    }
                    if (!this.m_helper.isRule(n, "windowing_clause")) continue;
                    windowingClauseNode = n;
                }
            }
            if (queryPartitionClauseNode != null) {
                this.processQueryPartitionClause(windowFunction, queryPartitionClauseNode);
            }
            if (orderByClauseNode != null) {
                this.processOrderBy(windowFunction, orderByClauseNode);
            }
            ++i;
        }
        if (windowingClauseNode != null) {
            this.buildBounds(windowingClauseNode, windowFunction);
        }
    }

    private void processQueryPartitionClause(WindowFunction windowFunction, ParseNode queryPartitionClauseNode) throws SQLQueryException {
        ExpressionList queryPartition = (ExpressionList)this.m_queryBuilder.createFragment(queryPartitionClauseNode, this.m_creating, windowFunction);
        windowFunction.setPartitionBy(queryPartition.getArguments());
    }

    private void processOrderBy(WindowFunction windowFunction, ParseNode orderByClauseNode) throws SQLQueryException {
        ExpressionList orderBy = (ExpressionList)this.m_queryBuilder.createFragment(orderByClauseNode, this.m_creating, windowFunction);
        SQLFragment[] obargs = orderBy.getArguments();
        OrderByObject[] orderByObjects = new OrderByObject[obargs.length];
        for (int ia = 0; ia < obargs.length; ++ia) {
            orderByObjects[ia] = (OrderByObject)obargs[ia];
        }
        windowFunction.setOrderBy(orderByObjects);
    }

    private void buildBounds(ParseNode node, WindowFunction windowFunction) throws SQLQueryException {
        int i;
        WindowFunction.WindowFunctionBound[] bounds = null;
        List<ParseNode> kids = this.m_helper.getOrderedChildren(node);
        if (this.m_helper.isKeyword(kids.get(i = 0), "ROWS")) {
            windowFunction.setClauseType(WindowFunction.ClauseType.ROWS);
        } else if (this.m_helper.isKeyword(kids.get(i), "RANGE")) {
            windowFunction.setClauseType(WindowFunction.ClauseType.RANGE);
        }
        int boundCount = 1;
        if (this.m_helper.isKeyword(kids.get(++i), "BETWEEN")) {
            boundCount = 2;
            ++i;
        }
        bounds = new WindowFunction.WindowFunctionBound[boundCount];
        for (int bi = 0; bi < boundCount; ++bi) {
            bounds[bi] = new WindowFunction.WindowFunctionBound();
            if (this.m_helper.isKeyword(kids.get(i), "UNBOUNDED") && this.m_helper.isKeyword(kids.get(i + 1), "PRECEDING")) {
                i += 2;
                bounds[bi].setBoundType(WindowFunction.BoundType.PRECEDING);
            } else if (this.m_helper.isKeyword(kids.get(i), "UNBOUNDED") && this.m_helper.isKeyword(kids.get(i + 1), "FOLLOWING")) {
                i += 2;
                bounds[bi].setBoundType(WindowFunction.BoundType.FOLLOWING);
            } else if (this.m_helper.isKeyword(kids.get(i), "CURRENT") && this.m_helper.isKeyword(kids.get(i + 1), "ROW")) {
                i += 2;
                bounds[bi].setBoundType(WindowFunction.BoundType.CURRENT_ROW);
            } else {
                SQLFragment expr = this.m_queryBuilder.createFragment(kids.get(i), this.m_creating, windowFunction);
                bounds[bi].setBoundExpr(new SQLFragment[]{expr});
                if (this.m_helper.isKeyword(kids.get(++i), "PRECEDING")) {
                    bounds[bi].setBoundType(WindowFunction.BoundType.PRECEDING);
                } else if (this.m_helper.isKeyword(kids.get(i), "FOLLOWING")) {
                    bounds[bi].setBoundType(WindowFunction.BoundType.FOLLOWING);
                }
                ++i;
            }
            if (i >= kids.size() || !this.m_helper.isKeyword(kids.get(i), "and")) continue;
            ++i;
        }
        windowFunction.setBounds((SQLFragment[])bounds);
    }

    private void processWithinGroup(List<ParseNode> kids, int index, WindowFunction windowFunction) throws SQLQueryException {
        int i = index + 3;
        this.processOrderBy(windowFunction, kids.get(i));
    }

    private void processNulls(List<ParseNode> kids, int i, WindowFunction windowFunction) {
        if (this.m_helper.isKeyword(kids.get(i), "RESPECT")) {
            windowFunction.setNullPolicy(WindowFunction.NullPolicy.RESPECT);
        } else if (this.m_helper.isKeyword(kids.get(i), "IGNORE")) {
            windowFunction.setNullPolicy(WindowFunction.NullPolicy.IGNORE);
        }
    }

    private void processFrom(List<ParseNode> kids, int i, WindowFunction windowFunction) {
        if (this.m_helper.isKeyword(kids.get(i + 1), "FIRST")) {
            windowFunction.setFromPolicy(WindowFunction.FromPolicy.FIRST);
        } else if (this.m_helper.isKeyword(kids.get(i + 1), "LAST")) {
            windowFunction.setFromPolicy(WindowFunction.FromPolicy.LAST);
        }
    }
}

