/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.IdentityColumnProperties;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class ColumnSequenceSXMLGenerator
extends SXMLFragmentGenerator {
    private static final String BASE = "CUSTOMER_AREA/ODB_PROPERTY_LIST";
    private static final String COLSEQ_TRIGGER_SCHEMA = "COLSEQ_TRIGGER_SCHEMA";
    private static final String COLSEQ_TRIGGER_NAME = "COLSEQ_TRIGGER_NAME";
    private static final String COLSEQ_SEQUENCE_SCHEMA = "COLSEQ_SEQUENCE_SCHEMA";
    private static final String COLSEQ_SEQUENCE_NAME = "COLSEQ_SEQUENCE_NAME";
    private static final String COLSEQ_REUSE = "COLSEQ_REUSE";
    private static final String COLSEQ_CHECKNULL = "COLSEQ_CHECKNULL";
    private static final String YES = "Y";
    private static final String NO = "N";

    ColumnSequenceSXMLGenerator() {
    }

    protected void populateNode(Node parent, Document doc, Object obj) {
        if (obj instanceof Column) {
            Column col = (Column)obj;
            if (col.getIdentityProperties() != null) {
                IdentityColumnProperties.GeneratedType genType = col.getIdentityProperties().getGenerated();
                Node idNode = this.findNode(parent, "IDENTITY_COLUMN");
                Node child = idNode.getFirstChild();
                Node generated = this.findOrCreateNodeBefore(doc, idNode, "GENERATION", child.getNodeName());
                String str = genType == null || genType == IdentityColumnProperties.GeneratedType.ALWAYS ? "ALWAYS" : "DEFAULT";
                generated.appendChild(doc.createTextNode(str));
                if (genType == IdentityColumnProperties.GeneratedType.BY_DEFAULT_ON_NULL) {
                    this.findOrCreateNodeAfter(doc, idNode, "ON_NULL", "GENERATION");
                }
            } else if (col.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER") != null) {
                this.add(parent, doc, COLSEQ_TRIGGER_SCHEMA, ((BaseObjectID)col.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER")).getSchemaName());
                this.add(parent, doc, COLSEQ_TRIGGER_NAME, ((BaseObjectID)col.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER")).getName());
                this.add(parent, doc, COLSEQ_SEQUENCE_SCHEMA, ((BaseObjectID)col.getProperty("AUTO_GENERATED_SEQUENCE")).getSchemaName());
                this.add(parent, doc, COLSEQ_SEQUENCE_NAME, ((BaseObjectID)col.getProperty("AUTO_GENERATED_SEQUENCE")).getName());
                Boolean reuse = (Boolean)col.getProperty("ColumnSequenceExpander.ReuseSequence");
                this.add(parent, doc, COLSEQ_REUSE, Boolean.TRUE.equals(reuse) ? YES : NO);
                Boolean checkNull = (Boolean)col.getProperty("ColumnSequenceExpander.TriggerNullCheck");
                this.add(parent, doc, COLSEQ_CHECKNULL, Boolean.TRUE.equals(checkNull) ? YES : NO);
            }
        }
    }

    protected void readNode(Node parent, Object obj) {
        if (obj instanceof Column) {
            Column col = (Column)obj;
            if (this.nodeExists(parent, "IDENTITY_COLUMN")) {
                IdentityColumnProperties props = col.getIdentityProperties();
                if (props == null) {
                    props = new IdentityColumnProperties();
                    col.setIdentityProperties(props);
                }
                String generated = this.nodeText(parent, "IDENTITY_COLUMN/GENERATION");
                boolean onNull = this.nodeExists(parent, "IDENTITY_COLUMN/ON_NULL");
                if ("DEFAULT".equals(generated)) {
                    props.setGenerated(onNull ? IdentityColumnProperties.GeneratedType.BY_DEFAULT_ON_NULL : IdentityColumnProperties.GeneratedType.BY_DEFAULT);
                } else {
                    props.setGenerated(IdentityColumnProperties.GeneratedType.ALWAYS);
                }
                if (Boolean.FALSE.equals(props.getCacheFlag())) {
                    props.setCacheSize(null);
                }
            } else if (this.nodeExists(parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_SEQUENCE_NAME")) {
                NameBasedID seqId = new NameBasedID();
                seqId.setType("SEQUENCE");
                seqId.setSchemaName(this.nodeText(parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_SEQUENCE_SCHEMA"));
                seqId.setName(this.nodeText(parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_SEQUENCE_NAME"));
                NameBasedID trgId = new NameBasedID();
                trgId.setType("TRIGGER");
                trgId.setSchemaName(this.nodeText(parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_TRIGGER_SCHEMA"));
                trgId.setName(this.nodeText(parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_TRIGGER_NAME"));
                Boolean reuse = YES.equals(this.nodeText(parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_REUSE"));
                Boolean checkNull = YES.equals(this.nodeText(parent, "CUSTOMER_AREA/ODB_PROPERTY_LIST/COLSEQ_CHECKNULL"));
                col.setProperty("AUTO_GENERATED_SEQUENCE", (Object)seqId);
                col.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", (Object)trgId);
                col.setProperty("ColumnSequenceExpander.ReuseSequence", (Object)reuse);
                col.setProperty("ColumnSequenceExpander.TriggerNullCheck", (Object)checkNull);
            }
        }
    }

    private void add(Node parent, Document doc, String name, String value) {
        Node propsNode = this.findOrCreateNode(doc, parent, BASE);
        Node propNode = this.createNode(doc, propsNode, name);
        propNode.appendChild(doc.createTextNode(value));
    }
}

