/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import oracle.javatools.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class MatViewSXMLGenerator
extends SXMLFragmentGenerator {
    MatViewSXMLGenerator() {
    }

    protected void populateNode(Node parent, Document doc, Object obj) {
        MaterializedView mv = (MaterializedView)obj;
        String name = mv.getRollbackSegmentName();
        MaterializedView.RollbackSegmentType type = mv.getRollbackSegmentType();
        String path = null;
        if (type == MaterializedView.RollbackSegmentType.LOCAL) {
            path = "REFRESH/LOCAL_ROLLBACK_SEGMENT";
        } else if (type == MaterializedView.RollbackSegmentType.MASTER) {
            path = "REFRESH/MASTER_ROLLBACK_SEGMENT";
        }
        if (path != null) {
            Node segNode = this.findOrCreateNodeBefore(doc, parent, path, "CONSTRAINTS");
            if (ModelUtil.hasLength((String)name)) {
                Node node = this.findOrCreateNode(doc, parent, path + "/NAME");
                node.appendChild(doc.createTextNode(name));
            } else {
                Node node = this.findOrCreateNode(doc, parent, path + "/DEFAULT");
            }
        }
    }

    protected void readNode(Node parent, Object obj) {
        SXMLReader reader = (SXMLReader)this.getParentGenerator();
        MaterializedView mv = (MaterializedView)obj;
        if (this.nodeExists(parent, "REFRESH/LOCAL_ROLLBACK_SEGMENT")) {
            mv.setRollbackSegmentType(MaterializedView.RollbackSegmentType.LOCAL);
            mv.setRollbackSegmentName(this.nodeText(parent, "REFRESH/LOCAL_ROLLBACK_SEGMENT/NAME"));
        } else if (this.nodeExists(parent, "REFRESH/MASTER_ROLLBACK_SEGMENT")) {
            mv.setRollbackSegmentType(MaterializedView.RollbackSegmentType.MASTER);
            mv.setRollbackSegmentName(this.nodeText(parent, "REFRESH/MASTER_ROLLBACK_SEGMENT/NAME"));
        }
    }
}

