/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.Iterator;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ora.sxml.SXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class SXMLFragmentGenerator {
    public static final String SXML_NAMESPACE = "http://xmlns.oracle.com/ku";
    private SXMLFragmentGenerator m_parentGen;
    private SXMLMappings m_mappings;
    private PropertyHelper m_propHelper = new PropertyHelper();

    protected SXMLFragmentGenerator() {
    }

    void setParentGenerator(SXMLFragmentGenerator parentGen) {
        this.m_parentGen = parentGen;
    }

    SXMLFragmentGenerator getParentGenerator() {
        return this.m_parentGen;
    }

    protected abstract void populateNode(Node var1, Document var2, Object var3);

    protected boolean supportsType(String type) {
        return true;
    }

    protected abstract void readNode(Node var1, Object var2);

    protected final SXMLMappings getMappings() {
        return this.m_mappings;
    }

    protected final void setMappings(SXMLMappings mappings) {
        this.m_mappings = mappings;
    }

    protected final String getType(Object obj) {
        if (obj instanceof DBObject) {
            return ((DBObject)obj).getType();
        }
        return obj.getClass().getSimpleName();
    }

    final void removeFromParentIfEmpty(Node parent, String name) {
        NodeList kids = parent.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            NodeList kidsKids;
            Node kid = kids.item(i);
            if (!kid.getNodeName().equals(name) || (kidsKids = kid.getChildNodes()) != null && kidsKids.getLength() != 0) continue;
            parent.removeChild(kid);
        }
    }

    protected final Node findOrCreateNode(Document doc, Node parent, String path) {
        return this.nodeCreateImpl(doc, parent, path, true, null, null);
    }

    protected final Node createNode(Document doc, Node parent, String path) {
        return this.nodeCreateImpl(doc, parent, path, false, null, null);
    }

    protected final Node findOrCreateNodeAfter(Document doc, Node parent, String path, String after) {
        return this.nodeCreateImpl(doc, parent, path, true, after, null);
    }

    protected final Node findOrCreateNodeBefore(Document doc, Node parent, String path, String before) {
        return this.nodeCreateImpl(doc, parent, path, true, null, before);
    }

    private Node nodeCreateImpl(Document doc, Node parent, String path, boolean findFirst, String after, String before) {
        int index = path.indexOf("/");
        String restOfPath = null;
        if (index > -1) {
            restOfPath = path.substring(index + 1);
            path = path.substring(0, index);
        }
        if (path.equals("")) {
            return parent;
        }
        Node newNode = null;
        if (findFirst && parent != null) {
            NodeList children = parent.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node n = children.item(i);
                if (!n.getNodeName().equals(path)) continue;
                newNode = n;
            }
        }
        if (newNode == null) {
            newNode = doc.createElementNS(SXML_NAMESPACE, path);
            if (parent != null) {
                if (after == null && before == null) {
                    parent.appendChild(newNode);
                } else {
                    Node insertBeforeMe = null;
                    if (ModelUtil.areEqual((Object)after, (Object)"/")) {
                        insertBeforeMe = parent.getFirstChild();
                    } else {
                        NodeList kids = parent.getChildNodes();
                        for (int i = 0; i < kids.getLength(); ++i) {
                            Node kid = kids.item(i);
                            if (after != null && kid.getNodeName().equals(after)) {
                                if (kids.getLength() <= i + 1) break;
                                insertBeforeMe = kids.item(i + 1);
                                break;
                            }
                            if (before == null || !kid.getNodeName().equals(before)) continue;
                            insertBeforeMe = kid;
                            break;
                        }
                    }
                    if (insertBeforeMe == null) {
                        parent.appendChild(newNode);
                    } else {
                        parent.insertBefore(newNode, insertBeforeMe);
                    }
                }
            }
        }
        if (restOfPath == null) {
            return newNode;
        }
        return this.nodeCreateImpl(doc, newNode, restOfPath, findFirst, after, before);
    }

    final DBObject resolveID(DBObjectID id, DBObject parent) {
        DBObject kid;
        if (parent != null && (kid = parent.findOwnedObject(id)) != null) {
            return kid;
        }
        try {
            DBObject obj = id.resolveID();
            return obj;
        }
        catch (DBException dbe) {
            dbe.printStackTrace();
            return null;
        }
    }

    final String toString(Object obj, DBObject parent) {
        DBObject found;
        if (ToStringManager.converterAvailable((Object)obj)) {
            return ToStringManager.toString((Object)obj);
        }
        if (obj instanceof BaseObjectID && ((BaseObjectID)obj).getName() != null) {
            return ((BaseObjectID)obj).getName();
        }
        if (obj instanceof DBObjectID && (found = this.resolveID((DBObjectID)obj, parent)) != null) {
            return found.getName();
        }
        return obj.toString();
    }

    final void processPropertyMapping(Node objNode, Document doc, Object obj, String elemPath, String propPath) {
        this.processPropertyMapping(objNode, doc, obj, elemPath, propPath, null);
    }

    final void processPropertyMapping(Node objNode, Document doc, Object obj, String elemPath, String propPath, SXMLValueConverter con) {
        SXMLMappings.Mapping m = new SXMLMappings.Mapping(elemPath, propPath, con);
        this.processPropertyMapping(objNode, doc, obj, m);
    }

    final void processPropertyMapping(Node objNode, Document doc, Object obj, SXMLMappings.Mapping map) {
        DBObject dbObject = obj instanceof DBObject ? (DBObject)obj : null;
        String propPath = map.getPropertyPath();
        Object value = propPath == null ? Boolean.valueOf(true) : this.getPropertyValue(obj, propPath);
        SXMLValueConverter con = map.getConverter();
        if (con != null) {
            value = con.getXMLValue(obj, value);
        }
        if (value != null && value instanceof Object[] && ((Object[])value).length == 0) {
            value = null;
        }
        if (value != null) {
            String elemPath = map.getElementPath();
            int index = elemPath.lastIndexOf("//");
            if (value instanceof Object[]) {
                if (index == -1) {
                    throw new IllegalStateException("array property found but no matching list in the SXML");
                }
                String postArrayPath = elemPath.substring(index + 2);
                elemPath = elemPath.substring(0, index);
                Object[] valueA = (Object[])value;
                Node propParentNode = this.findOrCreateNode(doc, objNode, elemPath);
                for (int i = 0; i < valueA.length; ++i) {
                    if (valueA[i] == null) continue;
                    Node propNode = this.createNode(doc, propParentNode, postArrayPath);
                    this.processPropertyNode(propNode, doc, valueA[i], dbObject);
                }
            } else {
                if (index > -1) {
                    throw new IllegalStateException("array marker found in element path (//) but property isn't an array.");
                }
                if (value instanceof Boolean) {
                    if (((Boolean)value).booleanValue()) {
                        Node propNode = this.findOrCreateNode(doc, objNode, elemPath);
                    }
                } else {
                    Node propNode = this.findOrCreateNode(doc, objNode, elemPath);
                    this.processPropertyNode(propNode, doc, value, dbObject);
                }
            }
        }
    }

    protected final boolean canRecurse(Object value) {
        return value instanceof Copyable && !(value instanceof DBObjectID);
    }

    private void processPropertyNode(Node propNode, Document doc, Object value, DBObject dbObject) {
        if (this.canRecurse(value)) {
            this.populateNode(propNode, doc, value);
        } else {
            Text valueNode = doc.createTextNode(this.toString(value, dbObject));
            if (propNode.getChildNodes().getLength() != 0) {
                Node oldNode = propNode.getFirstChild();
                DBLog.getLogger().log(DBLog.getTraceLogLevel(), "duplicate value {0} for property {1} was {2}", new Object[]{value, propNode.getNodeName(), oldNode.getTextContent()});
                propNode.replaceChild(valueNode, oldNode);
            } else {
                propNode.appendChild(valueNode);
            }
        }
    }

    private Object getPropertyValue(Object obj, String propPath) {
        Object value = null;
        if (propPath.equals("!schema")) {
            SXMLFragmentGenerator fg;
            for (fg = this; fg != null && !(fg instanceof SXMLGenerator); fg = fg.getParentGenerator()) {
            }
            if (fg != null) {
                value = ((SXMLGenerator)fg).getTopLevelObjectSchemaName();
            }
        } else {
            value = this.m_propHelper.getPropertyValue(obj, propPath);
        }
        return value;
    }

    protected final Node findNode(Node parentNode, String elementPath) {
        return this.findNode(parentNode, elementPath.split("/"));
    }

    private Node findNode(Node parentNode, String ... elements) {
        String next = elements[0];
        String[] theRest = new String[elements.length - 1];
        for (int i = 0; i < theRest.length; ++i) {
            theRest[i] = elements[i + 1];
        }
        NodeList nodes = parentNode.getChildNodes();
        Node theNode = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!next.equals(n.getLocalName())) continue;
            theNode = n;
            break;
        }
        if (theNode != null && theRest.length == 0) {
            return theNode;
        }
        if (theNode != null) {
            return this.findNode(theNode, theRest);
        }
        return null;
    }

    protected final boolean nodeExists(Node parentNode, String elementPath) {
        return this.findNode(parentNode, elementPath) != null;
    }

    protected final String nodeText(Node parentNode, String elementPath) {
        String text = null;
        Node subNode = this.findNode(parentNode, elementPath);
        if (subNode != null && subNode.getChildNodes().getLength() <= 1 && (text = subNode.getTextContent()) != null) {
            text = text.trim();
        }
        return text;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class childXMLElementIterator
    implements Iterator<Node> {
        NodeList m_children;
        int m_index = -1;

        public childXMLElementIterator(Node n) {
            this.m_children = n.getChildNodes();
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() != -1;
        }

        @Override
        public Node next() {
            int nextindex = this.nextIndex();
            if (nextindex != -1) {
                this.m_index = nextindex;
                return this.m_children.item(this.m_index);
            }
            return null;
        }

        @Override
        public void remove() {
        }

        private int nextIndex() {
            int retval = -1;
            for (int i = this.m_index + 1; i < this.m_children.getLength(); ++i) {
                if (!(this.m_children.item(i) instanceof XMLElement)) continue;
                retval = i;
                break;
            }
            return retval;
        }
    }
}

