/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.IdentityColumnProperties;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLMappings;
import oracle.javatools.db.ora.sxml.SXMLReaderException;
import oracle.javatools.db.ora.sxml.SXMLValueConverter;
import oracle.javatools.db.ora.sxml.UnsupportedTypeForSXMLException;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.TypeBody;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SXMLReader
extends SXMLFragmentGenerator {
    public static final String MIGRATING_BODY_SOURCE_PROP = "SXMLReader.TypeBody.Source";
    private Map<Class, Map<String, PropertyInfo>> m_infos = new HashMap<Class, Map<String, PropertyInfo>>();
    private SchemaObject m_parentObject;
    private SchemaObject m_currentObject;
    private DBObjectProvider m_pro;

    public SXMLReader() {
        this(null, new SXMLReaderMappings());
    }

    public SXMLReader(DBObjectProvider pro) {
        this(pro, new SXMLReaderMappings());
    }

    SXMLReader(SXMLMappings mappings) {
        this(null, mappings);
    }

    SXMLReader(DBObjectProvider pro, SXMLMappings mappings) {
        super.setMappings(mappings);
        this.m_pro = pro;
    }

    public void addMapping(String type, String elementPath, String propertyPath, SXMLValueConverter con) {
        this.getMappings().cache(type, elementPath, propertyPath, con);
    }

    public void removeMapping(String type, String elementPath, String propertyPath) {
        this.getMappings().uncache(type, elementPath, propertyPath);
    }

    public String getElementPath(String type, String propertyPath) {
        String retval = null;
        Iterator<SXMLMappings.Mapping> iter = this.getMappings().getMappings(type);
        if (iter != null) {
            while (iter.hasNext()) {
                SXMLMappings.Mapping mapping = iter.next();
                if (!ModelUtil.areEqual((Object)propertyPath, (Object)mapping.getPropertyPath())) continue;
                retval = mapping.getElementPath();
                break;
            }
        }
        return retval;
    }

    public void addGenerator(String type, Class<? extends SXMLFragmentGenerator> gen) {
        this.getMappings().registerGen(type, gen);
    }

    public SchemaObject getObject(XMLDocument doc) {
        try {
            Element rootNode = doc.getDocumentElement();
            return this.getObject(rootNode);
        }
        catch (SXMLReaderException sxmlre) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, sxmlre.getMessage(), sxmlre);
            return null;
        }
    }

    private SchemaObject getObject(Node rootNode) throws SXMLReaderException {
        SchemaObject so = null;
        String rootNodeName = rootNode.getLocalName();
        if ("COMPOSITE".equals(rootNodeName)) {
            so = this.getCompositeObject(rootNode);
        } else if ("TYPE_SPEC".equals(rootNodeName)) {
            so = this.getComplexType(rootNode, false);
        } else {
            SQLQueryOwner qo;
            Index ind;
            if (this.isRootNameForType(rootNodeName, "TABLE")) {
                so = new Table();
            } else if (this.isRootNameForType(rootNodeName, "VIEW")) {
                so = new View();
            } else if (this.isRootNameForType(rootNodeName, "MATERIALIZED VIEW")) {
                so = new MaterializedView();
                ((MaterializedView)so).setRefreshMethod(MaterializedView.RefreshMethod.FORCE);
            } else if (this.isRootNameForType(rootNodeName, "MATERIALIZED VIEW LOG")) {
                so = new MaterializedViewLog();
                ((MaterializedViewLog)so).setCache(Boolean.FALSE);
                ((MaterializedViewLog)so).setNewValues(Boolean.FALSE);
                ((MaterializedViewLog)so).setObjectIdLogged(Boolean.FALSE);
                ((MaterializedViewLog)so).setPrimaryKeyLogged(Boolean.FALSE);
                ((MaterializedViewLog)so).setRowidLogged(Boolean.FALSE);
                ((MaterializedViewLog)so).setSequenceLogged(Boolean.FALSE);
            } else if (this.isRootNameForType(rootNodeName, "SEQUENCE")) {
                so = new Sequence();
                ((Sequence)so).setOrderFlag(Boolean.FALSE);
                ((Sequence)so).setCycleFlag(Boolean.FALSE);
            } else if (this.isRootNameForType(rootNodeName, "SYNONYM")) {
                so = new Synonym();
            } else if (this.isRootNameForType(rootNodeName, "TRIGGER")) {
                so = new Trigger();
            } else if (this.isRootNameForType(rootNodeName, "INDEX")) {
                so = new Index();
            } else if (this.isRootNameForType(rootNodeName, "TYPE BODY")) {
                so = new TypeBody();
            }
            this.m_currentObject = so;
            if (so != null) {
                try {
                    this.fillInObject(so, rootNode, null);
                }
                catch (Exception e) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, e.getMessage(), e);
                }
            } else {
                throw new UnsupportedTypeForSXMLException(rootNodeName);
            }
            if (so instanceof MaterializedViewLog) {
                MaterializedViewLog mvl = (MaterializedViewLog)so;
                NameBasedID masterID = (NameBasedID)mvl.getMasterTableID();
                masterID.setSchema(mvl.getSchema());
                if (this.getProvider() != null) {
                    try {
                        String[] objs = this.getProvider().listObjects("MATERIALIZED VIEW", mvl.getSchema(), mvl.getName());
                        if (objs != null && objs.length > 0) {
                            NameBasedID mvID = new NameBasedID("MATERIALIZED VIEW", mvl.getSchema().getName(), mvl.getName());
                            mvl.setMasterTableID((DBObjectID)mvID);
                            for (DBObjectID colID : mvl.getColumnIDs()) {
                                ((NameBasedID)colID).setParent((DBObjectID)mvID);
                            }
                        }
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                }
            }
            if (so instanceof Index && (ind = (Index)so).getIndexType() == null) {
                ind.setIndexType(Index.IndexType.NORMAL);
            }
            if (so instanceof Table) {
                this.tidyPartitions((Table)so);
            }
            if ("TABLE".equals(so.getType()) && this.m_pro != null) {
                try {
                    DBUtil.ensureDerivedPropertiesBuilt((DBObject)so, (DBObjectProvider)this.m_pro);
                }
                catch (DBException e) {
                    DBLog.getLogger((Object)this).info("Failed to build derived prop:" + e.getMessage());
                }
                for (Column col : ((Table)so).getColumns()) {
                    IdentityColumnProperties icp = col.getIdentityProperties();
                    if (icp == null) continue;
                    if (icp.getOrderFlag() == null) {
                        icp.setOrderFlag(Boolean.valueOf(false));
                    }
                    if (icp.getCycleFlag() != null) continue;
                    icp.setCycleFlag(Boolean.valueOf(false));
                }
            }
            if (so instanceof SQLQueryOwner && this.m_pro != null && (qo = (SQLQueryOwner)so).getSQLQuery() != null) {
                qo.getSQLQuery().setParent((DBObject)qo);
                String sql = qo.getSQLQuery().getSQLText();
                Schema defSchema = null;
                try {
                    defSchema = this.m_pro.getDefaultSchema();
                }
                catch (DBException e) {
                    // empty catch block
                }
                this.m_pro.getDescriptor().getSQLQueryBuilderFactory();
                SQLQueryBuilder builder = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)this.m_pro, (Schema)defSchema);
                try {
                    builder.buildQuery(sql, qo);
                    qo.setSQLQuery(builder.getSQLQuery());
                }
                catch (SQLQueryException e) {
                    // empty catch block
                }
            }
            this.ensureKidsIDsParentID((DBObject)so);
        }
        return so;
    }

    private SchemaObject getCompositeObject(Node rootNode) throws SXMLReaderException {
        SchemaObject so = null;
        if (this.nodeExists(rootNode, "BASE_OBJECT/TYPE_SPEC")) {
            so = this.getComplexType(rootNode, true);
        } else {
            Node baseObjectNode = this.findNode(rootNode, "BASE_OBJECT/TABLE");
            if (baseObjectNode == null) {
                baseObjectNode = this.findNode(rootNode, "BASE_OBJECT/MATERIALIZED_VIEW");
            }
            if (baseObjectNode == null) {
                throw new SXMLReaderException("Base object node was not found");
            }
            this.m_parentObject = so = this.getObject(baseObjectNode);
            Node indexListNode = this.findNode(rootNode, "INDEX_LIST");
            ArrayList<Index> indexes = new ArrayList<Index>();
            SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(indexListNode);
            while (it.hasNext()) {
                Node indexNode = (Node)it.next();
                SchemaObject index = this.getObject(indexNode);
                if (!(index instanceof Index)) {
                    throw new SXMLReaderException("Index expected but " + (index == null ? "none found" : index.getType() + " found"));
                }
                indexes.add((Index)index);
            }
            ((Table)so).setIndexes(indexes.toArray(new Index[indexes.size()]));
        }
        return so;
    }

    private SchemaObject getComplexType(Node rootNode, boolean composite) {
        Type ct = new Type();
        String schemaName = null;
        if (composite) {
            ct.setName(this.nodeText(rootNode, "BASE_OBJECT/TYPE_SPEC/NAME"));
            schemaName = this.nodeText(rootNode, "BASE_OBJECT/TYPE_SPEC/SCHEMA");
            ct.setSource(this.nodeText(rootNode, "BASE_OBJECT/TYPE_SPEC/CUSTOMER_AREA/ODB_PROPERTY_LIST/PLSQL_BLOCK"));
            String bodySource = this.nodeText(rootNode, "TYPE_BODY/PLSQL_BLOCK");
            if (ModelUtil.hasLength((String)bodySource)) {
                ct.setProperty(MIGRATING_BODY_SOURCE_PROP, (Object)bodySource);
            }
        } else {
            ct.setName(this.nodeText(rootNode, "NAME"));
            schemaName = this.nodeText(rootNode, "SCHEMA");
            ct.setSource(this.nodeText(rootNode, "CUSTOMER_AREA/ODB_PROPERTY_LIST/PLSQL_BLOCK"));
        }
        ct.setSchema(new Schema(schemaName));
        this.setID((DBObject)ct);
        return ct;
    }

    protected final void fillInObject(Object obj, Node parentNode, String objToParentNodePath) {
        try {
            HashSet<String> processedChildren = new HashSet<String>();
            String mappingType = this.getMappingType(obj);
            if (mappingType != null) {
                SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(parentNode);
                while (it.hasNext()) {
                    Node currentNode = (Node)it.next();
                    Iterator<SXMLMappings.Mapping> maps = this.getMappings().getMappings(mappingType);
                    String nodeName = currentNode.getLocalName();
                    StringBuffer objToCurrentNodePath = new StringBuffer();
                    if (objToParentNodePath != null) {
                        objToCurrentNodePath.append(objToParentNodePath).append("/");
                    }
                    objToCurrentNodePath.append(nodeName);
                    StringBuffer objToCurrentNodePathSlash = new StringBuffer(objToCurrentNodePath).append("/");
                    StringBuffer objToCurrentNodePathSlashSlash = new StringBuffer(objToCurrentNodePath).append("//");
                    while (maps.hasNext()) {
                        SXMLMappings.Mapping map = maps.next();
                        String mappedElementPath = map.getElementPath();
                        String mappedPropertyPath = map.getPropertyPath();
                        if (mappedElementPath.startsWith(objToCurrentNodePathSlashSlash.toString())) {
                            Map<String, PropertyInfo> infos = this.getPropertyInfos(obj);
                            String propName = mappedPropertyPath;
                            if (propName.contains("/")) {
                                propName = propName.substring(propName.indexOf("/") + 1);
                            }
                            PropertyInfo info = infos.get(propName);
                            this.fillInArrayObject(obj, currentNode, objToCurrentNodePath.toString(), info);
                            continue;
                        }
                        if (mappedElementPath.startsWith(objToCurrentNodePathSlash.toString())) {
                            if (processedChildren.contains(nodeName)) continue;
                            processedChildren.add(nodeName);
                            this.fillInObject(obj, currentNode, objToCurrentNodePath.toString());
                            continue;
                        }
                        if (!mappedElementPath.equals(objToCurrentNodePath.toString()) || mappedPropertyPath == null) continue;
                        SXMLValueConverter con = map.getConverter();
                        this.processPropertyPath(obj, currentNode, mappedPropertyPath, this.getNodeText(currentNode), con);
                    }
                }
            }
            if (!ModelUtil.hasLength((String)objToParentNodePath)) {
                this.fillInObjectWithReaders(parentNode, obj);
            }
            if (obj instanceof DBObject && objToParentNodePath == null) {
                this.setID((DBObject)obj);
            }
        }
        catch (SXMLReaderException sxmlre) {
            DBLog.getLogger((Object)this).log(Level.SEVERE, sxmlre.getMessage(), sxmlre);
        }
    }

    private void setID(DBObject dbo) {
        NameBasedID objID = new NameBasedID();
        objID.setType(dbo.getType());
        objID.setName(dbo.getName());
        if (dbo instanceof SchemaObject) {
            objID.setSchema(((SchemaObject)dbo).getSchema());
        }
        dbo.setID((DBObjectID)objID);
    }

    private void fillInArrayObject(Object obj, Node parentNode, String objToParentNodePath, PropertyInfo info) throws SXMLReaderException {
        Class arrClz = info.getPropertyClass();
        if (arrClz.isArray()) {
            Class<Object> objClz = arrClz.getComponentType();
            ArrayList<Object> objectList = new ArrayList<Object>();
            Object existing = info.getPropertyValue(obj);
            if (existing instanceof Constraint[]) {
                Constraint[] existingArray;
                for (Constraint o : existingArray = (Constraint[])existing) {
                    objectList.add(o);
                }
            }
            SXMLFragmentGenerator.childXMLElementIterator it = new SXMLFragmentGenerator.childXMLElementIterator(parentNode);
            while (it.hasNext()) {
                Node currentNode = (Node)it.next();
                Object childObj = null;
                if (objClz == DBObjectID.class) {
                    childObj = this.createIDForProp(obj, info);
                } else {
                    if (objClz == Constraint.class) {
                        if (parentNode.getLocalName().equals("PRIMARY_KEY_CONSTRAINT_LIST")) {
                            objClz = PKConstraint.class;
                        } else if (parentNode.getLocalName().equals("UNIQUE_KEY_CONSTRAINT_LIST")) {
                            objClz = UniqueConstraint.class;
                        } else if (parentNode.getLocalName().equals("FOREIGN_KEY_CONSTRAINT_LIST")) {
                            objClz = FKConstraint.class;
                        } else if (parentNode.getLocalName().equals("CHECK_CONSTRAINT_LIST")) {
                            objClz = CheckConstraint.class;
                        }
                    }
                    try {
                        childObj = objClz.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        throw new SXMLReaderException("Failed to instantiate new object ", e);
                    }
                    catch (InstantiationException e) {
                        throw new SXMLReaderException("Failed to instantiate new object ", e);
                    }
                }
                objectList.add(childObj);
                this.fillInObject(childObj, currentNode, null);
            }
            Object[] array = Array.newInstance(objClz, objectList.size());
            array = objectList.toArray((Object[])array);
            try {
                info.setPropertyValue(obj, (Object)array);
            }
            catch (Exception e) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to set property " + info.getPropertyName(), e);
            }
        } else {
            throw new SXMLReaderException("fillInArrayObject called on an object that is not an array");
        }
    }

    private void processPropertyPath(Object obj, Node parentNode, String propertyPath, String sxmlValue, SXMLValueConverter con) throws SXMLReaderException {
        String[] propParts = propertyPath.split("/");
        Map<String, PropertyInfo> infos = this.getPropertyInfos(obj);
        PropertyInfo info = infos.get(propParts[0]);
        boolean done = false;
        if (info == null) {
            throw new SXMLReaderException("failed to find PropertyInfo from the propPath " + propertyPath);
        }
        Class clz = info.getPropertyClass();
        Object beanValue = null;
        if (clz == Map.class) {
            HashMap<String, Object> map = (HashMap<String, Object>)info.getPropertyValue(obj);
            if (map == null) {
                map = new HashMap<String, Object>();
                try {
                    info.setPropertyValue(obj, map);
                }
                catch (Exception e) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to set property " + info.getPropertyName(), e);
                }
            }
            if (propParts.length > 1) {
                Object objInMap = map.get(propParts[1]);
                PropertyInfo propInfo = infos.get(propParts[1]);
                clz = propInfo.getPropertyClass();
                Object copy = null;
                if (clz == String.class || clz == Integer.class || clz == Boolean.class) {
                    objInMap = clz != String.class ? ToStringManager.fromString((String)sxmlValue, (Class)clz) : sxmlValue;
                    map.put(propParts[1], objInMap);
                    done = true;
                } else if (objInMap == null) {
                    try {
                        objInMap = clz.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        throw new SXMLReaderException("Failed to instantiate new object ", e);
                    }
                    catch (InstantiationException e) {
                        throw new SXMLReaderException("Failed to instantiate new object ", e);
                    }
                    map.put(propParts[1], objInMap);
                    if (objInMap instanceof Copyable) {
                        copy = ((Copyable)objInMap).copyTo(null);
                    }
                }
                if (this.getMappingType(objInMap) != null) {
                    this.fillInObject(objInMap, parentNode, null);
                    if (copy != null && objInMap != null && objInMap.equals(copy)) {
                        map.remove(propParts[1]);
                    }
                } else if (!done) {
                    StringBuffer objToCurrentNodePath = new StringBuffer(propertyPath.substring(propertyPath.indexOf("/") + 1));
                    this.processPropertyPath(objInMap, parentNode, objToCurrentNodePath.toString(), sxmlValue, con);
                }
            }
        } else if (propParts.length == 1) {
            if (clz == DBObjectID.class) {
                beanValue = this.createIDForProp(obj, info);
                ((BaseObjectID)beanValue).setName(sxmlValue);
            } else {
                if (sxmlValue == null && con == null && parentNode.hasChildNodes()) {
                    try {
                        beanValue = clz.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        throw new SXMLReaderException("Failed to instantiate new bean value ", e);
                    }
                    catch (InstantiationException e) {
                        throw new SXMLReaderException("Failed to instantiate new bean value ", e);
                    }
                }
                if (con != null) {
                    try {
                        beanValue = con.getBeanValue(obj, sxmlValue);
                    }
                    catch (Exception e) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "SXML Converter failed to get value", e);
                        beanValue = null;
                    }
                } else {
                    beanValue = (clz == Boolean.TYPE || clz == Boolean.class) && !ModelUtil.hasLength((String)sxmlValue) ? Boolean.valueOf(true) : sxmlValue;
                }
                if (beanValue instanceof String && clz != String.class && ToStringManager.converterAvailable(clz)) {
                    try {
                        beanValue = ToStringManager.fromString((String)((String)beanValue), (Class)clz);
                    }
                    catch (Exception e) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to convert value from  a String", e);
                        beanValue = null;
                    }
                }
            }
            try {
                if (beanValue != null && !clz.isPrimitive()) {
                    clz.cast(beanValue);
                }
                info.setPropertyValue(obj, beanValue);
            }
            catch (Exception e) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to set property " + info.getPropertyName(), e);
            }
            String mappingType = this.getMappingType(beanValue);
            boolean fillIn = true;
            try {
                this.getMappings().getMappings(mappingType);
            }
            catch (UnsupportedTypeForSXMLException e) {
                fillIn = false;
            }
            if (this.getMappingType(beanValue) != null) {
                this.fillInObject(beanValue, parentNode, null);
            }
        } else if (propParts.length > 1) {
            Object propertyPathObj = info.getPropertyValue(obj);
            if (propertyPathObj == null) {
                if (clz == DBObjectID.class) {
                    propertyPathObj = this.createIDForProp(obj, info);
                } else {
                    if (clz == SQLFragment.class) {
                        clz = SimpleSQLFragment.class;
                    }
                    try {
                        propertyPathObj = clz.newInstance();
                    }
                    catch (IllegalAccessException e) {
                        throw new SXMLReaderException("Failed to instantiate new object ", e);
                    }
                    catch (InstantiationException e) {
                        throw new SXMLReaderException("Failed to instantiate new object ", e);
                    }
                }
                try {
                    info.setPropertyValue(obj, propertyPathObj);
                }
                catch (Exception e) {
                    DBLog.getLogger((Object)this).log(Level.SEVERE, "Failed to set property " + info.getPropertyName(), e);
                }
            }
            StringBuffer objToCurrentNodePath = new StringBuffer(propertyPath.substring(propertyPath.indexOf("/") + 1));
            this.processPropertyPath(propertyPathObj, parentNode, objToCurrentNodePath.toString(), sxmlValue, con);
        }
    }

    private void fillInObjectWithReaders(Node node, Object obj) throws SXMLReaderException {
        Iterator<Class<? extends SXMLFragmentGenerator>> gens = this.getMappings().getGenerators(this.getMappingType(obj));
        if (gens != null) {
            while (gens.hasNext()) {
                try {
                    SXMLFragmentGenerator gen = gens.next().newInstance();
                    gen.setParentGenerator(this);
                    gen.readNode(node, obj);
                }
                catch (IllegalAccessException e) {
                    throw new SXMLReaderException("Failed to instantiate new SXMLFragmentGenerator ", e);
                }
                catch (InstantiationException e) {
                    throw new SXMLReaderException("Failed to instantiate new SXMLFragmentGenerator ", e);
                }
            }
        }
    }

    private String getMappingType(Object obj) {
        if (obj == null) {
            return null;
        }
        String mappingType = obj instanceof DBObject ? ((DBObject)obj).getType() : obj.getClass().getSimpleName();
        try {
            this.getMappings().getMappings(mappingType);
        }
        catch (UnsupportedTypeForSXMLException e) {
            mappingType = null;
        }
        return mappingType;
    }

    private Map<String, PropertyInfo> getPropertyInfos(Object bean) {
        return this.getPropertyInfos(bean.getClass());
    }

    private Map<String, PropertyInfo> getPropertyInfos(Class clz) {
        if (this.m_infos.containsKey(clz)) {
            return this.m_infos.get(clz);
        }
        PropertyIterator iter = new PropertyIterator(clz, OracleDatabase.class);
        Map infos = iter.getPropertyInfos(false, false, false);
        this.m_infos.put(clz, infos);
        return infos;
    }

    private boolean isRootNameForType(String rootNodeName, String type) {
        if (type != null) {
            String type2 = type;
            if (type.indexOf(" ") > -1) {
                type2 = type.replaceAll(" ", "_");
            }
            return type2.equals(rootNodeName);
        }
        return false;
    }

    private String getNodeText(Node node) {
        String text = null;
        if (node.getChildNodes().getLength() <= 1 && (text = node.getTextContent()) != null) {
            text = text.trim();
        }
        return text;
    }

    private void tidyPartitions(Table tab) {
        OracleTablePartitions otp = (OracleTablePartitions)tab.getProperty("OracleTablePartitions");
        if (otp != null) {
            tab.setProperty("PARTITIONED TABLE", (Object)Boolean.TRUE);
            OracleTablePartitions subPartModel = otp.getSubpartitionModel();
            for (TablePartition tp : otp.getPartitions()) {
                OracleTablePartitions plsp = tp.getPartitionLevelSubpartitions();
                if (plsp == null || subPartModel == null) continue;
                if (plsp.getPartitionType() == null) {
                    plsp.setPartitionType(subPartModel.getPartitionType());
                }
                if (plsp.getPartitionColumns() != null && plsp.getPartitionColumns().length != 0) continue;
            }
            this.propegateObjectAndPartitionType(otp);
        }
    }

    private void propegateObjectAndPartitionType(OracleTablePartitions otp) {
        for (TablePartition tp : otp.getPartitions()) {
            if (tp.getObjectType() == null) {
                tp.setObjectType(otp.getObjectType());
            }
            if (tp.getPartitionType() == null) {
                tp.setPartitionType(otp.getPartitionType());
            }
            if (tp.getPartitionLevelSubpartitions() == null) continue;
            this.propegateObjectAndPartitionType(tp.getPartitionLevelSubpartitions());
        }
        if (otp.getSubpartitionModel() != null) {
            this.propegateObjectAndPartitionType(otp.getSubpartitionModel());
        }
    }

    private void ensureKidsIDsParentID(DBObject object) {
        for (DBObject kid : object.getOwnedObjects()) {
            if (kid.getID() instanceof BaseObjectID && ((BaseObjectID)kid.getID()).getParent() == null) {
                BaseObjectID id = (BaseObjectID)kid.getID();
                id.setParent(object.getID());
                kid.setID((DBObjectID)id);
            }
            this.ensureKidsIDsParentID(kid);
        }
    }

    @Override
    protected void populateNode(Node parent, Document doc, Object obj) {
    }

    @Override
    protected void readNode(Node parent, Object obj) {
    }

    final SchemaObject getCurrentObject() {
        return this.m_currentObject;
    }

    final SchemaObject getParentObject() {
        return this.m_parentObject;
    }

    final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    private DBObjectID createIDForProp(Object obj, PropertyInfo pi) {
        ReferenceID retval = null;
        Class clz = pi.getReferencedClass();
        String type = null;
        if (clz != null) {
            type = Metadata.getType((Class)clz);
            if (ModelUtil.hasLength((String)type)) {
                if (pi.isInternalReference()) {
                    String parentType = this.m_currentObject.getType();
                    String parentName = this.m_currentObject.getName();
                    String parentOwner = this.m_currentObject.getSchema() != null ? this.m_currentObject.getSchema().getName() : null;
                    NameBasedID parID = new NameBasedID(parentType, parentOwner, parentName);
                    retval = new NameBasedID(type, null, (DBObjectID)parID);
                } else if ("COLUMN".equals(type) || this.getProvider() != null && this.getProvider().supportsObjectType(type) || this.getProvider() == null && "TABLE".equals(type)) {
                    DBObjectID parID = null;
                    if (obj instanceof MaterializedViewLog && pi.getPropertyName().equals("columnIDs")) {
                        parID = ((MaterializedViewLog)obj).getMasterTableID();
                    }
                    retval = new NameBasedID(type, null, parID);
                }
            }
            if (retval == null) {
                retval = new ReferenceID(type, (String)null, null);
                String propName = pi.getPropertyName();
                if (obj instanceof Index && "domainIndextype".equals(propName)) {
                    retval.setType("INDEXTYPE");
                    retval.setSchemaName("SYS");
                } else if (obj instanceof OracleExternalTableProperties && "defaultDirectory".equals(propName)) {
                    retval.setSchemaName("SYS");
                } else if (obj instanceof OracleExternalTableProperties.LocationSpecifier && "directory".equals(propName)) {
                    retval.setSchemaName("SYS");
                }
                if (retval.getType() == null) {
                    retval.setType("UNSPECIFIED_TYPE");
                }
            }
        }
        return retval;
    }

    private static class SXMLReaderMappings
    extends SXMLMappings {
        public SXMLReaderMappings() {
            this.uncache("MATERIALIZED VIEW", "REFRESH", "refreshMode");
            this.uncache("MATERIALIZED VIEW", "PHYSICAL_PROPERTIES/HEAP_TABLE", null);
            this.uncache("TABLE", "GLOBAL_TEMPORARY", "TableType");
            this.uncache("TABLE", "RELATIONAL_TABLE/ON_COMMIT", "TableType");
            this.uncache("CONSTRAINT", "REFERENCES/SCHEMA", "referenceID", "relation", "schema", "name");
            this.uncache("CONSTRAINT", "REFERENCES/NAME", "referenceID", "relation", "name");
            this.uncache("CONSTRAINT", "REFERENCES/COL_LIST//COL_LIST_ITEM/NAME", "referenceID", "columnIDs");
            this.uncache("CONSTRAINT", "REFERENCES/SCHEMA", "referenceID", "parent", "schemaName");
            this.uncache("CONSTRAINT", "REFERENCES/NAME", "referenceID", "parent", "name");
            this.uncache("CONSTRAINT", "REFERENCES/COL_LIST//COL_LIST_ITEM/NAME", "referenceID", "childObjectNames");
            this.uncache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES/INDEXTYPE/SCHEMA", "domainIndextype", "schema", "name");
            this.uncache("SYNONYM", "OBJECT_SCHEMA", "reference", "schema", "name");
            this.uncache("OracleNestedTableProperties", "STORAGE_TABLE/SCHEMA", "!schema");
            this.uncache("LOB DESCRIPTOR", "SCHEMA", "!schema");
            this.uncache("OracleColumnProperties", "VARRAY_PROPERTIES/STORE_AS", "VAProperties");
            String NBID = NameBasedID.class.getSimpleName();
            this.cache(NBID, "SCHEMA", "schema", "name");
            this.cache(NBID, "NAME", "name");
            this.cache("MATERIALIZED VIEW LOG", "ON_TABLE/NAME", "name");
            this.cache("INDEX", "TABLE_INDEX/DOMAIN_INDEX_PROPERTIES", "indexType", new SXMLMappings.ValueCheckingConverter(Index.IndexType.DOMAIN));
            this.cache("IOT PROPERTIES", "COMPRESS", "keyCompression", new SXMLMappings.KeyCompressionConverter(true));
            this.uncache("XMLTypeColumnProperties", "XMLSCHEMA", "elementID", "parent");
            this.uncache("XMLTypeColumnProperties", "ELEMENT", "elementID");
            this.uncache("COLUMN", "CUSTOMER_AREA/ODB_PROPERTY_LIST/XMLTYPE_COLUMN_XMLSCHEMA_OWNER", "OracleColumnProperties", "XMLTypeColumnProperties", "elementID", "parent", "schemaName");
            this.uncache("IdentityColumnProperties", "SCHEMA", "parent", "parent", "schema", "name");
            this.uncache("VIEW", "COL_LIST//COL_LIST_ITEM", "columns");
        }
    }
}

