/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseLinkValidator
extends SchemaObjectValidator<DatabaseLink> {
    public DatabaseLinkValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("host");
        retval.add("shared");
        retval.add("public");
        retval.add("connectToUser");
        return retval;
    }

    @DBObjectValidator.PropertyValidator(value={"username"})
    @DBObjectValidator.PropertyDependency(value={"connectToUser"})
    public void validateUsername(DatabaseLink original, DatabaseLink dblink) throws ValidationException {
        String uname;
        if (Boolean.FALSE.equals(dblink.getConnectToUser()) && !ModelUtil.hasLength((String)(uname = dblink.getUsername()))) {
            throw new ValidationException((DBObject)dblink, APIBundle.get((String)"DBLV_NO_USERNAME"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"password"})
    @DBObjectValidator.PropertyDependency(value={"connectToUser"})
    public void validatePassword(DatabaseLink original, DatabaseLink dblink) throws ValidationException {
        if (Boolean.FALSE.equals(dblink.getConnectToUser()) && this.getProvider() instanceof Database) {
            String upwd = dblink.getPassword();
            String upwdX = dblink.getPasswordX();
            if (!ModelUtil.hasLength((String)upwd) && !ModelUtil.hasLength((String)upwdX)) {
                throw new ValidationException((DBObject)dblink, APIBundle.get((String)"DBLV_NO_PASSWORD"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"authentificationPassword"})
    @DBObjectValidator.PropertyDependency(value={"shared"})
    public void validateAuthentificationPassword(DatabaseLink original, DatabaseLink dblink) throws ValidationException {
        if (dblink.isShared() && this.getProvider() instanceof Database) {
            String apwd = dblink.getAuthentificationPassword();
            String apwdX = dblink.getAuthentificationPasswordX();
            if (!ModelUtil.hasLength((String)apwd) && !ModelUtil.hasLength((String)apwdX)) {
                throw new ValidationException((DBObject)dblink, APIBundle.get((String)"DBLV_NO_AUTHENTIFICATION_PASSWORD"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"authentificationUsername"})
    @DBObjectValidator.PropertyDependency(value={"shared"})
    public void validateAuthentificationUsername(DatabaseLink original, DatabaseLink dblink) throws ValidationException {
        String auname;
        if (dblink.isShared() && !ModelUtil.hasLength((String)(auname = dblink.getAuthentificationUsername()))) {
            throw new ValidationException((DBObject)dblink, APIBundle.get((String)"DBLV_NO_AUTHENTIFICATION_USERNAME"));
        }
    }
}

