/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.ora.OpaqueFormatSpec;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalTablePropsValidator
extends AbstractChildDBObjectValidator<OracleExternalTableProperties> {
    public ExternalTablePropsValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    public void validateObject(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        Table table = (Table)props.getParent();
        if (table == null) {
            throw new ValidationException((DBObject)props, "External table properties must be set on a table.");
        }
        super.validateObject((DBObject)original, (DBObject)props);
        ExternalTablePropsValidator.validateTable(table);
    }

    static void validateTable(Table table) throws ValidationException {
        if (table != null) {
            boolean isNestedTable;
            boolean isPartitionedTable = table.getProperty("PARTITIONED TABLE") == Boolean.TRUE;
            boolean bl = isNestedTable = table.getProperty("NESTED TABLE") == Boolean.TRUE;
            if (isPartitionedTable || isNestedTable) {
                throw new ValidationException((DBObject)table, APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_COMBINATION", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), isPartitionedTable ? APIBundle.get((String)"TABLE_PROPERTY_PARTITIONED") : APIBundle.get((String)"TABLE_PROPERTY_NESTED")}));
            }
            if (table.getConstraints().length != 0) {
                throw new ValidationException((DBObject)table, "constraints", APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_CONSTRAINTS")}));
            }
            if (table.getIndexes().length != 0) {
                throw new ValidationException((DBObject)table, "indexes", APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_INDEXES")}));
            }
            if (table.getProperty("Comment") != null) {
                throw new ValidationException((DBObject)table, "Comment", APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_COMMENTS")}));
            }
            for (Column column : table.getColumns()) {
                if (column.getProperty("OracleColumnProperties") != null) {
                    throw new ValidationException((DBObject)column, "OracleColumnProperties", APIBundle.format((String)"TABLE_PROPERTY_ERROR_INVALID_PROPERTY", (Object[])new Object[]{APIBundle.get((String)"TABLE_TYPE_EXTERNAL"), APIBundle.get((String)"TABLE_PROPERTY_LOB_PARAMETERS")}));
                }
                DataType dataType = null;
                try {
                    dataType = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
                }
                catch (DBException e) {
                    // empty catch block
                }
                if (dataType == null || !(dataType instanceof Type) && !dataType.getName().startsWith("LONG")) continue;
                throw new ValidationException((DBObject)column, "dataTypeUsage", APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_INVALID_COLUMN"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"projectColumn"})
    public void validateProjectColumn(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        OracleExternalTableProperties.ProjectColumn projectColumn = props.getProjectColumn();
        if (projectColumn != null && projectColumn != OracleExternalTableProperties.ProjectColumn.ALL && projectColumn != OracleExternalTableProperties.ProjectColumn.REFERENCED) {
            throw new ValidationException((DBObject)props, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_INVALID_PROJECT_COLUMN"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"defaultDirectory"})
    public void validateDefaultDirectory(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        DBObjectID defDir = props.getDefaultDirectory();
        Directory dir = null;
        try {
            dir = defDir != null ? (Directory)defDir.resolveID() : null;
        }
        catch (DBException dbe) {
            throw new ValidationException((DBObject)props, dbe.getMessage());
        }
        String dirName = null;
        if (dir != null) {
            dirName = dir.getName();
        } else if (defDir instanceof ReferenceID) {
            dirName = ((ReferenceID)defDir).getName();
        }
        if (!ModelUtil.hasLength((String)dirName)) {
            throw new ValidationException((DBObject)props, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MISSING_DEFAULT_DIR"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"locationSpecifiers"})
    public void validateLocationSpecifiers(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        OracleExternalTableProperties.LocationSpecifier[] locSpecs = props.getLocationSpecifiers();
        if (locSpecs.length == 0) {
            throw new ValidationException((DBObject)props, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MISSING_LOCATION"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"accessDriverType"})
    public void validateAccessDriverType(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        String accessDriverType = props.getAccessDriverType();
        if (accessDriverType != null && !accessDriverType.equals("ORACLE_LOADER") && !accessDriverType.equals("ORACLE_DATAPUMP")) {
            throw new ValidationException((DBObject)props, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_INVALID_ACCESS_DRIVER_TYPE"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"accessParameters"})
    public void validateAccessParameters(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        String val = null;
        Object accessParams = props.getAccessParameters();
        if (accessParams != null) {
            if (accessParams instanceof OpaqueFormatSpec) {
                if (props.isAccessUsingClob()) {
                    throw new ValidationException((DBObject)props, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MUST_BE_SUBQUERY"));
                }
                OpaqueFormatSpec spec = (OpaqueFormatSpec)accessParams;
                val = spec.getSpec();
            } else if (accessParams instanceof SQLQuery) {
                SQLQuery subquery = (SQLQuery)accessParams;
                val = subquery.getSQLText();
            } else {
                val = accessParams.toString();
            }
        }
        if (props.isAccessUsingClob() && !ModelUtil.hasLength(val)) {
            throw new ValidationException((DBObject)props, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_MUST_BE_SUBQUERY"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"rejectLimit"})
    public void validateRejectLimit(OracleExternalTableProperties original, OracleExternalTableProperties props) throws ValidationException {
        String rl = props.getRejectLimit();
        if (rl != null && !rl.equalsIgnoreCase("UNLIMITED")) {
            try {
                Integer rejectLimit = new Integer(rl);
                if (rejectLimit == null || rejectLimit < 0 || rejectLimit > 100000) {
                    throw new ValidationException((DBObject)props, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_INVALID_REJECT_LIMIT"));
                }
            }
            catch (NumberFormatException x) {
                throw new ValidationException((DBObject)props, APIBundle.get((String)"EXTERNAL_TABLE_PROPERTY_INVALID_REJECT_LIMIT"));
            }
        }
    }
}

