/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexPartitionsValidator
extends AbstractChildDBObjectValidator<OracleIndexPartitions> {
    public IndexPartitionsValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    @DBObjectValidator.PropertyValidator(value={"globalPartitionColumns"})
    public void validateGlobalPartitionColumns(OracleIndexPartitions orig, OracleIndexPartitions oip) throws ValidationException {
        if (oip.getParent() instanceof Index) {
            this.validateGlobalPartitionColumns(oip);
        }
    }

    private void validateGlobalPartitionColumns(OracleIndexPartitions oip) throws ValidationException {
        OracleIndexPartitions.PartitionType partitionType = oip.getPartitionType();
        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH || partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            DBObjectID[] partitionColumns = oip.getGlobalPartitionColumns();
            if (partitionColumns.length == 0) {
                throw new ValidationException((DBObject)oip, APIBundle.get((String)"INDEX_PARTITION_ERROR_MISSING_GLOBAL_COLUMN"));
            }
            Index index = (Index)oip.getParent();
            Table table = index.getTable();
            Column[] validColumns = OracleIndexPartitions.getValidGlobalPartitionColumns((Index)index);
            for (int i = 0; i < partitionColumns.length; ++i) {
                Column column = (Column)table.findOwnedObject(partitionColumns[i]);
                if (column == null) {
                    try {
                        column = (Column)partitionColumns[i].resolveID();
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                }
                if (column == null || i < validColumns.length && validColumns.length >= 1 && column.getName().equals(validColumns[i].getName())) continue;
                throw new ValidationException((DBObject)oip, APIBundle.format((String)"INDEX_PARTITION_ERROR_INVALID_GLOBAL_COLUMN", (Object[])new Object[]{column.getName()}));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"globalHashQuantity"})
    public void validateGlobalHashPartitions(OracleIndexPartitions orig, OracleIndexPartitions oip) throws ValidationException {
        if (oip.getParent() instanceof Index) {
            this.validateGlobalHashPartitions(oip);
        }
    }

    private void validateGlobalHashPartitions(OracleIndexPartitions oip) throws ValidationException {
        Index index = (Index)oip.getParent();
        if (index.getIndexType() == Index.IndexType.BITMAP && (oip.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH || oip.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_RANGE)) {
            throw new ValidationException((DBObject)index, APIBundle.get((String)"ORACLE_INDEX_ERROR_BITMAP_WITH_GLOBAL_PARTN"));
        }
        OracleIndexPartitions.PartitionType m_partitionType = oip.getPartitionType();
        if (m_partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH) {
            Integer globalHashQuantity = oip.getGlobalHashQuantity();
            int hashQuantity = globalHashQuantity == null ? 0 : globalHashQuantity;
            IndexPartition[] partitions = oip.getPartitions();
            if (hashQuantity == 0 && partitions.length == 0) {
                throw new ValidationException((DBObject)oip, APIBundle.get((String)"INDEX_PARTITION_ERROR_MISSING_GLOBAL_HASH_PARTITIONS"));
            }
        }
    }

    @DBObjectValidator.PropertyValidator(value={"partitions"})
    public void validatePartitions(OracleIndexPartitions orig, OracleIndexPartitions oip) throws ValidationException {
        ValidationException ve = null;
        IndexPartition[] partitions = oip.getPartitions();
        try {
            this.validateOwnedObjects((DBObject[])partitions);
        }
        catch (ValidationException ve2) {
            ve = (ValidationException)((Object)DBException.append(ve, (DBException)((Object)ve2)));
        }
        if (oip.getParent() instanceof Index) {
            try {
                this.validatePartitionExtras(oip);
            }
            catch (ValidationException ve2) {
                ve = (ValidationException)((Object)DBException.append((DBException)((Object)ve), (DBException)((Object)ve2)));
            }
        }
        if (ve != null) {
            throw ve;
        }
    }

    private void validatePartitionExtras(OracleIndexPartitions oip) throws ValidationException {
        IndexPartition[] partitions = oip.getPartitions();
        OracleIndexPartitions.PartitionType partitionType = oip.getPartitionType();
        Index index = (Index)oip.getParent();
        if (partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            if (partitions.length == 0) {
                throw new ValidationException((DBObject)oip, APIBundle.get((String)"INDEX_PARTITION_ERROR_MISSING_GLOBAL_RANGE_PARTITIONS"));
            }
            IndexPartition lastPartition = partitions[partitions.length - 1];
            for (Object value : lastPartition.getValuesLessThan()) {
                if (value != null && value == TablePartition.RangeValue.MAXVALUE) continue;
                throw new ValidationException((DBObject)oip, APIBundle.get((String)"INDEX_PARTITION_ERROR_INVALID_LAST_PARTITION_VALUES"));
            }
        } else if (index != null && (partitionType == OracleIndexPartitions.PartitionType.DOMAIN || partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP || partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH || partitionType == OracleIndexPartitions.PartitionType.LOCAL_OTHER)) {
            OracleTablePartitions otp;
            Table table = index.getTable();
            OracleTablePartitions oracleTablePartitions = otp = table == null ? null : (OracleTablePartitions)table.getProperty("OracleTablePartitions");
            if (partitionType == OracleIndexPartitions.PartitionType.DOMAIN && otp != null && (otp.getPartitionType() == OracleTablePartitions.PartitionType.HASH || otp.getPartitionType() == OracleTablePartitions.PartitionType.LIST || otp.getSubpartitionModel() != null)) {
                String partitionTypeString = otp.getPartitionType().toString();
                if (otp.getSubpartitionModel() != null) {
                    partitionTypeString = partitionTypeString + "-" + otp.getSubpartitionModel().getPartitionType().toString();
                }
                throw new ValidationException((DBObject)oip, APIBundle.format((String)"INDEX_PARTITION_ERROR_INELIGIBLE_DOMAIN_INDEX", (Object[])new Object[]{partitionTypeString}));
            }
            if (partitions.length > 0) {
                if (otp == null) {
                    throw new ValidationException((DBObject)oip, APIBundle.get((String)"INDEX_PARTITION_ERROR_NO_TABLE_PARTITIONS"));
                }
                int tablePartitionCount = otp.getPartitions().length;
                if (tablePartitionCount == 0 && otp.getPartitionType() == OracleTablePartitions.PartitionType.HASH) {
                    int n = tablePartitionCount = otp.getHashQuantity() == null ? 1 : otp.getHashQuantity();
                }
                if (tablePartitionCount != partitions.length) {
                    throw new ValidationException((DBObject)oip, APIBundle.get((String)"INDEX_PARTITION_ERROR_INVALID_LOCAL_PARTITIONS_COUNT"));
                }
            }
        }
    }
}

