/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.math.BigInteger;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOBDescriptorValidator
extends AbstractChildDBObjectValidator<LOBDescriptor> {
    public LOBDescriptorValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection ret = super.listAlwaysValidProperties();
        ret.add("LOBCache");
        return ret;
    }

    @DBObjectValidator.PropertyValidator(value={"storageEnabledInRow"})
    public void validateStorageEnabledInRow(LOBDescriptor orig, LOBDescriptor lobd) throws ValidationException {
        OracleIndexOrganizedTableProperties oiotp;
        Table parent;
        if (lobd.isStorageEnabledInRow() && (parent = (Table)DBUtil.findParentOfType((DBObject)lobd, Table.class)) != null && (oiotp = (OracleIndexOrganizedTableProperties)parent.getProperty("OracleIndexOrganizedTableProperties")) != null && !oiotp.isOverflowable()) {
            throw new ValidationException((DBObject)lobd, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_STORAGE_IN_IOT"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"LOBCache"})
    public void validateCache(LOBDescriptor orig, LOBDescriptor lobd) throws ValidationException {
        OracleStorageProperties osp;
        if (lobd.getLOBCache() == LOBDescriptor.LOBCache.CACHE && (osp = lobd.getStorage()) != null && Boolean.FALSE.equals(osp.getLogging())) {
            throw new ValidationException((DBObject)lobd, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_CACHE"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"chunk"})
    public void validateChunk(LOBDescriptor orig, LOBDescriptor lobd) throws ValidationException {
        Integer chunk = lobd.getChunk();
        if (chunk != null) {
            if (chunk < 1 || chunk > 32768) {
                throw new ValidationException((DBObject)lobd, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INVALID_CHUNK1"));
            }
            OracleStorageProperties storage = lobd.getStorage();
            if (storage != null && storage.getNextExtent() != null && storage.getNextExtent().compareTo(BigInteger.valueOf(chunk.longValue())) < 0) {
                throw new ValidationException((DBObject)lobd, APIBundle.format((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INVALID_CHUNK2", (Object[])new Object[]{storage.getNextExtent()}));
            }
        }
        this.validateNonNullableProperty((DBObject)orig, (DBObject)lobd, "chunk");
    }

    @DBObjectValidator.PropertyValidator(value={"freepools"})
    public void validateFreepools(LOBDescriptor orig, LOBDescriptor lobd) throws ValidationException {
        Integer freepools = lobd.getFreepools();
        if (freepools != null) {
            if (freepools < 0) {
                throw new ValidationException((DBObject)lobd, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INVALID_FREEPOOLS"));
            }
            OracleStorageProperties storage = lobd.getStorage();
            if (storage != null && storage.getFreelistGroups() != null) {
                throw new ValidationException((DBObject)lobd, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INVALID_FREEPOOLS_AND_FREELIST_GROUPS"));
            }
        }
        this.validateNonNullableProperty((DBObject)orig, (DBObject)lobd, "freepools");
    }

    @DBObjectValidator.PropertyValidator(value={"pctVersion"})
    public void validatePctVersion(LOBDescriptor orig, LOBDescriptor lobd) throws ValidationException {
        Integer pctVersion = lobd.getPctVersion();
        if (pctVersion != null && (pctVersion < 0 || pctVersion > 100)) {
            throw new ValidationException((DBObject)lobd, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INVALID_PCTVERSION"));
        }
        this.validateNonNullableProperty((DBObject)orig, (DBObject)lobd, "pctVersion");
    }

    @DBObjectValidator.PropertyValidator(value={"retention"})
    @DBObjectValidator.PropertyDependency(value={"pctVersion"})
    public void validateRetention(LOBDescriptor orig, LOBDescriptor lobd) throws ValidationException {
        Integer pctVersion = lobd.getPctVersion();
        boolean retention = lobd.isRetention();
        if (retention && pctVersion != null) {
            throw new ValidationException((DBObject)lobd, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INVALID_PCTVERSION_AND_RETENTION"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"storage"})
    public void validateStorage(LOBDescriptor orig, LOBDescriptor lobd) throws ValidationException {
        OracleStorageProperties storage = lobd.getStorage();
        if (storage != null) {
            this.getProvider().validateObject((DBObject)storage);
        }
    }

    @DBObjectValidator.PropertyValidator(value={"columns", "LOBSegName"})
    public void validateColumns(LOBDescriptor orig, LOBDescriptor lobd) throws ValidationException {
        DBObjectID[] lobColumns = lobd.getColumns();
        if (!(lobd.getParent() instanceof OracleColumnProperties) && lobColumns.length < 1) {
            throw new ValidationException((DBObject)lobd, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INCOMPLETE"));
        }
        String lobSegName = lobd.getLOBSegName();
        if (lobSegName != null && lobColumns.length > 1) {
            throw new ValidationException((DBObject)lobd, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_TOO_MANY_COLUMNS"));
        }
        for (int i = 0; i < lobColumns.length; ++i) {
            DBObjectID id = lobColumns[i];
            boolean isVarrayColumn = LOBDescriptor.isVARRAYColumn((DBObjectID)id, (DBObject)lobd);
            if (!LOBDescriptor.isLOBColumn((DBObjectID)id, (DBObject)lobd) && !isVarrayColumn || isVarrayColumn && i > 0) {
                throw new ValidationException((DBObject)lobd, APIBundle.get((String)"TABLE_PARTITION_LOB_DESCRIPTOR_ERROR_INCOMPLETE"));
            }
            if (!isVarrayColumn || lobSegName != null) continue;
            throw new ValidationException((DBObject)lobd, APIBundle.get((String)"TABLE_PARTITION_STORAGE_ERROR_MISSING_LOB_SEGNAME"));
        }
    }
}

