/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.validators;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.SchemaObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializedViewLogValidator
extends SchemaObjectValidator<MaterializedViewLog> {
    public MaterializedViewLogValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection retval = super.listAlwaysValidProperties();
        retval.add("cache");
        retval.add("columnIDs");
        retval.add("newValues");
        retval.add("parallelDegree");
        retval.add("primaryKeyLogged");
        retval.add("rowidLogged");
        retval.add("sequenceLogged");
        return retval;
    }

    @DBObjectValidator.PropertyValidator(value={"masterTableID"})
    public void validateMasterTableID(MaterializedViewLog original, MaterializedViewLog updated) throws ValidationException {
        DBObjectID masterID = updated.getMasterTableID();
        if (masterID == null || masterID instanceof ReferenceID) {
            throw new ValidationException((DBObject)updated, APIBundle.get((String)"MVIEW_LOG_MISSING_MASTER"));
        }
        if (ModelUtil.areDifferent((Object)updated.getName(), (Object)DBUtil.getDBObjectName((DBObjectID)masterID))) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"MVIEW_LOG_NAME_MASTER_MISMATCH", (Object[])new Object[]{updated.getName(), DBUtil.getDBObjectName((DBObjectID)masterID)}));
        }
    }

    public DBObjectValidator.NamespaceType getNamespaceType() {
        return DBObjectValidator.NamespaceType.NONE;
    }

    protected CascadeAction cascadePropertyChange(Difference objDiff, String propName, Object oldValue, Object newValue, MaterializedViewLog obj) {
        boolean isLogFor = ModelUtil.areEqual((Object)obj.getMasterTableID(), (Object)((DBObject)objDiff.getOriginalObject()).getID());
        CascadeAction retval = super.cascadePropertyChange(objDiff, propName, oldValue, newValue, (SchemaObject)obj);
        if (isLogFor && retval == CascadeAction.UPDATE) {
            if ("name".equals(propName)) {
                obj.setName((String)newValue);
            } else if ("schema".equals(propName)) {
                obj.setSchema((Schema)newValue);
            }
        }
        return retval;
    }

    public void validateObject(MaterializedViewLog original, MaterializedViewLog updated) throws ValidationException {
        super.validateObject((DBObject)original, (DBObject)updated);
        if (this.getProvider() instanceof OracleDatabaseImpl && original != null && updated != null && Boolean.FALSE.equals(updated.getPrimaryKeyLogged()) && Boolean.FALSE.equals(updated.getRowidLogged()) && (Boolean.TRUE.equals(original.getPrimaryKeyLogged()) || Boolean.TRUE.equals(original.getRowidLogged()))) {
            throw new ValidationException((DBObject)updated, APIBundle.format((String)"MVIEW_LOG_ERROR_PK_AND_ROWID_FALSE", (Object[])new Object[]{updated.getName()}));
        }
    }
}

